/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.vdurmont.semver4j.Semver;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.util.BitSets;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.api.util.StringUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.BiomeRegistry;
import net.raphimc.viabedrock.protocol.model.BlockProperties;
import net.raphimc.viabedrock.protocol.model.Experiment;
import net.raphimc.viabedrock.protocol.model.ItemEntry;
import net.raphimc.viabedrock.protocol.model.Position2f;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.BlockStateRewriter;
import net.raphimc.viabedrock.protocol.rewriter.DimensionIdRewriter;
import net.raphimc.viabedrock.protocol.rewriter.GameTypeRewriter;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.storage.SpawnPositionStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.JavaTypes;

public class JoinPackets {
    private static final int DEFAULT_VIEW_DISTANCE = 8;

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.START_GAME, null, wrapper -> {
            Semver version;
            wrapper.cancel();
            SpawnPositionStorage spawnPositionStorage = wrapper.user().get(SpawnPositionStorage.class);
            ResourcePacksStorage resourcePacksStorage = wrapper.user().get(ResourcePacksStorage.class);
            if (wrapper.user().has(GameSessionStorage.class)) {
                return;
            }
            if (resourcePacksStorage == null || !resourcePacksStorage.hasCompletedTransfer()) {
                BedrockProtocol.kickForIllegalState(wrapper.user(), "Pack negotiation not completed");
                return;
            }
            long uniqueEntityId = wrapper.read(BedrockTypes.VAR_LONG);
            long runtimeEntityId = wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            int playerGameType = wrapper.read(BedrockTypes.VAR_INT);
            Position3f playerPosition = wrapper.read(BedrockTypes.POSITION_3F);
            Position2f playerRotation = wrapper.read(BedrockTypes.POSITION_2F);
            wrapper.read(BedrockTypes.LONG_LE);
            wrapper.read(BedrockTypes.SHORT_LE);
            wrapper.read(BedrockTypes.STRING);
            int dimensionId = wrapper.read(BedrockTypes.VAR_INT);
            int generatorId = wrapper.read(BedrockTypes.VAR_INT);
            int levelGameType = wrapper.read(BedrockTypes.VAR_INT);
            int difficulty = wrapper.read(BedrockTypes.VAR_INT);
            Position defaultSpawnPosition = wrapper.read(BedrockTypes.BLOCK_POSITION);
            wrapper.read(Type.BOOLEAN);
            boolean isWorldEditor = wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.STRING);
            float rainLevel = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
            float lightningLevel = wrapper.read(BedrockTypes.FLOAT_LE).floatValue();
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(BedrockTypes.VAR_INT);
            boolean commandsEnabled = wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.GAME_RULE_ARRAY);
            Experiment[] experiments = wrapper.read(BedrockTypes.EXPERIMENT_ARRAY);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(BedrockTypes.INT_LE);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            String vanillaVersion = wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.INT_LE);
            wrapper.read(BedrockTypes.INT_LE);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.EDUCATION_URI_RESOURCE);
            if (wrapper.read(Type.BOOLEAN).booleanValue()) {
                wrapper.read(Type.BOOLEAN);
            }
            byte chatRestrictionLevel = wrapper.read(Type.BYTE);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.STRING);
            String levelName = wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.STRING);
            wrapper.read(Type.BOOLEAN);
            int movementMode = wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(BedrockTypes.VAR_INT);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.LONG_LE);
            wrapper.read(BedrockTypes.VAR_INT);
            BlockProperties[] blockProperties = wrapper.read(BedrockTypes.BLOCK_PROPERTIES_ARRAY);
            ItemEntry[] itemEntries = wrapper.read(BedrockTypes.ITEM_ENTRY_ARRAY);
            wrapper.read(BedrockTypes.STRING);
            wrapper.read(Type.BOOLEAN);
            String serverEngine = wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.NETWORK_TAG);
            wrapper.read(BedrockTypes.LONG_LE);
            wrapper.read(BedrockTypes.UUID);
            wrapper.read(Type.BOOLEAN);
            boolean hashedRuntimeBlockIds = wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            if (isWorldEditor) {
                PacketWrapper disconnect = PacketWrapper.create(ClientboundPackets1_19_4.DISCONNECT, wrapper.user());
                disconnect.write(Type.COMPONENT, JsonUtil.textToComponent(resourcePacksStorage.getTranslations().get("disconnectionScreen.editor.mismatchEditorWorld")));
                disconnect.send(BedrockProtocol.class);
                return;
            }
            ViaBedrock.getPlatform().getLogger().log(Level.INFO, "Server feature version: " + vanillaVersion);
            for (Experiment experiment : experiments) {
                if (!experiment.enabled()) continue;
                Via.getPlatform().getLogger().log(Level.WARNING, "This server uses an experimental feature: " + experiment.name());
            }
            try {
                version = vanillaVersion.equals("*") ? new Semver("99.99.99") : new Semver(vanillaVersion, Semver.SemverType.LOOSE);
            }
            catch (Throwable e) {
                Via.getPlatform().getLogger().log(Level.SEVERE, "Invalid vanilla version: " + vanillaVersion);
                version = new Semver("99.99.99");
            }
            CompoundTag registries = BedrockProtocol.MAPPINGS.getRegistries().clone();
            CompoundTag dimensionRegistry = (CompoundTag)registries.get("minecraft:dimension_type");
            CompoundTag biomeRegistry = (CompoundTag)registries.get("minecraft:worldgen/biome");
            ListTag dimensions = (ListTag)dimensionRegistry.get("value");
            Map<String, CompoundTag> dimensionMap = dimensions.getValue().stream().map(CompoundTag.class::cast).collect(Collectors.toMap(tag -> ((Tag)tag.get("name")).getValue().toString(), tag -> (CompoundTag)tag.get("element")));
            dimensionMap.get("minecraft:the_nether").put("min_y", new IntTag(0));
            dimensionMap.get("minecraft:the_nether").put("height", new IntTag(128));
            if (version.isLowerThan("1.18.0")) {
                dimensionMap.get("minecraft:overworld").put("min_y", new IntTag(0));
                dimensionMap.get("minecraft:overworld").put("height", new IntTag(256));
                dimensionMap.get("minecraft:overworld").put("logical_height", new IntTag(256));
                dimensionMap.get("minecraft:overworld_caves").put("min_y", new IntTag(0));
                dimensionMap.get("minecraft:overworld_caves").put("height", new IntTag(256));
                dimensionMap.get("minecraft:overworld_caves").put("logical_height", new IntTag(256));
            }
            biomeRegistry.put("value", BiomeRegistry.buildJavaBiomeRegistry(BedrockProtocol.MAPPINGS.getBiomeDefinitions()));
            GameSessionStorage gameSession = new GameSessionStorage(wrapper.user());
            wrapper.user().put(gameSession);
            gameSession.setBedrockVanillaVersion(version);
            gameSession.setJavaRegistries(registries);
            gameSession.setChatRestricted(chatRestrictionLevel >= 1);
            gameSession.setCommandsEnabled(commandsEnabled);
            gameSession.setFlatGenerator(generatorId == 2);
            gameSession.setMovementMode(movementMode);
            gameSession.setLevelGameType(levelGameType);
            if (movementMode >= 2) {
                ViaBedrock.getPlatform().getLogger().log(Level.SEVERE, "This server uses server authoritative movement with rewind. This is not supported.");
            } else if (movementMode >= 1) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "This server uses server authoritative movement. This is not stable yet.");
            }
            spawnPositionStorage.setSpawnPosition(dimensionId, defaultSpawnPosition);
            ClientPlayerEntity clientPlayer = new ClientPlayerEntity(wrapper.user(), uniqueEntityId, runtimeEntityId, 0, wrapper.user().getProtocolInfo().getUuid());
            clientPlayer.setPosition(new Position3f(playerPosition.x(), playerPosition.y() + clientPlayer.eyeOffset(), playerPosition.z()));
            clientPlayer.setRotation(new Position3f(playerRotation.x(), playerRotation.y(), 0.0f));
            clientPlayer.setOnGround(false);
            clientPlayer.setGameType(playerGameType);
            clientPlayer.setName(wrapper.user().getProtocolInfo().getUsername());
            PacketWrapper joinGame = PacketWrapper.create(ClientboundPackets1_19_4.JOIN_GAME, wrapper.user());
            joinGame.write(Type.INT, clientPlayer.javaId());
            joinGame.write(Type.BOOLEAN, false);
            joinGame.write(Type.UNSIGNED_BYTE, GameTypeRewriter.getEffectiveGameMode(playerGameType, levelGameType));
            joinGame.write(Type.BYTE, (byte)-1);
            joinGame.write(Type.STRING_ARRAY, new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
            joinGame.write(Type.NBT, registries);
            joinGame.write(Type.STRING, DimensionIdRewriter.dimensionIdToDimensionKey(dimensionId));
            joinGame.write(Type.STRING, DimensionIdRewriter.dimensionIdToDimensionKey(dimensionId));
            joinGame.write(Type.LONG, 0L);
            joinGame.write(Type.VAR_INT, 100);
            joinGame.write(Type.VAR_INT, 8);
            joinGame.write(Type.VAR_INT, 8);
            joinGame.write(Type.BOOLEAN, false);
            joinGame.write(Type.BOOLEAN, true);
            joinGame.write(Type.BOOLEAN, false);
            joinGame.write(Type.BOOLEAN, gameSession.isFlatGenerator());
            joinGame.write(Type.OPTIONAL_GLOBAL_POSITION, null);
            joinGame.write(Type.VAR_INT, 0);
            joinGame.send(BedrockProtocol.class);
            wrapper.user().put(new BlockStateRewriter(wrapper.user(), blockProperties, hashedRuntimeBlockIds));
            wrapper.user().put(new ItemRewriter(wrapper.user(), itemEntries));
            wrapper.user().put(new ChunkTracker(wrapper.user(), dimensionId));
            EntityTracker entityTracker = new EntityTracker(wrapper.user());
            entityTracker.addEntity(clientPlayer);
            wrapper.user().put(entityTracker);
            PacketWrapper brandPluginMessage = PacketWrapper.create(ClientboundPackets1_19_4.PLUGIN_MESSAGE, wrapper.user());
            brandPluginMessage.write(Type.STRING, "minecraft:brand");
            brandPluginMessage.write(Type.STRING, "Bedrock" + (!serverEngine.isEmpty() ? " @" + serverEngine : "") + " v: " + vanillaVersion);
            brandPluginMessage.send(BedrockProtocol.class);
            PacketWrapper serverDifficulty = PacketWrapper.create(ClientboundPackets1_19_4.SERVER_DIFFICULTY, wrapper.user());
            serverDifficulty.write(Type.UNSIGNED_BYTE, (short)difficulty);
            serverDifficulty.write(Type.BOOLEAN, false);
            serverDifficulty.send(BedrockProtocol.class);
            PacketWrapper tags = PacketWrapper.create(ClientboundPackets1_19_4.TAGS, wrapper.user());
            tags.write(Type.VAR_INT, BedrockProtocol.MAPPINGS.getTags().size());
            for (Map.Entry<String, Tag> registryEntry : BedrockProtocol.MAPPINGS.getTags().entrySet()) {
                CompoundTag tag2 = (CompoundTag)registryEntry.getValue();
                tags.write(Type.STRING, registryEntry.getKey());
                tags.write(Type.VAR_INT, tag2.size());
                for (Map.Entry<String, Tag> tagEntry : tag2.entrySet()) {
                    tags.write(Type.STRING, tagEntry.getKey());
                    tags.write(Type.VAR_INT_ARRAY_PRIMITIVE, ((IntArrayTag)tagEntry.getValue()).getValue());
                }
            }
            tags.send(BedrockProtocol.class);
            PacketWrapper tabList = PacketWrapper.create(ClientboundPackets1_19_4.TAB_LIST, wrapper.user());
            tabList.write(Type.COMPONENT, JsonUtil.textToComponent(levelName + "\n"));
            tabList.write(Type.COMPONENT, JsonUtil.textToComponent("\u00a7aViaBedrock \u00a73v0.0.2-SNAPSHOT\n\u00a77https://github.com/RaphiMC/ViaBedrock"));
            tabList.send(BedrockProtocol.class);
            PacketWrapper playerInfoUpdate = PacketWrapper.create(ClientboundPackets1_19_4.PLAYER_INFO_UPDATE, wrapper.user());
            playerInfoUpdate.write(JavaTypes.PROFILE_ACTIONS_ENUM_TYPE, BitSets.create(6, 0, 2));
            playerInfoUpdate.write(Type.VAR_INT, 1);
            playerInfoUpdate.write(Type.UUID, clientPlayer.javaUuid());
            playerInfoUpdate.write(Type.STRING, StringUtil.encodeUUID(clientPlayer.javaUuid()));
            playerInfoUpdate.write(Type.VAR_INT, 0);
            playerInfoUpdate.write(Type.VAR_INT, Integer.valueOf(GameTypeRewriter.getEffectiveGameMode(playerGameType, levelGameType)));
            playerInfoUpdate.send(BedrockProtocol.class);
            if (rainLevel > 0.0f || lightningLevel > 0.0f) {
                PacketWrapper rainStartGameEvent = PacketWrapper.create(ClientboundPackets1_19_4.GAME_EVENT, wrapper.user());
                rainStartGameEvent.write(Type.UNSIGNED_BYTE, (short)1);
                rainStartGameEvent.write(Type.FLOAT, Float.valueOf(0.0f));
                rainStartGameEvent.send(BedrockProtocol.class);
                if (rainLevel > 0.0f) {
                    PacketWrapper rainStrengthGameEvent = PacketWrapper.create(ClientboundPackets1_19_4.GAME_EVENT, wrapper.user());
                    rainStrengthGameEvent.write(Type.UNSIGNED_BYTE, (short)7);
                    rainStrengthGameEvent.write(Type.FLOAT, Float.valueOf(rainLevel));
                    rainStrengthGameEvent.send(BedrockProtocol.class);
                }
                if (lightningLevel > 0.0f) {
                    PacketWrapper thunderStrengthGameEvent = PacketWrapper.create(ClientboundPackets1_19_4.GAME_EVENT, wrapper.user());
                    thunderStrengthGameEvent.write(Type.UNSIGNED_BYTE, (short)8);
                    thunderStrengthGameEvent.write(Type.FLOAT, Float.valueOf(lightningLevel));
                    thunderStrengthGameEvent.send(BedrockProtocol.class);
                }
            }
            entityTracker.getClientPlayer().sendPlayerPositionPacketToClient(false);
            PacketWrapper requestChunkRadius = PacketWrapper.create(ServerboundBedrockPackets.REQUEST_CHUNK_RADIUS, wrapper.user());
            requestChunkRadius.write(BedrockTypes.VAR_INT, 8);
            requestChunkRadius.write(Type.UNSIGNED_BYTE, (short)28);
            requestChunkRadius.sendToServer(BedrockProtocol.class);
            PacketWrapper tickSync = PacketWrapper.create(ServerboundBedrockPackets.TICK_SYNC, wrapper.user());
            tickSync.write(BedrockTypes.LONG_LE, 0L);
            tickSync.write(BedrockTypes.LONG_LE, 0L);
            tickSync.sendToServer(BedrockProtocol.class);
            if (gameSession.getMovementMode() == 0) {
                entityTracker.getClientPlayer().sendMovePlayerPacketToServer((short)0);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.BIOME_DEFINITION_LIST, null, wrapper -> {
            wrapper.cancel();
            wrapper.user().get(GameSessionStorage.class).setBedrockBiomeDefinitions((CompoundTag)wrapper.read(BedrockTypes.NETWORK_TAG));
        });
        protocol.registerClientbound(ClientboundBedrockPackets.COMPRESSED_BIOME_DEFINITION_LIST, null, wrapper -> BedrockProtocol.kickForIllegalState(wrapper.user(), "Compressed biome definitions are not supported."));
    }
}

