/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.gson.JsonNull;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.gson.io.GsonDeserializer;
import io.jsonwebtoken.io.Decoders;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.logging.Level;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.providers.NettyPipelineProvider;
import net.raphimc.viabedrock.protocol.providers.SkinProvider;
import net.raphimc.viabedrock.protocol.storage.AuthChainData;
import net.raphimc.viabedrock.protocol.storage.HandshakeStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class LoginPackets {
    private static final KeyFactory EC_KEYFACTORY;
    private static final ECPublicKey MOJANG_PUBLIC_KEY;
    private static final int CLOCK_SKEW = 60;
    private static final Gson GSON;
    private static final GsonDeserializer<Map<String, ?>> GSON_DESERIALIZER;

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(State.LOGIN, ClientboundBedrockPackets.DISCONNECT.getId(), ClientboundLoginPackets.LOGIN_DISCONNECT.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    boolean hasMessage;
                    boolean bl = hasMessage = wrapper.read(Type.BOOLEAN) == false;
                    if (hasMessage) {
                        Map<String, String> translations = BedrockProtocol.MAPPINGS.getVanillaResourcePack().content().getLang("texts/en_US.lang");
                        Function<String, String> translator = k -> translations.getOrDefault(k, (String)k);
                        String rawMessage = wrapper.read(BedrockTypes.STRING);
                        String translatedMessage = BedrockTranslator.translate(rawMessage, translator, new Object[0], new TranslatorOptions[0]);
                        wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translatedMessage));
                    } else {
                        wrapper.write(Type.COMPONENT, JsonNull.INSTANCE);
                    }
                });
            }
        });
        protocol.registerClientbound(State.LOGIN, ClientboundBedrockPackets.NETWORK_SETTINGS.getId(), -1, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    HandshakeStorage handshakeStorage = wrapper.user().get(HandshakeStorage.class);
                    AuthChainData authChainData = wrapper.user().get(AuthChainData.class);
                    int threshold = wrapper.read(BedrockTypes.UNSIGNED_SHORT_LE);
                    int algorithm = wrapper.read(BedrockTypes.UNSIGNED_SHORT_LE);
                    Via.getManager().getProviders().get(NettyPipelineProvider.class).enableCompression(wrapper.user(), threshold, algorithm);
                    JsonObject rootObj = new JsonObject();
                    JsonArray chain = new JsonArray();
                    if (authChainData.getSelfSignedJwt() != null) {
                        chain.add((JsonElement)new JsonPrimitive(authChainData.getSelfSignedJwt()));
                    }
                    if (authChainData.getMojangJwt() != null) {
                        chain.add((JsonElement)new JsonPrimitive(authChainData.getMojangJwt()));
                    }
                    if (authChainData.getIdentityJwt() != null) {
                        chain.add((JsonElement)new JsonPrimitive(authChainData.getIdentityJwt()));
                    }
                    rootObj.add("chain", (JsonElement)chain);
                    String chainData = rootObj.toString();
                    PacketWrapper login = PacketWrapper.create(ServerboundBedrockPackets.LOGIN, wrapper.user());
                    login.write(Type.INT, handshakeStorage.getProtocolVersion());
                    login.write(BedrockTypes.UNSIGNED_VAR_INT, chainData.length() + authChainData.getSkinJwt().length() + 8);
                    login.write(BedrockTypes.ASCII_STRING, AsciiString.of((CharSequence)chainData));
                    login.write(BedrockTypes.ASCII_STRING, AsciiString.of((CharSequence)authChainData.getSkinJwt()));
                    login.sendToServer(BedrockProtocol.class);
                });
            }
        });
        protocol.registerClientbound(State.LOGIN, ClientboundBedrockPackets.SERVER_TO_CLIENT_HANDSHAKE.getId(), -1, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    AuthChainData authChainData = wrapper.user().get(AuthChainData.class);
                    final boolean[] trim = new boolean[]{true};
                    Jws<Claims> jwt = Jwts.parserBuilder().setAllowedClockSkewSeconds(60L).setSigningKeyResolver(new SigningKeyResolverAdapter(){

                        @Override
                        public Key resolveSigningKey(JwsHeader header, Claims claims) {
                            trim[0] = false;
                            return LoginPackets.publicKeyFromBase64((String)header.get("x5u"));
                        }
                    }).base64UrlDecodeWith(s -> {
                        if (trim[0]) {
                            return new String(Decoders.BASE64URL.decode((String)s), StandardCharsets.UTF_8).trim().getBytes(StandardCharsets.UTF_8);
                        }
                        return Decoders.BASE64URL.decode((String)s);
                    }).build().parseClaimsJws(wrapper.read(BedrockTypes.STRING));
                    byte[] salt = Base64.getDecoder().decode(((Claims)jwt.getBody()).get("salt", String.class));
                    SecretKey secretKey = LoginPackets.ecdhKeyExchange(authChainData.getPrivateKey(), LoginPackets.publicKeyFromBase64((String)((JwsHeader)jwt.getHeader()).get("x5u")), salt);
                    Via.getManager().getProviders().get(NettyPipelineProvider.class).enableEncryption(wrapper.user(), secretKey);
                    PacketWrapper clientToServerHandshake = PacketWrapper.create(ServerboundBedrockPackets.CLIENT_TO_SERVER_HANDSHAKE, wrapper.user());
                    clientToServerHandshake.sendToServer(BedrockProtocol.class);
                });
            }
        });
        protocol.registerClientbound(State.LOGIN, ClientboundBedrockPackets.PLAY_STATUS.getId(), ClientboundLoginPackets.GAME_PROFILE.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    int status = wrapper.read(Type.INT);
                    if (status == 0) {
                        AuthChainData authChainData = wrapper.user().get(AuthChainData.class);
                        wrapper.write(Type.UUID, authChainData.getIdentity());
                        wrapper.write(Type.STRING, authChainData.getDisplayName());
                        wrapper.write(Type.VAR_INT, 0);
                        ProtocolInfo protocolInfo = wrapper.user().getProtocolInfo();
                        protocolInfo.setUsername(authChainData.getDisplayName());
                        protocolInfo.setUuid(authChainData.getIdentity());
                        protocolInfo.setState(State.PLAY);
                        Via.getManager().getConnectionManager().onLoginSuccess(wrapper.user());
                        if (!protocolInfo.getPipeline().hasNonBaseProtocols()) {
                            wrapper.user().setActive(false);
                        }
                        PacketWrapper clientCacheStatus = PacketWrapper.create(ServerboundBedrockPackets.CLIENT_CACHE_STATUS, wrapper.user());
                        clientCacheStatus.write(Type.BOOLEAN, ViaBedrock.getConfig().isBlobCacheEnabled());
                        clientCacheStatus.sendToServer(BedrockProtocol.class);
                    } else {
                        wrapper.setPacketType(ClientboundLoginPackets.LOGIN_DISCONNECT);
                        LoginPackets.writePlayStatusKickMessage(wrapper, status);
                    }
                });
            }
        });
        protocol.registerServerbound(State.LOGIN, ServerboundLoginPackets.HELLO.getId(), ServerboundBedrockPackets.REQUEST_NETWORK_SETTINGS.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    HandshakeStorage handshakeStorage = wrapper.user().get(HandshakeStorage.class);
                    ProtocolInfo protocolInfo = wrapper.user().getProtocolInfo();
                    protocolInfo.setUsername(wrapper.read(Type.STRING));
                    protocolInfo.setUuid(wrapper.read(Type.OPTIONAL_UUID));
                    wrapper.write(Type.INT, handshakeStorage.getProtocolVersion());
                    LoginPackets.validateAndFullAuthChainData(wrapper.user());
                });
            }
        });
    }

    public static void writePlayStatusKickMessage(PacketWrapper wrapper, int status) {
        Map<String, String> translations = BedrockProtocol.MAPPINGS.getVanillaResourcePack().content().getLang("texts/en_US.lang");
        switch (status) {
            case 1: {
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translations.get("disconnectionScreen.outdatedClient")));
                break;
            }
            case 2: {
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translations.get("disconnectionScreen.outdatedServer")));
                break;
            }
            case 4: {
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translations.get("disconnectionScreen.invalidTenant")));
                break;
            }
            case 5: {
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translations.get("disconnectionScreen.editionMismatchEduToVanilla")));
                break;
            }
            case 6: {
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translations.get("disconnectionScreen.editionMismatchVanillaToEdu")));
                break;
            }
            case 7: 
            case 9: {
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translations.get("disconnectionScreen.serverFull") + "\n\n\n\n" + translations.get("disconnectionScreen.serverFull.title")));
                break;
            }
            case 8: {
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translations.get("disconnectionScreen.editor.mismatchEditorToVanilla")));
                break;
            }
            default: {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received invalid login status: " + status);
            }
            case 0: 
            case 3: {
                wrapper.cancel();
            }
        }
    }

    private static ECPublicKey publicKeyFromBase64(String base64) {
        try {
            return (ECPublicKey)EC_KEYFACTORY.generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(base64)));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not decode base64 public key", e);
        }
    }

    private static void validateAndFullAuthChainData(UserConnection user) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (user.has(AuthChainData.class)) {
            AuthChainData authChainData = user.get(AuthChainData.class);
            ECPublicKey publicKey = authChainData.getPublicKey();
            ECPrivateKey privateKey = authChainData.getPrivateKey();
            String encodedPublicKey = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            Jws<Claims> mojangJwt = Jwts.parserBuilder().setAllowedClockSkewSeconds(60L).setSigningKey(MOJANG_PUBLIC_KEY).deserializeJsonWith(GSON_DESERIALIZER).build().parseClaimsJws(authChainData.getMojangJwt());
            ECPublicKey mojangJwtPublicKey = LoginPackets.publicKeyFromBase64(((Claims)mojangJwt.getBody()).get("identityPublicKey", String.class));
            Jws<Claims> identityJwt = Jwts.parserBuilder().setAllowedClockSkewSeconds(60L).setSigningKey(mojangJwtPublicKey).build().parseClaimsJws(authChainData.getIdentityJwt());
            if (authChainData.getSelfSignedJwt() == null) {
                String selfSignedJwt = Jwts.builder().signWith(privateKey, SignatureAlgorithm.ES384).setHeaderParam("x5u", encodedPublicKey).claim("certificateAuthority", true).claim("identityPublicKey", ((JwsHeader)mojangJwt.getHeader()).get("x5u")).setExpiration(Date.from(Instant.now().plus(2L, ChronoUnit.DAYS))).setNotBefore(Date.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).compact();
                authChainData.setSelfSignedJwt(selfSignedJwt);
            }
            if (authChainData.getSkinJwt() == null) {
                String skinData = Jwts.builder().signWith(privateKey, SignatureAlgorithm.ES384).setHeaderParam("x5u", encodedPublicKey).addClaims(Via.getManager().getProviders().get(SkinProvider.class).getClientPlayerSkin(user)).compact();
                authChainData.setSkinJwt(skinData);
            }
            Map extraData = ((Claims)identityJwt.getBody()).get("extraData", Map.class);
            authChainData.setXuid((String)extraData.get("XUID"));
            authChainData.setIdentity(UUID.fromString((String)extraData.get("identity")));
            authChainData.setDisplayName((String)extraData.get("displayName"));
        } else {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(new ECGenParameterSpec("secp384r1"));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
            String encodedPublicKey = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            String displayName = user.getProtocolInfo().getUsername();
            UUID offlineUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + displayName).getBytes(StandardCharsets.UTF_8));
            HashMap<String, String> extraData = new HashMap<String, String>();
            extraData.put("XUID", Long.toString(offlineUUID.getLeastSignificantBits()));
            extraData.put("identity", offlineUUID.toString());
            extraData.put("displayName", displayName);
            extraData.put("titleId", "896928775");
            String identityJwt = Jwts.builder().signWith(privateKey, SignatureAlgorithm.ES384).setHeaderParam("x5u", encodedPublicKey).claim("identityPublicKey", encodedPublicKey).claim("iss", "Mojang").claim("randomNonce", ThreadLocalRandom.current().nextLong()).claim("extraData", extraData).setIssuedAt(Date.from(Instant.now())).setExpiration(Date.from(Instant.now().plus(1L, ChronoUnit.DAYS))).setNotBefore(Date.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).compact();
            AuthChainData authChainData = new AuthChainData(user, null, identityJwt, publicKey, privateKey, UUID.randomUUID(), "");
            authChainData.setXuid((String)extraData.get("XUID"));
            authChainData.setIdentity(UUID.fromString((String)extraData.get("identity")));
            authChainData.setDisplayName((String)extraData.get("displayName"));
            user.put(authChainData);
            String skinData = Jwts.builder().signWith(privateKey, SignatureAlgorithm.ES384).setHeaderParam("x5u", encodedPublicKey).addClaims(Via.getManager().getProviders().get(SkinProvider.class).getClientPlayerSkin(user)).compact();
            authChainData.setSkinJwt(skinData);
        }
    }

    private static SecretKey ecdhKeyExchange(ECPrivateKey localPrivateKey, ECPublicKey remotePublicKey, byte[] salt) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement ecdh = KeyAgreement.getInstance("ECDH");
        ecdh.init(localPrivateKey);
        ecdh.doPhase(remotePublicKey, true);
        byte[] sharedSecret = ecdh.generateSecret();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(salt);
        sha256.update(sharedSecret);
        return new SecretKeySpec(sha256.digest(), "AES");
    }

    static {
        GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).disableHtmlEscaping().create();
        GSON_DESERIALIZER = new GsonDeserializer(GSON);
        try {
            EC_KEYFACTORY = KeyFactory.getInstance("EC");
            MOJANG_PUBLIC_KEY = LoginPackets.publicKeyFromBase64("MHYwEAYHKoZIzj0CAQYFK4EEACIDYgAE8ELkixyLcwlZryUQcu1TvPOmI2B7vX83ndnWRUaXm74wFfa5f/lwQNTfrLVHa2PmenpGI6JhIMUJaWZrjmMj90NoKNFSNBuKdm8rYiXsfaz3K36x/1U26HpG0ZxK/V1V");
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not initialize the required cryptography", e);
        }
    }
}

