/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.minecraft.entities.Entity1_19_4Types;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.model.entity.PlayerEntity;
import net.raphimc.viabedrock.api.util.BitSets;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.api.util.StringUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.EntityLink;
import net.raphimc.viabedrock.protocol.model.PlayerAbilities;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.GameTypeRewriter;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.JavaTypes;

public class OtherPlayerPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.ADD_PLAYER, ClientboundPackets1_19_4.SPAWN_PLAYER, wrapper -> {
            GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
            ItemRewriter itemRewriter = wrapper.user().get(ItemRewriter.class);
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            UUID uuid = wrapper.read(BedrockTypes.UUID);
            String username = wrapper.read(BedrockTypes.STRING);
            long runtimeEntityId = wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            String platformChatId = wrapper.read(BedrockTypes.STRING);
            Position3f position = wrapper.read(BedrockTypes.POSITION_3F);
            Position3f motion = wrapper.read(BedrockTypes.POSITION_3F);
            Position3f rotation = wrapper.read(BedrockTypes.POSITION_3F);
            BedrockItem item = wrapper.read(itemRewriter.itemType());
            int gameType = wrapper.read(BedrockTypes.VAR_INT);
            Metadata[] metadata = wrapper.read(BedrockTypes.METADATA_ARRAY);
            Int2IntMap intProperties = wrapper.read(BedrockTypes.INT_PROPERTIES);
            Map<Integer, Float> floatProperties = wrapper.read(BedrockTypes.FLOAT_PROPERTIES);
            PlayerAbilities abilities = wrapper.read(BedrockTypes.PLAYER_ABILITIES);
            EntityLink[] entityLinks = wrapper.read(BedrockTypes.ENTITY_LINK_ARRAY);
            PlayerEntity entity = (PlayerEntity)entityTracker.addEntity(abilities.uniqueEntityId(), runtimeEntityId, uuid, Entity1_19_4Types.PLAYER);
            entity.setPosition(position);
            entity.setRotation(rotation);
            entity.updateName(username);
            PacketWrapper playerInfoUpdate = PacketWrapper.create(ClientboundPackets1_19_4.PLAYER_INFO_UPDATE, wrapper.user());
            playerInfoUpdate.write(JavaTypes.PROFILE_ACTIONS_ENUM_TYPE, BitSets.create(6, 0, 2));
            playerInfoUpdate.write(Type.VAR_INT, 1);
            playerInfoUpdate.write(Type.UUID, uuid);
            playerInfoUpdate.write(Type.STRING, StringUtil.encodeUUID(uuid));
            playerInfoUpdate.write(Type.VAR_INT, 3);
            playerInfoUpdate.write(Type.STRING, "platform_chat_id");
            playerInfoUpdate.write(Type.STRING, platformChatId);
            playerInfoUpdate.write(Type.OPTIONAL_STRING, null);
            playerInfoUpdate.write(Type.STRING, "device_id");
            playerInfoUpdate.write(Type.STRING, wrapper.read(BedrockTypes.STRING));
            playerInfoUpdate.write(Type.OPTIONAL_STRING, null);
            playerInfoUpdate.write(Type.STRING, "device_os");
            playerInfoUpdate.write(Type.STRING, wrapper.read(BedrockTypes.INT_LE).toString());
            playerInfoUpdate.write(Type.OPTIONAL_STRING, null);
            playerInfoUpdate.write(Type.VAR_INT, Integer.valueOf(GameTypeRewriter.getEffectiveGameMode(gameType, gameSession.getLevelGameType())));
            playerInfoUpdate.send(BedrockProtocol.class);
            wrapper.write(Type.VAR_INT, entity.javaId());
            wrapper.write(Type.UUID, uuid);
            wrapper.write(Type.DOUBLE, Double.valueOf(position.x()));
            wrapper.write(Type.DOUBLE, Double.valueOf(position.y()));
            wrapper.write(Type.DOUBLE, Double.valueOf(position.z()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(rotation.y()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(rotation.x()));
            wrapper.send(BedrockProtocol.class);
            wrapper.cancel();
            PacketWrapper entityHeadLook = PacketWrapper.create(ClientboundPackets1_19_4.ENTITY_HEAD_LOOK, wrapper.user());
            entityHeadLook.write(Type.VAR_INT, entity.javaId());
            entityHeadLook.write(Type.BYTE, MathUtil.float2Byte(rotation.z()));
            entityHeadLook.send(BedrockProtocol.class);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.MOVE_PLAYER, ClientboundPackets1_19_4.ENTITY_TELEPORT, wrapper -> {
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            long runtimeEntityId = wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            Position3f position = wrapper.read(BedrockTypes.POSITION_3F);
            Position3f rotation = wrapper.read(BedrockTypes.POSITION_3F);
            short mode = wrapper.read(Type.UNSIGNED_BYTE);
            boolean onGround = wrapper.read(Type.BOOLEAN);
            wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            if (mode == 2) {
                wrapper.read(BedrockTypes.INT_LE);
                wrapper.read(BedrockTypes.INT_LE);
            }
            wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
            Entity entity = entityTracker.getEntityByRid(runtimeEntityId);
            if (entity == null) {
                wrapper.cancel();
                return;
            }
            if (!entity.type().isOrHasParent(Entity1_19_4Types.PLAYER)) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received move player packet for non-player entity: " + entity.type());
                wrapper.cancel();
                return;
            }
            if (mode == 3) {
                BedrockProtocol.kickForIllegalState(wrapper.user(), "Head rotation is not implemented");
                return;
            }
            entity.setPosition(position);
            entity.setRotation(rotation);
            entity.setOnGround(onGround);
            if ((mode == 2 || mode == 1) && entity instanceof ClientPlayerEntity) {
                ClientPlayerEntity clientPlayer = (ClientPlayerEntity)entity;
                wrapper.setPacketType(ClientboundPackets1_19_4.PLAYER_POSITION);
                if (mode == 1 && clientPlayer.isChangingDimension()) {
                    clientPlayer.setRespawning(true);
                }
                clientPlayer.writePlayerPositionPacketToClient(wrapper, false, mode == 1);
                return;
            }
            wrapper.write(Type.VAR_INT, entity.javaId());
            wrapper.write(Type.DOUBLE, Double.valueOf(position.x()));
            wrapper.write(Type.DOUBLE, (double)position.y() - (double)entity.eyeOffset());
            wrapper.write(Type.DOUBLE, Double.valueOf(position.z()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(rotation.y()));
            wrapper.write(Type.BYTE, MathUtil.float2Byte(rotation.x()));
            wrapper.write(Type.BOOLEAN, onGround);
            PacketWrapper entityHeadLook = PacketWrapper.create(ClientboundPackets1_19_4.ENTITY_HEAD_LOOK, wrapper.user());
            entityHeadLook.write(Type.VAR_INT, entity.javaId());
            entityHeadLook.write(Type.BYTE, MathUtil.float2Byte(rotation.z()));
            entityHeadLook.send(BedrockProtocol.class);
        });
    }
}

