/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.gson.JsonNull;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ServerboundPackets1_19_4;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.util.JsonUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.packets.LoginPackets;
import net.raphimc.viabedrock.protocol.storage.BlobCache;
import net.raphimc.viabedrock.protocol.storage.ChannelStorage;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.PacketSyncStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class PlayPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.DISCONNECT, ClientboundPackets1_19_4.DISCONNECT, wrapper -> {
            boolean hasMessage;
            boolean bl = hasMessage = wrapper.read(Type.BOOLEAN) == false;
            if (hasMessage) {
                Map<String, String> translations = BedrockProtocol.MAPPINGS.getVanillaResourcePack().content().getLang("texts/en_US.lang");
                Function<String, String> translator = k -> translations.getOrDefault(k, (String)k);
                String rawMessage = wrapper.read(BedrockTypes.STRING);
                String translatedMessage = BedrockTranslator.translate(rawMessage, translator, new Object[0], new TranslatorOptions[0]);
                wrapper.write(Type.COMPONENT, JsonUtil.textToComponent(translatedMessage));
            } else {
                wrapper.write(Type.COMPONENT, JsonNull.INSTANCE);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.PLAY_STATUS, ClientboundPackets1_19_4.DISCONNECT, wrapper -> {
            int status = wrapper.read(Type.INT);
            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
            GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
            if (status == 0) {
                wrapper.cancel();
                PacketWrapper clientCacheStatus = PacketWrapper.create(ServerboundBedrockPackets.CLIENT_CACHE_STATUS, wrapper.user());
                clientCacheStatus.write(Type.BOOLEAN, ViaBedrock.getConfig().isBlobCacheEnabled());
                clientCacheStatus.sendToServer(BedrockProtocol.class);
            }
            if (status == 3) {
                wrapper.cancel();
                ClientPlayerEntity clientPlayer = entityTracker.getClientPlayer();
                if (clientPlayer.isInitiallySpawned()) {
                    if (clientPlayer.isChangingDimension()) {
                        clientPlayer.closeDownloadingTerrainScreen();
                    }
                    return;
                }
                if (gameSession.getBedrockBiomeDefinitions() == null) {
                    BedrockProtocol.kickForIllegalState(wrapper.user(), "Tried to spawn the client player before the biome definitions were loaded!");
                    return;
                }
                PacketWrapper interact = PacketWrapper.create(ServerboundBedrockPackets.INTERACT, wrapper.user());
                interact.write(Type.UNSIGNED_BYTE, (short)4);
                interact.write(BedrockTypes.UNSIGNED_VAR_LONG, clientPlayer.runtimeId());
                interact.write(BedrockTypes.POSITION_3F, new Position3f(0.0f, 0.0f, 0.0f));
                interact.sendToServer(BedrockProtocol.class);
                PacketWrapper emoteList = PacketWrapper.create(ServerboundBedrockPackets.EMOTE_LIST, wrapper.user());
                emoteList.write(BedrockTypes.VAR_LONG, clientPlayer.runtimeId());
                emoteList.write(BedrockTypes.UUID_ARRAY, new UUID[0]);
                emoteList.sendToServer(BedrockProtocol.class);
                clientPlayer.setRotation(new Position3f(clientPlayer.rotation().x(), clientPlayer.rotation().y(), clientPlayer.rotation().y()));
                clientPlayer.setInitiallySpawned();
                if (gameSession.getMovementMode() == 0) {
                    clientPlayer.sendMovePlayerPacketToServer((short)0);
                }
                PacketWrapper setLocalPlayerAsInitialized = PacketWrapper.create(ServerboundBedrockPackets.SET_LOCAL_PLAYER_AS_INITIALIZED, wrapper.user());
                setLocalPlayerAsInitialized.write(BedrockTypes.UNSIGNED_VAR_LONG, clientPlayer.runtimeId());
                setLocalPlayerAsInitialized.sendToServer(BedrockProtocol.class);
                clientPlayer.closeDownloadingTerrainScreen();
                if (wrapper.user().getProtocolInfo().getProtocolVersion() >= ProtocolVersion.v1_20.getVersion()) {
                    UUID httpToken = UUID.randomUUID();
                    ViaBedrock.getResourcePackServer().addConnection(httpToken, wrapper.user());
                    PacketWrapper resourcePack = PacketWrapper.create(ClientboundPackets1_19_4.RESOURCE_PACK, wrapper.user());
                    resourcePack.write(Type.STRING, ViaBedrock.getResourcePackServer().getUrl() + "?token=" + httpToken);
                    resourcePack.write(Type.STRING, "");
                    resourcePack.write(Type.BOOLEAN, false);
                    resourcePack.write(Type.OPTIONAL_COMPONENT, JsonUtil.textToComponent("\nFor the best possible experience, you should accept the resource pack."));
                    resourcePack.send(BedrockProtocol.class);
                }
            } else {
                LoginPackets.writePlayStatusKickMessage(wrapper, status);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_DIFFICULTY, ClientboundPackets1_19_4.SERVER_DIFFICULTY, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)BedrockTypes.UNSIGNED_VAR_INT, Type.UNSIGNED_BYTE);
                this.create(Type.BOOLEAN, false);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.NETWORK_STACK_LATENCY, ClientboundPackets1_19_4.KEEP_ALIVE, new PacketHandlers(){

            @Override
            protected void register() {
                this.map(BedrockTypes.LONG_LE, Type.LONG, t -> {
                    if (t >= 0L) {
                        return t / 1000L * 1000L;
                    }
                    long result = (t - 383L) / 1000L * 1000L;
                    return result > 0L ? result : result - 616L;
                });
                this.handler(wrapper -> {
                    if (!wrapper.read(Type.BOOLEAN).booleanValue()) {
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.CLIENT_CACHE_MISS_RESPONSE, null, wrapper -> {
            wrapper.cancel();
            int length = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
            for (int i = 0; i < length; ++i) {
                long hash = wrapper.read(BedrockTypes.LONG_LE);
                byte[] blob = wrapper.read(BedrockTypes.BYTE_ARRAY);
                wrapper.user().get(BlobCache.class).addBlob(hash, blob);
            }
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.CLIENT_SETTINGS, ServerboundBedrockPackets.REQUEST_CHUNK_RADIUS, new PacketHandlers(){

            @Override
            public void register() {
                this.read(Type.STRING);
                this.map((Type)Type.BYTE, BedrockTypes.VAR_INT);
                this.create(Type.UNSIGNED_BYTE, (short)28);
                this.read(Type.VAR_INT);
                this.read(Type.BOOLEAN);
                this.read(Type.UNSIGNED_BYTE);
                this.read(Type.VAR_INT);
                this.read(Type.BOOLEAN);
                this.read(Type.BOOLEAN);
            }
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.KEEP_ALIVE, ServerboundBedrockPackets.NETWORK_STACK_LATENCY, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.LONG, BedrockTypes.LONG_LE);
                this.create(Type.BOOLEAN, true);
                this.handler(wrapper -> {
                    if (wrapper.get(BedrockTypes.LONG_LE, 0) == 999L) {
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.PONG, null, wrapper -> {
            wrapper.cancel();
            wrapper.user().get(PacketSyncStorage.class).handleResponse(wrapper.read(Type.INT));
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.PLUGIN_MESSAGE, null, wrapper -> {
            wrapper.cancel();
            String channel = wrapper.read(Type.STRING);
            if (channel.equals("minecraft:register")) {
                String[] channels = new String(wrapper.read(Type.REMAINING_BYTES), StandardCharsets.UTF_8).split("\u0000");
                wrapper.user().get(ChannelStorage.class).addChannels(channels);
            }
        });
    }
}

