/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ServerboundPackets1_19_4;
import com.viaversion.viaversion.util.Pair;
import com.viaversion.viaversion.util.Triple;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.ResourcePack;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.providers.ResourcePackProvider;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ResourcePackPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.RESOURCE_PACKS_INFO, null, wrapper -> {
            ResourcePack[] resourcePacks;
            ResourcePack[] behaviorPacks;
            wrapper.cancel();
            if (wrapper.user().has(ResourcePacksStorage.class)) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACKS_INFO twice");
            }
            ResourcePacksStorage resourcePacksStorage = new ResourcePacksStorage(wrapper.user());
            wrapper.user().put(resourcePacksStorage);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            wrapper.read(Type.BOOLEAN);
            for (ResourcePack behaviorPack : behaviorPacks = wrapper.read(BedrockTypes.BEHAVIOUR_PACK_ARRAY)) {
                resourcePacksStorage.addPack(behaviorPack);
            }
            for (ResourcePack resourcePack : resourcePacks = wrapper.read(BedrockTypes.RESOURCE_PACK_ARRAY)) {
                resourcePacksStorage.addPack(resourcePack);
            }
            PacketWrapper resourcePackClientResponse = PacketWrapper.create(ServerboundBedrockPackets.RESOURCE_PACK_CLIENT_RESPONSE, wrapper.user());
            HashSet<String> missingPacks = new HashSet<String>();
            for (ResourcePack pack : resourcePacksStorage.getPacks()) {
                if (resourcePacksStorage.isPreloaded(pack.packId())) continue;
                if (ViaBedrock.getConfig().storePacks() && Via.getManager().getProviders().get(ResourcePackProvider.class).hasPack(pack)) {
                    Via.getManager().getProviders().get(ResourcePackProvider.class).loadPack(pack);
                    continue;
                }
                missingPacks.add(pack.packId() + "_" + pack.version());
            }
            if (!missingPacks.isEmpty()) {
                ViaBedrock.getPlatform().getLogger().log(Level.INFO, "Downloading " + missingPacks.size() + " packs");
                resourcePackClientResponse.write(Type.UNSIGNED_BYTE, (short)2);
                resourcePackClientResponse.write(BedrockTypes.SHORT_LE_STRING_ARRAY, missingPacks.toArray(new String[0]));
            } else {
                resourcePacksStorage.setCompletedTransfer();
                resourcePackClientResponse.write(Type.UNSIGNED_BYTE, (short)3);
                resourcePackClientResponse.write(BedrockTypes.SHORT_LE_STRING_ARRAY, new String[0]);
            }
            resourcePackClientResponse.sendToServer(BedrockProtocol.class);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.RESOURCE_PACK_DATA_INFO, null, wrapper -> {
            wrapper.cancel();
            ResourcePacksStorage resourcePacksStorage = wrapper.user().get(ResourcePacksStorage.class);
            if (resourcePacksStorage.hasCompletedTransfer()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_DATA_INFO after transfer completion");
                return;
            }
            Pair<UUID, String> idAndVersion = wrapper.read(BedrockTypes.PACK_ID_AND_VERSION);
            int maxChunkSize = wrapper.read(BedrockTypes.UNSIGNED_INT_LE).intValue();
            wrapper.read(BedrockTypes.UNSIGNED_INT_LE);
            long compressedPackSize = wrapper.read(BedrockTypes.LONG_LE);
            byte[] hash = wrapper.read(BedrockTypes.BYTE_ARRAY);
            boolean premium = wrapper.read(Type.BOOLEAN);
            short type = wrapper.read(Type.UNSIGNED_BYTE);
            int actualChunkCount = (int)Math.ceil((double)compressedPackSize / (double)maxChunkSize);
            if (resourcePacksStorage.hasPack(idAndVersion.key())) {
                ResourcePack resourcePack = resourcePacksStorage.getPack(idAndVersion.key());
                resourcePack.setHash(hash);
                resourcePack.setPremium(premium);
                resourcePack.setType(type);
                resourcePack.setCompressedDataLength((int)compressedPackSize, maxChunkSize);
            } else {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_DATA_INFO for unknown pack: " + idAndVersion.key());
            }
            for (int i = 0; i < actualChunkCount; ++i) {
                PacketWrapper resourcePackChunkRequest = wrapper.create(ClientboundBedrockPackets.RESOURCE_PACK_CHUNK_REQUEST);
                resourcePackChunkRequest.write(BedrockTypes.PACK_ID_AND_VERSION, idAndVersion);
                resourcePackChunkRequest.write(BedrockTypes.INT_LE, i);
                resourcePackChunkRequest.sendToServer(BedrockProtocol.class);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.RESOURCE_PACK_CHUNK_DATA, null, wrapper -> {
            wrapper.cancel();
            ResourcePacksStorage resourcePacksStorage = wrapper.user().get(ResourcePacksStorage.class);
            if (resourcePacksStorage.hasCompletedTransfer()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_CHUNK_DATA after transfer completion");
                return;
            }
            Pair<UUID, String> idAndVersion = wrapper.read(BedrockTypes.PACK_ID_AND_VERSION);
            int chunkIndex = wrapper.read(BedrockTypes.INT_LE);
            wrapper.read(BedrockTypes.LONG_LE);
            byte[] data = wrapper.read(BedrockTypes.BYTE_ARRAY);
            if (resourcePacksStorage.hasPack(idAndVersion.key()) && !resourcePacksStorage.getPack(idAndVersion.key()).isDecompressed()) {
                ResourcePack resourcePack = resourcePacksStorage.getPack(idAndVersion.key());
                if (resourcePack.processDataChunk(chunkIndex, data) && ViaBedrock.getConfig().storePacks()) {
                    Via.getManager().getProviders().get(ResourcePackProvider.class).addPack(resourcePack);
                }
            } else {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_CHUNK_DATA for unknown pack: " + idAndVersion.key());
            }
            if (resourcePacksStorage.areAllPacksDecompressed()) {
                resourcePacksStorage.setCompletedTransfer();
                ViaBedrock.getPlatform().getLogger().log(Level.INFO, "All packs have been decompressed and decrypted");
                PacketWrapper resourcePackClientResponse = wrapper.create(ClientboundBedrockPackets.RESOURCE_PACK_CLIENT_RESPONSE);
                resourcePackClientResponse.write(Type.UNSIGNED_BYTE, (short)3);
                resourcePackClientResponse.write(BedrockTypes.SHORT_LE_STRING_ARRAY, new String[0]);
                resourcePackClientResponse.sendToServer(BedrockProtocol.class);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.RESOURCE_PACK_STACK, null, wrapper -> {
            wrapper.cancel();
            ResourcePacksStorage resourcePacksStorage = wrapper.user().get(ResourcePacksStorage.class);
            wrapper.read(Type.BOOLEAN);
            Triple<UUID, String, String>[] behaviourPacks = wrapper.read(BedrockTypes.PACK_ID_AND_VERSION_AND_NAME_ARRAY);
            Triple<UUID, String, String>[] resourcePacks = wrapper.read(BedrockTypes.PACK_ID_AND_VERSION_AND_NAME_ARRAY);
            wrapper.read(BedrockTypes.STRING);
            wrapper.read(BedrockTypes.EXPERIMENT_ARRAY);
            wrapper.read(Type.BOOLEAN);
            UUID[] behaviourPackIds = new UUID[behaviourPacks.length];
            for (int i = 0; i < behaviourPacks.length; ++i) {
                behaviourPackIds[i] = behaviourPacks[i].first();
            }
            UUID[] resourcePackIds = new UUID[resourcePacks.length];
            for (int i = 0; i < resourcePacks.length; ++i) {
                resourcePackIds[i] = resourcePacks[i].first();
            }
            resourcePacksStorage.setCompletedTransfer();
            resourcePacksStorage.setPackStack(resourcePackIds, behaviourPackIds);
            PacketWrapper resourcePackClientResponse = wrapper.create(ClientboundBedrockPackets.RESOURCE_PACK_CLIENT_RESPONSE);
            resourcePackClientResponse.write(Type.UNSIGNED_BYTE, (short)4);
            resourcePackClientResponse.write(BedrockTypes.SHORT_LE_STRING_ARRAY, new String[0]);
            resourcePackClientResponse.sendToServer(BedrockProtocol.class);
        });
        protocol.registerServerbound(ServerboundPackets1_19_4.RESOURCE_PACK_STATUS, null, PacketWrapper::cancel);
    }
}

