/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packets;

import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord1_16_2;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.util.MathUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockChunk;
import net.raphimc.viabedrock.api.chunk.RawBlockEntity;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockBiomeArray;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockDataPalette;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSection;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSectionImpl;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.BlockChangeEntry;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.BlockStateRewriter;
import net.raphimc.viabedrock.protocol.rewriter.DimensionIdRewriter;
import net.raphimc.viabedrock.protocol.rewriter.GameTypeRewriter;
import net.raphimc.viabedrock.protocol.storage.BlobCache;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.SpawnPositionStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;
import net.raphimc.viabedrock.protocol.types.array.ByteArrayType;

public class WorldPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.SET_SPAWN_POSITION, ClientboundPackets1_19_4.SPAWN_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    SpawnPositionStorage spawnPositionStorage = wrapper.user().get(SpawnPositionStorage.class);
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    int type = wrapper.read(BedrockTypes.VAR_INT);
                    if (type != 1) {
                        wrapper.cancel();
                        return;
                    }
                    Position compassPosition = wrapper.read(BedrockTypes.BLOCK_POSITION);
                    int dimensionId = wrapper.read(BedrockTypes.VAR_INT);
                    wrapper.read(BedrockTypes.BLOCK_POSITION);
                    spawnPositionStorage.setSpawnPosition(dimensionId, compassPosition);
                    if (chunkTracker.getDimensionId() != dimensionId) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Type.POSITION1_14, compassPosition);
                    wrapper.write(Type.FLOAT, Float.valueOf(0.0f));
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.CHANGE_DIMENSION, ClientboundPackets1_19_4.RESPAWN, wrapper -> {
            int dimensionId = wrapper.read(BedrockTypes.VAR_INT);
            Position3f position = wrapper.read(BedrockTypes.POSITION_3F);
            boolean respawn = wrapper.read(Type.BOOLEAN);
            if (dimensionId == wrapper.user().get(ChunkTracker.class).getDimensionId()) {
                BedrockProtocol.kickForIllegalState(wrapper.user(), "Changing dimension to the same dimension is not supported");
                return;
            }
            GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
            SpawnPositionStorage spawnPositionStorage = wrapper.user().get(SpawnPositionStorage.class);
            wrapper.user().put(new ChunkTracker(wrapper.user(), dimensionId));
            EntityTracker oldEntityTracker = wrapper.user().get(EntityTracker.class);
            ClientPlayerEntity clientPlayer = oldEntityTracker.getClientPlayer();
            oldEntityTracker.prepareForRespawn();
            EntityTracker newEntityTracker = new EntityTracker(wrapper.user());
            newEntityTracker.addEntity(clientPlayer);
            wrapper.user().put(newEntityTracker);
            spawnPositionStorage.setSpawnPosition(dimensionId, new Position((int)position.x(), (int)position.y(), (int)position.z()));
            clientPlayer.setPosition(new Position3f(position.x(), position.y() + clientPlayer.eyeOffset(), position.z()));
            if (gameSession.getMovementMode() == 0) {
                clientPlayer.sendMovePlayerPacketToServer((short)0);
            }
            clientPlayer.setChangingDimension(true);
            clientPlayer.sendPlayerPositionPacketToClient(true, true);
            wrapper.write(Type.STRING, DimensionIdRewriter.dimensionIdToDimensionKey(dimensionId));
            wrapper.write(Type.STRING, DimensionIdRewriter.dimensionIdToDimensionKey(dimensionId));
            wrapper.write(Type.LONG, 0L);
            wrapper.write(Type.UNSIGNED_BYTE, GameTypeRewriter.getEffectiveGameMode(clientPlayer.getGameType(), gameSession.getLevelGameType()));
            wrapper.write(Type.BYTE, (byte)-1);
            wrapper.write(Type.BOOLEAN, false);
            wrapper.write(Type.BOOLEAN, gameSession.isFlatGenerator());
            wrapper.write(Type.BYTE, (byte)3);
            wrapper.write(Type.OPTIONAL_GLOBAL_POSITION, null);
            wrapper.write(Type.VAR_INT, 0);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.LEVEL_CHUNK, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    BedrockChunk chunk;
                    wrapper.cancel();
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    GameSessionStorage gameSession = wrapper.user().get(GameSessionStorage.class);
                    int chunkX = wrapper.read(BedrockTypes.VAR_INT);
                    int chunkZ = wrapper.read(BedrockTypes.VAR_INT);
                    int sectionCount = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                    if (sectionCount < -2) {
                        return;
                    }
                    int startY = chunkTracker.getMinY() >> 4;
                    int endY = chunkTracker.getMaxY() >> 4;
                    int requestCount = 0;
                    if (sectionCount == -2) {
                        requestCount = wrapper.read(BedrockTypes.UNSIGNED_SHORT_LE) + 1;
                    } else if (sectionCount == -1) {
                        requestCount = endY - startY;
                    }
                    BedrockChunk previousChunk = chunkTracker.getChunk(chunkX, chunkZ);
                    if (previousChunk != null) {
                        chunkTracker.unloadChunk(chunkX, chunkZ);
                        if (previousChunk.isRequestSubChunks()) {
                            requestCount = endY - startY;
                        }
                    }
                    if ((chunk = chunkTracker.createChunk(chunkX, chunkZ, sectionCount < 0 ? requestCount : sectionCount)) == null) {
                        return;
                    }
                    chunk.setRequestSubChunks(sectionCount < 0);
                    int fRequestCount = requestCount;
                    Consumer<byte[]> dataConsumer = combinedData -> {
                        try {
                            if (fRequestCount > 0) {
                                chunkTracker.requestSubChunks(chunkX, chunkZ, startY, MathUtil.clamp(startY + fRequestCount, startY + 1, endY));
                            }
                            ByteBuf dataBuf = Unpooled.wrappedBuffer((byte[])combinedData);
                            BedrockChunkSection[] sections = chunk.getSections();
                            List<BlockEntity> blockEntities = chunk.blockEntities();
                            if (dataBuf.isReadable()) {
                                try {
                                    int i;
                                    for (i = 0; i < sectionCount; ++i) {
                                        sections[i].mergeWith(chunkTracker.handleBlockPalette((BedrockChunkSection)BedrockTypes.CHUNK_SECTION.read(dataBuf)));
                                        sections[i].applyPendingBlockUpdates(wrapper.user().get(BlockStateRewriter.class).bedrockId(BedrockBlockState.AIR));
                                    }
                                    if (gameSession.getBedrockVanillaVersion().isLowerThan("1.18.0")) {
                                        byte[] biomeData = new byte[256];
                                        dataBuf.readBytes(biomeData);
                                        for (BedrockChunkSection section : sections) {
                                            section.addPalette(PaletteType.BIOMES, new BedrockBiomeArray(biomeData));
                                        }
                                    } else {
                                        for (i = 0; i < sections.length; ++i) {
                                            BedrockDataPalette biomePalette = (BedrockDataPalette)BedrockTypes.DATA_PALETTE.read(dataBuf);
                                            if (biomePalette == null) {
                                                if (i == 0) {
                                                    throw new RuntimeException("First biome palette can not point to previous biome palette");
                                                }
                                                biomePalette = ((BedrockDataPalette)sections[i - 1].palette(PaletteType.BIOMES)).clone();
                                            }
                                            if (biomePalette.hasTagPalette()) {
                                                throw new RuntimeException("Biome palette can not have tag palette");
                                            }
                                            sections[i].addPalette(PaletteType.BIOMES, biomePalette);
                                        }
                                    }
                                    dataBuf.skipBytes(1);
                                    while (dataBuf.isReadable()) {
                                        blockEntities.add(new RawBlockEntity((CompoundTag)BedrockTypes.NETWORK_TAG.read(dataBuf)));
                                    }
                                }
                                catch (IndexOutOfBoundsException i) {
                                }
                                catch (Throwable e) {
                                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error reading chunk data", e);
                                }
                            }
                            if (!chunk.isRequestSubChunks()) {
                                chunkTracker.sendChunk(chunkX, chunkZ);
                            }
                        }
                        catch (Throwable e) {
                            throw new RuntimeException("Error handling chunk data", e);
                        }
                    };
                    if (wrapper.read(Type.BOOLEAN).booleanValue()) {
                        int expectedLength;
                        Long[] blobs = wrapper.read(BedrockTypes.LONG_ARRAY);
                        int n = expectedLength = sectionCount < 0 ? 1 : sectionCount + 1;
                        if (blobs.length != expectedLength) {
                            BedrockProtocol.kickForIllegalState(wrapper.user(), "Invalid blob count: " + blobs.length + " (expected " + expectedLength + ")");
                            return;
                        }
                        byte[] data = wrapper.read(BedrockTypes.BYTE_ARRAY);
                        wrapper.user().get(BlobCache.class).getBlob(blobs).thenAccept(blob -> {
                            byte[] combinedData = new byte[data.length + ((byte[])blob).length];
                            System.arraycopy(blob, 0, combinedData, 0, ((byte[])blob).length);
                            System.arraycopy(data, 0, combinedData, ((byte[])blob).length, data.length);
                            dataConsumer.accept(combinedData);
                        });
                    } else {
                        dataConsumer.accept(wrapper.read(BedrockTypes.BYTE_ARRAY));
                    }
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SUB_CHUNK, null, wrapper -> {
            wrapper.cancel();
            ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
            boolean cachingEnabled = wrapper.read(Type.BOOLEAN);
            int dimensionId = wrapper.read(BedrockTypes.VAR_INT);
            if (dimensionId != chunkTracker.getDimensionId()) {
                return;
            }
            Position center = wrapper.read(BedrockTypes.POSITION_3I);
            long count = wrapper.read(BedrockTypes.UNSIGNED_INT_LE);
            for (long i = 0L; i < count; ++i) {
                Position offset = wrapper.read(BedrockTypes.SUB_CHUNK_OFFSET);
                Position absolute = new Position(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z());
                byte result = wrapper.read(Type.BYTE);
                byte[] data = result != 6 || !cachingEnabled ? wrapper.read(BedrockTypes.BYTE_ARRAY) : new byte[]{};
                byte heightmapResult = wrapper.read(Type.BYTE);
                byte[] heightmapData = heightmapResult == 1 ? wrapper.read(new ByteArrayType(256)) : new byte[]{};
                Consumer<byte[]> dataConsumer = combinedData -> {
                    block10: {
                        try {
                            if (result == 6) {
                                if (chunkTracker.mergeSubChunk(absolute.x(), absolute.y(), absolute.z(), new BedrockChunkSectionImpl(), new ArrayList<BlockEntity>())) {
                                    chunkTracker.sendChunkInNextTick(absolute.x(), absolute.z());
                                }
                                break block10;
                            }
                            if (result == 1) {
                                ByteBuf dataBuf = Unpooled.wrappedBuffer((byte[])combinedData);
                                BedrockChunkSection section = new BedrockChunkSectionImpl();
                                ArrayList<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
                                try {
                                    section = (BedrockChunkSection)BedrockTypes.CHUNK_SECTION.read(dataBuf);
                                    while (dataBuf.isReadable()) {
                                        blockEntities.add(new RawBlockEntity((CompoundTag)BedrockTypes.NETWORK_TAG.read(dataBuf)));
                                    }
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                }
                                catch (Throwable e) {
                                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error reading sub chunk data", e);
                                }
                                if (chunkTracker.mergeSubChunk(absolute.x(), absolute.y(), absolute.z(), section, blockEntities)) {
                                    chunkTracker.sendChunkInNextTick(absolute.x(), absolute.z());
                                }
                                break block10;
                            }
                            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received sub chunk with result " + result);
                            chunkTracker.requestSubChunk(absolute.x(), absolute.y(), absolute.z());
                        }
                        catch (Throwable e) {
                            throw new RuntimeException("Error handling sub chunk data", e);
                        }
                    }
                };
                if (cachingEnabled) {
                    long hash = wrapper.read(BedrockTypes.LONG_LE);
                    wrapper.user().get(BlobCache.class).getBlob(hash).thenAccept(blob -> {
                        if (data.length == 0) {
                            dataConsumer.accept((byte[])blob);
                        } else if (((byte[])blob).length == 0) {
                            dataConsumer.accept(data);
                        } else {
                            byte[] combinedData = new byte[data.length + ((byte[])blob).length];
                            System.arraycopy(blob, 0, combinedData, 0, ((byte[])blob).length);
                            System.arraycopy(data, 0, combinedData, ((byte[])blob).length, data.length);
                            dataConsumer.accept(combinedData);
                        }
                    });
                    continue;
                }
                dataConsumer.accept(data);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_BLOCK, ClientboundPackets1_19_4.BLOCK_CHANGE, new PacketHandlers(){

            @Override
            protected void register() {
                this.map(BedrockTypes.BLOCK_POSITION, Type.POSITION1_14);
                this.handler(wrapper -> {
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    Position position = wrapper.get(Type.POSITION1_14, 0);
                    int blockState = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                    wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                    int layer = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                    if (layer < 0 || layer > 1) {
                        wrapper.cancel();
                        return;
                    }
                    int remappedBlockState = chunkTracker.handleBlockChange(position, layer, blockState);
                    if (remappedBlockState == -1) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Type.VAR_INT, remappedBlockState);
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_BLOCK_SYNCED, ClientboundPackets1_19_4.BLOCK_CHANGE, new PacketHandlers(){

            @Override
            protected void register() {
                this.map(BedrockTypes.BLOCK_POSITION, Type.POSITION1_14);
                this.handler(wrapper -> {
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    Position position = wrapper.get(Type.POSITION1_14, 0);
                    int blockState = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                    wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                    int layer = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT);
                    wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
                    wrapper.read(BedrockTypes.UNSIGNED_VAR_LONG);
                    if (layer < 0 || layer > 1) {
                        wrapper.cancel();
                        return;
                    }
                    int remappedBlockState = chunkTracker.handleBlockChange(position, layer, blockState);
                    if (remappedBlockState == -1) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Type.VAR_INT, remappedBlockState);
                });
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.UPDATE_SUB_CHUNK_BLOCKS, null, wrapper -> {
            Position relative;
            Position chunkPosition;
            int remappedBlockState;
            wrapper.cancel();
            ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
            wrapper.read(BedrockTypes.BLOCK_POSITION);
            BlockChangeEntry[] layer0Blocks = wrapper.read(BedrockTypes.BLOCK_CHANGE_ENTRY_ARRAY);
            BlockChangeEntry[] layer1Blocks = wrapper.read(BedrockTypes.BLOCK_CHANGE_ENTRY_ARRAY);
            HashMap<Position, List> blockChanges = new HashMap<Position, List>();
            for (BlockChangeEntry entry : layer0Blocks) {
                remappedBlockState = chunkTracker.handleBlockChange(entry.position(), 0, entry.blockState());
                if (remappedBlockState == -1) continue;
                chunkPosition = new Position(entry.position().x() >> 4, entry.position().y() >> 4, entry.position().z() >> 4);
                relative = new Position(entry.position().x() & 0xF, entry.position().y() & 0xF, entry.position().z() & 0xF);
                blockChanges.computeIfAbsent(chunkPosition, k -> new ArrayList()).add(new BlockChangeRecord1_16_2(relative.x(), relative.y(), relative.z(), remappedBlockState));
            }
            for (BlockChangeEntry entry : layer1Blocks) {
                remappedBlockState = chunkTracker.handleBlockChange(entry.position(), 1, entry.blockState());
                if (remappedBlockState == -1) continue;
                chunkPosition = new Position(entry.position().x() >> 4, entry.position().y() >> 4, entry.position().z() >> 4);
                relative = new Position(entry.position().x() & 0xF, entry.position().y() & 0xF, entry.position().z() & 0xF);
                blockChanges.computeIfAbsent(chunkPosition, k -> new ArrayList()).add(new BlockChangeRecord1_16_2(relative.x(), relative.y(), relative.z(), remappedBlockState));
            }
            if (blockChanges.isEmpty()) {
                return;
            }
            for (Map.Entry entry : blockChanges.entrySet()) {
                Position chunkPosition2 = (Position)entry.getKey();
                List changes = (List)entry.getValue();
                long chunkKey = ((long)chunkPosition2.x() & 0x3FFFFFL) << 42;
                chunkKey |= ((long)chunkPosition2.z() & 0x3FFFFFL) << 20;
                PacketWrapper multiBlockChange = wrapper.create(ClientboundPackets1_19_4.MULTI_BLOCK_CHANGE);
                multiBlockChange.write(Type.LONG, chunkKey |= (long)chunkPosition2.y() & 0xFFFL);
                multiBlockChange.write(Type.VAR_LONG_BLOCK_CHANGE_RECORD_ARRAY, changes.toArray(new BlockChangeRecord[0]));
                multiBlockChange.send(BedrockProtocol.class);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.NETWORK_CHUNK_PUBLISHER_UPDATE, ClientboundPackets1_19_4.UPDATE_VIEW_DISTANCE, wrapper -> {
            Position position = wrapper.read(BedrockTypes.POSITION_3I);
            int radius = wrapper.read(BedrockTypes.UNSIGNED_VAR_INT) >> 4;
            wrapper.write(Type.VAR_INT, radius);
            ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
            chunkTracker.setRadius(radius);
            chunkTracker.setCenter(position.x() >> 4, position.z() >> 4);
            PacketWrapper updateViewPosition = wrapper.create(ClientboundPackets1_19_4.UPDATE_VIEW_POSITION);
            updateViewPosition.write(Type.VAR_INT, position.x() >> 4);
            updateViewPosition.write(Type.VAR_INT, position.z() >> 4);
            updateViewPosition.send(BedrockProtocol.class);
            int count = wrapper.read(BedrockTypes.INT_LE);
            for (int i = 0; i < count; ++i) {
                wrapper.read(BedrockTypes.VAR_INT);
                wrapper.read(BedrockTypes.VAR_INT);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.CHUNK_RADIUS_UPDATED, ClientboundPackets1_19_4.UPDATE_VIEW_DISTANCE, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)BedrockTypes.VAR_INT, Type.VAR_INT);
                this.handler(wrapper -> wrapper.user().get(ChunkTracker.class).setRadius(wrapper.get(Type.VAR_INT, 0)));
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SET_TIME, ClientboundPackets1_19_4.TIME_UPDATE, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)BedrockTypes.VAR_INT, Type.LONG);
                this.handler(wrapper -> wrapper.write(Type.LONG, wrapper.get(Type.LONG, 0) % 24000L));
            }
        });
    }
}

