/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.providers;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.platform.providers.Provider;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.raphimc.viabedrock.api.modinterface.BedrockSkinUtilityInterface;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.DeviceOS;
import net.raphimc.viabedrock.protocol.model.SkinData;
import net.raphimc.viabedrock.protocol.storage.AuthChainData;
import net.raphimc.viabedrock.protocol.storage.ChannelStorage;
import net.raphimc.viabedrock.protocol.storage.HandshakeStorage;
import net.raphimc.viabedrock.protocol.types.primitive.ImageType;

public class SkinProvider
implements Provider {
    public Map<String, Object> getClientPlayerSkin(UserConnection user) {
        HandshakeStorage handshakeStorage = user.get(HandshakeStorage.class);
        AuthChainData authChainData = user.get(AuthChainData.class);
        BufferedImage skin = BedrockProtocol.MAPPINGS.getSteveSkin();
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("PlayFabId", authChainData.getPlayFabId().toLowerCase(Locale.ROOT));
        claims.put("SkinId", "Custom" + authChainData.getDeviceId());
        claims.put("SkinResourcePatch", Base64.getEncoder().encodeToString("{\"geometry\":{\"default\":\"geometry.humanoid.custom\"}}".getBytes(StandardCharsets.UTF_8)));
        claims.put("SkinImageWidth", skin.getWidth());
        claims.put("SkinImageHeight", skin.getHeight());
        claims.put("SkinData", Base64.getEncoder().encodeToString(ImageType.getImageData(skin)));
        claims.put("AnimatedImageData", new ArrayList());
        claims.put("CapeImageHeight", 0);
        claims.put("CapeImageWidth", 0);
        claims.put("CapeData", "");
        claims.put("CapeId", "");
        claims.put("SkinGeometryData", Base64.getEncoder().encodeToString(BedrockProtocol.MAPPINGS.getSkinGeometry().toString().getBytes(StandardCharsets.UTF_8)));
        claims.put("SkinGeometryDataEngineVersion", Base64.getEncoder().encodeToString("0.0.0".getBytes(StandardCharsets.UTF_8)));
        claims.put("SkinAnimationData", "");
        claims.put("ArmSize", "wide");
        claims.put("SkinColor", "#0");
        claims.put("PersonaPieces", new ArrayList());
        claims.put("PieceTintColors", new ArrayList());
        claims.put("PremiumSkin", false);
        claims.put("PersonaSkin", false);
        claims.put("CapeOnClassicSkin", false);
        claims.put("ClientRandomId", ThreadLocalRandom.current().nextLong());
        claims.put("SelfSignedId", UUID.randomUUID().toString());
        claims.put("CurrentInputMode", 1);
        claims.put("DefaultInputMode", 1);
        claims.put("GuiScale", -1L);
        claims.put("UIProfile", 0);
        claims.put("DeviceId", authChainData.getDeviceId().toString());
        claims.put("DeviceModel", "");
        claims.put("DeviceOS", DeviceOS.UWP.ordinal());
        claims.put("LanguageCode", "en_US");
        claims.put("PlatformOfflineId", "");
        claims.put("PlatformOnlineId", "");
        claims.put("GameVersion", "1.20.0");
        claims.put("ServerAddress", handshakeStorage.getHostname() + ":" + handshakeStorage.getPort());
        claims.put("ThirdPartyName", user.getProtocolInfo().getUsername());
        claims.put("ThirdPartyNameOnly", false);
        claims.put("IsEditorMode", false);
        claims.put("TrustedSkin", false);
        claims.put("OverrideSkin", false);
        claims.put("CompatibleWithClientSideChunkGen", false);
        return claims;
    }

    public void setSkin(UserConnection user, UUID playerUuid, SkinData skin) throws Exception {
        ChannelStorage channelStorage = user.get(ChannelStorage.class);
        if (channelStorage.hasChannel("bedrockskin:data")) {
            BedrockSkinUtilityInterface.sendSkin(user, playerUuid, skin);
        }
    }
}

