/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter;

import com.google.common.collect.BiMap;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntOpenHashMap;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.block_state.BlockStateSanitizer;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.api.util.BlockStateHasher;
import net.raphimc.viabedrock.api.util.HashedPaletteComparator;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.model.BlockProperties;

public class BlockStateRewriter
extends StoredObject {
    private final Int2IntMap blockStateIdMappings = new Int2IntOpenHashMap();
    private final Int2IntMap legacyBlockStateIdMappings = new Int2IntOpenHashMap();
    private final Object2IntMap<BlockState> blockStateTagMappings = new Object2IntOpenHashMap<BlockState>();
    private final IntList waterIds = new IntArrayList();
    private final BlockStateSanitizer blockStateSanitizer;

    public BlockStateRewriter(UserConnection user, BlockProperties[] blockProperties, boolean hashedRuntimeBlockIds) {
        super(user);
        this.blockStateIdMappings.defaultReturnValue(-1);
        this.legacyBlockStateIdMappings.defaultReturnValue(-1);
        this.blockStateTagMappings.defaultReturnValue(-1);
        ArrayList<BedrockBlockState> bedrockBlockStates = new ArrayList<BedrockBlockState>(BedrockProtocol.MAPPINGS.getBedrockBlockStates());
        BiMap<BlockState, Integer> javaBlockStates = BedrockProtocol.MAPPINGS.getJavaBlockStates();
        Map<BlockState, BlockState> bedrockToJavaBlockStates = BedrockProtocol.MAPPINGS.getBedrockToJavaBlockStates();
        for (BlockProperties blockProperty : blockProperties) {
            CompoundTag blockStateTag = new CompoundTag();
            blockStateTag.put("name", new StringTag(blockProperty.name()));
            blockStateTag.put("states", new CompoundTag());
            blockStateTag.put("network_id", new IntTag(BlockStateHasher.hash(blockStateTag)));
            bedrockBlockStates.add(BedrockBlockState.fromNbt(blockStateTag));
        }
        bedrockBlockStates.sort((a, b) -> HashedPaletteComparator.INSTANCE.compare(a.namespacedIdentifier(), b.namespacedIdentifier()));
        for (int i = 0; i < bedrockBlockStates.size(); ++i) {
            BedrockBlockState bedrockBlockState = (BedrockBlockState)bedrockBlockStates.get(i);
            int bedrockId = hashedRuntimeBlockIds ? ((IntTag)bedrockBlockState.blockStateTag().get("network_id")).asInt() : i;
            this.blockStateTagMappings.put((BlockState)bedrockBlockState, bedrockId);
            if (bedrockBlockState.namespacedIdentifier().equals("minecraft:water") || bedrockBlockState.namespacedIdentifier().equals("minecraft:flowing_water")) {
                this.waterIds.add(bedrockId);
            }
            if (!bedrockToJavaBlockStates.containsKey(bedrockBlockState)) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing bedrock -> java block state mapping: " + bedrockBlockState.toBlockStateString());
                continue;
            }
            BlockState javaBlockState = bedrockToJavaBlockStates.get(bedrockBlockState);
            if (!javaBlockStates.containsKey(javaBlockState)) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing java block state mapping: " + javaBlockState);
                continue;
            }
            int javaId = (Integer)javaBlockStates.get(javaBlockState);
            this.blockStateIdMappings.put(bedrockId, javaId);
        }
        for (Int2ObjectMap.Entry entry : BedrockProtocol.MAPPINGS.getLegacyBlockStates().int2ObjectEntrySet()) {
            int legacyId = entry.getIntKey() >> 6;
            int legacyData = entry.getIntKey() & 0x3F;
            if (legacyData > 15) continue;
            int bedrockId = this.blockStateTagMappings.getInt(entry.getValue());
            if (bedrockId == -1) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Legacy block state " + entry.getValue() + " is not mapped to a modern block state");
                continue;
            }
            this.legacyBlockStateIdMappings.put(legacyId << 4 | legacyData & 0xF, bedrockId);
        }
        this.blockStateSanitizer = new BlockStateSanitizer(bedrockBlockStates);
    }

    public int bedrockId(CompoundTag bedrockBlockStateTag) {
        BedrockProtocol.MAPPINGS.getBlockStateUpgrader().upgradeToLatest(bedrockBlockStateTag);
        this.blockStateSanitizer.sanitize(bedrockBlockStateTag);
        return this.bedrockId(BedrockBlockState.fromNbt(bedrockBlockStateTag));
    }

    public int bedrockId(BlockState bedrockBlockState) {
        return this.blockStateTagMappings.getInt(bedrockBlockState);
    }

    public int bedrockId(int legacyBlockStateId) {
        return this.legacyBlockStateIdMappings.get(legacyBlockStateId);
    }

    public int javaId(int bedrockBlockStateId) {
        return this.blockStateIdMappings.get(bedrockBlockStateId);
    }

    public int waterlog(int javaBlockStateId) {
        if (BedrockProtocol.MAPPINGS.getPreWaterloggedStates().contains(javaBlockStateId)) {
            return javaBlockStateId;
        }
        BlockState waterlogged = ((BlockState)BedrockProtocol.MAPPINGS.getJavaBlockStates().inverse().get((Object)javaBlockStateId)).withProperty("waterlogged", "true");
        return (Integer)BedrockProtocol.MAPPINGS.getJavaBlockStates().getOrDefault((Object)waterlogged, (Object)-1);
    }

    public boolean isWater(int bedrockBlockStateId) {
        return this.waterIds.contains(bedrockBlockStateId);
    }
}

