/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.util.Key;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.ItemEntry;
import net.raphimc.viabedrock.protocol.types.BedrockItemType;

public class ItemRewriter
extends StoredObject {
    private final BiMap<String, Integer> items = HashBiMap.create(BedrockProtocol.MAPPINGS.getItems());
    private final Type<BedrockItem> itemType;

    public ItemRewriter(UserConnection user, ItemEntry[] itemEntries) {
        super(user);
        for (ItemEntry itemEntry : itemEntries) {
            this.items.inverse().remove((Object)itemEntry.id());
            this.items.put((Object)Key.namespaced(itemEntry.identifier()), (Object)itemEntry.id());
        }
        this.itemType = new BedrockItemType((Integer)this.items.getOrDefault((Object)"minecraft:shield", (Object)-1));
    }

    public BiMap<String, Integer> getItems() {
        return Maps.unmodifiableBiMap(this.items);
    }

    public Type<BedrockItem> itemType() {
        return this.itemType;
    }
}

