/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter;

import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.util.Locale;
import net.raphimc.viabedrock.api.model.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class ResourcePackRewriter {
    public static ResourcePack.Content bedrockToJava(ResourcePacksStorage resourcePacksStorage) {
        ResourcePack.Content javaContent = new ResourcePack.Content();
        resourcePacksStorage.iterateResourcePacksBottomToTop(pack -> {
            ResourcePackRewriter.convertGlyphSheets(pack.content(), javaContent);
            return true;
        });
        javaContent.putJson("pack.mcmeta", ResourcePackRewriter.createPackManifest());
        return javaContent;
    }

    private static JsonObject createPackManifest() {
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        root.add("pack", pack);
        pack.addProperty("pack_format", 15);
        pack.addProperty("description", "ViaBedrock Resource Pack");
        return root;
    }

    private static void convertGlyphSheets(ResourcePack.Content bedrockContent, ResourcePack.Content javaContent) {
        JsonArray providers;
        JsonObject root;
        int glyphsPerRow = 16;
        int glyphsPerColumn = 16;
        String javaDefaultsPath = "assets/minecraft/font/default.json";
        if (javaContent.containsKey("assets/minecraft/font/default.json")) {
            root = javaContent.getJson("assets/minecraft/font/default.json");
            providers = root.getAsJsonArray("providers");
        } else {
            root = new JsonObject();
            providers = new JsonArray();
            root.add("providers", providers);
        }
        for (int i = 0; i < 255; ++i) {
            String pageName = "glyph_" + String.format("%1$02X", i) + ".png";
            String bedrockPath = "font/" + pageName;
            if (!bedrockContent.containsKey(bedrockPath)) continue;
            String javaPath = "assets/viabedrock/textures/font/" + pageName.toLowerCase(Locale.ROOT);
            BufferedImage image = bedrockContent.getImage(bedrockPath);
            javaContent.putImage(javaPath, image);
            int glyphHeight = image.getHeight() / 16;
            for (JsonElement provider : providers) {
                if (!provider.getAsJsonObject().get("file").getAsString().equals("viabedrock:font/" + pageName.toLowerCase(Locale.ROOT))) continue;
                providers.remove(provider);
                break;
            }
            JsonObject glyphPage = new JsonObject();
            providers.add(glyphPage);
            glyphPage.addProperty("type", "bitmap");
            glyphPage.addProperty("file", "viabedrock:font/" + pageName.toLowerCase(Locale.ROOT));
            glyphPage.addProperty("ascent", glyphHeight / 2 + 5);
            glyphPage.addProperty("height", glyphHeight);
            JsonArray chars = new JsonArray();
            glyphPage.add("chars", chars);
            for (int c = 0; c < 16; ++c) {
                StringBuilder row = new StringBuilder();
                for (int r = 0; r < 16; ++r) {
                    int idx = c * 16 + r;
                    row.append((char)(i << 8 | idx));
                }
                chars.add(row.toString());
            }
        }
        if (providers.size() == 0) {
            return;
        }
        javaContent.putJson("assets/minecraft/font/default.json", root);
    }
}

