/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.providers.BlobCacheProvider;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BlobCache
extends StoredObject {
    private final Map<Long, CompletableFuture<byte[]>> pending = new HashMap<Long, CompletableFuture<byte[]>>();
    private final List<Long> missing = new ArrayList<Long>();
    private final List<Long> acked = new ArrayList<Long>();
    private final Deflater deflater = new Deflater(9);
    private final Inflater inflater = new Inflater();
    private final byte[] compressionBuffer = new byte[8192];

    public BlobCache(UserConnection user) {
        super(user);
    }

    public void tick() throws Exception {
        if (this.missing.isEmpty() && this.acked.isEmpty()) {
            return;
        }
        List<Long> missingSubSet = this.missing.subList(0, Math.min(4096, this.missing.size()));
        List<Long> ackedSubSet = this.acked.subList(0, Math.min(4096, this.acked.size()));
        PacketWrapper clientCacheBlobStatus = PacketWrapper.create(ServerboundBedrockPackets.CLIENT_CACHE_BLOB_STATUS, this.getUser());
        clientCacheBlobStatus.write(BedrockTypes.UNSIGNED_VAR_INT, missingSubSet.size());
        clientCacheBlobStatus.write(BedrockTypes.UNSIGNED_VAR_INT, ackedSubSet.size());
        for (long hash : missingSubSet) {
            clientCacheBlobStatus.write(BedrockTypes.LONG_LE, hash);
        }
        for (long hash : ackedSubSet) {
            clientCacheBlobStatus.write(BedrockTypes.LONG_LE, hash);
        }
        clientCacheBlobStatus.sendToServer(BedrockProtocol.class);
        this.missing.removeAll(missingSubSet);
        this.acked.removeAll(ackedSubSet);
    }

    public void addBlob(long hash, byte[] blob) {
        this.acked.add(hash);
        byte[] compressedBlob = this.compress(blob);
        byte[] previousBlob = Via.getManager().getProviders().get(BlobCacheProvider.class).addBlob(hash, compressedBlob);
        if (this.pending.containsKey(hash)) {
            this.pending.remove(hash).complete(blob);
        }
        if (previousBlob != null && !Arrays.equals(previousBlob, compressedBlob)) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Overwriting blob with hash " + hash + "!");
        }
    }

    public boolean hasBlob(long ... hashes) {
        for (long hash : hashes) {
            if (Via.getManager().getProviders().get(BlobCacheProvider.class).hasBlob(hash)) continue;
            return false;
        }
        return true;
    }

    public CompletableFuture<byte[]> getBlob(long ... hashes) {
        return this.getBlob(true, hashes);
    }

    public CompletableFuture<byte[]> getBlob(Long[] hashes) {
        long[] longs = new long[hashes.length];
        for (int i = 0; i < hashes.length; ++i) {
            longs[i] = hashes[i];
        }
        return this.getBlob(true, longs);
    }

    public CompletableFuture<byte[]> getBlob(boolean acknowledge, long ... hashes) {
        if (acknowledge) {
            for (long hash : hashes) {
                if (this.hasBlob(hash)) {
                    this.acked.add(hash);
                    continue;
                }
                if (this.pending.containsKey(hash)) continue;
                this.missing.add(hash);
            }
        }
        if (this.hasBlob(hashes)) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                for (long hash : hashes) {
                    output.write(this.decompress(Via.getManager().getProviders().get(BlobCacheProvider.class).getBlob(hash)));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return CompletableFuture.completedFuture(output.toByteArray());
        }
        CompletableFuture<byte[]> rootFuture = new CompletableFuture<byte[]>();
        for (long hash : hashes) {
            if (this.hasBlob(hash)) continue;
            CompletableFuture subFuture = new CompletableFuture();
            CompletableFuture<byte[]> existing = this.pending.get(hash);
            if (existing != null) {
                subFuture.whenComplete((blob, throwable) -> {
                    if (throwable != null) {
                        existing.completeExceptionally((Throwable)throwable);
                    } else {
                        existing.complete((byte[])blob);
                    }
                });
            }
            subFuture.whenComplete((blob, throwable) -> {
                if (throwable != null) {
                    rootFuture.completeExceptionally((Throwable)throwable);
                } else if (this.hasBlob(hashes)) {
                    rootFuture.complete(this.getBlob(false, hashes).getNow(null));
                }
            });
            this.pending.put(hash, subFuture);
        }
        return rootFuture;
    }

    private byte[] compress(byte[] data) {
        this.deflater.setInput(data);
        this.deflater.finish();
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        while (!this.deflater.finished()) {
            int size = this.deflater.deflate(this.compressionBuffer);
            compressed.write(this.compressionBuffer, 0, size);
        }
        this.deflater.reset();
        return compressed.toByteArray();
    }

    private byte[] decompress(byte[] compressed) {
        if (compressed.length == 0) {
            return compressed;
        }
        this.inflater.setInput(compressed);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            while (!this.inflater.finished()) {
                int size = this.inflater.inflate(this.compressionBuffer);
                data.write(this.compressionBuffer, 0, size);
            }
        }
        catch (DataFormatException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.inflater.reset();
        }
        return data.toByteArray();
    }
}

