/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk1_18;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionImpl;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.DataPaletteImpl;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntImmutablePair;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntPair;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.NumberTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_18to1_17_1.types.Chunk1_18Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.Protocol1_19_4To1_19_3;
import com.viaversion.viaversion.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockChunk;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockBlockArray;
import net.raphimc.viabedrock.api.chunk.datapalette.BedrockDataPalette;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSection;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSectionImpl;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.BlockStateRewriter;
import net.raphimc.viabedrock.protocol.rewriter.DimensionIdRewriter;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ChunkTracker
extends StoredObject {
    private static final byte[] FULL_LIGHT = new byte[2048];
    private final int dimensionId;
    private final int minY;
    private final int worldHeight;
    private final Chunk1_18Type chunkType;
    private final Object chunkLock = new Object();
    private final Map<Long, BedrockChunk> chunks = new HashMap<Long, BedrockChunk>();
    private final Set<Long> dirtyChunks = new HashSet<Long>();
    private final Object subChunkLock = new Object();
    private final Set<SubChunkPosition> subChunkRequests = new HashSet<SubChunkPosition>();
    private final Set<SubChunkPosition> pendingSubChunks = new HashSet<SubChunkPosition>();
    private int centerX = 0;
    private int centerZ = 0;
    private int radius = 5;

    public ChunkTracker(UserConnection user, int dimensionId) {
        super(user);
        this.dimensionId = dimensionId;
        GameSessionStorage gameSession = user.get(GameSessionStorage.class);
        CompoundTag registries = gameSession.getJavaRegistries();
        String dimensionKey = DimensionIdRewriter.dimensionIdToDimensionKey(this.dimensionId);
        CompoundTag dimensionRegistry = (CompoundTag)registries.get("minecraft:dimension_type");
        ListTag dimensions = (ListTag)dimensionRegistry.get("value");
        CompoundTag biomeRegistry = (CompoundTag)registries.get("minecraft:worldgen/biome");
        ListTag biomes = (ListTag)biomeRegistry.get("value");
        IntIntPair pair = dimensions.getValue().stream().map(CompoundTag.class::cast).filter(t -> ((Tag)t.get("name")).getValue().toString().equals(dimensionKey)).findFirst().map(t -> (CompoundTag)t.get("element")).map(t -> new IntIntImmutablePair(((NumberTag)t.get("min_y")).asInt(), ((NumberTag)t.get("height")).asInt())).orElse(null);
        if (pair == null) {
            throw new IllegalStateException("Could not find dimension min_y/height for dimension " + dimensionKey);
        }
        this.minY = pair.keyInt();
        this.worldHeight = pair.valueInt();
        this.chunkType = new Chunk1_18Type(this.worldHeight >> 4, MathUtil.ceilLog2(Protocol1_19_4To1_19_3.MAPPINGS.getBlockStateMappings().mappedSize()), MathUtil.ceilLog2(biomes.size()));
    }

    public void setCenter(int x, int z) throws Exception {
        this.centerX = x;
        this.centerZ = z;
        this.removeOutOfViewDistanceChunks();
    }

    public void setRadius(int radius) throws Exception {
        this.radius = radius;
        this.removeOutOfViewDistanceChunks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BedrockChunk createChunk(int chunkX, int chunkZ, int nonNullSectionCount) {
        int i;
        if (!this.isInViewDistance(chunkX, chunkZ)) {
            return null;
        }
        BedrockChunk chunk = new BedrockChunk(chunkX, chunkZ, new BedrockChunkSection[this.worldHeight >> 4]);
        for (i = 0; i < nonNullSectionCount && i < chunk.getSections().length; ++i) {
            chunk.getSections()[i] = new BedrockChunkSectionImpl();
        }
        for (i = 0; i < chunk.getSections().length; ++i) {
            if (chunk.getSections()[i] != null) continue;
            chunk.getSections()[i] = new BedrockChunkSectionImpl(true);
        }
        Object object = this.chunkLock;
        synchronized (object) {
            this.chunks.put(this.chunkKey(chunk.getX(), chunk.getZ()), chunk);
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadChunk(int chunkX, int chunkZ) throws Exception {
        Object object = this.chunkLock;
        synchronized (object) {
            this.chunks.remove(this.chunkKey(chunkX, chunkZ));
        }
        PacketWrapper unloadChunk = PacketWrapper.create(ClientboundPackets1_19_4.UNLOAD_CHUNK, this.getUser());
        unloadChunk.write(Type.INT, chunkX);
        unloadChunk.write(Type.INT, chunkZ);
        unloadChunk.send(BedrockProtocol.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BedrockChunk getChunk(int chunkX, int chunkZ) {
        if (!this.isInViewDistance(chunkX, chunkZ)) {
            return null;
        }
        Object object = this.chunkLock;
        synchronized (object) {
            return this.chunks.get(this.chunkKey(chunkX, chunkZ));
        }
    }

    public BedrockChunkSection getChunkSection(int chunkX, int subChunkY, int chunkZ) {
        BedrockChunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            return null;
        }
        int sectionIndex = subChunkY + Math.abs(this.minY >> 4);
        if (sectionIndex < 0 || sectionIndex >= chunk.getSections().length) {
            return null;
        }
        return chunk.getSections()[sectionIndex];
    }

    public BedrockChunkSection getChunkSection(Position blockPosition) {
        return this.getChunkSection(blockPosition.x() >> 4, blockPosition.y() >> 4, blockPosition.z() >> 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        if (!this.isInViewDistance(chunkX, chunkZ)) {
            return false;
        }
        Object object = this.chunkLock;
        synchronized (object) {
            return this.chunks.containsKey(this.chunkKey(chunkX, chunkZ));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUnloadedChunkSection(Position3f playerPosition) {
        Position chunkSectionPosition = new Position((int)Math.floor(playerPosition.x() / 16.0f), (int)Math.floor((playerPosition.y() - 1.62f) / 16.0f), (int)Math.floor(playerPosition.z() / 16.0f));
        if (!this.isChunkLoaded(chunkSectionPosition.x(), chunkSectionPosition.z())) {
            return true;
        }
        BedrockChunkSection chunkSection = this.getChunkSection(chunkSectionPosition.x(), chunkSectionPosition.y(), chunkSectionPosition.z());
        if (chunkSection == null) {
            return false;
        }
        if (chunkSection.hasPendingBlockUpdates()) {
            return true;
        }
        Set<Long> set = this.dirtyChunks;
        synchronized (set) {
            return this.dirtyChunks.contains(this.chunkKey(chunkSectionPosition.x(), chunkSectionPosition.z()));
        }
    }

    public boolean isInViewDistance(int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.centerX) <= this.radius && Math.abs(chunkZ - this.centerZ) <= this.radius;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutOfViewDistanceChunks() throws Exception {
        HashSet<Long> chunksToRemove = new HashSet<Long>();
        Iterator iterator = this.chunkLock;
        synchronized (iterator) {
            for (long chunkKey : this.chunks.keySet()) {
                int chunkZ;
                int chunkX = (int)(chunkKey >> 32);
                if (this.isInViewDistance(chunkX, chunkZ = (int)chunkKey)) continue;
                chunksToRemove.add(chunkKey);
            }
        }
        iterator = chunksToRemove.iterator();
        while (iterator.hasNext()) {
            long chunkKey = (Long)iterator.next();
            int chunkX = (int)(chunkKey >> 32);
            int chunkZ = (int)chunkKey;
            this.unloadChunk(chunkX, chunkZ);
        }
    }

    public void requestSubChunks(int chunkX, int chunkZ, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.requestSubChunk(chunkX, i, chunkZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSubChunk(int chunkX, int subChunkY, int chunkZ) {
        if (!this.isInViewDistance(chunkX, chunkZ)) {
            return;
        }
        Object object = this.subChunkLock;
        synchronized (object) {
            this.subChunkRequests.add(new SubChunkPosition(chunkX, subChunkY, chunkZ));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChunkInNextTick(int chunkX, int chunkZ) {
        Set<Long> set = this.dirtyChunks;
        synchronized (set) {
            this.dirtyChunks.add(this.chunkKey(chunkX, chunkZ));
        }
    }

    public void sendChunk(int chunkX, int chunkZ) throws Exception {
        BedrockChunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            return;
        }
        Chunk remappedChunk = this.remapChunk(chunk);
        PacketWrapper wrapper = PacketWrapper.create(ClientboundPackets1_19_4.CHUNK_DATA, this.getUser());
        BitSet lightMask = new BitSet();
        lightMask.set(0, remappedChunk.getSections().length + 2);
        wrapper.write(this.chunkType, remappedChunk);
        wrapper.write(Type.LONG_ARRAY_PRIMITIVE, lightMask.toLongArray());
        wrapper.write(Type.LONG_ARRAY_PRIMITIVE, new long[0]);
        wrapper.write(Type.LONG_ARRAY_PRIMITIVE, new long[0]);
        wrapper.write(Type.LONG_ARRAY_PRIMITIVE, lightMask.toLongArray());
        wrapper.write(Type.VAR_INT, remappedChunk.getSections().length + 2);
        for (int i = 0; i < remappedChunk.getSections().length + 2; ++i) {
            wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, FULL_LIGHT);
        }
        wrapper.write(Type.VAR_INT, 0);
        wrapper.send(BedrockProtocol.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mergeSubChunk(int chunkX, int subChunkY, int chunkZ, BedrockChunkSection other, List<BlockEntity> blockEntities) {
        if (!this.isInViewDistance(chunkX, chunkZ)) {
            return false;
        }
        SubChunkPosition position = new SubChunkPosition(chunkX, subChunkY, chunkZ);
        Object object = this.subChunkLock;
        synchronized (object) {
            if (!this.pendingSubChunks.contains(position)) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received sub chunk that was not requested: " + position);
                return false;
            }
            this.pendingSubChunks.remove(position);
        }
        BedrockChunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received sub chunk for unloaded chunk: " + position);
            return false;
        }
        BedrockChunkSection section = chunk.getSections()[subChunkY + Math.abs(this.minY >> 4)];
        section.mergeWith(this.handleBlockPalette(other));
        section.applyPendingBlockUpdates(this.getUser().get(BlockStateRewriter.class).bedrockId(BedrockBlockState.AIR));
        chunk.blockEntities().addAll(blockEntities);
        return true;
    }

    public int handleBlockChange(Position blockPosition, int layer, int blockState) {
        int layer1BlockState;
        BedrockChunkSection section = this.getChunkSection(blockPosition);
        if (section == null) {
            return -1;
        }
        int sectionX = blockPosition.x() & 0xF;
        int sectionY = blockPosition.y() & 0xF;
        int sectionZ = blockPosition.z() & 0xF;
        if (section.hasPendingBlockUpdates()) {
            section.addPendingBlockUpdate(sectionX, sectionY, sectionZ, layer, blockState);
            return -1;
        }
        BlockStateRewriter blockStateRewriter = this.getUser().get(BlockStateRewriter.class);
        while (section.palettesCount(PaletteType.BLOCKS) <= layer) {
            BedrockDataPalette palette = new BedrockDataPalette();
            palette.addId(blockStateRewriter.bedrockId(BedrockBlockState.AIR));
            section.addPalette(PaletteType.BLOCKS, palette);
        }
        List<DataPalette> blockPalettes = section.palettes(PaletteType.BLOCKS);
        blockPalettes.get(layer).setIdAt(sectionX, sectionY, sectionZ, blockState);
        int layer0BlockState = blockPalettes.get(0).idAt(sectionX, sectionY, sectionZ);
        int remappedBlockState = blockStateRewriter.javaId(layer0BlockState);
        if (remappedBlockState == -1) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block state: " + layer0BlockState);
            remappedBlockState = 0;
        }
        if (blockPalettes.size() > 1 && blockStateRewriter.isWater(layer1BlockState = blockPalettes.get(1).idAt(sectionX, sectionY, sectionZ))) {
            int prevBlockState = remappedBlockState;
            if ((remappedBlockState = blockStateRewriter.waterlog(remappedBlockState)) == -1) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing waterlogged block state: " + prevBlockState);
                remappedBlockState = prevBlockState;
            }
        }
        return remappedBlockState;
    }

    public BedrockChunkSection handleBlockPalette(BedrockChunkSection section) {
        this.replaceLegacyBlocks(section);
        this.resolveTagPalette(section);
        return section;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.worldHeight - Math.abs(this.minY);
    }

    public int getWorldHeight() {
        return this.worldHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() throws Exception {
        Object object = this.dirtyChunks;
        synchronized (object) {
            if (!this.dirtyChunks.isEmpty()) {
                this.getUser().getChannel().eventLoop().submit(() -> {
                    Set<Long> set = this.dirtyChunks;
                    synchronized (set) {
                        for (Long dirtyChunk : this.dirtyChunks) {
                            int chunkX = (int)(dirtyChunk >> 32);
                            int chunkZ = dirtyChunk.intValue();
                            try {
                                this.sendChunk(chunkX, chunkZ);
                            }
                            catch (Throwable e) {
                                throw new RuntimeException("Failed to send chunk", e);
                            }
                        }
                        this.dirtyChunks.clear();
                    }
                });
            }
        }
        if (this.getUser().get(EntityTracker.class) == null || !this.getUser().get(EntityTracker.class).getClientPlayer().isInitiallySpawned()) {
            return;
        }
        object = this.subChunkLock;
        synchronized (object) {
            this.subChunkRequests.removeIf(s -> !this.isInViewDistance(((SubChunkPosition)s).chunkX, ((SubChunkPosition)s).chunkZ));
            Position basePosition = new Position(this.centerX, 0, this.centerZ);
            while (!this.subChunkRequests.isEmpty()) {
                Set group = this.subChunkRequests.stream().limit(256L).collect(Collectors.toSet());
                this.subChunkRequests.removeAll(group);
                PacketWrapper subChunkRequest = PacketWrapper.create(ServerboundBedrockPackets.SUB_CHUNK_REQUEST, this.getUser());
                subChunkRequest.write(BedrockTypes.VAR_INT, this.dimensionId);
                subChunkRequest.write(BedrockTypes.POSITION_3I, basePosition);
                subChunkRequest.write(BedrockTypes.INT_LE, group.size());
                for (SubChunkPosition subChunkPosition : group) {
                    this.pendingSubChunks.add(subChunkPosition);
                    Position offset = new Position(subChunkPosition.chunkX - basePosition.x(), subChunkPosition.subChunkY, subChunkPosition.chunkZ - basePosition.z());
                    subChunkRequest.write(BedrockTypes.SUB_CHUNK_OFFSET, offset);
                }
                subChunkRequest.sendToServer(BedrockProtocol.class);
            }
        }
    }

    private long chunkKey(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    private Chunk remapChunk(Chunk chunk) {
        BlockStateRewriter blockStateRewriter = this.getUser().get(BlockStateRewriter.class);
        int airId = blockStateRewriter.bedrockId(BedrockBlockState.AIR);
        Chunk1_18 remappedChunk = new Chunk1_18(chunk.getX(), chunk.getZ(), new ChunkSection[chunk.getSections().length], new CompoundTag(), new ArrayList<BlockEntity>());
        ChunkSection[] sections = chunk.getSections();
        ChunkSection[] remappedSections = remappedChunk.getSections();
        for (int idx = 0; idx < sections.length; ++idx) {
            int z;
            int y;
            int x;
            ChunkSection section = sections[idx];
            remappedSections[idx] = new ChunkSectionImpl(false);
            ChunkSectionImpl remappedSection = remappedSections[idx];
            remappedSection.addPalette(PaletteType.BIOMES, new DataPaletteImpl(64));
            remappedSection.palette(PaletteType.BLOCKS).addId(0);
            remappedSection.palette(PaletteType.BIOMES).addId(0);
            if (!(section instanceof BedrockChunkSection)) continue;
            BedrockChunkSection bedrockSection = (BedrockChunkSection)section;
            List<DataPalette> blockPalettes = bedrockSection.palettes(PaletteType.BLOCKS);
            DataPalette remappedBlockPalette = remappedSection.palette(PaletteType.BLOCKS);
            if (blockPalettes.size() > 0) {
                DataPalette mainLayer = blockPalettes.get(0);
                if (mainLayer.size() == 1) {
                    int blockState = mainLayer.idByIndex(0);
                    int remappedBlockState = blockStateRewriter.javaId(blockState);
                    if (remappedBlockState == -1) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block state: " + blockState);
                        remappedBlockState = 0;
                    }
                    remappedBlockPalette.setIdByIndex(0, remappedBlockState);
                    if (remappedBlockState != 0) {
                        remappedSection.setNonAirBlocksCount(4096);
                    }
                } else {
                    int nonAirBlocks = 0;
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 16; ++z) {
                                int blockState = mainLayer.idAt(x, y, z);
                                if (blockState == airId) continue;
                                int remappedBlockState = blockStateRewriter.javaId(blockState);
                                if (remappedBlockState == -1) {
                                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block state: " + blockState);
                                    remappedBlockState = 0;
                                }
                                remappedBlockPalette.setIdAt(x, y, z, remappedBlockState);
                                if (remappedBlockState == 0) continue;
                                ++nonAirBlocks;
                            }
                        }
                    }
                    remappedSection.setNonAirBlocksCount(nonAirBlocks);
                }
            }
            for (int i = 1; i < blockPalettes.size(); ++i) {
                DataPalette prevLayer = blockPalettes.get(i - 1);
                DataPalette layer = blockPalettes.get(i);
                if (layer.size() == 1 && layer.idByIndex(0) == airId) continue;
                for (int x2 = 0; x2 < 16; ++x2) {
                    for (int y2 = 0; y2 < 16; ++y2) {
                        for (int z2 = 0; z2 < 16; ++z2) {
                            int blockState;
                            int prevBlockState = prevLayer.idAt(x2, y2, z2);
                            if (prevBlockState == airId || (blockState = layer.idAt(x2, y2, z2)) == airId) continue;
                            int javaBlockState = remappedBlockPalette.idAt(x2, y2, z2);
                            if (!blockStateRewriter.isWater(blockState)) continue;
                            int remappedBlockState = blockStateRewriter.waterlog(javaBlockState);
                            if (remappedBlockState == -1) {
                                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing waterlogged block state: " + prevBlockState);
                                continue;
                            }
                            remappedBlockPalette.setIdAt(x2, y2, z2, remappedBlockState);
                        }
                    }
                }
            }
            DataPalette biomePalette = bedrockSection.palette(PaletteType.BIOMES);
            DataPalette remappedBiomePalette = remappedSection.palette(PaletteType.BIOMES);
            if (biomePalette == null) continue;
            if (biomePalette.size() == 1) {
                int biomeId = biomePalette.idByIndex(0);
                int remappedBiomeId = biomeId + 1;
                if (!BedrockProtocol.MAPPINGS.getBiomes().inverse().containsKey((Object)biomeId)) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing biome: " + biomeId);
                    remappedBiomeId = 0;
                }
                remappedBiomePalette.setIdByIndex(0, remappedBiomeId);
                continue;
            }
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    for (z = 0; z < 4; ++z) {
                        Int2IntOpenHashMap subBiomes = new Int2IntOpenHashMap();
                        int maxBiomeId = -1;
                        int maxValue = -1;
                        for (int subX = 0; subX < 4; ++subX) {
                            for (int subY = 0; subY < 4; ++subY) {
                                for (int subZ = 0; subZ < 4; ++subZ) {
                                    int biomeId = biomePalette.idAt(x * 4 + subX, y * 4 + subY, z * 4 + subZ);
                                    int value = subBiomes.getOrDefault(biomeId, 0) + 1;
                                    subBiomes.put(biomeId, value);
                                    if (value <= maxValue) continue;
                                    maxBiomeId = biomeId;
                                    maxValue = value;
                                }
                            }
                        }
                        int biomeId = maxBiomeId;
                        int remappedBiomeId = biomeId + 1;
                        if (!BedrockProtocol.MAPPINGS.getBiomes().inverse().containsKey((Object)biomeId)) {
                            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing biome: " + biomeId);
                            remappedBiomeId = 0;
                        }
                        remappedBiomePalette.setIdAt(x, y, z, remappedBiomeId);
                    }
                }
            }
        }
        return remappedChunk;
    }

    private void resolveTagPalette(ChunkSection section) {
        BlockStateRewriter blockStateRewriter = this.getUser().get(BlockStateRewriter.class);
        if (section instanceof BedrockChunkSection) {
            BedrockChunkSection bedrockSection = (BedrockChunkSection)section;
            List<DataPalette> palettes = bedrockSection.palettes(PaletteType.BLOCKS);
            for (DataPalette palette : palettes) {
                BedrockDataPalette bedrockPalette;
                if (!(palette instanceof BedrockDataPalette) || !(bedrockPalette = (BedrockDataPalette)palette).hasTagPalette()) continue;
                bedrockPalette.addId(blockStateRewriter.bedrockId(BedrockBlockState.AIR));
                bedrockPalette.resolveTagPalette((Object tag) -> {
                    try {
                        int remappedBlockState = blockStateRewriter.bedrockId(((CompoundTag)tag).clone());
                        if (remappedBlockState == -1) {
                            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing block state: " + tag);
                            remappedBlockState = blockStateRewriter.bedrockId(BedrockBlockState.INFO_UPDATE);
                        }
                        return remappedBlockState;
                    }
                    catch (Throwable e) {
                        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error while rewriting block state tag: " + tag, e);
                        return blockStateRewriter.bedrockId(BedrockBlockState.AIR);
                    }
                });
            }
        }
    }

    private void replaceLegacyBlocks(ChunkSection section) {
        BlockStateRewriter blockStateRewriter = this.getUser().get(BlockStateRewriter.class);
        if (section instanceof BedrockChunkSection) {
            BedrockChunkSection bedrockSection = (BedrockChunkSection)section;
            List<DataPalette> palettes = bedrockSection.palettes(PaletteType.BLOCKS);
            for (DataPalette palette : palettes) {
                if (!(palette instanceof BedrockBlockArray)) continue;
                BedrockBlockArray blockArray = (BedrockBlockArray)palette;
                BedrockDataPalette dataPalette = new BedrockDataPalette();
                dataPalette.addId(blockStateRewriter.bedrockId(BedrockBlockState.AIR));
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            int blockState = blockArray.idAt(x, y, z);
                            if (blockState == 0) continue;
                            int remappedBlockState = blockStateRewriter.bedrockId(blockState);
                            if (remappedBlockState == -1) {
                                Via.getPlatform().getLogger().log(Level.WARNING, "Missing legacy block state: " + blockState);
                                remappedBlockState = blockStateRewriter.bedrockId(BedrockBlockState.AIR);
                            }
                            dataPalette.setIdAt(x, y, z, remappedBlockState);
                        }
                    }
                }
                palettes.set(palettes.indexOf(palette), dataPalette);
            }
        }
    }

    static {
        Arrays.fill(FULL_LIGHT, (byte)-1);
    }

    private static class SubChunkPosition {
        private final int chunkX;
        private final int subChunkY;
        private final int chunkZ;

        private SubChunkPosition(int chunkX, int subChunkY, int chunkZ) {
            this.chunkX = chunkX;
            this.subChunkY = subChunkY;
            this.chunkZ = chunkZ;
        }

        public double distance(SubChunkPosition other) {
            return Math.sqrt(Math.pow(this.chunkX - other.chunkX, 2.0) + Math.pow(this.chunkZ - other.chunkZ, 2.0));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubChunkPosition that = (SubChunkPosition)o;
            return this.chunkX == that.chunkX && this.subChunkY == that.subChunkY && this.chunkZ == that.chunkZ;
        }

        public int hashCode() {
            return Objects.hash(this.chunkX, this.subChunkY, this.chunkZ);
        }

        public String toString() {
            return "SubChunkPosition{chunkX=" + this.chunkX + ", subChunkY=" + this.subChunkY + ", chunkZ=" + this.chunkZ + '}';
        }
    }
}

