/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntImmutablePair;
import com.viaversion.viaversion.libs.fastutil.ints.IntIntPair;
import com.viaversion.viaversion.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.protocol.model.CommandData;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class CommandsStorage
extends StoredObject {
    private final CommandData[] commands;

    public CommandsStorage(UserConnection user, CommandData[] commands) {
        super(user);
        this.commands = commands;
    }

    public Pair<IntIntPair, List<Pair<String, String>>> complete(String message) {
        Function<String, String> translator = k -> this.getUser().get(ResourcePacksStorage.class).getTranslations().getOrDefault(k, (String)k);
        ArrayList<Pair<String, String>> completions = new ArrayList<Pair<String, String>>();
        int startIndex = 0;
        int endIndex = 0;
        String[] split = message.split(" ", 2);
        String cmdString = split[0];
        String args = split.length > 1 ? split[1] : "";
        CommandData cmd = null;
        for (CommandData commandData : this.commands) {
            for (String alias : commandData.alias().values().keySet()) {
                if (alias.equals(cmdString)) {
                    cmd = commandData;
                }
                if (!args.isEmpty() || message.endsWith(" ") || !alias.startsWith(cmdString)) continue;
                completions.add(new Pair<String, String>(alias, BedrockTranslator.translate(commandData.description(), translator, new Object[0], TranslatorOptions.IGNORE_STARTING_PERCENT)));
            }
        }
        if (!completions.isEmpty()) {
            startIndex = 1;
            endIndex = startIndex + cmdString.length();
        }
        return new Pair<IntIntPair, List<Pair<String, String>>>(new IntIntImmutablePair(startIndex, endIndex), completions);
    }
}

