/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_19_4Types;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.model.entity.Entity;
import net.raphimc.viabedrock.api.model.entity.PlayerEntity;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class EntityTracker
extends StoredObject {
    private final AtomicInteger ID_COUNTER = new AtomicInteger(1);
    private ClientPlayerEntity clientPlayerEntity = null;
    private final Map<Long, Long> runtimeIdToUniqueId = new HashMap<Long, Long>();
    private final Map<Long, Entity> entities = new HashMap<Long, Entity>();

    public EntityTracker(UserConnection user) {
        super(user);
    }

    public Entity addEntity(long uniqueId, long runtimeId, UUID uuid, Entity1_19_4Types type) throws Exception {
        switch (type) {
            case PLAYER: {
                return this.addEntity(new PlayerEntity(this.getUser(), uniqueId, runtimeId, this.ID_COUNTER.getAndIncrement(), uuid != null ? uuid : UUID.randomUUID()));
            }
        }
        return this.addEntity(new Entity(this.getUser(), uniqueId, runtimeId, this.ID_COUNTER.getAndIncrement(), uuid != null ? uuid : UUID.randomUUID(), type));
    }

    public Entity addEntity(Entity entity) throws Exception {
        Entity prevEntity;
        if (entity instanceof ClientPlayerEntity) {
            this.clientPlayerEntity = (ClientPlayerEntity)entity;
        }
        if (this.runtimeIdToUniqueId.putIfAbsent(entity.runtimeId(), entity.uniqueId()) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Duplicate runtime entity ID: " + entity.runtimeId());
        }
        if ((prevEntity = this.entities.put(entity.uniqueId(), entity)) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Duplicate unique entity ID: " + entity.uniqueId());
            PacketWrapper removeEntities = PacketWrapper.create(ClientboundPackets1_19_4.REMOVE_ENTITIES, this.getUser());
            removeEntities.write(Type.VAR_INT_ARRAY_PRIMITIVE, new int[]{prevEntity.javaId()});
            removeEntities.send(BedrockProtocol.class);
            if (prevEntity instanceof PlayerEntity) {
                ((PlayerEntity)prevEntity).deleteTeam();
            }
        }
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).createTeam();
        }
        return entity;
    }

    public void removeEntity(Entity entity) throws Exception {
        if (entity instanceof ClientPlayerEntity) {
            throw new IllegalArgumentException("Cannot remove client player entity");
        }
        this.runtimeIdToUniqueId.remove(entity.runtimeId());
        this.entities.remove(entity.uniqueId());
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).deleteTeam();
        }
    }

    public void tick() throws Exception {
        for (Entity entity : this.entities.values()) {
            entity.tick();
        }
    }

    public void prepareForRespawn() throws Exception {
        for (Entity entity : this.entities.values()) {
            if (!(entity instanceof PlayerEntity)) continue;
            ((PlayerEntity)entity).deleteTeam();
        }
    }

    public Entity getEntityByRid(long runtimeId) {
        return this.entities.get(this.runtimeIdToUniqueId.get(runtimeId));
    }

    public Entity getEntityByUid(long uniqueId) {
        return this.entities.get(uniqueId);
    }

    public ClientPlayerEntity getClientPlayer() {
        return this.clientPlayerEntity;
    }
}

