/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class PacketSyncStorage
extends StoredObject {
    private final AtomicInteger ID = new AtomicInteger(0);
    private final Int2ObjectMap<Callable<Void>> pendingActions = new Int2ObjectOpenHashMap<Callable<Void>>();

    public PacketSyncStorage(UserConnection user) {
        super(user);
    }

    public void syncWithClient(Callable<Void> callable) throws Exception {
        if (this.ID.get() >= Short.MAX_VALUE) {
            this.ID.set(0);
        }
        int id = this.ID.getAndIncrement();
        PacketWrapper pingPacket = PacketWrapper.create(ClientboundPackets1_19_4.PING, this.getUser());
        pingPacket.write(Type.INT, id);
        pingPacket.send(BedrockProtocol.class);
        if (this.pendingActions.put(id, callable) != null) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Overwrote pending action with id " + id);
        }
    }

    public void handleResponse(int id) throws Exception {
        Callable callable = (Callable)this.pendingActions.remove(id);
        if (callable != null) {
            callable.call();
        } else {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received unexpected packet sync response with id " + id);
        }
    }
}

