/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerListStorage
extends StoredObject {
    private final Map<UUID, Pair<Long, String>> playerList = new HashMap<UUID, Pair<Long, String>>();

    public PlayerListStorage(UserConnection user) {
        super(user);
    }

    public Pair<Long, String> addPlayer(UUID uuid, long playerListId, String name) {
        return this.playerList.put(uuid, new Pair<Long, String>(playerListId, name));
    }

    public Pair<Long, String> removePlayer(UUID uuid) {
        return this.playerList.remove(uuid);
    }

    public boolean containsPlayer(UUID uuid) {
        return this.playerList.containsKey(uuid);
    }

    public Pair<Long, String> getPlayer(UUID uuid) {
        return this.playerList.get(uuid);
    }

    public Pair<UUID, String> getPlayer(long playerListId) {
        for (Map.Entry<UUID, Pair<Long, String>> entry : this.playerList.entrySet()) {
            if (entry.getValue().key() != playerListId) continue;
            return new Pair<UUID, String>(entry.getKey(), entry.getValue().value());
        }
        return null;
    }
}

