/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.raphimc.viabedrock.api.model.ResourcePack;
import net.raphimc.viabedrock.protocol.BedrockProtocol;

public class ResourcePacksStorage
extends StoredObject {
    private final Map<UUID, ResourcePack> packs = new HashMap<UUID, ResourcePack>();
    private final Set<UUID> preloadedPacks = new HashSet<UUID>();
    private final List<UUID> resourcePackStack = new ArrayList<UUID>();
    private final List<UUID> behaviourPackStack = new ArrayList<UUID>();
    private boolean completedTransfer;
    private Map<String, String> translations;

    public ResourcePacksStorage(UserConnection user) {
        super(user);
        this.addPreloadedPack(BedrockProtocol.MAPPINGS.getVanillaResourcePack());
    }

    public boolean hasPack(UUID packId) {
        return this.packs.containsKey(packId);
    }

    public ResourcePack getPack(UUID packId) {
        return this.packs.get(packId);
    }

    public Collection<ResourcePack> getPacks() {
        return this.packs.values();
    }

    public boolean areAllPacksDecompressed() {
        return this.packs.values().stream().allMatch(ResourcePack::isDecompressed);
    }

    public void addPack(ResourcePack pack) {
        this.packs.put(pack.packId(), pack);
    }

    public boolean isPreloaded(UUID packId) {
        return this.preloadedPacks.contains(packId);
    }

    public void addPreloadedPack(ResourcePack pack) {
        this.packs.put(pack.packId(), pack);
        this.preloadedPacks.add(pack.packId());
        this.resourcePackStack.add(pack.packId());
    }

    public void iterateResourcePacksTopToBottom(Function<ResourcePack, Boolean> function) {
        UUID packId;
        ResourcePack pack;
        Iterator<UUID> iterator = this.resourcePackStack.iterator();
        while (iterator.hasNext() && ((pack = this.packs.get(packId = iterator.next())) == null || function.apply(pack).booleanValue())) {
        }
    }

    public void iterateResourcePacksBottomToTop(Function<ResourcePack, Boolean> function) {
        ResourcePack pack;
        for (int i = this.resourcePackStack.size() - 1; i >= 0 && ((pack = this.packs.get(this.resourcePackStack.get(i))) == null || function.apply(pack).booleanValue()); --i) {
        }
    }

    public void setPackStack(UUID[] resourcePackStack, UUID[] behaviourPackStack) {
        this.resourcePackStack.addAll(0, Arrays.asList(resourcePackStack));
        this.behaviourPackStack.addAll(0, Arrays.asList(behaviourPackStack));
        this.translations = new HashMap<String, String>();
        this.iterateResourcePacksBottomToTop(pack -> {
            if (pack.content().containsKey("texts/en_US.lang")) {
                this.translations.putAll(pack.content().getLang("texts/en_US.lang"));
            }
            return true;
        });
        this.translations = Collections.unmodifiableMap(this.translations);
    }

    public boolean hasCompletedTransfer() {
        return this.completedTransfer;
    }

    public void setCompletedTransfer() {
        this.completedTransfer = true;
    }

    public Map<String, String> getTranslations() {
        return this.translations;
    }
}

