/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardEntry;
import net.raphimc.viabedrock.api.model.scoreboard.ScoreboardObjective;

public class ScoreboardTracker
extends StoredObject {
    private final Map<String, ScoreboardObjective> objectives = new HashMap<String, ScoreboardObjective>();

    public ScoreboardTracker(UserConnection user) {
        super(user);
    }

    public boolean hasObjective(String name) {
        return this.objectives.containsKey(name);
    }

    public ScoreboardObjective getObjective(String name) {
        return this.objectives.get(name);
    }

    public void addObjective(String name, ScoreboardObjective objective) {
        this.objectives.put(name, objective);
    }

    public void removeObjective(String name) {
        this.objectives.remove(name);
    }

    public Pair<ScoreboardObjective, ScoreboardEntry> getEntry(long scoreboardId) {
        for (ScoreboardObjective objective : this.objectives.values()) {
            ScoreboardEntry entry = objective.getEntry(scoreboardId);
            if (entry == null) continue;
            return new Pair<ScoreboardObjective, ScoreboardEntry>(objective, entry);
        }
        return null;
    }

    public Pair<ScoreboardObjective, ScoreboardEntry> getEntryForPlayer(long playerListId) {
        for (ScoreboardObjective objective : this.objectives.values()) {
            ScoreboardEntry entry = objective.getEntryForPlayer(playerListId);
            if (entry == null) continue;
            return new Pair<ScoreboardObjective, ScoreboardEntry>(objective, entry);
        }
        return null;
    }
}

