/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types;

import com.viaversion.viaversion.api.type.PartialType;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import io.netty.buffer.ByteBuf;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BedrockItemType
extends PartialType<BedrockItem, Integer> {
    public BedrockItemType(int blockingId) {
        super(blockingId, BedrockItem.class);
    }

    @Override
    public BedrockItem read(ByteBuf buffer, Integer blockingId) throws Exception {
        int id = BedrockTypes.VAR_INT.read(buffer);
        if (id == 0) {
            return null;
        }
        BedrockItem item = new BedrockItem(id);
        item.setAmount(buffer.readUnsignedShortLE());
        item.setData(BedrockTypes.UNSIGNED_VAR_INT.read(buffer));
        item.setUsingNetId(buffer.readBoolean());
        if (item.usingNetId()) {
            item.setNetId(BedrockTypes.VAR_INT.read(buffer));
        }
        item.setBlockRuntimeId(BedrockTypes.VAR_INT.read(buffer));
        ByteBuf extraData = buffer.readSlice(BedrockTypes.UNSIGNED_VAR_INT.read(buffer).intValue());
        short tagLength = extraData.readShortLE();
        if (tagLength > 0) {
            item.setTag((CompoundTag)BedrockTypes.TAG_LE.read(extraData));
        } else if (tagLength == -1) {
            short tagCount = extraData.readUnsignedByte();
            if (tagCount != 1) {
                throw new IllegalArgumentException("Expected 1 tag but got " + tagCount);
            }
            item.setTag((CompoundTag)BedrockTypes.TAG_LE.read(extraData));
        }
        item.setCanPlace((String[])BedrockTypes.UTF8_STRING_ARRAY.read(extraData));
        item.setCanBreak((String[])BedrockTypes.UTF8_STRING_ARRAY.read(extraData));
        if (item.identifier() == blockingId.intValue()) {
            item.setBlockingTicks(extraData.readLongLE());
        }
        if (extraData.isReadable()) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Item had too much data: " + extraData.readableBytes() + " extra bytes");
        }
        return item;
    }

    @Override
    public void write(ByteBuf buffer, Integer blockingId, BedrockItem value) throws Exception {
        if (value == null) {
            BedrockTypes.VAR_INT.write(buffer, 0);
            return;
        }
        BedrockTypes.VAR_INT.write(buffer, value.identifier());
        buffer.writeShortLE(value.amount());
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, Integer.valueOf(value.data()));
        buffer.writeBoolean(value.usingNetId());
        if (value.usingNetId()) {
            BedrockTypes.VAR_INT.write(buffer, value.netId());
        }
        BedrockTypes.VAR_INT.write(buffer, value.blockRuntimeId());
        ByteBuf extraData = buffer.alloc().buffer();
        if (value.tag() != null) {
            extraData.writeShortLE(-1);
            extraData.writeByte(1);
            BedrockTypes.TAG_LE.write(extraData, value.tag());
        } else {
            extraData.writeShortLE(0);
        }
        BedrockTypes.UTF8_STRING_ARRAY.write(extraData, value.canPlace());
        BedrockTypes.UTF8_STRING_ARRAY.write(extraData, value.canBreak());
        if (value.identifier() == blockingId.intValue()) {
            extraData.writeLongLE(value.blockingTicks());
        }
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, extraData.readableBytes());
        buffer.writeBytes(extraData);
        extraData.release();
    }
}

