/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.array;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.TypeConverter;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;

public class ArrayType<T>
extends Type<T[]> {
    private final Type<T> elementType;
    private final Type<? extends Number> lengthType;

    public ArrayType(Type<T> type, Type<? extends Number> lengthType) {
        super(type.getTypeName() + " " + lengthType.getTypeName() + "Array", com.viaversion.viaversion.api.type.types.ArrayType.getArrayClass(type.getOutputClass()));
        if (!(lengthType instanceof TypeConverter)) {
            throw new IllegalArgumentException("Length type must be a TypeConverter<? extends Number>");
        }
        this.elementType = type;
        this.lengthType = lengthType;
    }

    @Override
    public T[] read(ByteBuf buffer) throws Exception {
        int length = ((Number)this.lengthType.read(buffer)).intValue();
        Object[] array = (Object[])Array.newInstance(this.elementType.getOutputClass(), length);
        for (int i = 0; i < length; ++i) {
            array[i] = this.elementType.read(buffer);
        }
        return array;
    }

    @Override
    public void write(ByteBuf buffer, T[] value) throws Exception {
        Type<? extends Number> lengthType = this.lengthType;
        lengthType.write(buffer, (Number)((TypeConverter)((Object)lengthType)).from(value.length));
        for (T v : value) {
            this.elementType.write(buffer, v);
        }
    }
}

