/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.chunk;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import net.raphimc.viabedrock.api.chunk.section.BedrockChunkSection;
import net.raphimc.viabedrock.protocol.types.chunk.ChunkSectionV0Type;
import net.raphimc.viabedrock.protocol.types.chunk.ChunkSectionV1Type;
import net.raphimc.viabedrock.protocol.types.chunk.ChunkSectionV8Type;
import net.raphimc.viabedrock.protocol.types.chunk.ChunkSectionV9Type;

public class ChunkSectionType
extends Type<BedrockChunkSection> {
    private final Type<BedrockChunkSection> V0 = new ChunkSectionV0Type();
    private final Type<BedrockChunkSection> V1 = new ChunkSectionV1Type();
    private final Type<BedrockChunkSection> V8 = new ChunkSectionV8Type();
    private final Type<BedrockChunkSection> V9 = new ChunkSectionV9Type();

    public ChunkSectionType() {
        super(BedrockChunkSection.class);
    }

    @Override
    public BedrockChunkSection read(ByteBuf buffer) throws Exception {
        byte version = buffer.readByte();
        switch (version) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (BedrockChunkSection)this.V0.read(buffer);
            }
            case 1: {
                return (BedrockChunkSection)this.V1.read(buffer);
            }
            case 8: {
                return (BedrockChunkSection)this.V8.read(buffer);
            }
            case 9: {
                return (BedrockChunkSection)this.V9.read(buffer);
            }
        }
        throw new UnsupportedOperationException("Unknown chunk section version: " + version);
    }

    @Override
    public void write(ByteBuf buffer, BedrockChunkSection value) throws Exception {
        throw new UnsupportedOperationException("ChunkSectionType is only for reading");
    }
}

