/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.metadata;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class FloatPropertiesType
extends Type<Map<Integer, Float>> {
    public FloatPropertiesType() {
        super("FloatProperties", Map.class);
    }

    @Override
    public Map<Integer, Float> read(ByteBuf buffer) throws Exception {
        int length = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
        HashMap<Integer, Float> properties = new HashMap<Integer, Float>(length);
        for (int i = 0; i < length; ++i) {
            int index = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
            float value = BedrockTypes.FLOAT_LE.readPrimitive(buffer);
            properties.put(index, Float.valueOf(value));
        }
        return properties;
    }

    @Override
    public void write(ByteBuf buffer, Map<Integer, Float> value) throws Exception {
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, value.size());
        value.forEach((i, v) -> {
            BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, (int)i);
            BedrockTypes.FLOAT_LE.writePrimitive(buffer, v.floatValue());
        });
    }
}

