/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.google.common.collect.Sets;
import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.raphimc.viabedrock.protocol.model.CommandData;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class CommandDataArrayType
extends Type<CommandData[]> {
    private static final int FLAG_VALID = 0x100000;
    private static final int FLAG_ENUM = 0x200000;
    private static final int FLAG_POSTFIX = 0x1000000;
    private static final int FLAG_DYNAMIC_ENUM = 0x4000000;

    public CommandDataArrayType() {
        super(CommandData[].class);
    }

    @Override
    public CommandData[] read(ByteBuf buffer) throws Exception {
        String[] enumLiterals = (String[])BedrockTypes.STRING_ARRAY.read(buffer);
        String[] postFixLiterals = (String[])BedrockTypes.STRING_ARRAY.read(buffer);
        Type indexType = enumLiterals.length <= 255 ? Type.UNSIGNED_BYTE : (enumLiterals.length <= 65535 ? BedrockTypes.UNSIGNED_SHORT_LE : BedrockTypes.UNSIGNED_INT_LE);
        CommandData.EnumData[] enumPalette = new CommandData.EnumData[BedrockTypes.UNSIGNED_VAR_INT.read(buffer).intValue()];
        HashMap<String, CommandData.EnumData> enumPaletteMap = new HashMap<String, CommandData.EnumData>(enumPalette.length);
        for (int i = 0; i < enumPalette.length; ++i) {
            CommandData.EnumData enumData;
            String name = (String)BedrockTypes.STRING.read(buffer);
            int count = BedrockTypes.UNSIGNED_VAR_INT.read(buffer);
            HashSet<String> values = new HashSet<String>(count);
            for (int j = 0; j < count; ++j) {
                int index = ((Number)indexType.read(buffer)).intValue();
                if (index >= 0 && index < enumLiterals.length) {
                    values.add(enumLiterals[index]);
                    continue;
                }
                values.add("default");
            }
            if (enumPaletteMap.containsKey(name)) {
                enumData = (CommandData.EnumData)enumPaletteMap.get(name);
                enumData.addValues(values);
            } else {
                enumData = new CommandData.EnumData(name, values, false);
                enumPaletteMap.put(name, enumData);
            }
            enumPalette[i] = enumData;
        }
        ArrayList<Consumer<CommandData.EnumData[]>> dynamicEnumResolvers = new ArrayList<Consumer<CommandData.EnumData[]>>();
        CommandData[] commands = new CommandData[BedrockTypes.UNSIGNED_VAR_INT.read(buffer).intValue()];
        HashMap<String, CommandData> commandMap = new HashMap<String, CommandData>(commands.length);
        for (int i = 0; i < commands.length; ++i) {
            CommandData commandData;
            String name = (String)BedrockTypes.STRING.read(buffer);
            String description = (String)BedrockTypes.STRING.read(buffer);
            int flags = buffer.readUnsignedShortLE();
            short permission = buffer.readUnsignedByte();
            int aliasIndex = buffer.readIntLE();
            boolean validAliasPointer = aliasIndex >= 0 && aliasIndex < enumPalette.length;
            CommandData.EnumData alias = validAliasPointer ? enumPalette[aliasIndex] : new CommandData.EnumData(name + "_invalid_alias_" + aliasIndex, Sets.newHashSet((Object[])new String[]{name}), false);
            CommandData.ParamData[][] parameters = new CommandData.ParamData[BedrockTypes.UNSIGNED_VAR_INT.read(buffer).intValue()][];
            for (int j = 0; j < parameters.length; ++j) {
                parameters[j] = new CommandData.ParamData[BedrockTypes.UNSIGNED_VAR_INT.read(buffer).intValue()];
                for (int k = 0; k < parameters[j].length; ++k) {
                    int index;
                    String paramName = (String)BedrockTypes.STRING.read(buffer);
                    int param = buffer.readIntLE();
                    boolean optional = buffer.readBoolean();
                    short paramFlags = buffer.readUnsignedByte();
                    Integer type = null;
                    CommandData.EnumData enumData = null;
                    String postfix = null;
                    if ((param & 0x1000000) != 0) {
                        index = param & 0xFEFFFFFF;
                        postfix = postFixLiterals[index];
                    } else if ((param & 0x200000) != 0) {
                        index = param & 0xFFDFFFFF & 0xFFEFFFFF;
                        if (index >= 0 && index < enumPalette.length) {
                            enumData = enumPalette[index];
                        }
                    } else {
                        if ((param & 0x4000000) != 0) {
                            index = param & 0xFBFFFFFF & 0xFFEFFFFF;
                            int finalJ = j;
                            int finalK = k;
                            dynamicEnumResolvers.add(dynamicEnumPalette -> {
                                parameters[finalJ][finalK] = index >= 0 && index < ((CommandData.EnumData[])dynamicEnumPalette).length ? new CommandData.ParamData(paramName, optional, paramFlags, null, dynamicEnumPalette[index], null) : new CommandData.ParamData(paramName, optional, paramFlags, 44, null, null);
                            });
                            continue;
                        }
                        if ((param & 0x100000) != 0) {
                            type = param & 0xFFEFFFFF;
                        }
                    }
                    parameters[j][k] = new CommandData.ParamData(paramName, optional, paramFlags, type, enumData, postfix);
                }
            }
            if (commandMap.containsKey(name)) {
                CommandData oldCommandData = (CommandData)commandMap.get(name);
                CommandData.EnumData newAlias = validAliasPointer ? alias : oldCommandData.alias();
                CommandData.ParamData[][] newParameters = new CommandData.ParamData[oldCommandData.parameters().length + parameters.length][];
                System.arraycopy(oldCommandData.parameters(), 0, newParameters, 0, oldCommandData.parameters().length);
                System.arraycopy(parameters, 0, newParameters, oldCommandData.parameters().length, parameters.length);
                commandData = new CommandData(name, oldCommandData.description(), oldCommandData.flags(), oldCommandData.permission(), newAlias, newParameters);
                commandMap.put(name, commandData);
            } else {
                commandData = new CommandData(name, description, flags, permission, alias, parameters);
                commandMap.put(name, commandData);
            }
            commands[i] = commandData;
        }
        CommandData.EnumData[] dynamicEnumPalette2 = new CommandData.EnumData[BedrockTypes.UNSIGNED_VAR_INT.read(buffer).intValue()];
        HashMap<String, CommandData.EnumData> dynamicEnumPaletteMap = new HashMap<String, CommandData.EnumData>(dynamicEnumPalette2.length);
        for (int i = 0; i < dynamicEnumPalette2.length; ++i) {
            CommandData.EnumData enumData;
            String name = (String)BedrockTypes.STRING.read(buffer);
            HashSet values = Sets.newHashSet((Object[])((Object[])BedrockTypes.STRING_ARRAY.read(buffer)));
            if (dynamicEnumPaletteMap.containsKey(name)) {
                enumData = (CommandData.EnumData)dynamicEnumPaletteMap.get(name);
                enumData.addValues(values);
            } else {
                enumData = new CommandData.EnumData(name, values, true);
                dynamicEnumPaletteMap.put(name, enumData);
            }
            dynamicEnumPalette2[i] = enumData;
        }
        dynamicEnumResolvers.forEach(c -> c.accept(dynamicEnumPalette2));
        int enumFlagsCount = BedrockTypes.UNSIGNED_VAR_INT.read(buffer);
        for (int i = 0; i < enumFlagsCount; ++i) {
            int valueIndex = buffer.readIntLE();
            int enumIndex = buffer.readIntLE();
            String valueKey = enumLiterals[valueIndex];
            CommandData.EnumData enumData = enumPalette[enumIndex];
            Set<Short> flags = enumData.values().get(valueKey);
            int flagsCount = BedrockTypes.UNSIGNED_VAR_INT.read(buffer);
            for (int j = 0; j < flagsCount; ++j) {
                flags.add(buffer.readUnsignedByte());
            }
        }
        return commands;
    }

    @Override
    public void write(ByteBuf buffer, CommandData[] value) throws Exception {
        throw new UnsupportedOperationException("Cannot serialize CommandData array");
    }
}

