/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.protocol.model.GameRule;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class GameRuleType
extends Type<GameRule<?>> {
    public GameRuleType() {
        super(GameRule.class);
    }

    @Override
    public GameRule<?> read(ByteBuf buffer) throws Exception {
        String name = (String)BedrockTypes.STRING.read(buffer);
        boolean editable = buffer.readBoolean();
        int type = BedrockTypes.UNSIGNED_VAR_INT.read(buffer);
        switch (type) {
            case 1: {
                return new GameRule<Boolean>(name, editable, buffer.readBoolean());
            }
            case 2: {
                return new GameRule<Integer>(name, editable, BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer));
            }
            case 3: {
                return new GameRule<Float>(name, editable, Float.valueOf(BedrockTypes.FLOAT_LE.readPrimitive(buffer)));
            }
        }
        ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown game rule type: " + type);
        return new GameRule<Object>(name, editable, null);
    }

    @Override
    public void write(ByteBuf buffer, GameRule value) throws Exception {
        Class<?> type;
        BedrockTypes.STRING.write(buffer, value.name());
        buffer.writeBoolean(value.editable());
        Class<?> clazz = type = value.value() == null ? null : value.value().getClass();
        int typeId = type == Boolean.class ? 1 : (type == Integer.class ? 2 : (type == Float.class ? 3 : -1));
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, typeId);
        switch (typeId) {
            case 1: {
                buffer.writeBoolean(((Boolean)value.value()).booleanValue());
                break;
            }
            case 2: {
                BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, (Integer)value.value());
                break;
            }
            case 3: {
                BedrockTypes.FLOAT_LE.writePrimitive(buffer, ((Float)value.value()).floatValue());
            }
        }
    }
}

