/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import io.netty.buffer.ByteBuf;
import net.raphimc.viabedrock.protocol.model.PlayerAbilities;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class PlayerAbilitiesType
extends Type<PlayerAbilities> {
    public PlayerAbilitiesType() {
        super(PlayerAbilities.class);
    }

    @Override
    public PlayerAbilities read(ByteBuf buffer) throws Exception {
        long uniqueEntityId = buffer.readLongLE();
        int playerPermission = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
        int commandPermission = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
        int layerCount = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
        Int2ObjectOpenHashMap<PlayerAbilities.Abilities> abilityLayers = new Int2ObjectOpenHashMap<PlayerAbilities.Abilities>(layerCount);
        for (int i = 0; i < layerCount; ++i) {
            short type = buffer.readShortLE();
            int abilitiesSet = buffer.readIntLE();
            int abilityValues = buffer.readIntLE();
            float flySpeed = buffer.readFloatLE();
            float walkSpeed = buffer.readFloatLE();
            abilityLayers.put(type, new PlayerAbilities.Abilities(abilitiesSet, abilityValues, walkSpeed, flySpeed));
        }
        return new PlayerAbilities(uniqueEntityId, playerPermission, commandPermission, abilityLayers);
    }

    @Override
    public void write(ByteBuf buffer, PlayerAbilities value) throws Exception {
        buffer.writeLongLE(value.uniqueEntityId());
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, value.playerPermission());
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, value.commandPermission());
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, value.abilityLayers().size());
        for (Int2ObjectMap.Entry entry : value.abilityLayers().int2ObjectEntrySet()) {
            buffer.writeShortLE(entry.getIntKey());
            buffer.writeIntLE(((PlayerAbilities.Abilities)entry.getValue()).abilitiesSet());
            buffer.writeIntLE(((PlayerAbilities.Abilities)entry.getValue()).abilityValues());
            buffer.writeFloatLE(((PlayerAbilities.Abilities)entry.getValue()).flySpeed());
            buffer.writeFloatLE(((PlayerAbilities.Abilities)entry.getValue()).walkSpeed());
        }
    }
}

