/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.ResourcePack;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ResourcePackType
extends Type<ResourcePack> {
    public ResourcePackType() {
        super(ResourcePack.class);
    }

    @Override
    public ResourcePack read(ByteBuf buffer) throws Exception {
        UUID packUUID;
        String packId = (String)BedrockTypes.STRING.read(buffer);
        String packVersion = (String)BedrockTypes.STRING.read(buffer);
        long packSize = buffer.readLongLE();
        String contentKey = (String)BedrockTypes.STRING.read(buffer);
        String subPackName = (String)BedrockTypes.STRING.read(buffer);
        String contentId = (String)BedrockTypes.STRING.read(buffer);
        boolean scripting = buffer.readBoolean();
        boolean raytracingCapable = buffer.readBoolean();
        try {
            packUUID = java.util.UUID.fromString(packId);
        }
        catch (IllegalArgumentException e) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Invalid resource pack UUID: " + packId, e);
            packUUID = new UUID(0L, 0L);
        }
        return new ResourcePack(packUUID, packVersion, contentKey, subPackName, contentId, scripting, raytracingCapable, packSize, 6);
    }

    @Override
    public void write(ByteBuf buffer, ResourcePack value) throws Exception {
        BedrockTypes.STRING.write(buffer, value.packId().toString());
        BedrockTypes.STRING.write(buffer, value.version());
        buffer.writeLongLE((long)value.compressedDataLength());
        BedrockTypes.STRING.write(buffer, value.contentKey());
        BedrockTypes.STRING.write(buffer, value.subPackName());
        BedrockTypes.STRING.write(buffer, value.contentId());
        buffer.writeBoolean(value.scripting());
        buffer.writeBoolean(value.raytracingCapable());
    }
}

