/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.primitive;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.TypeConverter;
import io.netty.buffer.ByteBuf;

public class VarIntType
extends Type<Integer>
implements TypeConverter<Integer> {
    public VarIntType() {
        super("VarInt", Integer.class);
    }

    public int readPrimitive(ByteBuf buffer) {
        int i = (int)Type.VAR_LONG.readPrimitive(buffer);
        return i >>> 1 ^ -(i & 1);
    }

    public void writePrimitive(ByteBuf buffer, int value) {
        Type.VAR_LONG.writePrimitive(buffer, ((long)value << 1 ^ (long)(value >> 31)) & 0xFFFFFFFFL);
    }

    @Override
    public Integer read(ByteBuf buffer) throws Exception {
        return this.readPrimitive(buffer);
    }

    @Override
    public void write(ByteBuf buffer, Integer value) {
        this.writePrimitive(buffer, value);
    }

    @Override
    public Integer from(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return (Integer)o;
    }
}

