/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.api;

import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.protocol.version.VersionRange;
import java.util.ArrayList;
import java.util.List;

public class LegacyProtocolVersion {
    public static final List<ProtocolVersion> PROTOCOLS = new ArrayList<ProtocolVersion>();
    public static final ProtocolVersion c0_0_15a_1 = LegacyProtocolVersion.registerLegacy(-7, "c0.0.15a-1");
    public static final ProtocolVersion c0_0_16a_02 = LegacyProtocolVersion.registerLegacy(-11, "c0.0.16a-02");
    public static final ProtocolVersion c0_0_18a_02 = LegacyProtocolVersion.registerLegacy(-15, "c0.0.18a-02");
    public static final ProtocolVersion c0_0_19a_06 = LegacyProtocolVersion.registerLegacy(-19, "c0.0.19a-06");
    public static final ProtocolVersion c0_0_20ac0_27 = LegacyProtocolVersion.registerLegacy(-23, "c0.0.20a-c0.27");
    public static final ProtocolVersion c0_28toc0_30 = LegacyProtocolVersion.registerLegacy(-27, "c0.28-c0.30");
    public static final ProtocolVersion a1_0_15 = LegacyProtocolVersion.registerLegacy(-51, "a1.0.15");
    public static final ProtocolVersion a1_0_16toa1_0_16_2 = LegacyProtocolVersion.registerLegacy(-55, "a1.0.16-a1.0.16.2", new VersionRange("a1.0.16", 0, 2));
    public static final ProtocolVersion a1_0_17toa1_0_17_4 = LegacyProtocolVersion.registerLegacy(-108, "a1.0.17-a1.0.17.4", new VersionRange("a1.0.17", 0, 4));
    public static final ProtocolVersion a1_1_0toa1_1_2_1 = LegacyProtocolVersion.registerLegacy(-8, "a1.1.0-a1.1.2.1", new VersionRange("a1.1", 0, 2));
    public static final ProtocolVersion a1_2_0toa1_2_1_1 = LegacyProtocolVersion.registerLegacy(-12, "a1.2.0-a1.2.1.1", new VersionRange("a1.2", 0, 1));
    public static final ProtocolVersion a1_2_2 = LegacyProtocolVersion.registerLegacy(-16, "a1.2.2");
    public static final ProtocolVersion a1_2_3toa1_2_3_4 = LegacyProtocolVersion.registerLegacy(-20, "a1.2.3-a1.2.3.4", new VersionRange("a1.2.3", 0, 4));
    public static final ProtocolVersion a1_2_3_5toa1_2_6 = LegacyProtocolVersion.registerLegacy(-24, "a1.2.3.5-a1.2.6", new VersionRange("a1.2.3", 5, 6));
    public static final ProtocolVersion b1_0tob1_1_1 = LegacyProtocolVersion.registerLegacy(-28, "b1.0-b1.1.1", new VersionRange("b1.0", 0, 1));
    public static final ProtocolVersion b1_1_2 = LegacyProtocolVersion.registerLegacy(-31, "b1.1.2");
    public static final ProtocolVersion b1_2_0tob1_2_2 = LegacyProtocolVersion.registerLegacy(-32, "b1.2-b1.2.2", new VersionRange("b1.2", 0, 2));
    public static final ProtocolVersion b1_3tob1_3_1 = LegacyProtocolVersion.registerLegacy(-36, "b1.3-b1.3.1", new VersionRange("b1.3", 0, 1));
    public static final ProtocolVersion b1_4tob1_4_1 = LegacyProtocolVersion.registerLegacy(-40, "b1.4-b1.4.1", new VersionRange("b1.4", 0, 1));
    public static final ProtocolVersion b1_5tob1_5_2 = LegacyProtocolVersion.registerLegacy(-44, "b1.5-b1.5.2", new VersionRange("b1.5", 0, 2));
    public static final ProtocolVersion b1_6tob1_6_6 = LegacyProtocolVersion.registerLegacy(-52, "b1.6-b1.6.6", new VersionRange("b1.6", 0, 6));
    public static final ProtocolVersion b1_7tob1_7_3 = LegacyProtocolVersion.registerLegacy(-56, "b1.7-b1.7.3", new VersionRange("b1.7", 0, 3));
    public static final ProtocolVersion b1_8tob1_8_1 = LegacyProtocolVersion.registerLegacy(-68, "b1.8-b1.8.1", new VersionRange("b1.8", 0, 1));
    public static final ProtocolVersion r1_0_0tor1_0_1 = LegacyProtocolVersion.registerLegacy(-88, "1.0.0-1.0.1", new VersionRange("1.0", 0, 1));
    public static final ProtocolVersion r1_1 = LegacyProtocolVersion.registerLegacy(-92, "1.1");
    public static final ProtocolVersion r1_2_1tor1_2_3 = LegacyProtocolVersion.registerLegacy(-112, "1.2.1-1.2.3", new VersionRange("1.2", 1, 3));
    public static final ProtocolVersion r1_2_4tor1_2_5 = LegacyProtocolVersion.registerLegacy(-116, "1.2.4-1.2.5", new VersionRange("1.2", 4, 5));
    public static final ProtocolVersion r1_3_1tor1_3_2 = LegacyProtocolVersion.registerLegacy(-156, "1.3.1-1.3.2", new VersionRange("1.3", 1, 2));
    public static final ProtocolVersion r1_4_2 = LegacyProtocolVersion.registerLegacy(-188, "1.4.2");
    public static final ProtocolVersion r1_4_4tor1_4_5 = LegacyProtocolVersion.registerLegacy(-196, "1.4.4-1.4.5", new VersionRange("1.4", 4, 5));
    public static final ProtocolVersion r1_4_6tor1_4_7 = LegacyProtocolVersion.registerLegacy(-204, "1.4.6-1.4.7", new VersionRange("1.4", 6, 7));
    public static final ProtocolVersion r1_5tor1_5_1 = LegacyProtocolVersion.registerLegacy(-240, "1.5-1.5.1", new VersionRange("1.5", 0, 1));
    public static final ProtocolVersion r1_5_2 = LegacyProtocolVersion.registerLegacy(-244, "1.5.2");
    public static final ProtocolVersion r1_6_1 = LegacyProtocolVersion.registerLegacy(-292, "1.6.1");
    public static final ProtocolVersion r1_6_2 = LegacyProtocolVersion.registerLegacy(-296, "1.6.2");
    public static final ProtocolVersion r1_6_4 = LegacyProtocolVersion.registerLegacy(-312, "1.6.4");
    public static final ProtocolVersion c0_30cpe = LegacyProtocolVersion.registerLegacy(-26, "c0.30 CPE");

    public static int protocolCompare(int a, int b) {
        int baseProtocolB;
        if (a > 0 || b > 0) {
            return a - b;
        }
        int baseProtocolA = (a = Math.abs(a)) >> 2;
        if (baseProtocolA != (baseProtocolB = (b = Math.abs(b)) >> 2)) {
            return baseProtocolA - baseProtocolB;
        }
        int discriminatorA = a & 3;
        int discriminatorB = b & 3;
        return discriminatorB - discriminatorA;
    }

    private static ProtocolVersion registerLegacy(int version, String name) {
        return LegacyProtocolVersion.registerLegacy(version, name, null);
    }

    private static ProtocolVersion registerLegacy(int version, String name, VersionRange versionRange) {
        ProtocolVersion protocolVersion = ProtocolVersion.register(version, name, versionRange);
        PROTOCOLS.add(protocolVersion);
        return protocolVersion;
    }
}

