/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.api.model;

import java.util.Objects;

public class IdAndData {
    public int id;
    public int data;

    public IdAndData(int id, int data) {
        if (data < 0 || data > 15) {
            throw new IllegalArgumentException("Block data out of bounds (id:" + id + " data:" + data + ")");
        }
        this.id = id;
        this.data = data;
    }

    public static IdAndData fromCompressedData(int idAndData) {
        return new IdAndData(idAndData >> 4, idAndData & 0xF);
    }

    public static int toCompressedData(int id, int data) {
        return id << 4 | data & 0xF;
    }

    public int toCompressedData() {
        return IdAndData.toCompressedData(this.id, this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdAndData idAndData = (IdAndData)o;
        return this.id == idAndData.id && this.data == idAndData.data;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.data);
    }

    public String toString() {
        return "IdAndData{id=" + this.id + ", data=" + this.data + '}';
    }
}

