/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.api.remapper;

import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.rewriter.ItemRewriter;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrayList;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectList;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ShortTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import java.util.List;

public abstract class LegacyItemRewriter<P extends Protocol>
extends RewriterBase<P>
implements ItemRewriter<P> {
    private final ObjectList<RewriteEntry> rewriteEntries = new ObjectArrayList<RewriteEntry>();
    private final ObjectList<NonExistentEntry> nonExistentItems = new ObjectArrayList<NonExistentEntry>();
    protected final String tagName;
    protected final String protocolName;

    public LegacyItemRewriter(P protocol, String protocolName) {
        super(protocol);
        this.tagName = protocolName.replace(".", "_") + "_ProtocolHack_" + System.currentTimeMillis();
        this.protocolName = protocolName;
    }

    protected void addRemappedItem(int oldItemId, int newItemId, String newItemName) {
        this.addRemappedItem(oldItemId, newItemId, -1, newItemName);
    }

    protected void addRemappedItem(int oldItemId, int newItemId, int newItemMeta, String newItemName) {
        this.addRemappedItem(oldItemId, -1, newItemId, newItemMeta, newItemName);
    }

    protected void addRemappedItem(int oldItemId, int oldItemMeta, int newItemId, int newItemMeta, String newItemName) {
        this.rewriteEntries.add(new RewriteEntry(oldItemId, (short)oldItemMeta, newItemId, (short)newItemMeta, newItemName));
    }

    protected void addNonExistentItem(int itemId, int itemMeta) {
        this.nonExistentItems.add(new NonExistentEntry(itemId, (short)itemMeta));
    }

    protected void addNonExistentItem(int itemId, int startItemMeta, int endItemMeta) {
        for (int i = startItemMeta; i <= endItemMeta; ++i) {
            this.nonExistentItems.add(new NonExistentEntry(itemId, (short)i));
        }
    }

    protected void addNonExistentItems(int ... itemIds) {
        for (int itemId : itemIds) {
            this.nonExistentItems.add(new NonExistentEntry(itemId, -1));
        }
    }

    protected void addNonExistentItemRange(int startItemId, int endItemId) {
        for (int i = startItemId; i <= endItemId; ++i) {
            this.nonExistentItems.add(new NonExistentEntry(i, -1));
        }
    }

    public void registerCreativeInventoryAction(ServerboundPacketType packetType, final Type<Item> type) {
        this.protocol.registerServerbound(packetType, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.SHORT);
                this.map(type);
                this.handler(LegacyItemRewriter.this.itemToServerHandler(type));
            }
        });
    }

    @Override
    public Item handleItemToClient(Item item) {
        if (item == null) {
            return null;
        }
        for (RewriteEntry rewriteEntry : this.rewriteEntries) {
            if (!rewriteEntry.rewrites(item)) continue;
            this.setRemappedNameRead(item, rewriteEntry.newItemName);
            if (rewriteEntry.newItemMeta != -1) {
                item.setData(rewriteEntry.newItemMeta);
            }
            item.setIdentifier(rewriteEntry.newItemID);
        }
        return item;
    }

    @Override
    public Item handleItemToServer(Item item) {
        if (item == null) {
            return null;
        }
        for (NonExistentEntry nonExistentEntry : this.nonExistentItems) {
            if (!nonExistentEntry.rewrites(item)) continue;
            item.setIdentifier(1);
            item.setData((short)0);
            return item;
        }
        this.setRemappedTagWrite(item);
        return item;
    }

    private PacketHandler itemToClientHandler(Type<Item> type) {
        return wrapper -> this.handleItemToClient((Item)wrapper.get(type, 0));
    }

    private PacketHandler itemToServerHandler(Type<Item> type) {
        return wrapper -> this.handleItemToServer((Item)wrapper.get(type, 0));
    }

    private void setRemappedNameRead(Item item, String name) {
        CompoundTag tag;
        CompoundTag protocolHackTag;
        CompoundTag compoundTag = protocolHackTag = item.tag() != null && item.tag().contains(this.tagName) ? (CompoundTag)item.tag().get(this.tagName) : new CompoundTag();
        if (item.tag() == null || !item.tag().contains(this.tagName)) {
            protocolHackTag.put("Id", new IntTag(item.identifier()));
            protocolHackTag.put("Meta", new ShortTag(item.data()));
        }
        if ((tag = item.tag()) == null) {
            tag = new CompoundTag();
            item.setTag(tag);
            protocolHackTag.put("RemoveTag", new IntTag(0));
        }
        tag.put(this.tagName, protocolHackTag);
        CompoundTag display = (CompoundTag)tag.get("display");
        if (display == null) {
            display = new CompoundTag();
            tag.put("display", display);
            protocolHackTag.put("RemoveDisplayTag", new IntTag(0));
        }
        if (display.contains("Name")) {
            ListTag lore = (ListTag)display.get("Lore");
            if (lore == null) {
                lore = new ListTag();
                display.put("Lore", lore);
                protocolHackTag.put("RemoveLore", new IntTag(0));
            }
            lore.add(new StringTag("\u00a7r " + this.protocolName + " Item ID: " + item.identifier() + " (" + name + ")"));
            protocolHackTag.put("RemoveLastLore", new IntTag(0));
        } else {
            display.put("Name", new StringTag("\u00a7r" + this.protocolName + " " + name));
            protocolHackTag.put("RemoveDisplayName", new IntTag(0));
        }
    }

    private void setRemappedTagWrite(Item item) {
        if (item.tag() == null) {
            return;
        }
        if (!item.tag().contains(this.tagName)) {
            return;
        }
        CompoundTag tag = item.tag();
        CompoundTag protocolHackTag = (CompoundTag)tag.get(this.tagName);
        tag.remove(this.tagName);
        item.setIdentifier(((IntTag)protocolHackTag.get("Id")).asInt());
        item.setData(((ShortTag)protocolHackTag.get("Meta")).asShort());
        if (protocolHackTag.contains("RemoveLastLore")) {
            ListTag lore = (ListTag)((CompoundTag)tag.get("display")).get("Lore");
            Object tags = lore.getValue();
            tags.remove(lore.size() - 1);
            lore.setValue((List<Tag>)tags);
        }
        if (protocolHackTag.contains("RemoveLore")) {
            ((CompoundTag)tag.get("display")).remove("Lore");
        }
        if (protocolHackTag.contains("RemoveDisplayName")) {
            ((CompoundTag)tag.get("display")).remove("Name");
        }
        if (protocolHackTag.contains("RemoveDisplayTag")) {
            tag.remove("display");
        }
        if (protocolHackTag.contains("RemoveTag")) {
            item.setTag(null);
        }
    }

    private static class NonExistentEntry {
        private final int itemId;
        private final short itemMeta;

        public NonExistentEntry(int itemId, short itemMeta) {
            this.itemId = itemId;
            this.itemMeta = itemMeta;
        }

        public boolean rewrites(Item item) {
            return item.identifier() == this.itemId && (this.itemMeta == -1 || this.itemMeta == item.data());
        }
    }

    private static class RewriteEntry {
        private final int oldItemID;
        private final short oldItemMeta;
        private final int newItemID;
        private final short newItemMeta;
        private final String newItemName;

        public RewriteEntry(int oldItemID, short oldItemMeta, int newItemID, short newItemMeta, String newItemName) {
            this.oldItemID = oldItemID;
            this.oldItemMeta = oldItemMeta;
            this.newItemID = newItemID;
            this.newItemMeta = newItemMeta;
            this.newItemName = newItemName;
        }

        public boolean rewrites(Item item) {
            return item.identifier() == this.oldItemID && (this.oldItemMeta == -1 || this.oldItemMeta == item.data());
        }
    }
}

