/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ShortTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.data.BlockList1_6;
import net.raphimc.vialegacy.api.data.ItemList1_6;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.ClientboundPacketsa1_2_6;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.ServerboundPacketsa1_2_6;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.data.AlphaItems;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.providers.AlphaInventoryProvider;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.providers.TrackingAlphaInventoryProvider;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.storage.AlphaInventoryTracker;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.storage.InventoryStorage;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.task.AlphaInventoryUpdateTask;
import net.raphimc.vialegacy.protocols.beta.protocolb1_2_0_2tob1_1_2.ClientboundPacketsb1_1;
import net.raphimc.vialegacy.protocols.beta.protocolb1_2_0_2tob1_1_2.ServerboundPacketsb1_1;
import net.raphimc.vialegacy.protocols.beta.protocolb1_2_0_2tob1_1_2.types.Typesb1_1;
import net.raphimc.vialegacy.protocols.beta.protocolb1_8_0_1tob1_7_0_3.types.Typesb1_7_0_3;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.Protocol1_2_1_3to1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_4_5to1_2_1_3.ClientboundPackets1_2_1;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.data.EntityList;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.types.Types1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_4_4_5to1_4_2.types.Types1_4_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ChunkTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.PlayerInfoStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocolb1_0_1_1_1toa1_2_3_5_1_2_6
extends AbstractProtocol<ClientboundPacketsa1_2_6, ClientboundPacketsb1_1, ServerboundPacketsa1_2_6, ServerboundPacketsb1_1> {
    public Protocolb1_0_1_1_1toa1_2_3_5_1_2_6() {
        super(ClientboundPacketsa1_2_6.class, ClientboundPacketsb1_1.class, ServerboundPacketsa1_2_6.class, ServerboundPacketsb1_1.class);
    }

    @Override
    protected void registerPackets() {
        this.registerClientbound(ClientboundPacketsa1_2_6.PLAYER_INVENTORY, ClientboundPacketsb1_1.WINDOW_ITEMS, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    InventoryStorage inventoryStorage = wrapper.user().get(InventoryStorage.class);
                    AlphaInventoryTracker inventoryTracker = wrapper.user().get(AlphaInventoryTracker.class);
                    int type = wrapper.read(Type.INT);
                    Item[] items = wrapper.read(Types1_4_2.NBTLESS_ITEM_ARRAY);
                    Item[] windowItems = new Item[45];
                    System.arraycopy(inventoryStorage.mainInventory, 0, windowItems, 36, 9);
                    System.arraycopy(inventoryStorage.mainInventory, 9, windowItems, 9, 27);
                    System.arraycopy(inventoryStorage.craftingInventory, 0, windowItems, 1, 4);
                    System.arraycopy(inventoryStorage.armorInventory, 0, windowItems, 5, 4);
                    switch (type) {
                        case -1: {
                            inventoryStorage.mainInventory = items;
                            if (inventoryTracker != null) {
                                inventoryTracker.setMainInventory(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItems(items));
                            }
                            System.arraycopy(items, 0, windowItems, 36, 9);
                            System.arraycopy(items, 9, windowItems, 9, 27);
                            break;
                        }
                        case -2: {
                            inventoryStorage.craftingInventory = items;
                            if (inventoryTracker != null) {
                                inventoryTracker.setCraftingInventory(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItems(items));
                            }
                            System.arraycopy(items, 0, windowItems, 1, 4);
                            break;
                        }
                        case -3: {
                            inventoryStorage.armorInventory = items;
                            if (inventoryTracker != null) {
                                inventoryTracker.setArmorInventory(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItems(items));
                            }
                            System.arraycopy(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.reverseArray(items), 0, windowItems, 5, 4);
                        }
                    }
                    wrapper.write(Type.BYTE, (byte)0);
                    wrapper.write(Types1_4_2.NBTLESS_ITEM_ARRAY, Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItems(windowItems));
                });
            }
        });
        this.registerClientbound(ClientboundPacketsa1_2_6.UPDATE_HEALTH, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.BYTE, Type.SHORT);
            }
        });
        this.registerClientbound(ClientboundPacketsa1_2_6.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.user().get(InventoryStorage.class).resetPlayerInventory();
                    AlphaInventoryTracker inventoryTracker = wrapper.user().get(AlphaInventoryTracker.class);
                    if (inventoryTracker != null) {
                        inventoryTracker.onRespawn();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPacketsa1_2_6.HELD_ITEM_CHANGE, ClientboundPacketsb1_1.ENTITY_EQUIPMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.create(Type.SHORT, (short)0);
                this.map(Type.SHORT);
                this.handler(wrapper -> {
                    if (wrapper.get(Type.SHORT, 1) == 0) {
                        wrapper.set(Type.SHORT, 1, (short)-1);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPacketsa1_2_6.ADD_TO_INVENTORY, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    Item item = wrapper.read(Types1_3_1.NBTLESS_ITEM);
                    Via.getManager().getProviders().get(AlphaInventoryProvider.class).addToInventory(wrapper.user(), item);
                });
            }
        });
        this.registerClientbound(ClientboundPacketsa1_2_6.PRE_CHUNK, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(wrapper -> wrapper.user().get(InventoryStorage.class).unload(wrapper.get(Type.INT, 0), wrapper.get(Type.INT, 1)));
            }
        });
        this.registerClientbound(ClientboundPacketsa1_2_6.COMPLEX_ENTITY, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String blockName;
                    wrapper.cancel();
                    InventoryStorage tracker = wrapper.user().get(InventoryStorage.class);
                    Position pos = wrapper.read(Types1_7_6.POSITION_SHORT);
                    CompoundTag tag = wrapper.read(Types1_7_6.COMPRESSED_NBT);
                    if (((IntTag)tag.get("x")).asInt() != pos.x() || ((IntTag)tag.get("y")).asInt() != pos.y() || ((IntTag)tag.get("z")).asInt() != pos.z()) {
                        return;
                    }
                    IdAndData block = wrapper.user().get(ChunkTracker.class).getBlockNotNull(pos);
                    String string = blockName = tag.get("id") != null ? ((StringTag)tag.get("id")).getValue() : "";
                    if (block.id == BlockList1_6.signPost.blockID || block.id == BlockList1_6.signWall.blockID || blockName.equals("Sign")) {
                        PacketWrapper updateSign = PacketWrapper.create(ClientboundPacketsb1_1.UPDATE_SIGN, wrapper.user());
                        updateSign.write(Types1_7_6.POSITION_SHORT, pos);
                        updateSign.write(Typesb1_7_0_3.STRING, ((StringTag)tag.get("Text1")).getValue());
                        updateSign.write(Typesb1_7_0_3.STRING, ((StringTag)tag.get("Text2")).getValue());
                        updateSign.write(Typesb1_7_0_3.STRING, ((StringTag)tag.get("Text3")).getValue());
                        updateSign.write(Typesb1_7_0_3.STRING, ((StringTag)tag.get("Text4")).getValue());
                        updateSign.send(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
                    } else if (block.id == BlockList1_6.mobSpawner.blockID || blockName.equals("MobSpawner")) {
                        if (wrapper.user().getProtocolInfo().getPipeline().contains(Protocol1_2_1_3to1_1.class)) {
                            PacketWrapper spawnerData = PacketWrapper.create(ClientboundPackets1_2_1.BLOCK_ENTITY_DATA, wrapper.user());
                            spawnerData.write(Types1_7_6.POSITION_SHORT, pos);
                            spawnerData.write(Type.BYTE, (byte)1);
                            spawnerData.write(Type.INT, EntityList.getEntityId(((StringTag)tag.get("EntityId")).getValue()));
                            spawnerData.write(Type.INT, 0);
                            spawnerData.write(Type.INT, 0);
                            spawnerData.send(Protocol1_2_1_3to1_1.class);
                        }
                    } else if (block.id == BlockList1_6.chest.blockID || blockName.equals("Chest")) {
                        Item[] chestItems = new Item[27];
                        Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.readItemsFromTag(tag, chestItems);
                        tracker.containers.put(pos, chestItems);
                        if (pos.equals(tracker.openContainerPos)) {
                            Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.sendWindowItems(wrapper.user(), (byte)55, chestItems);
                        }
                    } else if (block.id == BlockList1_6.furnaceIdle.blockID || block.id == BlockList1_6.furnaceBurning.blockID || blockName.equals("Furnace")) {
                        Item[] furnaceItems = new Item[3];
                        Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.readItemsFromTag(tag, furnaceItems);
                        tracker.containers.put(pos, furnaceItems);
                        if (pos.equals(tracker.openContainerPos)) {
                            Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.sendWindowItems(wrapper.user(), (byte)44, furnaceItems);
                            Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.sendProgressUpdate(wrapper.user(), (short)44, (short)0, ((ShortTag)tag.get("CookTime")).asShort());
                            Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.sendProgressUpdate(wrapper.user(), (short)44, (short)1, ((ShortTag)tag.get("BurnTime")).asShort());
                            Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.sendProgressUpdate(wrapper.user(), (short)44, (short)2, Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.getBurningTime(furnaceItems[1]));
                        }
                    } else {
                        ViaLegacy.getPlatform().getLogger().warning("Unhandled Complex Entity data: " + block + "@" + pos + ": '" + tag + "'");
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPacketsb1_1.PLAYER_DIGGING, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    short status = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    if (status == 4) {
                        wrapper.cancel();
                        Item selectedItem = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.fixItem(Via.getManager().getProviders().get(AlphaInventoryProvider.class).getHandItem(wrapper.user()));
                        if (selectedItem == null) {
                            return;
                        }
                        AlphaInventoryTracker inventoryTracker = wrapper.user().get(AlphaInventoryTracker.class);
                        if (inventoryTracker != null) {
                            inventoryTracker.onHandItemDrop();
                        }
                        selectedItem.setAmount(1);
                        Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.dropItem(wrapper.user(), selectedItem, false);
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPacketsb1_1.PLAYER_BLOCK_PLACEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    InventoryStorage tracker = wrapper.user().get(InventoryStorage.class);
                    AlphaInventoryTracker inventoryTracker = wrapper.user().get(AlphaInventoryTracker.class);
                    Position pos = wrapper.read(Types1_7_6.POSITION_UBYTE);
                    short direction = wrapper.read(Type.UNSIGNED_BYTE);
                    Item item = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.fixItem(wrapper.read(Typesb1_1.NBTLESS_ITEM));
                    if (item == null && inventoryTracker != null) {
                        item = Via.getManager().getProviders().get(AlphaInventoryProvider.class).getHandItem(wrapper.user());
                    }
                    wrapper.write(Type.SHORT, item == null ? (short)-1 : (short)item.identifier());
                    wrapper.write(Types1_7_6.POSITION_UBYTE, pos);
                    wrapper.write(Type.UNSIGNED_BYTE, direction);
                    if (inventoryTracker != null) {
                        inventoryTracker.onBlockPlace(pos, direction);
                    }
                    if (direction == 255) {
                        return;
                    }
                    IdAndData block = wrapper.user().get(ChunkTracker.class).getBlockNotNull(pos);
                    if (block.id != BlockList1_6.furnaceIdle.blockID && block.id != BlockList1_6.furnaceBurning.blockID && block.id != BlockList1_6.chest.blockID && block.id != BlockList1_6.workbench.blockID) {
                        return;
                    }
                    tracker.openContainerPos = pos;
                    Item[] containerItems = tracker.containers.get(tracker.openContainerPos);
                    if (containerItems == null && block.id != BlockList1_6.workbench.blockID) {
                        tracker.openContainerPos = null;
                        PacketWrapper chatMessage = PacketWrapper.create(ClientboundPacketsb1_1.CHAT_MESSAGE, wrapper.user());
                        chatMessage.write(Typesb1_7_0_3.STRING, "\u00a7cMissing Container");
                        chatMessage.send(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
                        return;
                    }
                    PacketWrapper openWindow = PacketWrapper.create(ClientboundPacketsb1_1.OPEN_WINDOW, wrapper.user());
                    if (block.id == BlockList1_6.chest.blockID) {
                        openWindow.write(Type.UNSIGNED_BYTE, (short)55);
                        openWindow.write(Type.UNSIGNED_BYTE, (short)0);
                        openWindow.write(Typesb1_7_0_3.STRING, "Chest");
                        openWindow.write(Type.UNSIGNED_BYTE, (short)27);
                        if (inventoryTracker != null) {
                            inventoryTracker.onWindowOpen(0, 27);
                        }
                    } else if (block.id == BlockList1_6.workbench.blockID) {
                        openWindow.write(Type.UNSIGNED_BYTE, (short)33);
                        openWindow.write(Type.UNSIGNED_BYTE, (short)1);
                        openWindow.write(Typesb1_7_0_3.STRING, "Crafting Table");
                        openWindow.write(Type.UNSIGNED_BYTE, (short)9);
                        if (inventoryTracker != null) {
                            inventoryTracker.onWindowOpen(1, 10);
                        }
                    } else {
                        openWindow.write(Type.UNSIGNED_BYTE, (short)44);
                        openWindow.write(Type.UNSIGNED_BYTE, (short)2);
                        openWindow.write(Typesb1_7_0_3.STRING, "Furnace");
                        openWindow.write(Type.UNSIGNED_BYTE, (short)3);
                        if (inventoryTracker != null) {
                            inventoryTracker.onWindowOpen(2, 3);
                        }
                    }
                    openWindow.send(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
                    if (block.id != BlockList1_6.workbench.blockID) {
                        Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.sendWindowItems(wrapper.user(), block.id == BlockList1_6.chest.blockID ? (byte)55 : (byte)44, containerItems);
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPacketsb1_1.HELD_ITEM_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    InventoryStorage inventoryStorage = wrapper.user().get(InventoryStorage.class);
                    short slot = wrapper.read(Type.SHORT);
                    if (slot < 0 || slot > 8) {
                        slot = 0;
                    }
                    inventoryStorage.selectedHotbarSlot = slot;
                    Item selectedItem = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.fixItem(Via.getManager().getProviders().get(AlphaInventoryProvider.class).getHandItem(wrapper.user()));
                    if (Objects.equals(selectedItem, inventoryStorage.handItem)) {
                        wrapper.cancel();
                        return;
                    }
                    inventoryStorage.handItem = selectedItem;
                    wrapper.write(Type.INT, 0);
                    wrapper.write(Type.SHORT, (short)(selectedItem == null ? 0 : selectedItem.identifier()));
                });
            }
        });
        this.registerServerbound(ServerboundPacketsb1_1.CLOSE_WINDOW, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    wrapper.user().get(InventoryStorage.class).openContainerPos = null;
                    AlphaInventoryTracker inventoryTracker = wrapper.user().get(AlphaInventoryTracker.class);
                    if (inventoryTracker != null) {
                        inventoryTracker.onWindowClose();
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPacketsb1_1.CLICK_WINDOW, ServerboundPacketsa1_2_6.COMPLEX_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    InventoryStorage tracker = wrapper.user().get(InventoryStorage.class);
                    AlphaInventoryTracker inventoryTracker = wrapper.user().get(AlphaInventoryTracker.class);
                    byte windowId = wrapper.read(Type.BYTE);
                    short slot = wrapper.read(Type.SHORT);
                    byte button = wrapper.read(Type.BYTE);
                    short action = wrapper.read(Type.SHORT);
                    Item item = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.fixItem(wrapper.read(Typesb1_1.NBTLESS_ITEM));
                    if (inventoryTracker != null) {
                        inventoryTracker.onWindowClick(windowId, slot, button, action, item);
                    }
                    if (windowId != 55 && windowId != 44 || tracker.openContainerPos == null) {
                        wrapper.cancel();
                        return;
                    }
                    Object[] containerItems = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.fixItems(Via.getManager().getProviders().get(AlphaInventoryProvider.class).getContainerItems(wrapper.user()));
                    if (Arrays.equals(tracker.containers.get(tracker.openContainerPos), containerItems)) {
                        wrapper.cancel();
                        return;
                    }
                    tracker.containers.put(tracker.openContainerPos, (Item[])containerItems);
                    CompoundTag tag = new CompoundTag();
                    tag.put("id", new StringTag(windowId == 55 ? "Chest" : "Furnace"));
                    tag.put("x", new IntTag(tracker.openContainerPos.x()));
                    tag.put("y", new IntTag(tracker.openContainerPos.y()));
                    tag.put("z", new IntTag(tracker.openContainerPos.z()));
                    Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.this.writeItemsToTag(tag, (Item[])containerItems);
                    wrapper.write(Type.INT, tracker.openContainerPos.x());
                    wrapper.write(Type.SHORT, (short)tracker.openContainerPos.y());
                    wrapper.write(Type.INT, tracker.openContainerPos.z());
                    wrapper.write(Types1_7_6.COMPRESSED_NBT, tag);
                });
            }
        });
        this.registerServerbound(ServerboundPacketsb1_1.UPDATE_SIGN, ServerboundPacketsa1_2_6.COMPLEX_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Position pos = wrapper.passthrough(Types1_7_6.POSITION_SHORT);
                    CompoundTag tag = new CompoundTag();
                    tag.put("id", new StringTag("Sign"));
                    tag.put("x", new IntTag(pos.x()));
                    tag.put("y", new IntTag(pos.y()));
                    tag.put("z", new IntTag(pos.z()));
                    tag.put("Text1", new StringTag(wrapper.read(Typesb1_7_0_3.STRING)));
                    tag.put("Text2", new StringTag(wrapper.read(Typesb1_7_0_3.STRING)));
                    tag.put("Text3", new StringTag(wrapper.read(Typesb1_7_0_3.STRING)));
                    tag.put("Text4", new StringTag(wrapper.read(Typesb1_7_0_3.STRING)));
                    wrapper.write(Types1_7_6.COMPRESSED_NBT, tag);
                });
            }
        });
        this.cancelServerbound(ServerboundPacketsb1_1.WINDOW_CONFIRMATION);
    }

    private void writeItemsToTag(CompoundTag tag, Item[] items) {
        ListTag slotList = new ListTag();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if (item == null) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.put("Slot", new ByteTag((byte)i));
            slotTag.put("id", new ShortTag((short)item.identifier()));
            slotTag.put("Count", new ByteTag((byte)item.amount()));
            slotTag.put("Damage", new ShortTag(item.data()));
            slotList.add(slotTag);
        }
        tag.put("Items", slotList);
    }

    private void readItemsFromTag(CompoundTag tag, Item[] items) {
        ListTag slotList = (ListTag)tag.get("Items");
        for (Tag itemTag : slotList) {
            CompoundTag slotTag = (CompoundTag)itemTag;
            items[((ByteTag)slotTag.get((String)"Slot")).asByte() & 0xFF] = new DataItem(((ShortTag)slotTag.get("id")).asShort(), ((ByteTag)slotTag.get("Count")).asByte(), ((ShortTag)slotTag.get("Damage")).asShort(), null);
        }
    }

    private void sendWindowItems(UserConnection user, byte windowId, Item[] items) throws Exception {
        PacketWrapper windowItems = PacketWrapper.create(ClientboundPacketsb1_1.WINDOW_ITEMS, user);
        windowItems.write(Type.BYTE, windowId);
        windowItems.write(Types1_4_2.NBTLESS_ITEM_ARRAY, Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItems(items));
        windowItems.send(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
        AlphaInventoryTracker inventoryTracker = user.get(AlphaInventoryTracker.class);
        if (inventoryTracker != null) {
            inventoryTracker.setOpenContainerItems(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItems(items));
        }
    }

    private void sendProgressUpdate(UserConnection user, short windowId, short id, short value) throws Exception {
        PacketWrapper windowProperty = PacketWrapper.create(ClientboundPacketsb1_1.WINDOW_PROPERTY, user);
        windowProperty.write(Type.UNSIGNED_BYTE, windowId);
        windowProperty.write(Type.SHORT, id);
        windowProperty.write(Type.SHORT, value);
        windowProperty.send(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
    }

    private short getBurningTime(Item item) {
        if (item == null) {
            return 0;
        }
        int id = item.identifier();
        if (id == BlockList1_6.bookShelf.blockID || id == BlockList1_6.chest.blockID || id == BlockList1_6.fence.blockID || id == BlockList1_6.jukebox.blockID || id == BlockList1_6.wood.blockID || id == BlockList1_6.planks.blockID || id == BlockList1_6.doorWood.blockID || id == BlockList1_6.signWall.blockID || id == BlockList1_6.signPost.blockID || id == BlockList1_6.workbench.blockID) {
            return 300;
        }
        if (id == ItemList1_6.stick.itemID) {
            return 100;
        }
        if (id == ItemList1_6.coal.itemID) {
            return 1600;
        }
        if (id == ItemList1_6.bucketLava.itemID) {
            return 20000;
        }
        return 0;
    }

    public static void dropItem(UserConnection user, Item item, boolean flag) throws Exception {
        double motionY;
        double motionZ;
        double motionX;
        PlayerInfoStorage playerInfoStorage = user.get(PlayerInfoStorage.class);
        double itemX = playerInfoStorage.posX;
        double itemY = playerInfoStorage.posY + (double)1.62f - (double)0.3f + 0.12;
        double itemZ = playerInfoStorage.posZ;
        if (flag) {
            float f2 = ThreadLocalRandom.current().nextFloat() * 0.5f;
            float f1 = (float)((double)ThreadLocalRandom.current().nextFloat() * Math.PI * 2.0);
            motionX = -Math.sin(f1) * (double)f2;
            motionZ = Math.cos(f1) * (double)f2;
            motionY = 0.2f;
        } else {
            motionX = -Math.sin((double)(playerInfoStorage.yaw / 180.0f) * Math.PI) * Math.cos((double)(playerInfoStorage.pitch / 180.0f) * Math.PI) * (double)0.3f;
            motionZ = Math.cos((double)(playerInfoStorage.yaw / 180.0f) * Math.PI) * Math.cos((double)(playerInfoStorage.pitch / 180.0f) * Math.PI) * (double)0.3f;
            motionY = -Math.sin((double)(playerInfoStorage.pitch / 180.0f) * Math.PI) * (double)0.3f + (double)0.1f;
            float f1 = (float)((double)ThreadLocalRandom.current().nextFloat() * Math.PI * 2.0);
            float f2 = 0.02f * ThreadLocalRandom.current().nextFloat();
            motionX += Math.cos(f1) * (double)f2;
            motionY += (double)((ThreadLocalRandom.current().nextFloat() - ThreadLocalRandom.current().nextFloat()) * 0.1f);
            motionZ += Math.sin(f1) * (double)f2;
        }
        PacketWrapper spawnItem = PacketWrapper.create(ServerboundPacketsa1_2_6.SPAWN_ITEM, user);
        spawnItem.write(Type.INT, 0);
        spawnItem.write(Type.SHORT, (short)item.identifier());
        spawnItem.write(Type.BYTE, (byte)item.amount());
        spawnItem.write(Type.INT, (int)(itemX * 32.0));
        spawnItem.write(Type.INT, (int)(itemY * 32.0));
        spawnItem.write(Type.INT, (int)(itemZ * 32.0));
        spawnItem.write(Type.BYTE, (byte)(motionX * 128.0));
        spawnItem.write(Type.BYTE, (byte)(motionY * 128.0));
        spawnItem.write(Type.BYTE, (byte)(motionZ * 128.0));
        spawnItem.sendToServer(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
    }

    public static Item[] reverseArray(Item[] array) {
        if (array == null) {
            return null;
        }
        Item[] reversed = new Item[array.length];
        for (int i = 0; i < array.length / 2; ++i) {
            reversed[i] = array[array.length - i - 1];
            reversed[array.length - i - 1] = array[i];
        }
        return reversed;
    }

    public static Item copyItem(Item item) {
        return item == null ? null : new DataItem(item);
    }

    public static Item[] copyItems(Item[] items) {
        return (Item[])Arrays.stream(items).map(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6::copyItem).toArray(Item[]::new);
    }

    public static Item fixItem(Item item) {
        if (item == null || !AlphaItems.isValid(item.identifier())) {
            return null;
        }
        item.setTag(null);
        return item;
    }

    public static Item[] fixItems(Item[] items) {
        for (int i = 0; i < items.length; ++i) {
            items[i] = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.fixItem(items[i]);
        }
        return items;
    }

    @Override
    public void register(ViaProviders providers) {
        providers.register(AlphaInventoryProvider.class, new TrackingAlphaInventoryProvider());
        Via.getPlatform().runRepeatingSync(new AlphaInventoryUpdateTask(), 20L);
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class, ClientboundPacketsa1_2_6::getPacket));
        userConnection.put(new InventoryStorage(userConnection));
        if (Via.getManager().getProviders().get(AlphaInventoryProvider.class).usesInventoryTracker()) {
            userConnection.put(new AlphaInventoryTracker(userConnection));
        }
    }
}

