/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.data;

import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.raphimc.vialegacy.api.data.BlockList1_6;
import net.raphimc.vialegacy.api.data.ItemList1_6;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.model.CraftingRecipe;

public class CraftingManager {
    private static final List<CraftingRecipe> recipes;
    private static final String[][] tools_pattern;
    private static final int[][] tools_ingredients;
    private static final String[][] weapons_pattern;
    private static final int[][] weapons_ingredients;
    private static final int[][] ingots_ingredients;
    private static final String[][] armor_pattern;
    private static final int[][] armor_ingredients;

    private static void addRecipe(Item resultItem, Object ... objects) {
        String var3 = "";
        int pos = 0;
        int width = 0;
        int height = 0;
        if (objects[pos] instanceof String[]) {
            String[] var11;
            for (String var9 : var11 = (String[])objects[pos++]) {
                ++height;
                width = var9.length();
                var3 = var3 + var9;
            }
        } else {
            while (objects[pos] instanceof String) {
                String var7 = (String)objects[pos++];
                ++height;
                width = var7.length();
                var3 = var3 + var7;
            }
        }
        HashMap<Character, Integer> lookup = new HashMap<Character, Integer>();
        while (pos < objects.length) {
            lookup.put(Character.valueOf(((Character)objects[pos]).charValue()), (Integer)objects[pos + 1]);
            pos += 2;
        }
        int[] ingredientMap = new int[width * height];
        for (int i = 0; i < ingredientMap.length; ++i) {
            ingredientMap[i] = lookup.getOrDefault(Character.valueOf(var3.charAt(i)), -1);
        }
        recipes.add(new CraftingRecipe(width, height, ingredientMap, resultItem));
    }

    public static Item getResult(Item[] craftingGrid) {
        int gridSize = (int)Math.sqrt(craftingGrid.length);
        int[] ingredientMap = new int[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                Item item;
                int ingredient = -1;
                if (x < gridSize && y < gridSize && (item = craftingGrid[x + y * gridSize]) != null) {
                    ingredient = item.identifier();
                }
                ingredientMap[x + y * 3] = ingredient;
            }
        }
        return CraftingManager.getResult(ingredientMap);
    }

    public static Item getResult(int[] ingredientMap) {
        for (CraftingRecipe recipe : recipes) {
            if (!recipe.matches(ingredientMap)) continue;
            return recipe.createResult();
        }
        return null;
    }

    static {
        int i1;
        int i;
        recipes = new ArrayList<CraftingRecipe>();
        tools_pattern = new String[][]{{"XXX", " # ", " # "}, {"X", "#", "#"}, {"XX", "X#", " #"}, {"XX", " #", " #"}};
        tools_ingredients = new int[][]{{BlockList1_6.planks.blockID, BlockList1_6.cobblestone.blockID, ItemList1_6.ingotIron.itemID, ItemList1_6.diamond.itemID, ItemList1_6.ingotGold.itemID}, {ItemList1_6.pickaxeWood.itemID, ItemList1_6.pickaxeStone.itemID, ItemList1_6.pickaxeIron.itemID, ItemList1_6.pickaxeDiamond.itemID, ItemList1_6.pickaxeGold.itemID}, {ItemList1_6.shovelWood.itemID, ItemList1_6.shovelStone.itemID, ItemList1_6.shovelIron.itemID, ItemList1_6.shovelDiamond.itemID, ItemList1_6.shovelGold.itemID}, {ItemList1_6.axeWood.itemID, ItemList1_6.axeStone.itemID, ItemList1_6.axeIron.itemID, ItemList1_6.axeDiamond.itemID, ItemList1_6.axeGold.itemID}, {ItemList1_6.hoeWood.itemID, ItemList1_6.hoeStone.itemID, ItemList1_6.hoeIron.itemID, ItemList1_6.hoeDiamond.itemID, ItemList1_6.hoeGold.itemID}};
        weapons_pattern = new String[][]{{"X", "X", "#"}};
        weapons_ingredients = new int[][]{{BlockList1_6.planks.blockID, BlockList1_6.cobblestone.blockID, ItemList1_6.ingotIron.itemID, ItemList1_6.diamond.itemID, ItemList1_6.ingotGold.itemID}, {ItemList1_6.swordWood.itemID, ItemList1_6.swordStone.itemID, ItemList1_6.swordIron.itemID, ItemList1_6.swordDiamond.itemID, ItemList1_6.swordGold.itemID}};
        ingots_ingredients = new int[][]{{BlockList1_6.blockGold.blockID, ItemList1_6.ingotGold.itemID}, {BlockList1_6.blockIron.blockID, ItemList1_6.ingotIron.itemID}, {BlockList1_6.blockDiamond.blockID, ItemList1_6.diamond.itemID}};
        armor_pattern = new String[][]{{"XXX", "X X"}, {"X X", "XXX", "XXX"}, {"XXX", "X X", "X X"}, {"X X", "X X"}};
        armor_ingredients = new int[][]{{ItemList1_6.leather.itemID, BlockList1_6.fire.blockID, ItemList1_6.ingotIron.itemID, ItemList1_6.diamond.itemID, ItemList1_6.ingotGold.itemID}, {ItemList1_6.helmetLeather.itemID, ItemList1_6.helmetChain.itemID, ItemList1_6.helmetIron.itemID, ItemList1_6.helmetDiamond.itemID, ItemList1_6.helmetGold.itemID}, {ItemList1_6.plateLeather.itemID, ItemList1_6.plateChain.itemID, ItemList1_6.plateIron.itemID, ItemList1_6.plateDiamond.itemID, ItemList1_6.plateGold.itemID}, {ItemList1_6.legsLeather.itemID, ItemList1_6.legsChain.itemID, ItemList1_6.legsIron.itemID, ItemList1_6.legsDiamond.itemID, ItemList1_6.legsGold.itemID}, {ItemList1_6.bootsLeather.itemID, ItemList1_6.bootsChain.itemID, ItemList1_6.bootsIron.itemID, ItemList1_6.bootsDiamond.itemID, ItemList1_6.bootsGold.itemID}};
        for (i = 0; i < tools_ingredients[0].length; ++i) {
            for (i1 = 0; i1 < tools_ingredients.length - 1; ++i1) {
                CraftingManager.addRecipe(new DataItem(tools_ingredients[i1 + 1][i], 1, 0, null), tools_pattern[i1], Character.valueOf('#'), ItemList1_6.stick.itemID, Character.valueOf('X'), tools_ingredients[0][i]);
            }
        }
        for (i = 0; i < weapons_ingredients[0].length; ++i) {
            for (i1 = 0; i1 < weapons_ingredients.length - 1; ++i1) {
                CraftingManager.addRecipe(new DataItem(weapons_ingredients[i1 + 1][i], 1, 0, null), weapons_pattern[i1], Character.valueOf('#'), ItemList1_6.stick.itemID, Character.valueOf('X'), weapons_ingredients[0][i]);
            }
        }
        CraftingManager.addRecipe(new DataItem(ItemList1_6.bow.itemID, 1, 0, null), " #X", "# X", " #X", Character.valueOf('X'), ItemList1_6.silk.itemID, Character.valueOf('#'), ItemList1_6.stick.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.arrow.itemID, 4, 0, null), "X", "#", "Y", Character.valueOf('Y'), ItemList1_6.feather.itemID, Character.valueOf('X'), ItemList1_6.flint.itemID, Character.valueOf('#'), ItemList1_6.stick.itemID);
        int[][] i2 = ingots_ingredients;
        i1 = i2.length;
        for (int j = 0; j < i1; ++j) {
            int[] ingots_ingredient = i2[j];
            CraftingManager.addRecipe(new DataItem(ingots_ingredient[0], 1, 0, null), "###", "###", "###", Character.valueOf('#'), ingots_ingredient[1]);
            CraftingManager.addRecipe(new DataItem(ingots_ingredient[1], 9, 0, null), "#", Character.valueOf('#'), ingots_ingredient[0]);
        }
        CraftingManager.addRecipe(new DataItem(ItemList1_6.bowlSoup.itemID, 1, 0, null), "Y", "X", "#", Character.valueOf('X'), BlockList1_6.mushroomBrown.blockID, Character.valueOf('Y'), BlockList1_6.mushroomRed.blockID, Character.valueOf('#'), ItemList1_6.bowlEmpty.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.bowlSoup.itemID, 1, 0, null), "Y", "X", "#", Character.valueOf('X'), BlockList1_6.mushroomRed.blockID, Character.valueOf('Y'), BlockList1_6.mushroomBrown.blockID, Character.valueOf('#'), ItemList1_6.bowlEmpty.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.chest.blockID, 1, 0, null), "###", "# #", "###", Character.valueOf('#'), BlockList1_6.planks.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.furnaceIdle.blockID, 1, 0, null), "###", "# #", "###", Character.valueOf('#'), BlockList1_6.cobblestone.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.workbench.blockID, 1, 0, null), "##", "##", Character.valueOf('#'), BlockList1_6.planks.blockID);
        for (int i3 = 0; i3 < armor_ingredients[0].length; ++i3) {
            for (i1 = 0; i1 < armor_ingredients.length - 1; ++i1) {
                CraftingManager.addRecipe(new DataItem(armor_ingredients[i1 + 1][i3], 1, 0, null), armor_pattern[i1], Character.valueOf('X'), armor_ingredients[0][i3]);
            }
        }
        CraftingManager.addRecipe(new DataItem(ItemList1_6.paper.itemID, 3, 0, null), "###", Character.valueOf('#'), ItemList1_6.reed.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.book.itemID, 1, 0, null), "#", "#", "#", Character.valueOf('#'), ItemList1_6.paper.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.fence.blockID, 2, 0, null), "###", "###", Character.valueOf('#'), ItemList1_6.stick.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.jukebox.blockID, 1, 0, null), "###", "#X#", "###", Character.valueOf('#'), BlockList1_6.planks.blockID, Character.valueOf('X'), ItemList1_6.diamond.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.bookShelf.blockID, 1, 0, null), "###", "XXX", "###", Character.valueOf('#'), BlockList1_6.planks.blockID, Character.valueOf('X'), ItemList1_6.book.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.blockSnow.blockID, 1, 0, null), "##", "##", Character.valueOf('#'), ItemList1_6.snowball.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.blockClay.blockID, 1, 0, null), "##", "##", Character.valueOf('#'), ItemList1_6.clay.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.brick.blockID, 1, 0, null), "##", "##", Character.valueOf('#'), ItemList1_6.brick.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.glowStone.blockID, 1, 0, null), "###", "###", "###", Character.valueOf('#'), ItemList1_6.glowstone.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.cloth.blockID, 1, 0, null), "###", "###", "###", Character.valueOf('#'), ItemList1_6.silk.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.tnt.blockID, 1, 0, null), "X#X", "#X#", "X#X", Character.valueOf('X'), ItemList1_6.gunpowder.itemID, Character.valueOf('#'), BlockList1_6.sand.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.stoneSingleSlab.blockID, 3, 0, null), "###", Character.valueOf('#'), BlockList1_6.cobblestone.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.ladder.blockID, 1, 0, null), "# #", "###", "# #", Character.valueOf('#'), ItemList1_6.stick.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.doorWood.itemID, 1, 0, null), "##", "##", "##", Character.valueOf('#'), BlockList1_6.planks.blockID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.doorIron.itemID, 1, 0, null), "##", "##", "##", Character.valueOf('#'), ItemList1_6.ingotIron.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.sign.itemID, 1, 0, null), "###", "###", " X ", Character.valueOf('#'), BlockList1_6.planks.blockID, Character.valueOf('X'), ItemList1_6.stick.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.planks.blockID, 4, 0, null), "#", Character.valueOf('#'), BlockList1_6.wood.blockID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.stick.itemID, 4, 0, null), "#", "#", Character.valueOf('#'), BlockList1_6.planks.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.torchWood.blockID, 4, 0, null), "X", "#", Character.valueOf('X'), ItemList1_6.coal.itemID, Character.valueOf('#'), ItemList1_6.stick.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.bowlEmpty.itemID, 4, 0, null), "# #", " # ", Character.valueOf('#'), BlockList1_6.planks.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.rail.blockID, 16, 0, null), "X X", "X#X", "X X", Character.valueOf('X'), ItemList1_6.ingotIron.itemID, Character.valueOf('#'), ItemList1_6.stick.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.minecartEmpty.itemID, 1, 0, null), "# #", "###", Character.valueOf('#'), ItemList1_6.ingotIron.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.pumpkinLantern.blockID, 1, 0, null), "A", "B", Character.valueOf('A'), BlockList1_6.pumpkin.blockID, Character.valueOf('B'), BlockList1_6.torchWood.blockID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.minecartCrate.itemID, 1, 0, null), "A", "B", Character.valueOf('A'), BlockList1_6.chest.blockID, Character.valueOf('B'), ItemList1_6.minecartEmpty.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.minecartPowered.itemID, 1, 0, null), "A", "B", Character.valueOf('A'), BlockList1_6.furnaceIdle.blockID, Character.valueOf('B'), ItemList1_6.minecartEmpty.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.boat.itemID, 1, 0, null), "# #", "###", Character.valueOf('#'), BlockList1_6.planks.blockID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.bucketEmpty.itemID, 1, 0, null), "# #", " # ", Character.valueOf('#'), ItemList1_6.ingotIron.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.flintAndSteel.itemID, 1, 0, null), "A ", " B", Character.valueOf('A'), ItemList1_6.ingotIron.itemID, Character.valueOf('B'), ItemList1_6.flint.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.bread.itemID, 1, 0, null), "###", Character.valueOf('#'), ItemList1_6.wheat.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.stairsWoodOak.blockID, 4, 0, null), "#  ", "## ", "###", Character.valueOf('#'), BlockList1_6.planks.blockID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.fishingRod.itemID, 1, 0, null), "  #", " #X", "# X", Character.valueOf('#'), ItemList1_6.stick.itemID, Character.valueOf('X'), ItemList1_6.silk.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.stairsCobblestone.blockID, 4, 0, null), "#  ", "## ", "###", Character.valueOf('#'), BlockList1_6.cobblestone.blockID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.painting.itemID, 1, 0, null), "###", "#X#", "###", Character.valueOf('#'), ItemList1_6.stick.itemID, Character.valueOf('X'), BlockList1_6.cloth.blockID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.appleGold.itemID, 1, 0, null), "###", "#X#", "###", Character.valueOf('#'), BlockList1_6.blockGold.blockID, Character.valueOf('X'), ItemList1_6.appleRed.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.lever.blockID, 1, 0, null), "X", "#", Character.valueOf('#'), BlockList1_6.cobblestone.blockID, Character.valueOf('X'), ItemList1_6.stick.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.torchRedstoneActive.blockID, 1, 0, null), "X", "#", Character.valueOf('#'), ItemList1_6.stick.itemID, Character.valueOf('X'), ItemList1_6.redstone.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.pocketSundial.itemID, 1, 0, null), " # ", "#X#", " # ", Character.valueOf('#'), ItemList1_6.ingotGold.itemID, Character.valueOf('X'), ItemList1_6.redstone.itemID);
        CraftingManager.addRecipe(new DataItem(ItemList1_6.compass.itemID, 1, 0, null), " # ", "#X#", " # ", Character.valueOf('#'), ItemList1_6.ingotIron.itemID, Character.valueOf('X'), ItemList1_6.redstone.itemID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.stoneButton.blockID, 1, 0, null), "#", "#", Character.valueOf('#'), BlockList1_6.stone.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.pressurePlateStone.blockID, 1, 0, null), "###", Character.valueOf('#'), BlockList1_6.stone.blockID);
        CraftingManager.addRecipe(new DataItem(BlockList1_6.pressurePlatePlanks.blockID, 1, 0, null), "###", Character.valueOf('#'), BlockList1_6.planks.blockID);
        recipes.sort((o1, o2) -> Integer.compare(o2.getRecipeSize(), o1.getRecipeSize()));
    }
}

