/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import java.util.Arrays;
import net.raphimc.vialegacy.api.data.BlockList1_6;
import net.raphimc.vialegacy.api.data.ItemList1_6;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.util.BlockFaceUtil;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.Protocolb1_0_1_1_1toa1_2_3_5_1_2_6;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.data.AlphaItems;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.data.CraftingManager;
import net.raphimc.vialegacy.protocols.alpha.protocolb1_0_1_1_1toa1_2_3_5_1_2_6.storage.InventoryStorage;
import net.raphimc.vialegacy.protocols.beta.protocolb1_2_0_2tob1_1_2.ClientboundPacketsb1_1;
import net.raphimc.vialegacy.protocols.beta.protocolb1_2_0_2tob1_1_2.types.Typesb1_1;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.Protocolc0_30toc0_30cpe;
import net.raphimc.vialegacy.protocols.release.protocol1_4_4_5to1_4_2.types.Types1_4_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ChunkTracker;

public class AlphaInventoryTracker
extends StoredObject {
    private boolean creativeMode;
    private Item[] mainInventory = null;
    private Item[] craftingInventory = null;
    private Item[] armorInventory = null;
    private Item[] openContainerItems = null;
    private Item cursorItem = null;
    private int openWindowType = -1;
    final InventoryStorage inventoryStorage;

    public AlphaInventoryTracker(UserConnection user) {
        super(user);
        this.inventoryStorage = user.get(InventoryStorage.class);
        this.onRespawn();
    }

    public void onWindowOpen(int windowType, int containerSlots) {
        this.openWindowType = windowType;
        this.openContainerItems = new Item[containerSlots];
    }

    public void onWindowClose() throws Exception {
        Item item;
        int i;
        if (this.openWindowType == 1) {
            for (i = 1; i <= 9; ++i) {
                item = this.openContainerItems[i];
                if (item == null) continue;
                Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.dropItem(this.getUser(), item, false);
                this.openContainerItems[i] = null;
            }
        }
        for (i = 0; i < 4; ++i) {
            item = this.craftingInventory[i];
            if (item == null) continue;
            Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.dropItem(this.getUser(), item, false);
            this.craftingInventory[i] = null;
        }
        if (this.cursorItem != null) {
            Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.dropItem(this.getUser(), this.cursorItem, false);
            this.cursorItem = null;
        }
        this.openWindowType = -1;
        this.updatePlayerInventory();
        this.updateCursorItem();
    }

    public void onWindowClick(byte windowId, short slot, byte button, short action, Item item) throws Exception {
        boolean leftClick;
        boolean bl = leftClick = button != 1;
        if (slot == -999) {
            if (this.cursorItem != null) {
                if (leftClick) {
                    Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.dropItem(this.getUser(), this.cursorItem, false);
                    this.cursorItem = null;
                } else {
                    Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.dropItem(this.getUser(), this.splitStack(this.cursorItem, 1), false);
                }
            }
        } else {
            Item[] slots = null;
            boolean slotTakesItems = true;
            int slotStackLimit = 64;
            boolean isCraftingResultSlot = false;
            switch (windowId) {
                case 0: {
                    slots = new Item[45];
                    System.arraycopy(this.mainInventory, 0, slots, 36, 9);
                    System.arraycopy(this.mainInventory, 9, slots, 9, 27);
                    System.arraycopy(this.craftingInventory, 0, slots, 1, 4);
                    System.arraycopy(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.reverseArray(this.armorInventory), 0, slots, 5, 4);
                    isCraftingResultSlot = slot == 0;
                    slotTakesItems = !isCraftingResultSlot;
                    int n = slotStackLimit = slot >= 5 && slot <= 8 ? 1 : 64;
                    if (!isCraftingResultSlot) break;
                    slots[0] = CraftingManager.getResult(this.craftingInventory);
                    break;
                }
                case 33: {
                    slots = new Item[46];
                    System.arraycopy(this.openContainerItems, 0, slots, 0, 10);
                    System.arraycopy(this.mainInventory, 0, slots, 37, 9);
                    System.arraycopy(this.mainInventory, 9, slots, 10, 27);
                    isCraftingResultSlot = slot == 0;
                    boolean bl2 = slotTakesItems = !isCraftingResultSlot;
                    if (!isCraftingResultSlot) break;
                    Item[] craftingGrid = Arrays.copyOfRange(this.openContainerItems, 1, 10);
                    slots[0] = CraftingManager.getResult(craftingGrid);
                    break;
                }
                case 44: {
                    slots = new Item[39];
                    System.arraycopy(this.openContainerItems, 0, slots, 0, 3);
                    System.arraycopy(this.mainInventory, 0, slots, 30, 9);
                    System.arraycopy(this.mainInventory, 9, slots, 3, 27);
                    break;
                }
                case 55: {
                    slots = new Item[63];
                    System.arraycopy(this.openContainerItems, 0, slots, 0, 27);
                    System.arraycopy(this.mainInventory, 0, slots, 54, 9);
                    System.arraycopy(this.mainInventory, 9, slots, 27, 27);
                }
            }
            if (slots != null) {
                int amount;
                Item itm = slots[slot];
                if (itm == null) {
                    if (this.cursorItem != null && slotTakesItems) {
                        int n = amount = leftClick ? this.cursorItem.amount() : 1;
                        if (amount > slotStackLimit) {
                            amount = slotStackLimit;
                        }
                        slots[slot] = this.splitStack(this.cursorItem, amount);
                    }
                } else if (this.cursorItem == null) {
                    int n = amount = leftClick ? itm.amount() : (itm.amount() + 1) / 2;
                    if (isCraftingResultSlot) {
                        amount = itm.amount();
                    }
                    this.cursorItem = this.splitStack(itm, amount);
                    if (isCraftingResultSlot) {
                        this.onCraftingResultPickup(windowId, slots);
                    }
                } else if (slotTakesItems) {
                    if (itm.identifier() != this.cursorItem.identifier()) {
                        if (this.cursorItem.amount() <= slotStackLimit) {
                            slots[slot] = this.cursorItem;
                            this.cursorItem = itm;
                        }
                    } else {
                        int n = amount = leftClick ? this.cursorItem.amount() : 1;
                        if (amount > slotStackLimit - itm.amount()) {
                            amount = slotStackLimit - itm.amount();
                        }
                        if (amount > AlphaItems.getMaxStackSize(this.cursorItem.identifier()) - itm.amount()) {
                            amount = AlphaItems.getMaxStackSize(this.cursorItem.identifier()) - itm.amount();
                        }
                        this.cursorItem.setAmount(this.cursorItem.amount() - amount);
                        itm.setAmount(itm.amount() + amount);
                    }
                } else if (itm.identifier() == this.cursorItem.identifier() && AlphaItems.getMaxStackSize(this.cursorItem.identifier()) > 1 && (amount = itm.amount()) > 0 && amount + this.cursorItem.amount() <= AlphaItems.getMaxStackSize(this.cursorItem.identifier())) {
                    itm.setAmount(itm.amount() - amount);
                    this.cursorItem.setAmount(this.cursorItem.amount() + amount);
                    if (isCraftingResultSlot) {
                        this.onCraftingResultPickup(windowId, slots);
                    }
                }
                for (int i = 0; i < slots.length; ++i) {
                    Item slotItem = slots[i];
                    if (slotItem == null || slotItem.amount() != 0) continue;
                    slots[i] = null;
                }
                switch (windowId) {
                    case 0: {
                        System.arraycopy(slots, 36, this.mainInventory, 0, 9);
                        System.arraycopy(slots, 9, this.mainInventory, 9, 27);
                        System.arraycopy(slots, 1, this.craftingInventory, 0, 4);
                        System.arraycopy(slots, 5, this.armorInventory, 0, 4);
                        this.armorInventory = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.reverseArray(this.armorInventory);
                        break;
                    }
                    case 33: {
                        System.arraycopy(slots, 0, this.openContainerItems, 0, 10);
                        System.arraycopy(slots, 37, this.mainInventory, 0, 9);
                        System.arraycopy(slots, 10, this.mainInventory, 9, 27);
                        break;
                    }
                    case 44: {
                        System.arraycopy(slots, 0, this.openContainerItems, 0, 3);
                        System.arraycopy(slots, 30, this.mainInventory, 0, 9);
                        System.arraycopy(slots, 3, this.mainInventory, 9, 27);
                        break;
                    }
                    case 55: {
                        System.arraycopy(slots, 0, this.openContainerItems, 0, 27);
                        System.arraycopy(slots, 54, this.mainInventory, 0, 9);
                        System.arraycopy(slots, 27, this.mainInventory, 9, 27);
                    }
                }
                this.updateInventory(windowId, slots);
                boolean updateCraftResultSlot = false;
                switch (windowId) {
                    case 0: {
                        boolean bl3 = updateCraftResultSlot = !this.isEmpty(this.craftingInventory);
                        if (!updateCraftResultSlot) break;
                        slots[0] = CraftingManager.getResult(this.craftingInventory);
                        break;
                    }
                    case 33: {
                        Item[] craftingGrid = Arrays.copyOfRange(this.openContainerItems, 1, 10);
                        boolean bl4 = updateCraftResultSlot = !this.isEmpty(craftingGrid);
                        if (!updateCraftResultSlot) break;
                        slots[0] = CraftingManager.getResult(craftingGrid);
                    }
                }
                if (updateCraftResultSlot) {
                    this.updateInventorySlot(windowId, (short)0, slots[0]);
                }
            } else {
                this.updatePlayerInventory();
            }
        }
        if (this.cursorItem != null && this.cursorItem.amount() == 0) {
            this.cursorItem = null;
        }
        this.updateCursorItem();
    }

    public void onBlockPlace(Position position, short direction) {
        if (this.creativeMode) {
            return;
        }
        Item handItem = this.mainInventory[this.inventoryStorage.selectedHotbarSlot];
        if (handItem == null) {
            return;
        }
        if (direction == 255) {
            AlphaItems.doInteract(handItem);
        } else {
            IdAndData placedAgainst = this.getUser().get(ChunkTracker.class).getBlockNotNull(position);
            IdAndData targetBlock = this.getUser().get(ChunkTracker.class).getBlockNotNull(position.getRelative(BlockFaceUtil.getFace(direction)));
            AlphaItems.doPlace(handItem, direction, placedAgainst);
            if (handItem.identifier() < 256 || handItem.identifier() == ItemList1_6.reed.itemID) {
                if (targetBlock.id == 0 || targetBlock.id == BlockList1_6.waterStill.blockID || targetBlock.id == BlockList1_6.waterMoving.blockID || targetBlock.id == BlockList1_6.lavaStill.blockID || targetBlock.id == BlockList1_6.lavaMoving.blockID || targetBlock.id == BlockList1_6.fire.blockID || targetBlock.id == BlockList1_6.snow.blockID) {
                    handItem.setAmount(handItem.amount() - 1);
                }
            } else if (handItem.identifier() == ItemList1_6.sign.itemID) {
                if (direction != 0 && targetBlock.id == 0) {
                    handItem.setAmount(handItem.amount() - 1);
                }
            } else if (handItem.identifier() == ItemList1_6.redstone.itemID && targetBlock.id == 0) {
                handItem.setAmount(handItem.amount() - 1);
            }
        }
        if (handItem.amount() == 0) {
            this.mainInventory[this.inventoryStorage.selectedHotbarSlot] = null;
        }
        this.updatePlayerInventorySlot(this.inventoryStorage.selectedHotbarSlot);
    }

    public void onHandItemDrop() {
        Item handItem = this.mainInventory[this.inventoryStorage.selectedHotbarSlot];
        if (handItem == null) {
            return;
        }
        handItem.setAmount(handItem.amount() - 1);
        if (handItem.amount() == 0) {
            this.mainInventory[this.inventoryStorage.selectedHotbarSlot] = null;
        }
        this.updatePlayerInventorySlot(this.inventoryStorage.selectedHotbarSlot);
    }

    public void onRespawn() {
        this.mainInventory = new Item[37];
        this.craftingInventory = new Item[4];
        this.armorInventory = new Item[4];
        this.openContainerItems = new Item[0];
        this.cursorItem = null;
        this.openWindowType = -1;
    }

    public void addItem(Item item) {
        int i;
        int slot;
        if (item == null) {
            return;
        }
        if (item.amount() == 0) {
            return;
        }
        if (item.data() == 0) {
            slot = -1;
            for (i = 0; i < this.mainInventory.length; ++i) {
                if (this.mainInventory[i] == null || this.mainInventory[i].identifier() != item.identifier() || this.mainInventory[i].amount() >= AlphaItems.getMaxStackSize(this.mainInventory[i].identifier())) continue;
                slot = i;
                break;
            }
            if (slot != -1) {
                int amount = item.amount();
                if (amount > AlphaItems.getMaxStackSize(this.mainInventory[slot].identifier()) - this.mainInventory[slot].amount()) {
                    amount = AlphaItems.getMaxStackSize(this.mainInventory[slot].identifier()) - this.mainInventory[slot].amount();
                }
                item.setAmount(item.amount() - amount);
                this.mainInventory[slot].setAmount(this.mainInventory[slot].amount() + amount);
                this.updatePlayerInventorySlot((short)slot);
            }
        }
        if (item.amount() != 0) {
            slot = -1;
            for (i = 0; i < this.mainInventory.length; ++i) {
                if (this.mainInventory[i] != null) continue;
                slot = i;
                break;
            }
            if (slot != -1) {
                this.mainInventory[slot] = item;
                this.updatePlayerInventorySlot((short)slot);
            }
        }
    }

    public void handleCreativeSetSlot(short slot, Item item) throws Exception {
        if (!this.getUser().getProtocolInfo().getPipeline().contains(Protocolc0_30toc0_30cpe.class)) {
            item = Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.fixItem(item);
        }
        if (slot <= 0) {
            return;
        }
        if (slot <= 4) {
            slot = (short)(slot - 1);
            this.craftingInventory[slot] = item;
        } else if (slot <= 8) {
            slot = (short)(slot - 5);
            slot = (short)(3 - slot);
            this.armorInventory[slot] = item;
        } else if (slot <= 44) {
            if (slot >= 36) {
                slot = (short)(slot - 36);
            }
            this.mainInventory[slot] = item;
        }
    }

    public void setCreativeMode(boolean creativeMode) {
        this.creativeMode = creativeMode;
    }

    public void setMainInventory(Item[] items) {
        this.mainInventory = items;
    }

    public void setCraftingInventory(Item[] items) {
        this.craftingInventory = items;
    }

    public void setArmorInventory(Item[] items) {
        this.armorInventory = items;
    }

    public void setOpenContainerItems(Item[] items) {
        this.openContainerItems = items;
    }

    public Item[] getMainInventory() {
        return this.mainInventory;
    }

    public Item[] getCraftingInventory() {
        return this.craftingInventory;
    }

    public Item[] getArmorInventory() {
        return this.armorInventory;
    }

    public Item[] getOpenContainerItems() {
        return this.openContainerItems;
    }

    public Item getCursorItem() {
        return this.cursorItem;
    }

    private void updatePlayerInventorySlot(short slot) {
        this.updateInventorySlot((byte)0, slot >= 0 && slot < 9 ? (short)(slot + 36) : slot, this.mainInventory[slot]);
    }

    private void updateCursorItem() {
        this.updateInventorySlot((byte)-1, (short)0, this.cursorItem);
    }

    private void updateInventorySlot(byte windowId, short slot, Item item) {
        try {
            PacketWrapper setSlot = PacketWrapper.create(ClientboundPacketsb1_1.SET_SLOT, this.getUser());
            setSlot.write(Type.BYTE, windowId);
            setSlot.write(Type.SHORT, slot);
            setSlot.write(Typesb1_1.NBTLESS_ITEM, Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItem(item));
            setSlot.send(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void updatePlayerInventory() {
        Item[] items = new Item[45];
        System.arraycopy(this.mainInventory, 0, items, 36, 9);
        System.arraycopy(this.mainInventory, 9, items, 9, 27);
        System.arraycopy(this.craftingInventory, 0, items, 1, 4);
        System.arraycopy(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.reverseArray(this.armorInventory), 0, items, 5, 4);
        this.updateInventory((byte)0, items);
    }

    private void updateInventory(byte windowId, Item[] items) {
        try {
            PacketWrapper windowItems = PacketWrapper.create(ClientboundPacketsb1_1.WINDOW_ITEMS, this.getUser());
            windowItems.write(Type.BYTE, windowId);
            windowItems.write(Types1_4_2.NBTLESS_ITEM_ARRAY, Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.copyItems(items));
            windowItems.send(Protocolb1_0_1_1_1toa1_2_3_5_1_2_6.class);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private Item splitStack(Item item, int size) {
        item.setAmount(item.amount() - size);
        DataItem newItem = new DataItem(item);
        newItem.setAmount(size);
        return newItem;
    }

    private void onCraftingResultPickup(byte windowId, Item[] slots) {
        for (int i = 1; i < 1 + (windowId == 0 ? 4 : 9); ++i) {
            Item item = slots[i];
            if (item == null) continue;
            item.setAmount(item.amount() - 1);
        }
    }

    private boolean isEmpty(Item[] items) {
        for (Item item : items) {
            if (item == null || item.amount() == 0) continue;
            return false;
        }
        return true;
    }
}

