/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.beta.protocolb1_6_0_6tob1_5_0_2;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import net.raphimc.vialegacy.api.data.BlockList1_6;
import net.raphimc.vialegacy.api.data.ItemList1_6;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.beta.protocolb1_6_0_6tob1_5_0_2.ClientboundPacketsb1_5;
import net.raphimc.vialegacy.protocols.beta.protocolb1_6_0_6tob1_5_0_2.ServerboundPacketsb1_5;
import net.raphimc.vialegacy.protocols.beta.protocolb1_6_0_6tob1_5_0_2.storage.WorldTimeStorage;
import net.raphimc.vialegacy.protocols.beta.protocolb1_6_0_6tob1_5_0_2.task.TimeTrackTask;
import net.raphimc.vialegacy.protocols.beta.protocolb1_8_0_1tob1_7_0_3.ClientboundPacketsb1_7;
import net.raphimc.vialegacy.protocols.beta.protocolb1_8_0_1tob1_7_0_3.ServerboundPacketsb1_7;
import net.raphimc.vialegacy.protocols.release.protocol1_4_4_5to1_4_2.types.Types1_4_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ChunkTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.PlayerInfoStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocolb1_6_0_6tob1_5_0_2
extends AbstractProtocol<ClientboundPacketsb1_5, ClientboundPacketsb1_7, ServerboundPacketsb1_5, ServerboundPacketsb1_7> {
    public Protocolb1_6_0_6tob1_5_0_2() {
        super(ClientboundPacketsb1_5.class, ClientboundPacketsb1_7.class, ServerboundPacketsb1_5.class, ServerboundPacketsb1_7.class);
    }

    @Override
    protected void registerPackets() {
        this.registerClientbound(ClientboundPacketsb1_5.TIME_UPDATE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.LONG);
                this.handler(wrapper -> {
                    wrapper.user().get(WorldTimeStorage.class).time = wrapper.get(Type.LONG, 0);
                });
            }
        });
        this.registerClientbound(ClientboundPacketsb1_5.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.create(Type.BYTE, (byte)0);
            }
        });
        this.registerClientbound(ClientboundPacketsb1_5.SPAWN_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.create(Type.INT, 0);
            }
        });
        this.registerServerbound(ServerboundPacketsb1_7.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.read(Type.BYTE);
            }
        });
        this.registerServerbound(ServerboundPacketsb1_7.PLAYER_BLOCK_PLACEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Types1_4_2.NBTLESS_ITEM);
                this.handler(wrapper -> {
                    PlayerInfoStorage playerInfoStorage = wrapper.user().get(PlayerInfoStorage.class);
                    Position pos = wrapper.get(Types1_7_6.POSITION_UBYTE, 0);
                    IdAndData block = wrapper.user().get(ChunkTracker.class).getBlockNotNull(pos);
                    Item item = wrapper.get(Types1_4_2.NBTLESS_ITEM, 0);
                    if (block.id == BlockList1_6.bed.blockID) {
                        boolean isDayTime;
                        boolean isOccupied;
                        boolean isFoot;
                        byte[][] headBlockToFootBlock = new byte[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
                        boolean bl = isFoot = (block.data & 8) != 0;
                        if (!isFoot) {
                            int bedDirection = block.data & 3;
                            pos = new Position(pos.x() + headBlockToFootBlock[bedDirection][0], pos.y(), pos.z() + headBlockToFootBlock[bedDirection][1]);
                            block = wrapper.user().get(ChunkTracker.class).getBlockNotNull(pos);
                            if (block.id != BlockList1_6.bed.blockID) {
                                return;
                            }
                        }
                        boolean bl2 = isOccupied = (block.data & 4) != 0;
                        if (isOccupied) {
                            PacketWrapper chat = PacketWrapper.create(ClientboundPacketsb1_7.CHAT_MESSAGE, wrapper.user());
                            chat.write(Types1_6_4.STRING, "This bed is occupied");
                            chat.send(Protocolb1_6_0_6tob1_5_0_2.class);
                            return;
                        }
                        int dayTime = (int)(wrapper.user().get(WorldTimeStorage.class).time % 24000L);
                        float dayPercent = ((float)dayTime + 1.0f) / 24000.0f - 0.25f;
                        if (dayPercent < 0.0f) {
                            dayPercent += 1.0f;
                        }
                        if (dayPercent > 1.0f) {
                            dayPercent -= 1.0f;
                        }
                        float tempDayPercent = dayPercent;
                        dayPercent = 1.0f - (float)((Math.cos((double)dayPercent * Math.PI) + 1.0) / 2.0);
                        float skyRotation = (float)(1.0 - (Math.cos((double)(dayPercent = tempDayPercent + (dayPercent - tempDayPercent) / 3.0f) * Math.PI * 2.0) * 2.0 + 0.5));
                        if (skyRotation < 0.0f) {
                            skyRotation = 0.0f;
                        }
                        if (skyRotation > 1.0f) {
                            skyRotation = 1.0f;
                        }
                        boolean bl3 = isDayTime = (int)(skyRotation * 11.0f) < 4;
                        if (isDayTime) {
                            PacketWrapper chat = PacketWrapper.create(ClientboundPacketsb1_7.CHAT_MESSAGE, wrapper.user());
                            chat.write(Types1_6_4.STRING, "You can only sleep at night");
                            chat.send(Protocolb1_6_0_6tob1_5_0_2.class);
                            return;
                        }
                        if (Math.abs(playerInfoStorage.posX - (double)pos.x()) > 3.0 || Math.abs(playerInfoStorage.posY - (double)pos.y()) > 2.0 || Math.abs(playerInfoStorage.posZ - (double)pos.z()) > 3.0) {
                            return;
                        }
                        PacketWrapper useBed = PacketWrapper.create(ClientboundPacketsb1_7.USE_BED, wrapper.user());
                        useBed.write(Type.INT, playerInfoStorage.entityId);
                        useBed.write(Type.BYTE, (byte)0);
                        useBed.write(Types1_7_6.POSITION_BYTE, pos);
                        useBed.send(Protocolb1_6_0_6tob1_5_0_2.class);
                    } else if (block.id == BlockList1_6.jukebox.blockID) {
                        if (block.data > 0) {
                            PacketWrapper effect = PacketWrapper.create(ClientboundPacketsb1_7.EFFECT, wrapper.user());
                            effect.write(Type.INT, 1005);
                            effect.write(Types1_7_6.POSITION_UBYTE, pos);
                            effect.write(Type.INT, 0);
                            effect.send(Protocolb1_6_0_6tob1_5_0_2.class);
                        } else if (item != null && (item.identifier() == ItemList1_6.record13.itemID || item.identifier() == ItemList1_6.recordCat.itemID)) {
                            PacketWrapper effect = PacketWrapper.create(ClientboundPacketsb1_7.EFFECT, wrapper.user());
                            effect.write(Type.INT, 1005);
                            effect.write(Types1_7_6.POSITION_UBYTE, pos);
                            effect.write(Type.INT, item.identifier());
                            effect.send(Protocolb1_6_0_6tob1_5_0_2.class);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void register(ViaProviders providers) {
        Via.getPlatform().runRepeatingSync(new TimeTrackTask(), 1L);
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocolb1_6_0_6tob1_5_0_2.class, ClientboundPacketsb1_5::getPacket));
        userConnection.put(new WorldTimeStorage(userConnection));
    }
}

