/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionImpl;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import com.viaversion.viaversion.util.MathUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.model.ChunkCoord;
import net.raphimc.vialegacy.api.util.ChunkCoordSpiral;
import net.raphimc.vialegacy.protocols.alpha.protocola1_0_16_2toa1_0_15.ClientboundPacketsa1_0_15;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.Protocola1_0_15toc0_30;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.model.ClassicLevel;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.providers.ClassicWorldHeightProvider;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage.ClassicBlockRemapper;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage.ClassicPositionTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.chunks.NibbleArray1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.types.Chunk1_1Type;

public class ClassicLevelStorage
extends StoredObject {
    private ByteArrayOutputStream netBuffer = new ByteArrayOutputStream(262144);
    private ClassicLevel classicLevel;
    private int chunkXCount;
    private int sectionYCount;
    private int chunkZCount;
    private int subChunkXLength;
    private int subChunkYLength;
    private int subChunkZLength;
    private int sectionBitmask;
    private int chunksPerTick = ViaLegacy.getConfig().getChunksPerTick();
    private final Set<ChunkCoord> loadedChunks = new HashSet<ChunkCoord>();
    private long lastPosPacket;

    public ClassicLevelStorage(UserConnection user) {
        super(user);
    }

    public void addDataPart(byte[] part, int partSize) {
        if (this.netBuffer == null) {
            throw new IllegalStateException("Level is already fully loaded");
        }
        this.netBuffer.write(part, 0, partSize);
    }

    public void finish(int sizeX, int sizeY, int sizeZ) {
        try {
            DataInputStream dis = new DataInputStream(new GZIPInputStream((InputStream)new ByteArrayInputStream(this.netBuffer.toByteArray()), 65536));
            byte[] blocks = new byte[dis.readInt()];
            dis.readFully(blocks);
            dis.close();
            this.netBuffer = null;
            this.classicLevel = new ClassicLevel(sizeX, sizeY, sizeZ, blocks);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to load level", e);
        }
        short maxChunkSectionCount = Via.getManager().getProviders().get(ClassicWorldHeightProvider.class).getMaxChunkSectionCount(this.getUser());
        this.chunkXCount = sizeX >> 4;
        if (sizeX % 16 != 0) {
            ++this.chunkXCount;
        }
        this.sectionYCount = sizeY >> 4;
        if (sizeY % 16 != 0) {
            ++this.sectionYCount;
        }
        if (this.sectionYCount > maxChunkSectionCount) {
            this.sectionYCount = maxChunkSectionCount;
        }
        this.chunkZCount = sizeZ >> 4;
        if (sizeZ % 16 != 0) {
            ++this.chunkZCount;
        }
        this.subChunkXLength = Math.min(16, sizeX);
        this.subChunkYLength = Math.min(16, sizeY);
        this.subChunkZLength = Math.min(16, sizeZ);
        this.sectionBitmask = 0;
        for (int i = 0; i < this.sectionYCount; ++i) {
            this.sectionBitmask = this.sectionBitmask << 1 | 1;
        }
        if (this.chunksPerTick <= 0) {
            this.chunksPerTick = MathUtil.clamp(32 / this.sectionYCount, 1, 8);
        }
    }

    public void tickChunks(ChunkCoord center) throws Exception {
        if (!this.getUser().get(ClassicPositionTracker.class).spawned) {
            return;
        }
        if (System.currentTimeMillis() - this.lastPosPacket < 50L) {
            return;
        }
        this.lastPosPacket = System.currentTimeMillis();
        this.sendChunks(center, ViaLegacy.getConfig().getClassicChunkRange(), this.chunksPerTick);
    }

    public void sendChunks(ChunkCoord center, int radius) throws Exception {
        this.sendChunks(center, radius, Integer.MAX_VALUE);
    }

    public void sendChunks(ChunkCoord center, int radius, int limit) throws Exception {
        ChunkCoordSpiral spiral = new ChunkCoordSpiral(center, new ChunkCoord(radius, radius));
        for (ChunkCoord coord : spiral) {
            if (!this.shouldSend(coord)) continue;
            if (limit-- <= 0) {
                return;
            }
            this.sendChunk(coord);
        }
    }

    public void sendChunk(ChunkCoord coord) throws Exception {
        if (!this.shouldSend(coord)) {
            return;
        }
        ClassicBlockRemapper remapper = this.getUser().get(ClassicBlockRemapper.class);
        this.classicLevel.calculateLight(coord.chunkX * 16, coord.chunkZ * 16, this.subChunkXLength, this.subChunkZLength);
        ChunkSection[] modernSections = new ChunkSection[Math.max(8, this.sectionYCount)];
        for (int sectionY = 0; sectionY < this.sectionYCount; ++sectionY) {
            modernSections[sectionY] = new ChunkSectionImpl(true);
            ChunkSectionImpl section = modernSections[sectionY];
            section.palette(PaletteType.BLOCKS).addId(0);
            NibbleArray1_1 skyLight = new NibbleArray1_1(4096, 4);
            for (int y = 0; y < this.subChunkYLength; ++y) {
                int totalY = y + sectionY * 16;
                for (int x = 0; x < this.subChunkXLength; ++x) {
                    int totalX = x + coord.chunkX * 16;
                    for (int z = 0; z < this.subChunkZLength; ++z) {
                        int totalZ = z + coord.chunkZ * 16;
                        section.palette(PaletteType.BLOCKS).setIdAt(x, y, z, remapper.getMapper().get(this.classicLevel.getBlock(totalX, totalY, totalZ)).toCompressedData());
                        skyLight.set(x, y, z, this.classicLevel.isLit(totalX, totalY, totalZ) ? 15 : 9);
                    }
                }
            }
            section.getLight().setSkyLight(skyLight.getHandle());
        }
        this.loadedChunks.add(coord);
        BaseChunk viaChunk = new BaseChunk(coord.chunkX, coord.chunkZ, true, false, this.sectionBitmask, modernSections, new int[256], new ArrayList<CompoundTag>());
        PacketWrapper chunkData = PacketWrapper.create(ClientboundPacketsa1_0_15.CHUNK_DATA, this.getUser());
        chunkData.write(new Chunk1_1Type(this.getUser().get(ClientWorld.class)), viaChunk);
        chunkData.send(Protocola1_0_15toc0_30.class);
    }

    private boolean shouldSend(ChunkCoord coord) {
        if (!this.hasReceivedLevel()) {
            return false;
        }
        boolean isInBounds = coord.chunkX >= 0 && coord.chunkX < this.chunkXCount && coord.chunkZ >= 0 && coord.chunkZ < this.chunkZCount;
        return isInBounds && !this.isChunkLoaded(coord);
    }

    public boolean isChunkLoaded(ChunkCoord coord) {
        return this.loadedChunks.contains(coord);
    }

    public boolean isChunkLoaded(Position position) {
        return this.isChunkLoaded(new ChunkCoord(position.x() >> 4, position.z() >> 4));
    }

    public boolean hasReceivedLevel() {
        return this.classicLevel != null;
    }

    public ClassicLevel getClassicLevel() {
        return this.classicLevel;
    }
}

