/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import net.raphimc.vialegacy.api.model.ChunkCoord;

public class ClassicPositionTracker
extends StoredObject {
    public double posX;
    public double stance;
    public double posZ;
    public float yaw;
    public float pitch;
    public boolean spawned;

    public ClassicPositionTracker(UserConnection user) {
        super(user);
    }

    public void writeToPacket(PacketWrapper wrapper) {
        int x = (int)(this.posX * 32.0);
        int y = (int)(this.stance * 32.0);
        int z = (int)(this.posZ * 32.0);
        int yaw = (int)(this.yaw * 256.0f / 360.0f) & 0xFF;
        int pitch = (int)(this.pitch * 256.0f / 360.0f) & 0xFF;
        wrapper.write(Type.BYTE, (byte)-1);
        wrapper.write(Type.SHORT, (short)x);
        wrapper.write(Type.SHORT, (short)y);
        wrapper.write(Type.SHORT, (short)z);
        wrapper.write(Type.BYTE, (byte)(yaw - 128));
        wrapper.write(Type.BYTE, (byte)pitch);
    }

    public Position getBlockPosition() {
        return new Position(ClassicPositionTracker.floor(this.posX), ClassicPositionTracker.floor(this.stance), ClassicPositionTracker.floor(this.posZ));
    }

    public ChunkCoord getChunkPosition() {
        Position pos = this.getBlockPosition();
        return new ChunkCoord(pos.x() >> 4, pos.z() >> 4);
    }

    private static int floor(double f) {
        int i = (int)f;
        return f < (double)i ? i - 1 : i;
    }
}

