/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord1_8;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.CustomByteType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.data.BlockList1_6;
import net.raphimc.vialegacy.api.model.ChunkCoord;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.alpha.protocola1_0_16_2toa1_0_15.ClientboundPacketsa1_0_15;
import net.raphimc.vialegacy.protocols.alpha.protocola1_0_16_2toa1_0_15.Protocola1_0_16_2toa1_0_15;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.ClientboundPacketsc0_28;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.ServerboundPacketsc0_28;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.data.ClassicBlocks;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.model.ClassicLevel;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage.ClassicBlockRemapper;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage.ClassicLevelStorage;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage.ClassicOpLevelStorage;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.storage.ClassicProgressStorage;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.types.Typesc0_30;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.ClientboundPacketsc0_30cpe;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.ServerboundPacketsc0_30cpe;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.data.ClassicProtocolExtension;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.data.ExtendedClassicBlocks;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.storage.ExtBlockPermissionsStorage;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.storage.ExtensionProtocolMetadataStorage;
import net.raphimc.vialegacy.protocols.classic.protocolc0_28_30toc0_28_30cpe.task.ClassicPingTask;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.types.Types1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_6_2to1_6_1.Protocol1_6_2to1_6_1;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.ClientboundPackets1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;

public class Protocolc0_30toc0_30cpe
extends AbstractProtocol<ClientboundPacketsc0_30cpe, ClientboundPacketsc0_28, ServerboundPacketsc0_30cpe, ServerboundPacketsc0_28> {
    public Protocolc0_30toc0_30cpe() {
        super(ClientboundPacketsc0_30cpe.class, ClientboundPacketsc0_28.class, ServerboundPacketsc0_30cpe.class, ServerboundPacketsc0_28.class);
    }

    @Override
    protected void registerPackets() {
        this.registerClientbound(ClientboundPacketsc0_30cpe.JOIN_GAME, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    if (wrapper.user().getProtocolInfo().getPipeline().contains(Protocol1_6_2to1_6_1.class)) {
                        ExtensionProtocolMetadataStorage protocolMetadataStorage = wrapper.user().get(ExtensionProtocolMetadataStorage.class);
                        PacketWrapper brand = PacketWrapper.create(ClientboundPackets1_6_4.PLUGIN_MESSAGE, wrapper.user());
                        brand.write(Types1_6_4.STRING, "MC|Brand");
                        byte[] brandBytes = protocolMetadataStorage.getServerSoftwareName().getBytes(StandardCharsets.UTF_8);
                        brand.write(Type.SHORT, (short)brandBytes.length);
                        brand.write(Type.REMAINING_BYTES, brandBytes);
                        wrapper.send(Protocolc0_30toc0_30cpe.class);
                        brand.send(Protocol1_6_2to1_6_1.class);
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPacketsc0_30cpe.EXTENSION_PROTOCOL_INFO, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    ExtensionProtocolMetadataStorage protocolMetadataStorage = wrapper.user().get(ExtensionProtocolMetadataStorage.class);
                    protocolMetadataStorage.setServerSoftwareName(wrapper.read(Typesc0_30.STRING));
                    protocolMetadataStorage.setExtensionCount(wrapper.read(Type.SHORT));
                    ClassicProgressStorage classicProgressStorage = wrapper.user().get(ClassicProgressStorage.class);
                    classicProgressStorage.progress = 0;
                    classicProgressStorage.upperBound = protocolMetadataStorage.getExtensionCount();
                    classicProgressStorage.status = "Receiving extension list...";
                });
            }
        });
        this.registerClientbound(ClientboundPacketsc0_30cpe.EXTENSION_PROTOCOL_ENTRY, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    ExtensionProtocolMetadataStorage protocolMetadataStorage = wrapper.user().get(ExtensionProtocolMetadataStorage.class);
                    String extensionName = wrapper.read(Typesc0_30.STRING);
                    int extensionVersion = wrapper.read(Type.INT);
                    ClassicProtocolExtension extension = ClassicProtocolExtension.byName(extensionName);
                    if (extension != null) {
                        protocolMetadataStorage.addServerExtension(extension, extensionVersion);
                    } else {
                        ViaLegacy.getPlatform().getLogger().warning("Received unknown classic protocol extension: (" + extensionName + " v" + extensionVersion + ")");
                    }
                    protocolMetadataStorage.incrementReceivedExtensions();
                    ClassicProgressStorage classicProgressStorage = wrapper.user().get(ClassicProgressStorage.class);
                    classicProgressStorage.progress = protocolMetadataStorage.getReceivedExtensions();
                    if (protocolMetadataStorage.getReceivedExtensions() >= protocolMetadataStorage.getExtensionCount()) {
                        classicProgressStorage.status = "Sending extension list...";
                        ArrayList<ClassicProtocolExtension> supportedExtensions = new ArrayList<ClassicProtocolExtension>();
                        for (ClassicProtocolExtension protocolExtension : ClassicProtocolExtension.values()) {
                            if (!protocolExtension.isSupported()) continue;
                            supportedExtensions.add(protocolExtension);
                        }
                        if (supportedExtensions.contains((Object)ClassicProtocolExtension.BLOCK_PERMISSIONS)) {
                            wrapper.user().put(new ExtBlockPermissionsStorage(wrapper.user()));
                        }
                        PacketWrapper extensionProtocolInfo = PacketWrapper.create(ServerboundPacketsc0_30cpe.EXTENSION_PROTOCOL_INFO, wrapper.user());
                        extensionProtocolInfo.write(Typesc0_30.STRING, ViaLegacy.getPlatform().getCpeAppName());
                        extensionProtocolInfo.write(Type.SHORT, (short)supportedExtensions.size());
                        extensionProtocolInfo.sendToServer(Protocolc0_30toc0_30cpe.class);
                        for (ClassicProtocolExtension protocolExtension : supportedExtensions) {
                            PacketWrapper extensionProtocolEntry = PacketWrapper.create(ServerboundPacketsc0_30cpe.EXTENSION_PROTOCOL_ENTRY, wrapper.user());
                            extensionProtocolEntry.write(Typesc0_30.STRING, protocolExtension.getName());
                            extensionProtocolEntry.write(Type.INT, protocolExtension.getHighestSupportedVersion());
                            extensionProtocolEntry.sendToServer(Protocolc0_30toc0_30cpe.class);
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPacketsc0_30cpe.EXT_CUSTOM_BLOCKS_SUPPORT_LEVEL, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    byte level = wrapper.read(Type.BYTE);
                    if (level != 1) {
                        ViaLegacy.getPlatform().getLogger().info("Classic server supports CustomBlocks level " + level);
                    }
                    PacketWrapper response = PacketWrapper.create(ServerboundPacketsc0_30cpe.EXT_CUSTOM_BLOCKS_SUPPORT_LEVEL, wrapper.user());
                    response.write(Type.BYTE, (byte)1);
                    response.sendToServer(Protocolc0_30toc0_30cpe.class);
                });
            }
        });
        this.registerClientbound(ClientboundPacketsc0_30cpe.EXT_HACK_CONTROL, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    ClassicOpLevelStorage opLevelStorage = wrapper.user().get(ClassicOpLevelStorage.class);
                    boolean flying = wrapper.read(Type.BOOLEAN);
                    boolean noClip = wrapper.read(Type.BOOLEAN);
                    boolean speed = wrapper.read(Type.BOOLEAN);
                    boolean respawn = wrapper.read(Type.BOOLEAN);
                    wrapper.read(Type.BOOLEAN);
                    wrapper.read(Type.SHORT);
                    opLevelStorage.updateHax(flying, noClip, speed, respawn);
                });
            }
        });
        this.registerClientbound(ClientboundPacketsc0_30cpe.EXT_SET_BLOCK_PERMISSION, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    ExtBlockPermissionsStorage blockPermissionsStorage = wrapper.user().get(ExtBlockPermissionsStorage.class);
                    byte blockId = wrapper.read(Type.BYTE);
                    boolean canPlace = wrapper.read(Type.BOOLEAN);
                    boolean canDelete = wrapper.read(Type.BOOLEAN);
                    if (canPlace) {
                        blockPermissionsStorage.addPlaceable(blockId);
                    } else {
                        blockPermissionsStorage.removePlaceable(blockId);
                    }
                    if (canDelete) {
                        blockPermissionsStorage.addBreakable(blockId);
                    } else {
                        blockPermissionsStorage.removeBreakable(blockId);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPacketsc0_30cpe.EXT_BULK_BLOCK_UPDATE, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    ClassicLevelStorage levelStorage = wrapper.user().get(ClassicLevelStorage.class);
                    if (levelStorage == null || !levelStorage.hasReceivedLevel()) {
                        return;
                    }
                    ClassicBlockRemapper remapper = wrapper.user().get(ClassicBlockRemapper.class);
                    ClassicLevel level = levelStorage.getClassicLevel();
                    int count = wrapper.read(Type.UNSIGNED_BYTE) + 1;
                    byte[] indices = wrapper.read(new CustomByteType(1024));
                    byte[] blocks = wrapper.read(new CustomByteType(256));
                    if (wrapper.user().getProtocolInfo().getPipeline().contains(Protocola1_0_16_2toa1_0_15.class)) {
                        HashMap<ChunkCoord, List> records = new HashMap<ChunkCoord, List>();
                        for (int i = 0; i < count; ++i) {
                            int index = (indices[i * 4] & 0xFF) << 24 | (indices[i * 4 + 1] & 0xFF) << 16 | (indices[i * 4 + 2] & 0xFF) << 8 | indices[i * 4 + 3] & 0xFF;
                            Position pos = new Position(index % level.getSizeX(), index / level.getSizeX() / level.getSizeZ(), index / level.getSizeX() % level.getSizeZ());
                            byte blockId = blocks[i];
                            level.setBlock(pos, blockId);
                            if (!levelStorage.isChunkLoaded(pos)) continue;
                            IdAndData mappedBlock = remapper.getMapper().get(blockId);
                            records.computeIfAbsent(new ChunkCoord(pos.x() >> 4, pos.z() >> 4), k -> new ArrayList()).add(new BlockChangeRecord1_8(pos.x() & 0xF, pos.y(), pos.z() & 0xF, mappedBlock.toCompressedData()));
                        }
                        for (Map.Entry entry : records.entrySet()) {
                            PacketWrapper multiBlockChange = PacketWrapper.create(ClientboundPacketsa1_0_15.MULTI_BLOCK_CHANGE, wrapper.user());
                            multiBlockChange.write(Type.INT, ((ChunkCoord)entry.getKey()).chunkX);
                            multiBlockChange.write(Type.INT, ((ChunkCoord)entry.getKey()).chunkZ);
                            multiBlockChange.write(Types1_1.BLOCK_CHANGE_RECORD_ARRAY, ((List)entry.getValue()).toArray(new BlockChangeRecord[0]));
                            multiBlockChange.send(Protocola1_0_16_2toa1_0_15.class);
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPacketsc0_30cpe.EXT_TWO_WAY_PING, ClientboundPacketsc0_28.KEEP_ALIVE, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    byte direction = wrapper.read(Type.BYTE);
                    short data = wrapper.read(Type.SHORT);
                    if (direction == 1) {
                        PacketWrapper pingResponse = PacketWrapper.create(ServerboundPacketsc0_30cpe.EXT_TWO_WAY_PING, wrapper.user());
                        pingResponse.write(Type.BYTE, direction);
                        pingResponse.write(Type.SHORT, data);
                        pingResponse.sendToServer(Protocolc0_30toc0_30cpe.class);
                    }
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundPacketsc0_28.LOGIN.getId(), ServerboundPacketsc0_30cpe.LOGIN.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Typesc0_30.STRING);
                this.map(Typesc0_30.STRING);
                this.map(Type.BYTE);
                this.handler(wrapper -> wrapper.set(Type.BYTE, 1, (byte)66));
            }
        });
        this.registerServerbound(ServerboundPacketsc0_28.CHAT_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Typesc0_30.STRING);
                this.handler(wrapper -> {
                    ExtensionProtocolMetadataStorage protocolMetadata = wrapper.user().get(ExtensionProtocolMetadataStorage.class);
                    if (!protocolMetadata.hasServerExtension(ClassicProtocolExtension.LONGER_MESSAGES, 1)) {
                        return;
                    }
                    wrapper.cancel();
                    String message = wrapper.get(Typesc0_30.STRING, 0);
                    while (!message.isEmpty()) {
                        int pos = Math.min(message.length(), 64);
                        String msg = message.substring(0, pos);
                        message = message.substring(pos);
                        PacketWrapper chatMessage = PacketWrapper.create(ServerboundPacketsc0_30cpe.CHAT_MESSAGE, wrapper.user());
                        chatMessage.write(Type.BYTE, (byte)(!message.isEmpty() ? 1 : 0));
                        chatMessage.write(Typesc0_30.STRING, msg);
                        chatMessage.sendToServer(Protocolc0_30toc0_30cpe.class);
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPacketsc0_28.PLAYER_BLOCK_PLACEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Typesc0_30.POSITION);
                this.map(Type.BOOLEAN);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    boolean disallow;
                    if (!wrapper.user().has(ExtBlockPermissionsStorage.class)) {
                        return;
                    }
                    ExtBlockPermissionsStorage blockPermissions = wrapper.user().get(ExtBlockPermissionsStorage.class);
                    ClassicLevel level = wrapper.user().get(ClassicLevelStorage.class).getClassicLevel();
                    Position position = wrapper.get(Typesc0_30.POSITION, 0);
                    boolean placeBlock = wrapper.get(Type.BOOLEAN, 0);
                    byte blockId = wrapper.get(Type.BYTE, 0);
                    int block = level.getBlock(position);
                    boolean bl = disallow = placeBlock && blockPermissions.isPlacingDenied(blockId) || !placeBlock && blockPermissions.isBreakingDenied(block);
                    if (disallow) {
                        wrapper.cancel();
                        PacketWrapper chatMessage = PacketWrapper.create(ClientboundPacketsc0_30cpe.CHAT_MESSAGE, wrapper.user());
                        chatMessage.write(Type.BYTE, (byte)0);
                        chatMessage.write(Typesc0_30.STRING, "&cYou are not allowed to place/break this block");
                        chatMessage.send(Protocolc0_30toc0_30cpe.class);
                    } else {
                        block = placeBlock ? blockId : (byte)0;
                        level.setBlock(position, block);
                    }
                    PacketWrapper blockChange = PacketWrapper.create(ClientboundPacketsc0_30cpe.BLOCK_CHANGE, wrapper.user());
                    blockChange.write(Typesc0_30.POSITION, position);
                    blockChange.write(Type.BYTE, (byte)block);
                    blockChange.send(Protocolc0_30toc0_30cpe.class);
                });
            }
        });
    }

    @Override
    public void register(ViaProviders providers) {
        Via.getPlatform().runRepeatingSync(new ClassicPingTask(), 20L);
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocolc0_30toc0_30cpe.class, ClientboundPacketsc0_30cpe::getPacket));
        userConnection.put(new ExtensionProtocolMetadataStorage(userConnection));
        ClassicBlockRemapper previousRemapper = userConnection.get(ClassicBlockRemapper.class);
        userConnection.put(new ClassicBlockRemapper(userConnection, i -> {
            if (ClassicBlocks.MAPPING.containsKey(i)) {
                return previousRemapper.getMapper().get(i);
            }
            ExtensionProtocolMetadataStorage extensionProtocol = userConnection.get(ExtensionProtocolMetadataStorage.class);
            if (extensionProtocol.hasServerExtension(ClassicProtocolExtension.CUSTOM_BLOCKS, 1)) {
                return (IdAndData)ExtendedClassicBlocks.MAPPING.get(i);
            }
            return new IdAndData(BlockList1_6.stone.blockID, 0);
        }, o -> {
            if (ClassicBlocks.REVERSE_MAPPING.containsKey(o)) {
                return previousRemapper.getReverseMapper().getInt(o);
            }
            ExtensionProtocolMetadataStorage extensionProtocol = userConnection.get(ExtensionProtocolMetadataStorage.class);
            if (extensionProtocol.hasServerExtension(ClassicProtocolExtension.CUSTOM_BLOCKS, 1)) {
                return ExtendedClassicBlocks.REVERSE_MAPPING.getInt(o);
            }
            return 1;
        }));
    }
}

