/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.NibbleArray;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import java.util.Arrays;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.remapper.LegacyItemRewriter;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.beta.protocolb1_8_0_1tob1_7_0_3.Protocolb1_8_0_1tob1_7_0_3;
import net.raphimc.vialegacy.protocols.classic.protocola1_0_15toc0_28_30.Protocola1_0_15toc0_30;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.ClientboundPackets1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.ServerboundPackets1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.biome.EndBiomeGenerator;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.biome.NetherBiomeGenerator;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.biome.PlainsBiomeGenerator;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.biome.beta.WorldChunkManager_b1_7;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.biome.release.WorldChunkManager_r1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.chunks.NibbleArray1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.model.NonFullChunk1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.rewriter.ItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.storage.DimensionTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.storage.PendingBlocksTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.storage.SeedStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.tasks.BlockReceiveInvalidatorTask;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.types.Chunk1_1Type;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.types.Types1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_4_5to1_2_1_3.ClientboundPackets1_2_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_4_5to1_2_1_3.ServerboundPackets1_2_1;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.types.Chunk1_2_4Type;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.types.Types1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ChunkTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocol1_2_1_3to1_1
extends AbstractProtocol<ClientboundPackets1_1, ClientboundPackets1_2_1, ServerboundPackets1_1, ServerboundPackets1_2_1> {
    private final LegacyItemRewriter<Protocol1_2_1_3to1_1> itemRewriter = new ItemRewriter(this);

    public Protocol1_2_1_3to1_1() {
        super(ClientboundPackets1_1.class, ClientboundPackets1_2_1.class, ServerboundPackets1_1.class, ServerboundPackets1_2_1.class);
    }

    @Override
    protected void registerPackets() {
        this.itemRewriter.register();
        this.registerClientbound(ClientboundPackets1_1.JOIN_GAME, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.handler(wrapper -> {
                    wrapper.user().get(SeedStorage.class).seed = wrapper.read(Type.LONG);
                });
                this.map(Types1_6_4.STRING);
                this.map(Type.INT);
                this.map((Type)Type.BYTE, Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> Protocol1_2_1_3to1_1.this.handleRespawn(wrapper.get(Type.INT, 2), wrapper.user()));
            }
        });
        this.registerClientbound(ClientboundPackets1_1.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.BYTE, Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.handler(wrapper -> {
                    wrapper.user().get(SeedStorage.class).seed = wrapper.read(Type.LONG);
                });
                this.map(Types1_6_4.STRING);
                this.handler(wrapper -> Protocol1_2_1_3to1_1.this.handleRespawn(wrapper.get(Type.INT, 0), wrapper.user()));
            }
        });
        this.registerClientbound(ClientboundPackets1_1.SPAWN_MOB, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> wrapper.write(Type.BYTE, wrapper.get(Type.BYTE, 0)));
                this.map(Types1_3_1.METADATA_LIST);
            }
        });
        this.registerClientbound(ClientboundPackets1_1.ENTITY_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> Protocol1_2_1_3to1_1.this.sendEntityHeadLook(wrapper.get(Type.INT, 0), wrapper.get(Type.BYTE, 0), wrapper));
            }
        });
        this.registerClientbound(ClientboundPackets1_1.ENTITY_POSITION_AND_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> Protocol1_2_1_3to1_1.this.sendEntityHeadLook(wrapper.get(Type.INT, 0), wrapper.get(Type.BYTE, 3), wrapper));
            }
        });
        this.registerClientbound(ClientboundPackets1_1.ENTITY_TELEPORT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> Protocol1_2_1_3to1_1.this.sendEntityHeadLook(wrapper.get(Type.INT, 0), wrapper.get(Type.BYTE, 0), wrapper));
            }
        });
        this.registerClientbound(ClientboundPackets1_1.CHUNK_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    int[] newBiomeData;
                    ClientWorld clientWorld = wrapper.user().get(ClientWorld.class);
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    SeedStorage seedStorage = wrapper.user().get(SeedStorage.class);
                    PendingBlocksTracker pendingBlocksTracker = wrapper.user().get(PendingBlocksTracker.class);
                    Chunk chunk = wrapper.read(new Chunk1_1Type(clientWorld));
                    if (chunk instanceof NonFullChunk1_1) {
                        if (!chunkTracker.isChunkLoaded(chunk.getX(), chunk.getZ())) {
                            wrapper.cancel();
                            return;
                        }
                        NonFullChunk1_1 nfc = (NonFullChunk1_1)chunk;
                        wrapper.setPacketType(ClientboundPackets1_2_1.MULTI_BLOCK_CHANGE);
                        wrapper.write(Type.INT, nfc.getX());
                        wrapper.write(Type.INT, nfc.getZ());
                        wrapper.write(Types1_7_6.BLOCK_CHANGE_RECORD_ARRAY, nfc.asBlockChangeRecords().toArray(new BlockChangeRecord[0]));
                        pendingBlocksTracker.markReceived(new Position((nfc.getX() << 4) + nfc.getStartPos().x(), nfc.getStartPos().y(), (nfc.getZ() << 4) + nfc.getStartPos().z()), new Position((nfc.getX() << 4) + nfc.getEndPos().x() - 1, nfc.getEndPos().y() - 1, (nfc.getZ() << 4) + nfc.getEndPos().z() - 1));
                        return;
                    }
                    pendingBlocksTracker.markReceived(new Position(chunk.getX() << 4, 0, chunk.getZ() << 4), new Position((chunk.getX() << 4) + 15, chunk.getSections().length * 16, (chunk.getZ() << 4) + 15));
                    if (seedStorage.worldChunkManager != null) {
                        byte[] byArray = seedStorage.worldChunkManager.getBiomeDataAt(chunk.getX(), chunk.getZ());
                        newBiomeData = new int[byArray.length];
                        for (int i = 0; i < byArray.length; ++i) {
                            newBiomeData[i] = byArray[i] & 0xFF;
                        }
                    } else {
                        newBiomeData = new int[256];
                        Arrays.fill(newBiomeData, 1);
                    }
                    chunk.setBiomeData(newBiomeData);
                    for (ChunkSection section : chunk.getSections()) {
                        if (section == null) continue;
                        NibbleArray1_1 oldBlockLight = new NibbleArray1_1(section.getLight().getBlockLight(), 4);
                        NibbleArray newBlockLight = new NibbleArray(oldBlockLight.size());
                        NibbleArray1_1 oldSkyLight = null;
                        NibbleArray newSkyLight = null;
                        if (section.getLight().hasSkyLight()) {
                            oldSkyLight = new NibbleArray1_1(section.getLight().getSkyLight(), 4);
                            newSkyLight = new NibbleArray(oldSkyLight.size());
                        }
                        for (int x = 0; x < 16; ++x) {
                            for (int y = 0; y < 16; ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    newBlockLight.set(x, y, z, oldBlockLight.get(x, y, z));
                                    if (oldSkyLight == null) continue;
                                    newSkyLight.set(x, y, z, oldSkyLight.get(x, y, z));
                                }
                            }
                        }
                        section.getLight().setBlockLight(newBlockLight.getHandle());
                        if (newSkyLight == null) continue;
                        section.getLight().setSkyLight(newSkyLight.getHandle());
                    }
                    if (chunk.getSections().length < 16) {
                        ChunkSection[] chunkSectionArray = new ChunkSection[16];
                        System.arraycopy(chunk.getSections(), 0, chunkSectionArray, 0, chunk.getSections().length);
                        chunk.setSections(chunkSectionArray);
                    }
                    wrapper.write(new Chunk1_2_4Type(clientWorld), chunk);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_1.MULTI_BLOCK_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Types1_1.BLOCK_CHANGE_RECORD_ARRAY, Types1_7_6.BLOCK_CHANGE_RECORD_ARRAY);
                this.handler(wrapper -> {
                    BlockChangeRecord[] blockChangeRecords;
                    PendingBlocksTracker pendingBlocksTracker = wrapper.user().get(PendingBlocksTracker.class);
                    int chunkX = wrapper.get(Type.INT, 0);
                    int chunkZ = wrapper.get(Type.INT, 1);
                    for (BlockChangeRecord record : blockChangeRecords = wrapper.get(Types1_7_6.BLOCK_CHANGE_RECORD_ARRAY, 0)) {
                        int targetX = record.getSectionX() + (chunkX << 4);
                        short targetY = record.getY(-1);
                        int targetZ = record.getSectionZ() + (chunkZ << 4);
                        pendingBlocksTracker.markReceived(new Position(targetX, (int)targetY, targetZ));
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_1.BLOCK_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(wrapper -> wrapper.user().get(PendingBlocksTracker.class).markReceived(wrapper.get(Types1_7_6.POSITION_UBYTE, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_1.EXPLOSION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.FLOAT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    PendingBlocksTracker pendingBlocksTracker = wrapper.user().get(PendingBlocksTracker.class);
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    int x = wrapper.get(Type.DOUBLE, 0).intValue();
                    int y = wrapper.get(Type.DOUBLE, 1).intValue();
                    int z = wrapper.get(Type.DOUBLE, 2).intValue();
                    int recordCount = wrapper.get(Type.INT, 0);
                    for (int i = 0; i < recordCount; ++i) {
                        Position pos = new Position(x + wrapper.passthrough(Type.BYTE), y + wrapper.passthrough(Type.BYTE), z + wrapper.passthrough(Type.BYTE));
                        IdAndData block = chunkTracker.getBlockNotNull(pos);
                        if (block.id == 0) continue;
                        pendingBlocksTracker.addPending(pos, block);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_1.EFFECT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int sfxId = wrapper.get(Type.INT, 0);
                    int sfxData = wrapper.get(Type.INT, 1);
                    if (sfxId == 2001) {
                        int blockID = sfxData & 0xFF;
                        int blockData = sfxData >> 8 & 0xFF;
                        wrapper.set(Type.INT, 1, blockID + (blockData << 12));
                    } else if (sfxId == 1009) {
                        wrapper.set(Type.INT, 0, 1008);
                    }
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundPackets1_2_1.HANDSHAKE.getId(), ServerboundPackets1_1.HANDSHAKE.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Types1_6_4.STRING, s -> s.split(";")[0]);
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundPackets1_2_1.LOGIN.getId(), ServerboundPackets1_1.LOGIN.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.create(Type.LONG, 0L);
                this.map(Types1_6_4.STRING);
                this.map(Type.INT);
                this.map((Type)Type.INT, Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
            }
        });
        this.registerServerbound(ServerboundPackets1_2_1.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.create(Type.LONG, 0L);
                this.map(Types1_6_4.STRING);
            }
        });
    }

    private void handleRespawn(int dimensionId, UserConnection user) {
        user.get(ClientWorld.class).setEnvironment(dimensionId);
        if (user.get(DimensionTracker.class).getDimensionId() != dimensionId) {
            user.get(DimensionTracker.class).setDimension(dimensionId);
            user.get(PendingBlocksTracker.class).clear();
        }
        if (ViaLegacy.getConfig().isOldBiomes()) {
            SeedStorage seedStorage = user.get(SeedStorage.class);
            seedStorage.worldChunkManager = dimensionId == -1 ? new NetherBiomeGenerator() : (dimensionId == 1 ? new EndBiomeGenerator() : (dimensionId == 0 ? (!user.getProtocolInfo().getPipeline().contains(Protocolb1_8_0_1tob1_7_0_3.class) ? new WorldChunkManager_r1_1(user, seedStorage.seed) : (!user.getProtocolInfo().getPipeline().contains(Protocola1_0_15toc0_30.class) ? new WorldChunkManager_b1_7(seedStorage.seed) : new PlainsBiomeGenerator())) : null));
        }
    }

    private void sendEntityHeadLook(int entityId, byte headYaw, PacketWrapper wrapper) throws Exception {
        PacketWrapper entityHeadLook = PacketWrapper.create(ClientboundPackets1_2_1.ENTITY_HEAD_LOOK, wrapper.user());
        entityHeadLook.write(Type.INT, entityId);
        entityHeadLook.write(Type.BYTE, headYaw);
        wrapper.send(Protocol1_2_1_3to1_1.class);
        entityHeadLook.send(Protocol1_2_1_3to1_1.class);
        wrapper.cancel();
    }

    @Override
    public void register(ViaProviders providers) {
        Via.getPlatform().runRepeatingSync(new BlockReceiveInvalidatorTask(), 1L);
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocol1_2_1_3to1_1.class, ClientboundPackets1_1::getPacket));
        userConnection.put(new SeedStorage(userConnection));
        userConnection.put(new PendingBlocksTracker(userConnection));
        userConnection.put(new DimensionTracker(userConnection));
        if (!userConnection.has(ClientWorld.class)) {
            userConnection.put(new ClientWorld(userConnection));
        }
    }

    @Override
    public LegacyItemRewriter<Protocol1_2_1_3to1_1> getItemRewriter() {
        return this.itemRewriter;
    }
}

