/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.types;

import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionImpl;
import com.viaversion.viaversion.api.minecraft.chunks.NibbleArray;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.type.PartialType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.CustomByteType;
import com.viaversion.viaversion.api.type.types.minecraft.BaseChunkType;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.chunks.NibbleArray1_1;
import net.raphimc.vialegacy.protocols.release.protocol1_2_1_3to1_1.model.NonFullChunk1_1;

public class Chunk1_1Type
extends PartialType<Chunk, ClientWorld> {
    public Chunk1_1Type(ClientWorld clientWorld) {
        super(clientWorld, Chunk.class);
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkType.class;
    }

    @Override
    public Chunk read(ByteBuf byteBuf, ClientWorld clientWorld) throws Exception {
        int xPosition = byteBuf.readInt();
        short yPosition = byteBuf.readShort();
        int zPosition = byteBuf.readInt();
        int xSize = byteBuf.readUnsignedByte() + 1;
        int ySize = byteBuf.readUnsignedByte() + 1;
        int zSize = byteBuf.readUnsignedByte() + 1;
        int chunkSize = byteBuf.readInt();
        byte[] compressedData = (byte[])new CustomByteType(chunkSize).read(byteBuf);
        byte[] uncompressedData = new byte[xSize * ySize * zSize * 5 / 2];
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        try {
            inflater.inflate(uncompressedData);
        }
        catch (DataFormatException dataformatexception) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
        return Chunk1_1Type.deserialize(xPosition, yPosition, zPosition, xSize, ySize, zSize, clientWorld.getEnvironment() == Environment.NORMAL, uncompressedData);
    }

    @Override
    public void write(ByteBuf byteBuf, ClientWorld clientWorld, Chunk chunk) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static Chunk deserialize(int xPosition, int yPosition, int zPosition, int xSize, int ySize, int zSize, boolean skyLight, byte[] chunkData) {
        int chunkX = xPosition >> 4;
        int chunkZ = zPosition >> 4;
        int endChunkX = xPosition + xSize - 1 >> 4;
        int endChunkZ = zPosition + zSize - 1 >> 4;
        int startX = Math.max(xPosition - chunkX * 16, 0);
        int endX = Math.min(xPosition + xSize - chunkX * 16, 16);
        int startY = Math.max(yPosition, 0);
        int endY = Math.min(yPosition + ySize, 128);
        int startZ = Math.max(zPosition - chunkZ * 16, 0);
        int endZ = Math.min(zPosition + zSize - chunkZ * 16, 16);
        boolean fullChunk = (xPosition & 0xF) == 0 && yPosition == 0 && (zPosition & 0xF) == 0 && xSize == 16 && ySize == 128 && zSize == 16;
        byte[] blockArray = new byte[32768];
        NibbleArray1_1 blockDataArray = new NibbleArray1_1(blockArray.length);
        NibbleArray1_1 blockLightArray = new NibbleArray1_1(blockArray.length);
        NibbleArray1_1 skyLightArray = new NibbleArray1_1(blockArray.length);
        if (fullChunk) {
            int blockDataOffset = blockArray.length;
            int blockLightOffset = blockArray.length + blockDataArray.getHandle().length;
            int skyLightOffset = chunkData.length - blockLightArray.getHandle().length;
            System.arraycopy(chunkData, 0, blockArray, 0, blockArray.length);
            System.arraycopy(chunkData, blockDataOffset, blockDataArray.getHandle(), 0, blockDataArray.getHandle().length);
            System.arraycopy(chunkData, blockLightOffset, blockLightArray.getHandle(), 0, blockLightArray.getHandle().length);
            System.arraycopy(chunkData, skyLightOffset, skyLightArray.getHandle(), 0, skyLightArray.getHandle().length);
        } else {
            int size;
            int index;
            int z;
            int x;
            if (chunkX != endChunkX || chunkZ != endChunkZ) {
                throw new IllegalStateException("Can't decode 1.1 non full-chunk which spans over multiple chunks");
            }
            int offset = 0;
            for (x = startX; x < endX; ++x) {
                for (z = startZ; z < endZ; ++z) {
                    index = x << 11 | z << 7 | startY;
                    size = endY - startY;
                    System.arraycopy(chunkData, offset, blockArray, index, size);
                    offset += size;
                }
            }
            for (x = startX; x < endX; ++x) {
                for (z = startZ; z < endZ; ++z) {
                    index = (x << 11 | z << 7 | startY) >> 1;
                    size = (endY - startY) / 2;
                    System.arraycopy(chunkData, offset, blockDataArray.getHandle(), index, size);
                    offset += size;
                }
            }
            for (x = startX; x < endX; ++x) {
                for (z = startZ; z < endZ; ++z) {
                    index = (x << 11 | z << 7 | startY) >> 1;
                    size = (endY - startY) / 2;
                    System.arraycopy(chunkData, offset, blockLightArray.getHandle(), index, size);
                    offset += size;
                }
            }
            for (x = startX; x < endX; ++x) {
                for (z = startZ; z < endZ; ++z) {
                    index = (x << 11 | z << 7 | startY) >> 1;
                    size = (endY - startY) / 2;
                    System.arraycopy(chunkData, offset, skyLightArray.getHandle(), index, size);
                    offset += size;
                }
            }
        }
        ChunkSection[] modernSections = new ChunkSection[8];
        int bitmask = 0;
        ChunkSection section = null;
        NibbleArray sectionSkyLight = null;
        NibbleArray sectionBlockLight = null;
        for (int y = startY; y < endY; ++y) {
            if (section == null || y % 16 == 0) {
                int sectionY = y >> 4;
                bitmask |= 1 << sectionY;
                section = modernSections[sectionY] = new ChunkSectionImpl(true);
                section.palette(PaletteType.BLOCKS).addId(0);
                sectionSkyLight = new NibbleArray1_1(4096, 4);
                sectionBlockLight = new NibbleArray1_1(4096, 4);
            }
            for (int x = startX; x < endX; ++x) {
                for (int z = startZ; z < endZ; ++z) {
                    section.palette(PaletteType.BLOCKS).setIdAt(x, y & 0xF, z, IdAndData.toCompressedData(blockArray[x << 11 | z << 7 | y] & 0xFF, blockDataArray.get(x, y, z)));
                    ((NibbleArray1_1)sectionSkyLight).set(x, y & 0xF, z, skyLightArray.get(x, y, z));
                    ((NibbleArray1_1)sectionBlockLight).set(x, y & 0xF, z, blockLightArray.get(x, y, z));
                }
            }
            section.getLight().setBlockLight(sectionBlockLight.getHandle());
            if (!skyLight) continue;
            section.getLight().setSkyLight(sectionSkyLight.getHandle());
        }
        if (fullChunk) {
            return new BaseChunk(chunkX, chunkZ, true, false, 255, modernSections, new int[256], new ArrayList<CompoundTag>());
        }
        return new NonFullChunk1_1(chunkX, chunkZ, bitmask, modernSections, new Position(startX, startY, startZ), new Position(endX, endY, endZ));
    }
}

