/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5;

import com.google.common.collect.Lists;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionImpl;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ShortTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.data.BlockList1_6;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.model.Location;
import net.raphimc.vialegacy.api.remapper.LegacyItemRewriter;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.ClientboundPackets1_2_4;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.ServerboundPackets1_2_4;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.data.EntityList;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.AbstractTrackedEntity;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.TrackedEntity;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.TrackedLivingEntity;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.providers.OldAuthProvider;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.rewriter.ItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.Sound;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.SoundType;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.storage.ChestStateTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.storage.DimensionTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.storage.EntityTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.task.EntityTrackerTickTask;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.types.Chunk1_2_4Type;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.types.Types1_2_4;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.ClientboundPackets1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.ServerboundPackets1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.types.MetaType1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.types.Types1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.metadata.MetaIndex1_6_1to1_5_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ChunkTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ProtocolMetadataStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata.MetaIndex1_8to1_7_6;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Chunk1_7_6Type;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocol1_3_1_2to1_2_4_5
extends AbstractProtocol<ClientboundPackets1_2_4, ClientboundPackets1_3_1, ServerboundPackets1_2_4, ServerboundPackets1_3_1> {
    private final LegacyItemRewriter<Protocol1_3_1_2to1_2_4_5> itemRewriter = new ItemRewriter(this);

    public Protocol1_3_1_2to1_2_4_5() {
        super(ClientboundPackets1_2_4.class, ClientboundPackets1_3_1.class, ServerboundPackets1_2_4.class, ServerboundPackets1_3_1.class);
    }

    @Override
    protected void registerPackets() {
        this.itemRewriter.register();
        this.registerClientbound(State.LOGIN, ClientboundPackets1_2_4.HANDSHAKE.getId(), ClientboundPackets1_3_1.SHARED_KEY.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Protocol1_3_1_2to1_2_4_5.this.handleHandshake(wrapper);
                    wrapper.write(Type.SHORT_BYTE_ARRAY, new byte[0]);
                    wrapper.write(Type.SHORT_BYTE_ARRAY, new byte[0]);
                    wrapper.user().get(ProtocolMetadataStorage.class).skipEncryption = true;
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.HANDSHAKE, null, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Protocol1_3_1_2to1_2_4_5.this.handleHandshake(wrapper);
                    wrapper.cancel();
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.JOIN_GAME, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.read(Types1_6_4.STRING);
                this.map(Types1_6_4.STRING);
                this.map((Type)Type.INT, Type.BYTE);
                this.map((Type)Type.INT, Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    wrapper.user().get(ClientWorld.class).setEnvironment(wrapper.get(Type.BYTE, 1).byteValue());
                    wrapper.user().get(DimensionTracker.class).setDimension(wrapper.get(Type.BYTE, 1).byteValue());
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    entityTracker.setPlayerID(wrapper.get(Type.INT, 0));
                    entityTracker.getTrackedEntities().put(entityTracker.getPlayerID(), new TrackedLivingEntity(entityTracker.getPlayerID(), new Location(8.0, 64.0, 8.0), Entity1_10Types.EntityType.PLAYER));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.ENTITY_EQUIPMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.SHORT);
                this.handler(wrapper -> {
                    short itemId = wrapper.read(Type.SHORT);
                    short itemDamage = wrapper.read(Type.SHORT);
                    wrapper.write(Types1_7_6.COMPRESSED_ITEM, itemId < 0 ? null : new DataItem(itemId, 1, itemDamage, null));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Types1_6_4.STRING);
                this.handler(wrapper -> {
                    int oldDim = wrapper.user().get(DimensionTracker.class).getDimensionId();
                    int newDim = wrapper.get(Type.INT, 0);
                    wrapper.user().get(ClientWorld.class).setEnvironment(newDim);
                    wrapper.user().get(DimensionTracker.class).setDimension(newDim);
                    if (oldDim != newDim) {
                        wrapper.user().get(ChestStateTracker.class).clear();
                        EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                        entityTracker.getTrackedEntities().clear();
                        entityTracker.getTrackedEntities().put(entityTracker.getPlayerID(), new TrackedLivingEntity(entityTracker.getPlayerID(), new Location(8.0, 64.0, 8.0), Entity1_10Types.EntityType.PLAYER));
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.SPAWN_PLAYER, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.UNSIGNED_SHORT);
                this.handler(wrapper -> wrapper.write(Types1_3_1.METADATA_LIST, Lists.newArrayList((Object[])new Metadata[]{new Metadata(0, MetaType1_3_1.Byte, (byte)0)})));
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Type.INT, 0);
                    double x = (double)wrapper.get(Type.INT, 1).intValue() / 32.0;
                    double y = (double)wrapper.get(Type.INT, 2).intValue() / 32.0;
                    double z = (double)wrapper.get(Type.INT, 3).intValue() / 32.0;
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    tracker.getTrackedEntities().put(entityId, new TrackedLivingEntity(entityId, new Location(x, y, z), Entity1_10Types.EntityType.PLAYER));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.SPAWN_ITEM, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_3_1.NBTLESS_ITEM);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.INT, 0);
                    double x = (double)wrapper.get(Type.INT, 1).intValue() / 32.0;
                    double y = (double)wrapper.get(Type.INT, 2).intValue() / 32.0;
                    double z = (double)wrapper.get(Type.INT, 3).intValue() / 32.0;
                    tracker.getTrackedEntities().put(entityId, new TrackedEntity(entityId, new Location(x, y, z), Entity1_10Types.ObjectType.ITEM.getType()));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.COLLECT_ITEM, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.handler(wrapper -> wrapper.user().get(EntityTracker.class).getTrackedEntities().remove(wrapper.get(Type.INT, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.SPAWN_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    Entity1_10Types.EntityType type;
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.INT, 0);
                    byte typeId = wrapper.get(Type.BYTE, 0);
                    if (typeId == 70 || typeId == 71 || typeId == 74) {
                        type = Entity1_10Types.ObjectType.FALLING_BLOCK.getType();
                        wrapper.set(Type.BYTE, 0, (byte)Entity1_10Types.ObjectType.FALLING_BLOCK.getId());
                    } else {
                        type = typeId == 10 || typeId == 11 || typeId == 12 ? Entity1_10Types.ObjectType.MINECART.getType() : Entity1_10Types.getTypeFromId(typeId, true);
                    }
                    double x = (double)wrapper.get(Type.INT, 1).intValue() / 32.0;
                    double y = (double)wrapper.get(Type.INT, 2).intValue() / 32.0;
                    double z = (double)wrapper.get(Type.INT, 3).intValue() / 32.0;
                    Location location = new Location(x, y, z);
                    int throwerEntityId = wrapper.get(Type.INT, 4);
                    short speedX = 0;
                    short speedY = 0;
                    short speedZ = 0;
                    if (throwerEntityId > 0) {
                        speedX = wrapper.read(Type.SHORT);
                        speedY = wrapper.read(Type.SHORT);
                        speedZ = wrapper.read(Type.SHORT);
                    }
                    if (typeId == 70) {
                        throwerEntityId = 12;
                    }
                    if (typeId == 71) {
                        throwerEntityId = 13;
                    }
                    if (typeId == 74) {
                        throwerEntityId = 122;
                    }
                    if (typeId == Entity1_10Types.ObjectType.FISHIHNG_HOOK.getId()) {
                        Optional<AbstractTrackedEntity> nearestEntity = entityTracker.getNearestEntity(location, 2.0, e -> e.getEntityType().isOrHasParent(Entity1_10Types.EntityType.PLAYER));
                        throwerEntityId = nearestEntity.map(AbstractTrackedEntity::getEntityId).orElseGet(entityTracker::getPlayerID);
                    }
                    wrapper.set(Type.INT, 4, throwerEntityId);
                    if (throwerEntityId > 0) {
                        wrapper.write(Type.SHORT, speedX);
                        wrapper.write(Type.SHORT, speedY);
                        wrapper.write(Type.SHORT, speedZ);
                    }
                    entityTracker.getTrackedEntities().put(entityId, new TrackedEntity(entityId, location, type));
                    Entity1_10Types.ObjectType objectType = Entity1_10Types.ObjectType.findById(typeId).orElse(null);
                    if (objectType == null) {
                        return;
                    }
                    switch (objectType) {
                        case TNT_PRIMED: {
                            entityTracker.playSoundAt(location, Sound.RANDOM_FUSE, 1.0f, 1.0f);
                            break;
                        }
                        case TIPPED_ARROW: {
                            float pitch = 1.0f / (entityTracker.RND.nextFloat() * 0.4f + 1.2f) + 0.5f;
                            entityTracker.playSoundAt(location, Sound.RANDOM_BOW, 1.0f, pitch);
                            break;
                        }
                        case SNOWBALL: 
                        case EGG: 
                        case ENDER_PEARL: 
                        case ENDER_SIGNAL: 
                        case POTION: 
                        case THROWN_EXP_BOTTLE: 
                        case FISHIHNG_HOOK: {
                            float pitch = 0.4f / (entityTracker.RND.nextFloat() * 0.4f + 0.8f);
                            entityTracker.playSoundAt(location, Sound.RANDOM_BOW, 0.5f, pitch);
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.SPAWN_MOB, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.create(Type.SHORT, (short)0);
                this.create(Type.SHORT, (short)0);
                this.create(Type.SHORT, (short)0);
                this.map(Types1_3_1.METADATA_LIST);
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Type.INT, 0);
                    short type = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    double x = (double)wrapper.get(Type.INT, 1).intValue() / 32.0;
                    double y = (double)wrapper.get(Type.INT, 2).intValue() / 32.0;
                    double z = (double)wrapper.get(Type.INT, 3).intValue() / 32.0;
                    List<Metadata> metadataList = wrapper.get(Types1_3_1.METADATA_LIST, 0);
                    Entity1_10Types.EntityType entityType = Entity1_10Types.getTypeFromId(type, false);
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    tracker.getTrackedEntities().put(entityId, new TrackedLivingEntity(entityId, new Location(x, y, z), entityType));
                    tracker.updateEntityMetadata(entityId, metadataList);
                    Protocol1_3_1_2to1_2_4_5.this.handleEntityMetadata(entityId, metadataList, wrapper);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.DESTROY_ENTITIES, new PacketHandlers(){

            /*
             * Exception decompiling
             */
            @Override
            public void register() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.UnsupportedOperationException
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static /* synthetic */ void lambda$register$1(PacketWrapper wrapper) throws Exception {
                EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                for (int entityId : wrapper.get(Types1_7_6.INT_ARRAY, 0)) {
                    tracker.getTrackedEntities().remove(entityId);
                }
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.ENTITY_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.INT, 0);
                    byte x = wrapper.get(Type.BYTE, 0);
                    byte y = wrapper.get(Type.BYTE, 1);
                    byte z = wrapper.get(Type.BYTE, 2);
                    tracker.updateEntityLocation(entityId, x, y, z, true);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.ENTITY_POSITION_AND_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.INT, 0);
                    byte x = wrapper.get(Type.BYTE, 0);
                    byte y = wrapper.get(Type.BYTE, 1);
                    byte z = wrapper.get(Type.BYTE, 2);
                    tracker.updateEntityLocation(entityId, x, y, z, true);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.ENTITY_TELEPORT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.INT, 0);
                    int x = wrapper.get(Type.INT, 1);
                    int y = wrapper.get(Type.INT, 2);
                    int z = wrapper.get(Type.INT, 3);
                    tracker.updateEntityLocation(entityId, x, y, z, false);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.ENTITY_STATUS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.INT, 0);
                    byte status = wrapper.get(Type.BYTE, 0);
                    if (status == 2) {
                        entityTracker.playSound(entityId, SoundType.HURT);
                    } else if (status == 3) {
                        entityTracker.playSound(entityId, SoundType.DEATH);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.ENTITY_METADATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_3_1.METADATA_LIST);
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Type.INT, 0);
                    List<Metadata> metadataList = wrapper.get(Types1_3_1.METADATA_LIST, 0);
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    if (entityTracker.getTrackedEntities().containsKey(entityId)) {
                        entityTracker.updateEntityMetadata(entityId, metadataList);
                        Protocol1_3_1_2to1_2_4_5.this.handleEntityMetadata(entityId, metadataList, wrapper);
                    } else {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.PRE_CHUNK, ClientboundPackets1_3_1.CHUNK_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    int chunkX = wrapper.read(Type.INT);
                    int chunkZ = wrapper.read(Type.INT);
                    short mode = wrapper.read(Type.UNSIGNED_BYTE);
                    boolean load = mode != 0;
                    wrapper.user().get(ChestStateTracker.class).unload(chunkX, chunkZ);
                    if (!load) {
                        BaseChunk chunk = new BaseChunk(chunkX, chunkZ, true, false, 0, new ChunkSection[16], null, new ArrayList<CompoundTag>());
                        wrapper.write(new Chunk1_7_6Type(wrapper.user().get(ClientWorld.class)), chunk);
                    } else {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.CHUNK_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    ClientWorld clientWorld = wrapper.user().get(ClientWorld.class);
                    Chunk chunk = wrapper.read(new Chunk1_2_4Type(clientWorld));
                    wrapper.user().get(ChestStateTracker.class).unload(chunk.getX(), chunk.getZ());
                    if (chunk.isFullChunk() && chunk.getBitmask() == 0) {
                        ViaLegacy.getPlatform().getLogger().warning("Received empty 1.2.5 chunk packet");
                        chunk = new BaseChunk(chunk.getX(), chunk.getZ(), true, false, 65535, new ChunkSection[16], new int[256], new ArrayList<CompoundTag>());
                        for (int i = 0; i < chunk.getSections().length; ++i) {
                            ChunkSectionImpl chunkSectionImpl = new ChunkSectionImpl(true);
                            chunk.getSections()[i] = chunkSectionImpl;
                            ChunkSectionImpl chunkSection = chunkSectionImpl;
                            chunkSection.palette(PaletteType.BLOCKS).addId(0);
                            if (clientWorld.getEnvironment() != Environment.NORMAL) continue;
                            byte[] skyLight = new byte[2048];
                            Arrays.fill(skyLight, (byte)-1);
                            chunkSection.getLight().setSkyLight(skyLight);
                        }
                    }
                    wrapper.write(new Chunk1_7_6Type(clientWorld), chunk);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.BLOCK_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map((Type)Type.UNSIGNED_BYTE, Type.UNSIGNED_SHORT);
                this.map(Type.UNSIGNED_BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.BLOCK_ACTION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    IdAndData block = wrapper.user().get(ChunkTracker.class).getBlockNotNull(wrapper.get(Types1_7_6.POSITION_SHORT, 0));
                    wrapper.write(Type.SHORT, (short)block.id);
                });
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    Position pos = wrapper.get(Types1_7_6.POSITION_SHORT, 0);
                    byte type = wrapper.get(Type.BYTE, 0);
                    short data = wrapper.get(Type.BYTE, 1).byteValue();
                    short blockId = wrapper.get(Type.SHORT, 0);
                    if (blockId <= 0) {
                        return;
                    }
                    float volume = 1.0f;
                    float pitch = 1.0f;
                    Sound sound = null;
                    if (blockId == BlockList1_6.music.blockID) {
                        switch (type) {
                            default: {
                                sound = Sound.NOTE_HARP;
                                break;
                            }
                            case 1: {
                                sound = Sound.NOTE_CLICK;
                                break;
                            }
                            case 2: {
                                sound = Sound.NOTE_SNARE;
                                break;
                            }
                            case 3: {
                                sound = Sound.NOTE_HAT;
                                break;
                            }
                            case 4: {
                                sound = Sound.NOTE_BASS_ATTACK;
                            }
                        }
                        volume = 3.0f;
                        pitch = (float)Math.pow(2.0, (double)(data - 12) / 12.0);
                    } else if (blockId == BlockList1_6.chest.blockID) {
                        if (type == 1) {
                            ChestStateTracker chestStateTracker = wrapper.user().get(ChestStateTracker.class);
                            if (chestStateTracker.isChestOpen(pos) && data <= 0) {
                                sound = Sound.CHEST_CLOSE;
                                chestStateTracker.closeChest(pos);
                            } else if (!chestStateTracker.isChestOpen(pos) && data > 0) {
                                sound = Sound.CHEST_OPEN;
                                chestStateTracker.openChest(pos);
                            }
                            volume = 0.5f;
                            pitch = entityTracker.RND.nextFloat() * 0.1f + 0.9f;
                        }
                    } else if (blockId == BlockList1_6.pistonBase.blockID || blockId == BlockList1_6.pistonStickyBase.blockID) {
                        if (type == 0) {
                            sound = Sound.PISTON_OUT;
                            volume = 0.5f;
                            pitch = entityTracker.RND.nextFloat() * 0.25f + 0.6f;
                        } else if (type == 1) {
                            sound = Sound.PISTON_IN;
                            volume = 0.5f;
                            pitch = entityTracker.RND.nextFloat() * 0.15f + 0.6f;
                        }
                    }
                    if (sound != null) {
                        entityTracker.playSoundAt(new Location(pos), sound, volume, pitch);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.EXPLOSION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.FLOAT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int count = wrapper.get(Type.INT, 0);
                    for (int i = 0; i < count * 3; ++i) {
                        wrapper.passthrough(Type.BYTE);
                    }
                });
                this.create(Type.FLOAT, Float.valueOf(0.0f));
                this.create(Type.FLOAT, Float.valueOf(0.0f));
                this.create(Type.FLOAT, Float.valueOf(0.0f));
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    Location loc = new Location(wrapper.get(Type.DOUBLE, 0), wrapper.get(Type.DOUBLE, 1), wrapper.get(Type.DOUBLE, 2));
                    entityTracker.playSoundAt(loc, Sound.RANDOM_EXPLODE, 4.0f, (1.0f + (entityTracker.RND.nextFloat() - entityTracker.RND.nextFloat()) * 0.2f) * 0.7f);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.SET_SLOT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Types1_2_4.COMPRESSED_NBT_ITEM, Types1_7_6.COMPRESSED_ITEM);
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.WINDOW_ITEMS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Types1_2_4.COMPRESSED_NBT_ITEM_ARRAY, Types1_7_6.COMPRESSED_ITEM_ARRAY);
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.BLOCK_ENTITY_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    int entityId = wrapper.read(Type.INT);
                    wrapper.read(Type.INT);
                    wrapper.read(Type.INT);
                    if (wrapper.get(Type.BYTE, 0) != 1) {
                        wrapper.cancel();
                        return;
                    }
                    Position pos = wrapper.get(Types1_7_6.POSITION_SHORT, 0);
                    CompoundTag tag = new CompoundTag();
                    tag.put("EntityId", new StringTag(EntityList.getEntityName(entityId)));
                    tag.put("Delay", new ShortTag(20));
                    tag.put("x", new IntTag(pos.x()));
                    tag.put("y", new IntTag(pos.y()));
                    tag.put("z", new IntTag(pos.z()));
                    wrapper.write(Types1_7_6.COMPRESSED_NBT, tag);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_2_4.PLAYER_ABILITIES, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    boolean disableDamage = wrapper.read(Type.BOOLEAN);
                    boolean flying = wrapper.read(Type.BOOLEAN);
                    boolean allowFlying = wrapper.read(Type.BOOLEAN);
                    boolean creativeMode = wrapper.read(Type.BOOLEAN);
                    byte mask = 0;
                    if (disableDamage) {
                        mask = (byte)(mask | 1);
                    }
                    if (flying) {
                        mask = (byte)(mask | 2);
                    }
                    if (allowFlying) {
                        mask = (byte)(mask | 4);
                    }
                    if (creativeMode) {
                        mask = (byte)(mask | 8);
                    }
                    wrapper.write(Type.BYTE, mask);
                    wrapper.write(Type.BYTE, (byte)12);
                    wrapper.write(Type.BYTE, (byte)25);
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundPackets1_3_1.CLIENT_PROTOCOL.getId(), ServerboundPackets1_2_4.HANDSHAKE.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.read(Type.UNSIGNED_BYTE);
                    String userName = wrapper.read(Types1_6_4.STRING);
                    String hostname = wrapper.read(Types1_6_4.STRING);
                    int port = wrapper.read(Type.INT);
                    wrapper.write(Types1_6_4.STRING, userName + ";" + hostname + ":" + port);
                });
            }
        });
        this.cancelServerbound(ServerboundPackets1_3_1.CLIENT_PROTOCOL);
        this.cancelServerbound(ServerboundPackets1_3_1.SHARED_KEY);
        this.registerServerbound(ServerboundPackets1_3_1.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    AbstractTrackedEntity player = entityTracker.getTrackedEntities().get(entityTracker.getPlayerID());
                    if (wrapper.get(Type.DOUBLE, 1) == -999.0 && wrapper.get(Type.DOUBLE, 2) == -999.0) {
                        player.setRiding(true);
                    } else {
                        player.setRiding(false);
                        player.getLocation().setX(wrapper.get(Type.DOUBLE, 0));
                        player.getLocation().setY(wrapper.get(Type.DOUBLE, 1));
                        player.getLocation().setZ(wrapper.get(Type.DOUBLE, 3));
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_3_1.PLAYER_POSITION_AND_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    AbstractTrackedEntity player = entityTracker.getTrackedEntities().get(entityTracker.getPlayerID());
                    if (wrapper.get(Type.DOUBLE, 1) == -999.0 && wrapper.get(Type.DOUBLE, 2) == -999.0) {
                        player.setRiding(true);
                    } else {
                        player.setRiding(false);
                        player.getLocation().setX(wrapper.get(Type.DOUBLE, 0));
                        player.getLocation().setY(wrapper.get(Type.DOUBLE, 1));
                        player.getLocation().setZ(wrapper.get(Type.DOUBLE, 3));
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_3_1.PLAYER_BLOCK_PLACEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Types1_7_6.COMPRESSED_ITEM, Types1_2_4.COMPRESSED_NBT_ITEM);
                this.read(Type.UNSIGNED_BYTE);
                this.read(Type.UNSIGNED_BYTE);
                this.read(Type.UNSIGNED_BYTE);
            }
        });
        this.registerServerbound(ServerboundPackets1_3_1.CLICK_WINDOW, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.BYTE);
                this.map(Types1_7_6.COMPRESSED_ITEM, Types1_2_4.COMPRESSED_NBT_ITEM);
            }
        });
        this.registerServerbound(ServerboundPackets1_3_1.CREATIVE_INVENTORY_ACTION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.SHORT);
                this.map(Types1_7_6.COMPRESSED_ITEM, Types1_2_4.COMPRESSED_NBT_ITEM);
                this.handler(wrapper -> Protocol1_3_1_2to1_2_4_5.this.itemRewriter.handleItemToServer(wrapper.get(Types1_2_4.COMPRESSED_NBT_ITEM, 0)));
            }
        });
        this.registerServerbound(ServerboundPackets1_3_1.PLAYER_ABILITIES, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    byte mask = wrapper.read(Type.BYTE);
                    wrapper.read(Type.BYTE);
                    wrapper.read(Type.BYTE);
                    boolean disableDamage = (mask & 1) > 0;
                    boolean flying = (mask & 2) > 0;
                    boolean allowFlying = (mask & 4) > 0;
                    boolean creativeMode = (mask & 8) > 0;
                    wrapper.write(Type.BOOLEAN, disableDamage);
                    wrapper.write(Type.BOOLEAN, flying);
                    wrapper.write(Type.BOOLEAN, allowFlying);
                    wrapper.write(Type.BOOLEAN, creativeMode);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_3_1.CLIENT_STATUS, ServerboundPackets1_2_4.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    byte action = wrapper.read(Type.BYTE);
                    if (action != 1) {
                        wrapper.cancel();
                    }
                    wrapper.write(Type.INT, 0);
                    wrapper.write(Type.BYTE, (byte)0);
                    wrapper.write(Type.BYTE, (byte)0);
                    wrapper.write(Type.SHORT, (short)0);
                    wrapper.write(Types1_6_4.STRING, "");
                });
            }
        });
        this.cancelServerbound(ServerboundPackets1_3_1.TAB_COMPLETE);
        this.cancelServerbound(ServerboundPackets1_3_1.CLIENT_SETTINGS);
    }

    private void handleEntityMetadata(int entityId, List<Metadata> metadataList, PacketWrapper wrapper) throws Exception {
        EntityTracker tracker = wrapper.user().get(EntityTracker.class);
        if (entityId == tracker.getPlayerID()) {
            return;
        }
        AbstractTrackedEntity entity = tracker.getTrackedEntities().get(entityId);
        for (Metadata metadata : metadataList) {
            if (MetaIndex1_6_1to1_5_2.searchIndex(entity.getEntityType(), metadata.id()) != null) continue;
            MetaIndex1_8to1_7_6 index = MetaIndex1_8to1_7_6.searchIndex(entity.getEntityType(), metadata.id());
            if (index == MetaIndex1_8to1_7_6.ENTITY_FLAGS) {
                if (((Byte)metadata.value() & 4) != 0) {
                    Optional<AbstractTrackedEntity> oNearbyEntity = tracker.getNearestEntity(entity.getLocation(), 1.0, e -> e.getEntityType().isOrHasParent(Entity1_10Types.EntityType.MINECART_RIDEABLE) || e.getEntityType().isOrHasParent(Entity1_10Types.EntityType.PIG) || e.getEntityType().isOrHasParent(Entity1_10Types.EntityType.BOAT));
                    if (!oNearbyEntity.isPresent()) break;
                    entity.setRiding(true);
                    AbstractTrackedEntity nearbyEntity = oNearbyEntity.get();
                    PacketWrapper attachEntity = PacketWrapper.create(ClientboundPackets1_3_1.ATTACH_ENTITY, wrapper.user());
                    attachEntity.write(Type.INT, entityId);
                    attachEntity.write(Type.INT, nearbyEntity.getEntityId());
                    wrapper.send(Protocol1_3_1_2to1_2_4_5.class);
                    attachEntity.send(Protocol1_3_1_2to1_2_4_5.class);
                    wrapper.cancel();
                    break;
                }
                if (((Byte)metadata.value() & 4) != 0 || !entity.isRiding()) break;
                entity.setRiding(false);
                PacketWrapper detachEntity = PacketWrapper.create(ClientboundPackets1_3_1.ATTACH_ENTITY, wrapper.user());
                detachEntity.write(Type.INT, entityId);
                detachEntity.write(Type.INT, -1);
                detachEntity.send(Protocol1_3_1_2to1_2_4_5.class);
                wrapper.send(Protocol1_3_1_2to1_2_4_5.class);
                wrapper.cancel();
                break;
            }
            if (index != MetaIndex1_8to1_7_6.CREEPER_STATE || (Byte)metadata.value() <= 0) continue;
            tracker.playSoundAt(entity.getLocation(), Sound.RANDOM_FUSE, 1.0f, 0.5f);
        }
    }

    private void handleHandshake(PacketWrapper wrapper) throws Exception {
        ProtocolInfo info = wrapper.user().getProtocolInfo();
        String serverHash = wrapper.read(Types1_6_4.STRING);
        if (!serverHash.trim().isEmpty() && !serverHash.equalsIgnoreCase("-")) {
            try {
                Via.getManager().getProviders().get(OldAuthProvider.class).sendAuthRequest(wrapper.user(), serverHash);
            }
            catch (Throwable e) {
                ViaLegacy.getPlatform().getLogger().log(Level.WARNING, "Could not authenticate with mojang for joinserver request!", e);
                wrapper.cancel();
                PacketWrapper kick = PacketWrapper.create(ClientboundPackets1_3_1.DISCONNECT, wrapper.user());
                kick.write(Types1_6_4.STRING, "Failed to log in: Invalid session (Try restarting your game and the launcher)");
                kick.send(Protocol1_3_1_2to1_2_4_5.class);
                return;
            }
        }
        PacketWrapper login = PacketWrapper.create(ServerboundPackets1_2_4.LOGIN, wrapper.user());
        login.write(Type.INT, -(info.getServerProtocolVersion() >> 2));
        login.write(Types1_6_4.STRING, info.getUsername());
        login.write(Types1_6_4.STRING, "");
        login.write(Type.INT, 0);
        login.write(Type.INT, 0);
        login.write(Type.BYTE, (byte)0);
        login.write(Type.BYTE, (byte)0);
        login.write(Type.BYTE, (byte)0);
        State oldState = info.getState();
        info.setState(State.LOGIN);
        login.sendToServer(Protocol1_3_1_2to1_2_4_5.class);
        info.setState(oldState);
    }

    @Override
    public void register(ViaProviders providers) {
        providers.register(OldAuthProvider.class, new OldAuthProvider());
        if (ViaLegacy.getConfig().isSoundEmulation()) {
            Via.getPlatform().runRepeatingSync(new EntityTrackerTickTask(), 1L);
        }
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocol1_3_1_2to1_2_4_5.class, ClientboundPackets1_2_4::getPacket));
        userConnection.put(new ChestStateTracker(userConnection));
        userConnection.put(new EntityTracker(userConnection));
        userConnection.put(new DimensionTracker(userConnection));
        if (!userConnection.has(ClientWorld.class)) {
            userConnection.put(new ClientWorld(userConnection));
        }
    }

    @Override
    public LegacyItemRewriter<Protocol1_3_1_2to1_2_4_5> getItemRewriter() {
        return this.itemRewriter;
    }
}

