/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model;

import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import java.util.List;
import net.raphimc.vialegacy.api.model.Location;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.AbstractTrackedEntity;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.ConfiguredSound;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.SoundEmulation;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.SoundType;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.storage.EntityTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.metadata.MetaIndex1_6_1to1_5_2;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata.MetaIndex1_8to1_7_6;

public class TrackedLivingEntity
extends AbstractTrackedEntity {
    private int soundTime;
    public int growingAge;
    public boolean isTamed;
    public int wolfHealth;
    public boolean wolfIsAngry;

    public TrackedLivingEntity(int entityId, Location location, Entity1_10Types.EntityType entityType) {
        super(entityId, location, entityType);
    }

    public void tick(EntityTracker tracker) {
        if (tracker.RND.nextInt(1000) < this.soundTime++) {
            this.soundTime = SoundEmulation.getSoundDelayTime(this.getEntityType());
            tracker.playSound(this.getEntityId(), SoundType.IDLE);
        }
        if (this.getEntityType().isOrHasParent(Entity1_10Types.EntityType.ENTITY_AGEABLE)) {
            if (this.growingAge < 0) {
                ++this.growingAge;
            } else if (this.growingAge > 0) {
                --this.growingAge;
            }
        }
    }

    public void updateMetadata(List<Metadata> metadataList) {
        for (Metadata metadata : metadataList) {
            MetaIndex1_6_1to1_5_2 index = MetaIndex1_6_1to1_5_2.searchIndex(this.getEntityType(), metadata.id());
            MetaIndex1_8to1_7_6 index2 = MetaIndex1_8to1_7_6.searchIndex(this.getEntityType(), metadata.id());
            if (index == MetaIndex1_6_1to1_5_2.WOLF_HEALTH) {
                this.wolfHealth = (Integer)metadata.value();
            } else if (index != null) continue;
            if (index2 == MetaIndex1_8to1_7_6.ENTITY_AGEABLE_AGE) {
                this.growingAge = (Integer)metadata.value();
                continue;
            }
            if (index2 != MetaIndex1_8to1_7_6.TAMEABLE_FLAGS) continue;
            this.isTamed = ((Byte)metadata.value() & 4) != 0;
            this.wolfIsAngry = ((Byte)metadata.value() & 2) != 0;
        }
    }

    public void applyPitch(EntityTracker tracker, ConfiguredSound sound) {
        float pitch = this.getEntityType().isOrHasParent(Entity1_10Types.EntityType.ENTITY_AGEABLE) && this.growingAge < 0 ? (tracker.RND.nextFloat() - tracker.RND.nextFloat()) * 0.2f + 1.5f : (tracker.RND.nextFloat() - tracker.RND.nextFloat()) * 0.2f + 1.0f;
        sound.setPitch(pitch);
    }
}

