/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound;

import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.ConfiguredSound;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.Sound;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.SoundType;

public class SoundEmulation {
    private static final Sound[][] ENTITY_SOUNDS = new Sound[256][];
    private static final float[] VOL_ADJUST = new float[256];
    private static final int[] INTERVAL_ADJUST = new int[256];

    public static ConfiguredSound getEntitySound(Entity1_10Types.EntityType entityType, SoundType soundType) {
        Sound[] entitySounds;
        ConfiguredSound sound = new ConfiguredSound(Sound.NO_SOUND, 0.0f, 1.0f);
        int entityTypeID = entityType.getId();
        if (entityType.isOrHasParent(Entity1_10Types.EntityType.PLAYER)) {
            entityTypeID = 48;
        }
        if ((entitySounds = ENTITY_SOUNDS[entityTypeID]) == null) {
            return sound;
        }
        switch (soundType) {
            case IDLE: {
                sound = new ConfiguredSound(entitySounds[0], 1.0f, 1.0f);
                break;
            }
            case HURT: {
                sound = new ConfiguredSound(entitySounds[1], 1.0f, 1.0f);
                break;
            }
            case DEATH: {
                sound = new ConfiguredSound(entitySounds[2], 1.0f, 1.0f);
            }
        }
        float correctedVolume = VOL_ADJUST[entityTypeID];
        if (correctedVolume != 0.0f) {
            sound.setVolume(correctedVolume);
        }
        return sound;
    }

    public static int getSoundDelayTime(Entity1_10Types.EntityType entityType) {
        int entityTypeID = entityType.getId();
        if (entityType.isOrHasParent(Entity1_10Types.EntityType.PLAYER)) {
            entityTypeID = 48;
        }
        int soundTime = -80;
        int ajustedSoundTime = INTERVAL_ADJUST[entityTypeID];
        if (ajustedSoundTime != 0) {
            soundTime = -ajustedSoundTime;
        }
        return soundTime;
    }

    static {
        SoundEmulation.ENTITY_SOUNDS[48] = new Sound[]{Sound.NO_SOUND, Sound.MOB_HUMAN_HURT, Sound.MOB_HUMAN_HURT};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.CREEPER.getId()] = new Sound[]{Sound.NO_SOUND, Sound.MOB_CREEPER, Sound.MOB_CREEPER_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.SKELETON.getId()] = new Sound[]{Sound.MOB_SKELETON, Sound.MOB_SKELETON_HURT, Sound.MOB_SKELETON_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.SPIDER.getId()] = new Sound[]{Sound.MOB_SPIDER, Sound.MOB_SPIDER, Sound.MOB_SPIDER_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.GIANT.getId()] = new Sound[]{Sound.NO_SOUND, Sound.MOB_HUMAN_HURT, Sound.MOB_HUMAN_HURT};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.ZOMBIE.getId()] = new Sound[]{Sound.MOB_ZOMBIE, Sound.MOB_ZOMBIE_HURT, Sound.MOB_ZOMBIE_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.SLIME.getId()] = new Sound[]{Sound.MOB_SLIME, Sound.MOB_SLIME, Sound.MOB_SLIME};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.GHAST.getId()] = new Sound[]{Sound.MOB_GHAST, Sound.MOB_GHAST_HURT, Sound.MOB_GHAST_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.PIG_ZOMBIE.getId()] = new Sound[]{Sound.MOB_PIG_ZOMBIE, Sound.MOB_PIG_ZOMBIE_HURT, Sound.MOB_PIG_ZOMBIE_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.ENDERMAN.getId()] = new Sound[]{Sound.MOB_ENDERMEN, Sound.MOB_ENDERMEN_HURT, Sound.MOB_ENDERMEN_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.CAVE_SPIDER.getId()] = new Sound[]{Sound.MOB_SPIDER, Sound.MOB_SPIDER, Sound.MOB_SPIDER_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.SILVERFISH.getId()] = new Sound[]{Sound.MOB_SILVERFISH, Sound.MOB_SILVERFISH_HURT, Sound.MOB_SILVERFISH_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.BLAZE.getId()] = new Sound[]{Sound.MOB_BLAZE, Sound.MOB_BLAZE_HURT, Sound.MOB_BLAZE_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.MAGMA_CUBE.getId()] = new Sound[]{Sound.MOB_MAGMACUBE_SMALL, Sound.MOB_SLIME, Sound.MOB_SLIME};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.ENDER_DRAGON.getId()] = new Sound[]{Sound.NO_SOUND, Sound.MOB_HUMAN_HURT, Sound.MOB_HUMAN_HURT};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.PIG.getId()] = new Sound[]{Sound.MOB_PIG, Sound.MOB_PIG, Sound.MOB_PIG_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.SHEEP.getId()] = new Sound[]{Sound.MOB_SHEEP, Sound.MOB_SHEEP, Sound.MOB_SHEEP};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.COW.getId()] = new Sound[]{Sound.MOB_COW, Sound.MOB_COW_HURT, Sound.MOB_COW_HURT};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.CHICKEN.getId()] = new Sound[]{Sound.MOB_CHICKEN, Sound.MOB_CHICKEN_HURT, Sound.MOB_CHICKEN_HURT};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.SQUID.getId()] = new Sound[]{Sound.NO_SOUND, Sound.NO_SOUND, Sound.NO_SOUND};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.WOLF.getId()] = new Sound[]{Sound.MOB_WOLF, Sound.MOB_WOLF_HURT, Sound.MOB_WOLF_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.MUSHROOM_COW.getId()] = new Sound[]{Sound.MOB_COW, Sound.MOB_COW_HURT, Sound.MOB_COW_HURT};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.SNOWMAN.getId()] = new Sound[]{Sound.NO_SOUND, Sound.NO_SOUND, Sound.NO_SOUND};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.OCELOT.getId()] = new Sound[]{Sound.NO_SOUND, Sound.MOB_CAT_HURT, Sound.MOB_CAT_HURT};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.IRON_GOLEM.getId()] = new Sound[]{Sound.NO_SOUND, Sound.MOB_IRON_GOLEM_HURT, Sound.MOB_IRON_GOLEM_DEATH};
        SoundEmulation.ENTITY_SOUNDS[Entity1_10Types.EntityType.VILLAGER.getId()] = new Sound[]{Sound.MOB_VILLAGER, Sound.MOB_VILLAGER_HURT, Sound.MOB_VILLAGER_DEATH};
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.SLIME.getId()] = 1.6f;
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.MAGMA_CUBE.getId()] = 1.6f;
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.GHAST.getId()] = 10.0f;
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.COW.getId()] = 0.4f;
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.WOLF.getId()] = 0.4f;
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.SQUID.getId()] = 0.4f;
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.MUSHROOM_COW.getId()] = 0.4f;
        SoundEmulation.VOL_ADJUST[Entity1_10Types.EntityType.OCELOT.getId()] = 0.4f;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.PIG.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.SHEEP.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.WOLF.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.SNOWMAN.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.IRON_GOLEM.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.MUSHROOM_COW.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.COW.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.CHICKEN.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.SQUID.getId()] = 120;
        SoundEmulation.INTERVAL_ADJUST[Entity1_10Types.EntityType.OCELOT.getId()] = 120;
    }
}

