/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChestStateTracker
extends StoredObject {
    private final Set<Position> openChests = new HashSet<Position>();

    public ChestStateTracker(UserConnection userConnection) {
        super(userConnection);
    }

    public void openChest(Position position) {
        this.openChests.add(position);
    }

    public void closeChest(Position position) {
        this.openChests.remove(position);
    }

    public boolean isChestOpen(Position position) {
        return this.openChests.contains(position);
    }

    public void clear() {
        this.openChests.clear();
    }

    public void unload(int chunkX, int chunkZ) {
        Iterator<Position> it = this.openChests.iterator();
        while (it.hasNext()) {
            Position entry = it.next();
            int x = entry.x() >> 4;
            int z = entry.z() >> 4;
            if (chunkX != x || chunkZ != z) continue;
            it.remove();
        }
    }
}

