/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.util.MathUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.model.Location;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.Protocol1_3_1_2to1_2_4_5;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.AbstractTrackedEntity;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.ConfiguredSound;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.model.TrackedLivingEntity;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.Sound;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.SoundEmulation;
import net.raphimc.vialegacy.protocols.release.protocol1_3_1_2to1_2_4_5.sound.SoundType;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.ClientboundPackets1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;

public class EntityTracker
extends StoredObject {
    public final Random RND = new Random();
    private final Map<Integer, AbstractTrackedEntity> entityMap = new ConcurrentHashMap<Integer, AbstractTrackedEntity>();
    private int playerID;

    public EntityTracker(UserConnection user) {
        super(user);
    }

    public int getPlayerID() {
        return this.playerID;
    }

    public void setPlayerID(int playerID) {
        this.playerID = playerID;
    }

    public Map<Integer, AbstractTrackedEntity> getTrackedEntities() {
        return this.entityMap;
    }

    public void updateEntityLocation(int entityId, int x, int y, int z, boolean relative) {
        AbstractTrackedEntity entity = this.entityMap.get(entityId);
        if (entity != null) {
            Location oldLoc = entity.getLocation();
            double xPos = (double)x / 32.0;
            double yPos = (double)y / 32.0;
            double zPos = (double)z / 32.0;
            Location newLoc = relative ? new Location(oldLoc.getX() + xPos, oldLoc.getY() + yPos, oldLoc.getZ() + zPos) : new Location(xPos, yPos, zPos);
            entity.setLocation(newLoc);
        }
    }

    public void updateEntityMetadata(int entityId, List<Metadata> metadataList) {
        AbstractTrackedEntity entity = this.entityMap.get(entityId);
        if (entity instanceof TrackedLivingEntity) {
            TrackedLivingEntity livingEntity = (TrackedLivingEntity)entity;
            livingEntity.updateMetadata(metadataList);
        }
    }

    public Optional<AbstractTrackedEntity> getNearestEntity(Location location, double range, Predicate<AbstractTrackedEntity> entityPredicate) {
        return this.entityMap.values().stream().filter(entityPredicate).filter(e -> !e.getLocation().equals(location)).filter(e -> e.getLocation().distanceTo(location) <= range).min(Comparator.comparingDouble(o -> o.getLocation().distanceTo(location)));
    }

    public void tick() {
        for (AbstractTrackedEntity entity : this.entityMap.values()) {
            if (!(entity instanceof TrackedLivingEntity)) continue;
            TrackedLivingEntity livingEntity = (TrackedLivingEntity)entity;
            livingEntity.tick(this);
        }
    }

    public void playSound(int entityId, SoundType type) {
        if (this.playerID == entityId && type == SoundType.HURT) {
            return;
        }
        if (this.entityMap.get(entityId) != null) {
            AbstractTrackedEntity entity = this.entityMap.get(entityId);
            ConfiguredSound sound = SoundEmulation.getEntitySound(entity.getEntityType(), type);
            Location entityLocation = entity.getLocation();
            Location playerLocation = this.entityMap.get(this.playerID).getLocation();
            if (entity instanceof TrackedLivingEntity && type == SoundType.IDLE) {
                TrackedLivingEntity livingEntity = (TrackedLivingEntity)entity;
                livingEntity.applyPitch(this, sound);
                if (entity.getEntityType().isOrHasParent(Entity1_10Types.EntityType.WOLF)) {
                    if (livingEntity.wolfIsAngry) {
                        sound.setSound(Sound.MOB_WOLF_GROWL);
                    } else if (this.RND.nextInt(3) == 0) {
                        sound.setSound(livingEntity.isTamed && livingEntity.wolfHealth < 10 ? Sound.MOB_WOLF_WHINE : Sound.MOB_WOLF_PANTING);
                    }
                } else if (entity.getEntityType().isOrHasParent(Entity1_10Types.EntityType.OCELOT) && livingEntity.isTamed) {
                    sound.setSound(this.RND.nextInt(4) == 0 ? Sound.MOB_CAT_PURREOW : Sound.MOB_CAT_MEOW);
                }
            }
            if (Sound.NO_SOUND.equals((Object)sound.getSound())) {
                return;
            }
            this.playSoundAt(entityLocation, playerLocation, sound);
        }
    }

    public void playSoundAt(Location entityLocation, Sound sound, float volume, float pitch) {
        Location playerLocation = this.entityMap.get(this.playerID).getLocation();
        this.playSoundAt(entityLocation, playerLocation, new ConfiguredSound(sound, volume, pitch));
    }

    public static short constrainToRange(short value, short min, short max) {
        return value < min ? min : (value < max ? value : max);
    }

    private void playSoundAt(Location sourceLocation, Location targetLocation, ConfiguredSound sound) {
        if (!ViaLegacy.getConfig().isSoundEmulation()) {
            return;
        }
        short correctedPitch = (short)MathUtil.clamp((int)(sound.getPitch() * 63.0f), 0, 255);
        float vol = sound.getVolume();
        float range = 16.0f;
        if (vol > 1.0f) {
            range *= vol;
        }
        if (targetLocation.distanceTo(sourceLocation) > (double)range) {
            return;
        }
        try {
            PacketWrapper entitySound = PacketWrapper.create(ClientboundPackets1_3_1.NAMED_SOUND, this.getUser());
            entitySound.write(Types1_6_4.STRING, sound.getSound().getSoundName());
            entitySound.write(Type.INT, (int)sourceLocation.getX() * 8);
            entitySound.write(Type.INT, (int)sourceLocation.getY() * 8);
            entitySound.write(Type.INT, (int)sourceLocation.getZ() * 8);
            entitySound.write(Type.FLOAT, Float.valueOf(vol));
            entitySound.write(Type.UNSIGNED_BYTE, correctedPitch);
            entitySound.send(Protocol1_3_1_2to1_2_4_5.class);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

