/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2;

import com.google.common.collect.Lists;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import java.util.List;
import java.util.logging.Level;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.data.ItemList1_6;
import net.raphimc.vialegacy.api.remapper.LegacyItemRewriter;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.ClientboundPackets1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.ServerboundPackets1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.rewriter.ItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.rewriter.SoundRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_4_2to1_3_1_2.types.Types1_3_1;
import net.raphimc.vialegacy.protocols.release.protocol1_4_4_5to1_4_2.ClientboundPackets1_4_2;
import net.raphimc.vialegacy.protocols.release.protocol1_4_4_5to1_4_2.types.MetaType1_4_2;
import net.raphimc.vialegacy.protocols.release.protocol1_4_4_5to1_4_2.types.Types1_4_2;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.ServerboundPackets1_5_2;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.storage.EntityTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata.MetaIndex1_8to1_7_6;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocol1_4_2to1_3_1_2
extends AbstractProtocol<ClientboundPackets1_3_1, ClientboundPackets1_4_2, ServerboundPackets1_3_1, ServerboundPackets1_5_2> {
    private final LegacyItemRewriter<Protocol1_4_2to1_3_1_2> itemRewriter = new ItemRewriter(this);

    public Protocol1_4_2to1_3_1_2() {
        super(ClientboundPackets1_3_1.class, ClientboundPackets1_4_2.class, ServerboundPackets1_3_1.class, ServerboundPackets1_5_2.class);
    }

    @Override
    protected void registerPackets() {
        this.itemRewriter.register();
        this.registerClientbound(State.STATUS, ClientboundPackets1_3_1.DISCONNECT.getId(), ClientboundPackets1_4_2.DISCONNECT.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String reason = wrapper.read(Types1_6_4.STRING);
                    try {
                        ProtocolInfo info = wrapper.user().getProtocolInfo();
                        String[] pingParts = reason.split("\u00a7");
                        String out = "\u00a71\u0000" + (-info.getServerProtocolVersion() >> 2) + "\u0000" + ProtocolVersion.getProtocol(info.getServerProtocolVersion()).getName() + "\u0000" + pingParts[0] + "\u0000" + pingParts[1] + "\u0000" + pingParts[2];
                        wrapper.write(Types1_6_4.STRING, out);
                    }
                    catch (Throwable e) {
                        ViaLegacy.getPlatform().getLogger().log(Level.WARNING, "Could not parse 1.3.1 ping: " + reason, e);
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.JOIN_GAME, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    wrapper.send(Protocol1_4_2to1_3_1_2.class);
                    wrapper.cancel();
                    PacketWrapper entityMetadata = PacketWrapper.create(ClientboundPackets1_4_2.ENTITY_METADATA, wrapper.user());
                    entityMetadata.write(Type.INT, wrapper.get(Type.INT, 0));
                    entityMetadata.write(Types1_4_2.METADATA_LIST, Lists.newArrayList((Object[])new Metadata[]{new Metadata(MetaIndex1_8to1_7_6.HUMAN_SKIN_FLAGS.getOldIndex(), MetaType1_4_2.Byte, (byte)0)}));
                    entityMetadata.send(Protocol1_4_2to1_3_1_2.class);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.TIME_UPDATE, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    long time = wrapper.passthrough(Type.LONG);
                    wrapper.write(Type.LONG, time % 24000L);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Types1_6_4.STRING);
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    Integer[] entityIds = (Integer[])entityTracker.getTrackedEntities().keySet().stream().filter(i -> i.intValue() != entityTracker.getPlayerID()).toArray(Integer[]::new);
                    int[] primitiveInts = new int[entityIds.length];
                    for (int i2 = 0; i2 < entityIds.length; ++i2) {
                        primitiveInts[i2] = entityIds[i2];
                    }
                    PacketWrapper destroyEntities = PacketWrapper.create(ClientboundPackets1_4_2.DESTROY_ENTITIES, wrapper.user());
                    destroyEntities.write(Types1_7_6.INT_ARRAY, primitiveInts);
                    destroyEntities.send(Protocol1_4_2to1_3_1_2.class);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.SPAWN_PLAYER, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.UNSIGNED_SHORT);
                this.map(Types1_3_1.METADATA_LIST, Types1_4_2.METADATA_LIST);
                this.handler(wrapper -> Protocol1_4_2to1_3_1_2.this.rewriteMetadata(wrapper.get(Types1_4_2.METADATA_LIST, 0)));
                this.handler(wrapper -> {
                    List<Metadata> metadataList = wrapper.get(Types1_4_2.METADATA_LIST, 0);
                    metadataList.removeIf(metadata -> metadata.metaType() == MetaType1_4_2.Byte && metadata.id() == MetaIndex1_8to1_7_6.HUMAN_SKIN_FLAGS.getOldIndex());
                    metadataList.add(new Metadata(MetaIndex1_8to1_7_6.HUMAN_SKIN_FLAGS.getOldIndex(), MetaType1_4_2.Byte, (byte)0));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.SPAWN_ITEM, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_3_1.NBTLESS_ITEM, Types1_7_6.COMPRESSED_ITEM);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.SPAWN_MOB, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Types1_3_1.METADATA_LIST, Types1_4_2.METADATA_LIST);
                this.handler(wrapper -> Protocol1_4_2to1_3_1_2.this.rewriteMetadata(wrapper.get(Types1_4_2.METADATA_LIST, 0)));
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Type.INT, 0);
                    short typeId = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    if (typeId == Entity1_10Types.EntityType.SKELETON.getId()) {
                        Protocol1_4_2to1_3_1_2.this.setMobHandItem(entityId, new DataItem(ItemList1_6.bow.itemID, 1, 0, null), wrapper);
                    } else if (typeId == Entity1_10Types.EntityType.PIG_ZOMBIE.getId()) {
                        Protocol1_4_2to1_3_1_2.this.setMobHandItem(entityId, new DataItem(ItemList1_6.swordGold.itemID, 1, 0, null), wrapper);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.SPAWN_PAINTING, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.map(Types1_7_6.POSITION_INT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int direction = wrapper.get(Type.INT, 1);
                    switch (direction) {
                        case 0: {
                            direction = 2;
                            break;
                        }
                        case 2: {
                            direction = 0;
                        }
                    }
                    wrapper.set(Type.INT, 1, direction);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.ENTITY_METADATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_3_1.METADATA_LIST, Types1_4_2.METADATA_LIST);
                this.handler(wrapper -> Protocol1_4_2to1_3_1_2.this.rewriteMetadata(wrapper.get(Types1_4_2.METADATA_LIST, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.EFFECT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.INT);
                this.create(Type.BOOLEAN, false);
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.NAMED_SOUND, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String oldSound = wrapper.read(Types1_6_4.STRING);
                    String newSound = SoundRewriter.map(oldSound);
                    if (oldSound.isEmpty()) {
                        newSound = "";
                    }
                    if (newSound == null) {
                        ViaLegacy.getPlatform().getLogger().warning("Unable to map 1.3.2 sound '" + oldSound + "'");
                        newSound = "";
                    }
                    if (newSound.isEmpty()) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Types1_6_4.STRING, newSound);
                });
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.FLOAT);
                this.map(Type.UNSIGNED_BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.MAP_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Types1_4_2.UNSIGNED_BYTE_BYTE_ARRAY);
                this.handler(wrapper -> {
                    byte[] data = wrapper.get(Types1_4_2.UNSIGNED_BYTE_BYTE_ARRAY, 0);
                    if (data[0] == 1) {
                        for (int i = 0; i < (data.length - 1) / 3; ++i) {
                            byte icon = (byte)(data[i * 3 + 1] % 16);
                            byte centerX = data[i * 3 + 2];
                            byte centerZ = data[i * 3 + 3];
                            byte iconRotation = (byte)(data[i * 3 + 1] / 16);
                            data[i * 3 + 1] = (byte)(icon << 4 | iconRotation & 0xF);
                            data[i * 3 + 2] = centerX;
                            data[i * 3 + 3] = centerZ;
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_3_1.PLUGIN_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING);
                this.handler(wrapper -> {
                    String channel = wrapper.get(Types1_6_4.STRING, 0);
                    wrapper.passthrough(Type.SHORT);
                    if (channel.equalsIgnoreCase("MC|TrList")) {
                        wrapper.passthrough(Type.INT);
                        int count = wrapper.passthrough(Type.UNSIGNED_BYTE).shortValue();
                        for (int i = 0; i < count; ++i) {
                            wrapper.passthrough(Types1_7_6.COMPRESSED_ITEM);
                            wrapper.passthrough(Types1_7_6.COMPRESSED_ITEM);
                            if (wrapper.passthrough(Type.BOOLEAN).booleanValue()) {
                                wrapper.passthrough(Types1_7_6.COMPRESSED_ITEM);
                            }
                            wrapper.write(Type.BOOLEAN, false);
                        }
                    }
                });
            }
        });
        this.registerServerbound(State.STATUS, ServerboundPackets1_5_2.SERVER_PING.getId(), ServerboundPackets1_3_1.SERVER_PING.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(PacketWrapper::clearPacket);
            }
        });
        this.registerServerbound(ServerboundPackets1_5_2.CLIENT_SETTINGS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.read(Type.BOOLEAN);
            }
        });
    }

    private void rewriteMetadata(List<Metadata> metadataList) {
        for (Metadata metadata : metadataList) {
            metadata.setMetaType(MetaType1_4_2.byId(metadata.metaType().typeId()));
        }
    }

    private void setMobHandItem(int entityId, Item item, PacketWrapper wrapper) throws Exception {
        PacketWrapper handItem = PacketWrapper.create(ClientboundPackets1_4_2.ENTITY_EQUIPMENT, wrapper.user());
        handItem.write(Type.INT, entityId);
        handItem.write(Type.SHORT, (short)0);
        handItem.write(Types1_7_6.COMPRESSED_ITEM, item);
        wrapper.send(Protocol1_4_2to1_3_1_2.class);
        handItem.send(Protocol1_4_2to1_3_1_2.class);
        wrapper.cancel();
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocol1_4_2to1_3_1_2.class, ClientboundPackets1_3_1::getPacket));
    }

    @Override
    public LegacyItemRewriter<Protocol1_4_2to1_3_1_2> getItemRewriter() {
        return this.itemRewriter;
    }
}

