/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import java.util.List;
import net.lenni0451.mcstructs.text.components.StringComponent;
import net.lenni0451.mcstructs.text.serializer.TextComponentSerializer;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.remapper.LegacyItemRewriter;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.ClientboundPackets1_5_2;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.ServerboundPackets1_5_2;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.metadata.MetadataRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.rewriter.ItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.rewriter.SoundRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.storage.AttachTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.storage.EntityTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_6_2to1_6_1.ClientboundPackets1_6_1;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.ServerboundPackets1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata.MetaIndex1_8to1_7_6;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocol1_6_1to1_5_2
extends AbstractProtocol<ClientboundPackets1_5_2, ClientboundPackets1_6_1, ServerboundPackets1_5_2, ServerboundPackets1_6_4> {
    private final LegacyItemRewriter<Protocol1_6_1to1_5_2> itemRewriter = new ItemRewriter(this);

    public Protocol1_6_1to1_5_2() {
        super(ClientboundPackets1_5_2.class, ClientboundPackets1_6_1.class, ServerboundPackets1_5_2.class, ServerboundPackets1_6_4.class);
    }

    @Override
    protected void registerPackets() {
        this.itemRewriter.register();
        this.registerClientbound(ClientboundPackets1_5_2.JOIN_GAME, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Type.INT, 0);
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    tracker.getTrackedEntities().put(entityId, Entity1_10Types.EntityType.PLAYER);
                    tracker.setPlayerID(entityId);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.CHAT_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Types1_6_4.STRING, msg -> TextComponentSerializer.V1_6.serialize(new StringComponent((String)msg)));
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.UPDATE_HEALTH, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.SHORT, Type.FLOAT);
                this.map(Type.SHORT);
                this.map(Type.FLOAT);
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.SPAWN_PLAYER, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.UNSIGNED_SHORT);
                this.map(Types1_6_4.METADATA_LIST);
                this.handler(wrapper -> MetadataRewriter.transform(Entity1_10Types.EntityType.PLAYER, wrapper.get(Types1_6_4.METADATA_LIST, 0)));
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Type.INT, 0);
                    wrapper.user().get(EntityTracker.class).getTrackedEntities().put(entityId, Entity1_10Types.EntityType.PLAYER);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.COLLECT_ITEM, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.handler(wrapper -> wrapper.user().get(EntityTracker.class).getTrackedEntities().remove(wrapper.get(Type.INT, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.SPAWN_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int entityID = wrapper.get(Type.INT, 0);
                    byte typeID = wrapper.get(Type.BYTE, 0);
                    wrapper.user().get(EntityTracker.class).getTrackedEntities().put(entityID, Entity1_10Types.getTypeFromId(typeID, true));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.SPAWN_MOB, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Types1_6_4.METADATA_LIST);
                this.handler(wrapper -> {
                    int entityID = wrapper.get(Type.INT, 0);
                    short typeID = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    Entity1_10Types.EntityType entityType = Entity1_10Types.getTypeFromId(typeID, false);
                    List<Metadata> metadataList = wrapper.get(Types1_6_4.METADATA_LIST, 0);
                    wrapper.user().get(EntityTracker.class).getTrackedEntities().put(entityID, entityType);
                    MetadataRewriter.transform(entityType, metadataList);
                    if (entityType.isOrHasParent(Entity1_10Types.EntityType.WOLF)) {
                        Protocol1_6_1to1_5_2.this.handleWolfMetadata(entityID, metadataList, wrapper);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.SPAWN_PAINTING, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.STRING);
                this.map(Types1_7_6.POSITION_INT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int entityID = wrapper.get(Type.INT, 0);
                    wrapper.user().get(EntityTracker.class).getTrackedEntities().put(entityID, Entity1_10Types.EntityType.PAINTING);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.SPAWN_EXPERIENCE_ORB, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.SHORT);
                this.handler(wrapper -> {
                    int entityID = wrapper.get(Type.INT, 0);
                    wrapper.user().get(EntityTracker.class).getTrackedEntities().put(entityID, Entity1_10Types.EntityType.EXPERIENCE_ORB);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.DESTROY_ENTITIES, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.INT_ARRAY);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    for (int entityId : wrapper.get(Types1_7_6.INT_ARRAY, 0)) {
                        tracker.getTrackedEntities().remove(entityId);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.ATTACH_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    AttachTracker attachTracker = wrapper.user().get(AttachTracker.class);
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    int ridingId = wrapper.get(Type.INT, 0);
                    int vehicleId = wrapper.get(Type.INT, 1);
                    if (entityTracker.getPlayerID() == ridingId) {
                        attachTracker.vehicleEntityId = vehicleId;
                    }
                });
                this.create(Type.UNSIGNED_BYTE, (short)0);
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.ENTITY_METADATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.METADATA_LIST);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    List<Metadata> metadataList = wrapper.get(Types1_6_4.METADATA_LIST, 0);
                    int entityID = wrapper.get(Type.INT, 0);
                    Entity1_10Types.EntityType entityType = tracker.getTrackedEntities().get(entityID);
                    if (tracker.getTrackedEntities().containsKey(entityID)) {
                        MetadataRewriter.transform(entityType, metadataList);
                        if (metadataList.isEmpty()) {
                            wrapper.cancel();
                        }
                        if (entityType.isOrHasParent(Entity1_10Types.EntityType.WOLF)) {
                            Protocol1_6_1to1_5_2.this.handleWolfMetadata(entityID, metadataList, wrapper);
                        }
                    } else {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.NAMED_SOUND, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String oldSound = wrapper.read(Types1_6_4.STRING);
                    String newSound = SoundRewriter.map(oldSound);
                    if (oldSound.isEmpty()) {
                        newSound = "";
                    }
                    if (newSound == null) {
                        ViaLegacy.getPlatform().getLogger().warning("Unable to map 1.5.2 sound '" + oldSound + "'");
                        newSound = "";
                    }
                    if (newSound.isEmpty()) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Types1_6_4.STRING, newSound);
                });
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.FLOAT);
                this.map(Type.UNSIGNED_BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.STATISTICS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map((Type)Type.BYTE, Type.INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_5_2.PLAYER_ABILITIES, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Type.BYTE, Type.FLOAT, b -> Float.valueOf((float)b.byteValue() / 255.0f));
                this.map(Type.BYTE, Type.FLOAT, b -> Float.valueOf((float)b.byteValue() / 255.0f));
            }
        });
        this.registerServerbound(State.STATUS, ServerboundPackets1_6_4.SERVER_PING.getId(), ServerboundPackets1_5_2.SERVER_PING.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.clearPacket();
                    wrapper.write(Type.BYTE, (byte)1);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_6_4.ENTITY_ACTION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.read(Type.INT);
                this.handler(wrapper -> {
                    if (wrapper.get(Type.BYTE, 0) > 5) {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_6_4.STEER_VEHICLE, ServerboundPackets1_5_2.INTERACT_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    AttachTracker attachTracker = wrapper.user().get(AttachTracker.class);
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    wrapper.read(Type.FLOAT);
                    wrapper.read(Type.FLOAT);
                    wrapper.read(Type.BOOLEAN);
                    boolean sneaking = wrapper.read(Type.BOOLEAN);
                    if (attachTracker.lastSneakState != sneaking) {
                        attachTracker.lastSneakState = sneaking;
                        if (sneaking) {
                            wrapper.write(Type.INT, entityTracker.getPlayerID());
                            wrapper.write(Type.INT, attachTracker.vehicleEntityId);
                            wrapper.write(Type.BYTE, (byte)0);
                            return;
                        }
                    }
                    wrapper.cancel();
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_6_4.PLAYER_ABILITIES, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Type.FLOAT, Type.BYTE, f -> (byte)(f.floatValue() * 255.0f));
                this.map(Type.FLOAT, Type.BYTE, f -> (byte)(f.floatValue() * 255.0f));
            }
        });
    }

    private void handleWolfMetadata(int entityId, List<Metadata> metadataList, PacketWrapper wrapper) throws Exception {
        for (Metadata metadata : metadataList) {
            MetaIndex1_8to1_7_6 index = MetaIndex1_8to1_7_6.searchIndex(Entity1_10Types.EntityType.WOLF, metadata.id());
            if (index != MetaIndex1_8to1_7_6.TAMEABLE_FLAGS) continue;
            if (((Byte)metadata.value() & 4) == 0) break;
            PacketWrapper attributes = PacketWrapper.create(ClientboundPackets1_6_1.ENTITY_PROPERTIES, wrapper.user());
            attributes.write(Type.INT, entityId);
            attributes.write(Type.INT, 1);
            attributes.write(Types1_6_4.STRING, "generic.maxHealth");
            attributes.write(Type.DOUBLE, 20.0);
            wrapper.send(Protocol1_6_1to1_5_2.class);
            attributes.send(Protocol1_6_1to1_5_2.class);
            wrapper.cancel();
            break;
        }
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocol1_6_1to1_5_2.class, ClientboundPackets1_5_2::getPacket));
        userConnection.put(new EntityTracker(userConnection));
        userConnection.put(new AttachTracker(userConnection));
    }

    @Override
    public LegacyItemRewriter<Protocol1_6_1to1_5_2> getItemRewriter() {
        return this.itemRewriter;
    }
}

