/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.metadata;

import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.protocols.release.protocol1_6_1to1_5_2.metadata.MetaIndex1_6_1to1_5_2;

public class MetadataRewriter {
    public static void transform(Entity1_10Types.EntityType type, List<Metadata> list) {
        for (Metadata entry : new ArrayList<Metadata>(list)) {
            MetaIndex1_6_1to1_5_2 metaIndex = MetaIndex1_6_1to1_5_2.searchIndex(type, entry.id());
            try {
                if (metaIndex == null) continue;
                Object value = entry.getValue();
                entry.setTypeAndValue(metaIndex.getOldType(), value);
                entry.setMetaTypeUnsafe(metaIndex.getNewType());
                entry.setId(metaIndex.getNewIndex());
                switch (metaIndex.getNewType()) {
                    case Byte: {
                        entry.setValue(((Number)value).byteValue());
                        break;
                    }
                    case Short: {
                        entry.setValue(((Number)value).shortValue());
                        break;
                    }
                    case Int: {
                        entry.setValue(((Number)value).intValue());
                        break;
                    }
                    case Float: {
                        entry.setValue(Float.valueOf(((Number)value).floatValue()));
                        break;
                    }
                    case Slot: 
                    case String: 
                    case Position: {
                        break;
                    }
                    default: {
                        ViaLegacy.getPlatform().getLogger().warning("1.5.2 MetaDataType: Unhandled Type: " + metaIndex.getNewType() + " " + entry);
                        list.remove(entry);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                ViaLegacy.getPlatform().getLogger().log(Level.WARNING, "Error rewriting metadata entry for " + type.name() + ": " + entry, e);
                list.remove(entry);
            }
        }
    }
}

