/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4;

import com.google.common.base.Joiner;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2IntOpenHashMap;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.base.BaseProtocol;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ClientboundStatusPackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundStatusPackets;
import com.viaversion.viaversion.protocols.protocol1_8.ClientboundPackets1_8;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.logging.Level;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.remapper.LegacyItemRewriter;
import net.raphimc.vialegacy.api.splitter.PreNettySplitter;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.ClientboundPackets1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.ServerboundPackets1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.providers.EncryptionProvider;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.rewriter.ChatComponentRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.rewriter.ItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.rewriter.SoundRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.rewriter.StatisticRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.rewriter.TranslationRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ChunkTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.DimensionTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.HandshakeStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.PlayerInfoStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.ProtocolMetadataStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.storage.StatisticsStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.MetaType1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_7_2_5to1_6_4.types.Types1_6_4;
import net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5.ClientboundPackets1_7_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5.ServerboundPackets1_7_2;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.Protocol1_8to1_7_6_10;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.providers.GameProfileFetcher;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Chunk1_7_6Type;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.ChunkBulk1_7_6Type;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.MetaType1_7_6;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocol1_7_2_5to1_6_4
extends AbstractProtocol<ClientboundPackets1_6_4, ClientboundPackets1_7_2, ServerboundPackets1_6_4, ServerboundPackets1_7_2> {
    private final LegacyItemRewriter<Protocol1_7_2_5to1_6_4> itemRewriter = new ItemRewriter(this);

    public Protocol1_7_2_5to1_6_4() {
        super(ClientboundPackets1_6_4.class, ClientboundPackets1_7_2.class, ServerboundPackets1_6_4.class, ServerboundPackets1_7_2.class);
    }

    @Override
    protected void registerPackets() {
        this.itemRewriter.register();
        this.registerClientbound(State.STATUS, ClientboundPackets1_6_4.DISCONNECT.getId(), ClientboundStatusPackets.STATUS_RESPONSE.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String reason = wrapper.read(Types1_6_4.STRING);
                    try {
                        String[] motdParts = reason.split("\u0000");
                        JsonObject rootObject = new JsonObject();
                        JsonObject descriptionObject = new JsonObject();
                        JsonObject playersObject = new JsonObject();
                        JsonObject versionObject = new JsonObject();
                        descriptionObject.addProperty("text", motdParts[3]);
                        playersObject.addProperty("max", Integer.parseInt(motdParts[5]));
                        playersObject.addProperty("online", Integer.parseInt(motdParts[4]));
                        versionObject.addProperty("name", motdParts[2]);
                        versionObject.addProperty("protocol", Integer.parseInt(motdParts[1]));
                        rootObject.add("description", descriptionObject);
                        rootObject.add("players", playersObject);
                        rootObject.add("version", versionObject);
                        wrapper.write(Type.STRING, rootObject.toString());
                    }
                    catch (Throwable e) {
                        ViaLegacy.getPlatform().getLogger().log(Level.WARNING, "Could not parse 1.6.4 ping: " + reason, e);
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(State.LOGIN, ClientboundPackets1_6_4.SHARED_KEY.getId(), ClientboundLoginPackets.GAME_PROFILE.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    ProtocolInfo info = wrapper.user().getProtocolInfo();
                    ProtocolMetadataStorage protocolMetadata = wrapper.user().get(ProtocolMetadataStorage.class);
                    wrapper.read(Type.SHORT_BYTE_ARRAY);
                    wrapper.read(Type.SHORT_BYTE_ARRAY);
                    wrapper.write(Type.STRING, info.getUuid().toString().replace("-", ""));
                    wrapper.write(Type.STRING, info.getUsername());
                    if (!protocolMetadata.skipEncryption) {
                        Via.getManager().getProviders().get(EncryptionProvider.class).enableDecryption(wrapper.user());
                    }
                    info.setState(State.PLAY);
                    Via.getManager().getConnectionManager().onLoginSuccess(wrapper.user());
                    if (info.getPipeline().pipes().stream().allMatch(Via.getManager().getProtocolManager()::isBaseProtocol)) {
                        wrapper.user().setActive(false);
                    }
                    if (Via.getManager().isDebug()) {
                        ViaLegacy.getPlatform().getLogger().log(Level.INFO, "{0} logged in with protocol {1}, Route: {2}", new Object[]{info.getUsername(), info.getProtocolVersion(), Joiner.on((String)", ").join(info.getPipeline().pipes(), (Object)", ", new Object[0])});
                    }
                    PacketWrapper respawn = PacketWrapper.create(ServerboundPackets1_6_4.CLIENT_STATUS, wrapper.user());
                    respawn.write(Type.BYTE, (byte)0);
                    respawn.sendToServer(Protocol1_7_2_5to1_6_4.class);
                });
            }
        });
        this.cancelClientbound(ClientboundPackets1_6_4.SHARED_KEY);
        this.registerClientbound(State.LOGIN, ClientboundPackets1_6_4.SERVER_AUTH_DATA.getId(), ClientboundLoginPackets.HELLO.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Type.SHORT_BYTE_ARRAY);
                this.map(Type.SHORT_BYTE_ARRAY);
                this.handler(wrapper -> {
                    ProtocolMetadataStorage protocolMetadata = wrapper.user().get(ProtocolMetadataStorage.class);
                    String serverHash = wrapper.get(Type.STRING, 0);
                    protocolMetadata.authenticate = !serverHash.equals("-");
                });
            }
        });
        this.cancelClientbound(ClientboundPackets1_6_4.SERVER_AUTH_DATA);
        this.registerClientbound(State.LOGIN, ClientboundPackets1_6_4.DISCONNECT.getId(), ClientboundLoginPackets.LOGIN_DISCONNECT.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING, ChatComponentRewriter::toClientDisconnect);
            }
        });
        this.cancelClientbound(State.LOGIN, ClientboundPackets1_6_4.PLUGIN_MESSAGE.getId());
        this.registerClientbound(State.LOGIN, ClientboundPackets1_6_4.JOIN_GAME.getId(), ClientboundPackets1_6_4.JOIN_GAME.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    ViaLegacy.getPlatform().getLogger().warning("Server skipped LOGIN state");
                    PacketWrapper sharedKey = PacketWrapper.create(ClientboundPackets1_6_4.SHARED_KEY, wrapper.user());
                    sharedKey.write(Type.SHORT_BYTE_ARRAY, new byte[0]);
                    sharedKey.write(Type.SHORT_BYTE_ARRAY, new byte[0]);
                    wrapper.user().get(ProtocolMetadataStorage.class).skipEncryption = true;
                    sharedKey.send(BaseProtocol.class);
                    wrapper.user().get(ProtocolMetadataStorage.class).skipEncryption = false;
                    wrapper.send(BaseProtocol.class);
                    wrapper.cancel();
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.JOIN_GAME, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.handler(wrapper -> {
                    wrapper.user().get(PlayerInfoStorage.class).entityId = wrapper.get(Type.INT, 0);
                    String terrainType = wrapper.read(Types1_6_4.STRING);
                    short gameType = wrapper.read(Type.BYTE).byteValue();
                    byte dimension = wrapper.read(Type.BYTE);
                    short difficulty = wrapper.read(Type.BYTE).byteValue();
                    wrapper.read(Type.BYTE);
                    short maxPlayers = wrapper.read(Type.BYTE).byteValue();
                    wrapper.write(Type.UNSIGNED_BYTE, gameType);
                    wrapper.write(Type.BYTE, dimension);
                    wrapper.write(Type.UNSIGNED_BYTE, difficulty);
                    wrapper.write(Type.UNSIGNED_BYTE, maxPlayers);
                    wrapper.write(Type.STRING, terrainType);
                });
                this.handler(wrapper -> {
                    byte dimensionId = wrapper.get(Type.BYTE, 0);
                    wrapper.user().get(DimensionTracker.class).setDimension(dimensionId);
                    wrapper.user().get(ClientWorld.class).setEnvironment(dimensionId);
                    wrapper.user().put(new ChunkTracker(wrapper.user()));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.CHAT_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING, msg -> TranslationRewriter.toClient(ChatComponentRewriter.toClient(msg)));
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.ENTITY_EQUIPMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.SHORT);
                this.map(Types1_7_6.COMPRESSED_ITEM);
                this.handler(wrapper -> Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToClient(wrapper.get(Types1_7_6.COMPRESSED_ITEM, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
                this.read(Type.SHORT);
                this.map(Types1_6_4.STRING, Type.STRING);
                this.handler(wrapper -> {
                    int oldDim = wrapper.user().get(DimensionTracker.class).getDimensionId();
                    int newDim = wrapper.get(Type.INT, 0);
                    wrapper.user().get(DimensionTracker.class).setDimension(newDim);
                    wrapper.user().get(ClientWorld.class).setEnvironment(newDim);
                    if (oldDim != newDim) {
                        wrapper.user().get(ChunkTracker.class).clear();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.PLAYER_POSITION_ONLY_ONGROUND, ClientboundPackets1_7_2.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    PlayerInfoStorage playerInfoStorage = wrapper.user().get(PlayerInfoStorage.class);
                    boolean supportsFlags = wrapper.user().getProtocolInfo().getPipeline().contains(Protocol1_8to1_7_6_10.class);
                    wrapper.write(Type.DOUBLE, supportsFlags ? 0.0 : playerInfoStorage.posX);
                    wrapper.write(Type.DOUBLE, supportsFlags ? 0.0 : playerInfoStorage.posY + (double)1.62f);
                    wrapper.write(Type.DOUBLE, supportsFlags ? 0.0 : playerInfoStorage.posZ);
                    wrapper.write(Type.FLOAT, Float.valueOf(supportsFlags ? 0.0f : playerInfoStorage.yaw));
                    wrapper.write(Type.FLOAT, Float.valueOf(supportsFlags ? 0.0f : playerInfoStorage.pitch));
                    if (supportsFlags) {
                        wrapper.read(Type.BOOLEAN);
                        wrapper.write(Type.BYTE, (byte)31);
                        wrapper.setPacketType(ClientboundPackets1_8.PLAYER_POSITION);
                        wrapper.send(Protocol1_8to1_7_6_10.class);
                        wrapper.cancel();
                    } else {
                        wrapper.passthrough(Type.BOOLEAN);
                    }
                    PacketWrapper setVelocityToZero = PacketWrapper.create(ClientboundPackets1_7_2.ENTITY_VELOCITY, wrapper.user());
                    setVelocityToZero.write(Type.INT, playerInfoStorage.entityId);
                    setVelocityToZero.write(Type.SHORT, (short)0);
                    setVelocityToZero.write(Type.SHORT, (short)0);
                    setVelocityToZero.write(Type.SHORT, (short)0);
                    if (!wrapper.isCancelled()) {
                        wrapper.send(Protocol1_7_2_5to1_6_4.class);
                    }
                    setVelocityToZero.send(Protocol1_7_2_5to1_6_4.class);
                    wrapper.cancel();
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.PLAYER_POSITION_ONLY_POSITION, ClientboundPackets1_7_2.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    PlayerInfoStorage playerInfoStorage = wrapper.user().get(PlayerInfoStorage.class);
                    boolean supportsFlags = wrapper.user().getProtocolInfo().getPipeline().contains(Protocol1_8to1_7_6_10.class);
                    wrapper.passthrough(Type.DOUBLE);
                    wrapper.passthrough(Type.DOUBLE);
                    wrapper.read(Type.DOUBLE);
                    wrapper.passthrough(Type.DOUBLE);
                    wrapper.write(Type.FLOAT, Float.valueOf(supportsFlags ? 0.0f : playerInfoStorage.yaw));
                    wrapper.write(Type.FLOAT, Float.valueOf(supportsFlags ? 0.0f : playerInfoStorage.pitch));
                    if (supportsFlags) {
                        wrapper.read(Type.BOOLEAN);
                        wrapper.write(Type.BYTE, (byte)24);
                        wrapper.setPacketType(ClientboundPackets1_8.PLAYER_POSITION);
                        wrapper.send(Protocol1_8to1_7_6_10.class);
                        wrapper.cancel();
                    } else {
                        wrapper.passthrough(Type.BOOLEAN);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.PLAYER_POSITION_ONLY_LOOK, ClientboundPackets1_7_2.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    PlayerInfoStorage playerInfoStorage = wrapper.user().get(PlayerInfoStorage.class);
                    boolean supportsFlags = wrapper.user().getProtocolInfo().getPipeline().contains(Protocol1_8to1_7_6_10.class);
                    wrapper.write(Type.DOUBLE, supportsFlags ? 0.0 : playerInfoStorage.posX);
                    wrapper.write(Type.DOUBLE, supportsFlags ? 0.0 : playerInfoStorage.posY + (double)1.62f);
                    wrapper.write(Type.DOUBLE, supportsFlags ? 0.0 : playerInfoStorage.posZ);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.FLOAT);
                    if (supportsFlags) {
                        wrapper.read(Type.BOOLEAN);
                        wrapper.write(Type.BYTE, (byte)7);
                        wrapper.setPacketType(ClientboundPackets1_8.PLAYER_POSITION);
                        wrapper.send(Protocol1_8to1_7_6_10.class);
                        wrapper.cancel();
                    } else {
                        wrapper.passthrough(Type.BOOLEAN);
                    }
                    PacketWrapper setVelocityToZero = PacketWrapper.create(ClientboundPackets1_7_2.ENTITY_VELOCITY, wrapper.user());
                    setVelocityToZero.write(Type.INT, playerInfoStorage.entityId);
                    setVelocityToZero.write(Type.SHORT, (short)0);
                    setVelocityToZero.write(Type.SHORT, (short)0);
                    setVelocityToZero.write(Type.SHORT, (short)0);
                    if (!wrapper.isCancelled()) {
                        wrapper.send(Protocol1_7_2_5to1_6_4.class);
                    }
                    setVelocityToZero.send(Protocol1_7_2_5to1_6_4.class);
                    wrapper.cancel();
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.read(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.BOOLEAN);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.HELD_ITEM_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.SHORT, Type.BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.USE_BED, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.handler(wrapper -> {
                    if (wrapper.read(Type.BYTE) != 0) {
                        wrapper.cancel();
                    }
                });
                this.map(Types1_7_6.POSITION_BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.ENTITY_ANIMATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.handler(wrapper -> {
                    short animate = wrapper.read(Type.BYTE).byteValue();
                    if (animate == 0 || animate == 4) {
                        wrapper.cancel();
                    }
                    animate = animate >= 1 && animate <= 3 ? (short)(animate - 1) : (short)(animate - 2);
                    wrapper.write(Type.UNSIGNED_BYTE, animate);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SPAWN_PLAYER, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.handler(wrapper -> {
                    String name = wrapper.read(Types1_6_4.STRING);
                    wrapper.write(Type.STRING, (ViaLegacy.getConfig().isLegacySkinLoading() ? Via.getManager().getProviders().get(GameProfileFetcher.class).getMojangUUID(name) : new GameProfile((String)name).uuid).toString().replace("-", ""));
                    wrapper.write(Type.STRING, name);
                });
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    DataItem currentItem = new DataItem(wrapper.read(Type.UNSIGNED_SHORT), 1, 0, null);
                    Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToClient(currentItem);
                    wrapper.write(Type.SHORT, (short)currentItem.identifier());
                });
                this.map(Types1_6_4.METADATA_LIST, Types1_7_6.METADATA_LIST);
                this.handler(wrapper -> Protocol1_7_2_5to1_6_4.this.rewriteMetadata(wrapper.get(Types1_7_6.METADATA_LIST, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SPAWN_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int data = wrapper.get(Type.INT, 3);
                    if (Entity1_10Types.getTypeFromId(wrapper.get(Type.BYTE, 0).byteValue(), true) == Entity1_10Types.ObjectType.FALLING_BLOCK.getType()) {
                        int id = data & 0xFFFF;
                        int metadata = data >> 16;
                        IdAndData block = new IdAndData(id, metadata);
                        wrapper.user().get(ChunkTracker.class).remapBlockParticle(block);
                        data = block.id & 0xFFFF | block.data << 16;
                    }
                    wrapper.set(Type.INT, 3, data);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SPAWN_MOB, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Types1_6_4.METADATA_LIST, Types1_7_6.METADATA_LIST);
                this.handler(wrapper -> Protocol1_7_2_5to1_6_4.this.rewriteMetadata(wrapper.get(Types1_7_6.METADATA_LIST, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SPAWN_PAINTING, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Types1_7_6.POSITION_INT);
                this.map(Type.INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SPAWN_EXPERIENCE_ORB, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.SHORT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.ENTITY_METADATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_6_4.METADATA_LIST, Types1_7_6.METADATA_LIST);
                this.handler(wrapper -> Protocol1_7_2_5to1_6_4.this.rewriteMetadata(wrapper.get(Types1_7_6.METADATA_LIST, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.ENTITY_PROPERTIES, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int amount = wrapper.passthrough(Type.INT);
                    for (int i = 0; i < amount; ++i) {
                        wrapper.write(Type.STRING, wrapper.read(Types1_6_4.STRING));
                        wrapper.passthrough(Type.DOUBLE);
                        int modifierlength = wrapper.passthrough(Type.SHORT).shortValue();
                        for (int x = 0; x < modifierlength; ++x) {
                            wrapper.passthrough(Type.UUID);
                            wrapper.passthrough(Type.DOUBLE);
                            wrapper.passthrough(Type.BYTE);
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.CHUNK_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Chunk chunk = wrapper.passthrough(new Chunk1_7_6Type(wrapper.user().get(ClientWorld.class)));
                    wrapper.user().get(ChunkTracker.class).trackAndRemap(chunk);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.MULTI_BLOCK_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Types1_7_6.BLOCK_CHANGE_RECORD_ARRAY);
                this.handler(wrapper -> {
                    BlockChangeRecord[] blockChangeRecords;
                    int chunkX = wrapper.get(Type.INT, 0);
                    int chunkZ = wrapper.get(Type.INT, 1);
                    for (BlockChangeRecord record : blockChangeRecords = wrapper.get(Types1_7_6.BLOCK_CHANGE_RECORD_ARRAY, 0)) {
                        int targetX = record.getSectionX() + (chunkX << 4);
                        short targetY = record.getY(-1);
                        int targetZ = record.getSectionZ() + (chunkZ << 4);
                        IdAndData block = IdAndData.fromCompressedData(record.getBlockId());
                        Position pos = new Position(targetX, (int)targetY, targetZ);
                        wrapper.user().get(ChunkTracker.class).trackAndRemap(pos, block);
                        record.setBlockId(block.toCompressedData());
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.BLOCK_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map((Type)Type.UNSIGNED_SHORT, Type.VAR_INT);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    Position pos = wrapper.get(Types1_7_6.POSITION_UBYTE, 0);
                    int blockId = wrapper.get(Type.VAR_INT, 0);
                    short data = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    IdAndData block = new IdAndData(blockId, data);
                    wrapper.user().get(ChunkTracker.class).trackAndRemap(pos, block);
                    wrapper.set(Type.VAR_INT, 0, block.id);
                    wrapper.set(Type.UNSIGNED_BYTE, 0, (short)block.data);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.BLOCK_ACTION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT);
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
                this.map((Type)Type.SHORT, Type.VAR_INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.BLOCK_BREAK_ANIMATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Types1_7_6.POSITION_INT);
                this.map(Type.BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.MAP_BULK_CHUNK, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Chunk[] chunks;
                    for (Chunk chunk : chunks = wrapper.passthrough(new ChunkBulk1_7_6Type(wrapper.user().get(ClientWorld.class)))) {
                        wrapper.user().get(ChunkTracker.class).trackAndRemap(chunk);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.EXPLOSION, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.DOUBLE, Type.FLOAT);
                this.map((Type)Type.DOUBLE, Type.FLOAT);
                this.map((Type)Type.DOUBLE, Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int x = wrapper.get(Type.FLOAT, 0).intValue();
                    int y = wrapper.get(Type.FLOAT, 1).intValue();
                    int z = wrapper.get(Type.FLOAT, 2).intValue();
                    int recordCount = wrapper.get(Type.INT, 0);
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    for (int i = 0; i < recordCount; ++i) {
                        Position pos = new Position(x + wrapper.passthrough(Type.BYTE), y + wrapper.passthrough(Type.BYTE), z + wrapper.passthrough(Type.BYTE));
                        chunkTracker.trackAndRemap(pos, new IdAndData(0, 0));
                    }
                });
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.NAMED_SOUND, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String oldSound = wrapper.read(Types1_6_4.STRING);
                    String newSound = SoundRewriter.map(oldSound);
                    if (oldSound.isEmpty()) {
                        newSound = "";
                    }
                    if (newSound == null) {
                        ViaLegacy.getPlatform().getLogger().warning("Unable to map 1.6.4 sound '" + oldSound + "'");
                        newSound = "";
                    }
                    if (newSound.isEmpty()) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Type.STRING, newSound);
                });
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.FLOAT);
                this.map(Type.UNSIGNED_BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.EFFECT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.INT);
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    int effectId = wrapper.get(Type.INT, 0);
                    int data = wrapper.get(Type.INT, 1);
                    boolean disableRelativeVolume = wrapper.get(Type.BOOLEAN, 0);
                    if (!disableRelativeVolume && effectId == 2001) {
                        ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                        int blockID = data & 0xFFF;
                        int blockData = data >> 12 & 0xFF;
                        IdAndData block = new IdAndData(blockID, blockData);
                        chunkTracker.remapBlockParticle(block);
                        data = block.id & 0xFFF | block.data << 12;
                        wrapper.set(Type.INT, 1, data);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SPAWN_PARTICLE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    CharSequence[] parts = wrapper.get(Type.STRING, 0).split("_", 3);
                    if (parts[0].equals("tilecrack")) {
                        parts[0] = "blockcrack";
                    }
                    if (parts[0].equals("blockcrack") || parts[0].equals("blockdust")) {
                        int id = Integer.parseInt(parts[1]);
                        int metadata = Integer.parseInt(parts[2]);
                        IdAndData block = new IdAndData(id, metadata);
                        wrapper.user().get(ChunkTracker.class).remapBlockParticle(block);
                        parts[1] = String.valueOf(block.id);
                        parts[2] = String.valueOf(block.data);
                    }
                    wrapper.set(Type.STRING, 0, String.join((CharSequence)"_", parts));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.GAME_EVENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
                this.map((Type)Type.BYTE, Type.FLOAT);
                this.handler(wrapper -> {
                    short gameState = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    if (gameState == 1) {
                        PacketWrapper startRain = PacketWrapper.create(ClientboundPackets1_7_2.GAME_EVENT, wrapper.user());
                        startRain.write(Type.UNSIGNED_BYTE, (short)7);
                        startRain.write(Type.FLOAT, Float.valueOf(1.0f));
                        wrapper.send(Protocol1_7_2_5to1_6_4.class);
                        startRain.send(Protocol1_7_2_5to1_6_4.class);
                        wrapper.cancel();
                    } else if (gameState == 2) {
                        PacketWrapper stopRain = PacketWrapper.create(ClientboundPackets1_7_2.GAME_EVENT, wrapper.user());
                        stopRain.write(Type.UNSIGNED_BYTE, (short)7);
                        stopRain.write(Type.FLOAT, Float.valueOf(0.0f));
                        wrapper.send(Protocol1_7_2_5to1_6_4.class);
                        stopRain.send(Protocol1_7_2_5to1_6_4.class);
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SPAWN_GLOBAL_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.OPEN_WINDOW, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.BOOLEAN);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.CLOSE_WINDOW, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SET_SLOT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Types1_7_6.COMPRESSED_ITEM);
                this.handler(wrapper -> Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToClient(wrapper.get(Types1_7_6.COMPRESSED_ITEM, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.WINDOW_ITEMS, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    Item[] items;
                    for (Item item : items = wrapper.passthrough(Types1_7_6.COMPRESSED_ITEM_ARRAY)) {
                        Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToClient(item);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.UPDATE_SIGN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT);
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Types1_6_4.STRING, Type.STRING);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.MAP_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.read(Type.SHORT);
                this.map((Type)Type.SHORT, Type.VAR_INT);
                this.map(Type.SHORT_BYTE_ARRAY);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.BLOCK_ENTITY_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT);
                this.map((Type)Type.BYTE, Type.UNSIGNED_BYTE);
                this.map(Types1_7_6.COMPRESSED_NBT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.OPEN_SIGN_EDITOR, new PacketHandlers(){

            @Override
            public void register() {
                this.read(Type.BYTE);
                this.map(Types1_7_6.POSITION_INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.STATISTICS, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    StatisticsStorage statisticsStorage = wrapper.user().get(StatisticsStorage.class);
                    int statId = wrapper.read(Type.INT);
                    int increment = wrapper.read(Type.INT);
                    statisticsStorage.values.put(statId, statisticsStorage.values.get(statId) + increment);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.PLAYER_INFO, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Type.BOOLEAN);
                this.map(Type.SHORT);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.TAB_COMPLETE, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String completions = wrapper.read(Types1_6_4.STRING);
                    String[] completionsArray = completions.split("\u0000");
                    wrapper.write(Type.VAR_INT, completionsArray.length);
                    for (String s : completionsArray) {
                        wrapper.write(Type.STRING, s);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.SCOREBOARD_OBJECTIVE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Types1_6_4.STRING, Type.STRING);
                this.map(Type.BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.UPDATE_SCORE, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.write(Type.STRING, wrapper.read(Types1_6_4.STRING));
                    byte mode = wrapper.passthrough(Type.BYTE);
                    if (mode == 0) {
                        wrapper.write(Type.STRING, wrapper.read(Types1_6_4.STRING));
                        wrapper.passthrough(Type.INT);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.DISPLAY_SCOREBOARD, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Types1_6_4.STRING, Type.STRING);
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.TEAMS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING);
                this.handler(wrapper -> {
                    byte mode = wrapper.passthrough(Type.BYTE);
                    if (mode == 0 || mode == 2) {
                        wrapper.write(Type.STRING, wrapper.read(Types1_6_4.STRING));
                        wrapper.write(Type.STRING, wrapper.read(Types1_6_4.STRING));
                        wrapper.write(Type.STRING, wrapper.read(Types1_6_4.STRING));
                        wrapper.passthrough(Type.BYTE);
                    }
                    if (mode == 0 || mode == 3 || mode == 4) {
                        int count = wrapper.passthrough(Type.SHORT).shortValue();
                        for (int i = 0; i < count; ++i) {
                            wrapper.write(Type.STRING, wrapper.read(Types1_6_4.STRING));
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.PLUGIN_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING);
                this.handler(wrapper -> {
                    String channel = wrapper.get(Type.STRING, 0);
                    wrapper.passthrough(Type.SHORT);
                    if (channel.equals("MC|TrList")) {
                        wrapper.passthrough(Type.INT);
                        int count = wrapper.passthrough(Type.UNSIGNED_BYTE).shortValue();
                        for (int i = 0; i < count; ++i) {
                            Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToClient(wrapper.passthrough(Types1_7_6.COMPRESSED_ITEM));
                            Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToClient(wrapper.passthrough(Types1_7_6.COMPRESSED_ITEM));
                            if (wrapper.passthrough(Type.BOOLEAN).booleanValue()) {
                                Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToClient(wrapper.passthrough(Types1_7_6.COMPRESSED_ITEM));
                            }
                            wrapper.passthrough(Type.BOOLEAN);
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_6_4.DISCONNECT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_6_4.STRING, Type.STRING, ChatComponentRewriter::toClientDisconnect);
            }
        });
        this.cancelClientbound(ClientboundPackets1_6_4.CREATIVE_INVENTORY_ACTION);
        this.registerServerbound(State.STATUS, ServerboundStatusPackets.STATUS_REQUEST.getId(), ServerboundPackets1_6_4.SERVER_PING.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    HandshakeStorage handshakeStorage = wrapper.user().get(HandshakeStorage.class);
                    String ip = handshakeStorage.getHostname();
                    int port = handshakeStorage.getPort();
                    wrapper.write(Type.UNSIGNED_BYTE, (short)1);
                    wrapper.write(Type.UNSIGNED_BYTE, (short)250);
                    wrapper.write(Types1_6_4.STRING, "MC|PingHost");
                    wrapper.write(Type.UNSIGNED_SHORT, 3 + 2 * ip.length() + 4);
                    wrapper.write(Type.UNSIGNED_BYTE, (short)(-wrapper.user().getProtocolInfo().getServerProtocolVersion() >> 2));
                    wrapper.write(Types1_6_4.STRING, ip);
                    wrapper.write(Type.INT, port);
                });
            }
        });
        this.registerServerbound(State.STATUS, ServerboundStatusPackets.PING_REQUEST.getId(), -1, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    PacketWrapper pong = PacketWrapper.create(ClientboundStatusPackets.PONG_RESPONSE, wrapper.user());
                    pong.write(Type.LONG, wrapper.read(Type.LONG));
                    pong.send(Protocol1_7_2_5to1_6_4.class);
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.HELLO.getId(), ServerboundPackets1_6_4.CLIENT_PROTOCOL.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String name = wrapper.read(Type.STRING);
                    ProtocolInfo info = wrapper.user().getProtocolInfo();
                    HandshakeStorage handshakeStorage = wrapper.user().get(HandshakeStorage.class);
                    info.setUsername(name);
                    info.setUuid(ViaLegacy.getConfig().isLegacySkinLoading() ? Via.getManager().getProviders().get(GameProfileFetcher.class).getMojangUUID(name) : new GameProfile((String)name).uuid);
                    wrapper.write(Type.UNSIGNED_BYTE, (short)(-info.getServerProtocolVersion() >> 2));
                    wrapper.write(Types1_6_4.STRING, name);
                    wrapper.write(Types1_6_4.STRING, handshakeStorage.getHostname());
                    wrapper.write(Type.INT, handshakeStorage.getPort());
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.ENCRYPTION_KEY.getId(), ServerboundPackets1_6_4.SHARED_KEY.getId());
        this.registerServerbound(ServerboundPackets1_7_2.CHAT_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, Types1_6_4.STRING);
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.INTERACT_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> wrapper.write(Type.INT, wrapper.user().get(PlayerInfoStorage.class).entityId));
                this.map(Type.INT);
                this.map(Type.BYTE);
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.PLAYER_MOVEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    wrapper.user().get(PlayerInfoStorage.class).onGround = wrapper.get(Type.BOOLEAN, 0);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    PlayerInfoStorage playerInfoStorage = wrapper.user().get(PlayerInfoStorage.class);
                    playerInfoStorage.posX = wrapper.get(Type.DOUBLE, 0);
                    playerInfoStorage.posY = wrapper.get(Type.DOUBLE, 1);
                    playerInfoStorage.posZ = wrapper.get(Type.DOUBLE, 3);
                    playerInfoStorage.onGround = wrapper.get(Type.BOOLEAN, 0);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.PLAYER_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    PlayerInfoStorage playerInfoStorage = wrapper.user().get(PlayerInfoStorage.class);
                    playerInfoStorage.yaw = wrapper.get(Type.FLOAT, 0).floatValue();
                    playerInfoStorage.pitch = wrapper.get(Type.FLOAT, 1).floatValue();
                    playerInfoStorage.onGround = wrapper.get(Type.BOOLEAN, 0);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.PLAYER_POSITION_AND_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.BOOLEAN);
                this.handler(wrapper -> {
                    PlayerInfoStorage playerInfoStorage = wrapper.user().get(PlayerInfoStorage.class);
                    playerInfoStorage.posX = wrapper.get(Type.DOUBLE, 0);
                    playerInfoStorage.posY = wrapper.get(Type.DOUBLE, 1);
                    playerInfoStorage.posZ = wrapper.get(Type.DOUBLE, 3);
                    playerInfoStorage.yaw = wrapper.get(Type.FLOAT, 0).floatValue();
                    playerInfoStorage.pitch = wrapper.get(Type.FLOAT, 1).floatValue();
                    playerInfoStorage.onGround = wrapper.get(Type.BOOLEAN, 0);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.PLAYER_BLOCK_PLACEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_UBYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Types1_7_6.COMPRESSED_ITEM);
                this.handler(wrapper -> Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToServer(wrapper.get(Types1_7_6.COMPRESSED_ITEM, 0)));
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.CLICK_WINDOW, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.BYTE);
                this.map(Types1_7_6.COMPRESSED_ITEM);
                this.handler(wrapper -> Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToServer(wrapper.get(Types1_7_6.COMPRESSED_ITEM, 0)));
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.UPDATE_SIGN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT);
                this.map(Type.STRING, Types1_6_4.STRING);
                this.map(Type.STRING, Types1_6_4.STRING);
                this.map(Type.STRING, Types1_6_4.STRING);
                this.map(Type.STRING, Types1_6_4.STRING);
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.TAB_COMPLETE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, Types1_6_4.STRING);
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.CLIENT_SETTINGS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, Types1_6_4.STRING);
                this.handler(wrapper -> {
                    byte renderDistance = wrapper.read(Type.BYTE);
                    renderDistance = renderDistance <= 2 ? (byte)3 : (renderDistance <= 4 ? (byte)2 : (renderDistance <= 8 ? (byte)1 : (byte)0));
                    wrapper.write(Type.BYTE, renderDistance);
                });
                this.handler(wrapper -> {
                    byte chatVisibility = wrapper.read(Type.BYTE);
                    boolean enableColors = wrapper.read(Type.BOOLEAN);
                    byte mask = (byte)(chatVisibility | (enableColors ? 1 : 0) << 3);
                    wrapper.write(Type.BYTE, mask);
                });
                this.map(Type.BYTE);
                this.map(Type.BOOLEAN);
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.CLIENT_STATUS, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    int action = wrapper.read(Type.VAR_INT);
                    if (action == 1) {
                        Object2IntOpenHashMap<String> loadedStatistics = new Object2IntOpenHashMap<String>();
                        for (Int2IntMap.Entry entry : wrapper.user().get(StatisticsStorage.class).values.int2IntEntrySet()) {
                            String string = StatisticRewriter.map(entry.getIntKey());
                            if (string == null) continue;
                            loadedStatistics.put(string, entry.getIntValue());
                        }
                        PacketWrapper statistics = PacketWrapper.create(ClientboundPackets1_8.STATISTICS, wrapper.user());
                        statistics.write(Type.VAR_INT, loadedStatistics.size());
                        for (Object2IntMap.Entry entry : loadedStatistics.object2IntEntrySet()) {
                            statistics.write(Type.STRING, entry.getKey());
                            statistics.write(Type.VAR_INT, entry.getIntValue());
                        }
                        statistics.send(Protocol1_7_2_5to1_6_4.class);
                    }
                    if (action != 0) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Type.BYTE, (byte)1);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_7_2.PLUGIN_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, Types1_6_4.STRING);
                this.map(Type.SHORT);
                this.handler(wrapper -> {
                    String channel = wrapper.get(Types1_6_4.STRING, 0);
                    PacketWrapper lengthPacketWrapper = PacketWrapper.create(null, wrapper.user());
                    ByteBuf lengthBuffer = Unpooled.buffer();
                    switch (channel) {
                        case "MC|BEdit": 
                        case "MC|BSign": {
                            Item item = wrapper.read(Types1_7_6.COMPRESSED_ITEM);
                            Protocol1_7_2_5to1_6_4.this.itemRewriter.handleItemToServer(item);
                            lengthPacketWrapper.write(Types1_7_6.COMPRESSED_ITEM, item);
                            lengthPacketWrapper.writeToBuffer(lengthBuffer);
                            wrapper.set(Type.SHORT, 0, (short)lengthBuffer.readableBytes());
                            wrapper.write(Types1_7_6.COMPRESSED_ITEM, item);
                            break;
                        }
                        case "MC|AdvCdm": {
                            byte type = wrapper.read(Type.BYTE);
                            if (type == 0) {
                                int posX = wrapper.read(Type.INT);
                                int posY = wrapper.read(Type.INT);
                                int posZ = wrapper.read(Type.INT);
                                String command = wrapper.read(Type.STRING);
                                lengthPacketWrapper.write(Type.INT, posX);
                                lengthPacketWrapper.write(Type.INT, posY);
                                lengthPacketWrapper.write(Type.INT, posZ);
                                lengthPacketWrapper.write(Types1_6_4.STRING, command);
                                lengthPacketWrapper.writeToBuffer(lengthBuffer);
                                wrapper.set(Type.SHORT, 0, (short)lengthBuffer.readableBytes());
                                wrapper.write(Type.INT, posX);
                                wrapper.write(Type.INT, posY);
                                wrapper.write(Type.INT, posZ);
                                wrapper.write(Types1_6_4.STRING, command);
                                break;
                            }
                            wrapper.cancel();
                        }
                    }
                    lengthBuffer.release();
                });
            }
        });
    }

    private void rewriteMetadata(List<Metadata> metadataList) {
        for (Metadata metadata : metadataList) {
            if (metadata.metaType().equals(MetaType1_6_4.Slot)) {
                this.itemRewriter.handleItemToClient((Item)metadata.value());
            }
            metadata.setMetaType(MetaType1_7_6.byId(metadata.metaType().typeId()));
        }
    }

    @Override
    public void register(ViaProviders providers) {
        providers.require(EncryptionProvider.class);
    }

    @Override
    public void init(final UserConnection userConnection) {
        userConnection.put(new PreNettySplitter(userConnection, Protocol1_7_2_5to1_6_4.class, ClientboundPackets1_6_4::getPacket));
        userConnection.put(new PlayerInfoStorage(userConnection));
        userConnection.put(new StatisticsStorage(userConnection));
        userConnection.put(new DimensionTracker(userConnection));
        if (!userConnection.has(ClientWorld.class)) {
            userConnection.put(new ClientWorld(userConnection));
        }
        userConnection.put(new ChunkTracker(userConnection));
        if (userConnection.getChannel() != null) {
            userConnection.getChannel().pipeline().addFirst(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                    if (userConnection.getProtocolInfo().getState().equals((Object)State.PLAY) && ctx.channel().isWritable() && userConnection.get(PlayerInfoStorage.class).entityId != -1) {
                        PacketWrapper disconnect = PacketWrapper.create(ServerboundPackets1_6_4.DISCONNECT, userConnection);
                        disconnect.write(Types1_6_4.STRING, "Quitting");
                        disconnect.sendToServer(Protocol1_7_2_5to1_6_4.class);
                    }
                    super.close(ctx, promise);
                }
            }});
        }
    }

    @Override
    public LegacyItemRewriter<Protocol1_7_2_5to1_6_4> getItemRewriter() {
        return this.itemRewriter;
    }
}

