/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.protocols.base.BaseProtocol1_7;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5.ClientboundPackets1_7_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5.ServerboundPackets1_7_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5.rewriter.TranslationRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.providers.GameProfileFetcher;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocol1_7_6_10to1_7_2_5
extends AbstractProtocol<ClientboundPackets1_7_2, ClientboundPackets1_7_2, ServerboundPackets1_7_2, ServerboundPackets1_7_2> {
    public Protocol1_7_6_10to1_7_2_5() {
        super(ClientboundPackets1_7_2.class, ClientboundPackets1_7_2.class, ServerboundPackets1_7_2.class, ServerboundPackets1_7_2.class);
    }

    @Override
    protected void registerPackets() {
        this.registerClientbound(State.LOGIN, ClientboundLoginPackets.GAME_PROFILE.getId(), ClientboundLoginPackets.GAME_PROFILE.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, Type.STRING, BaseProtocol1_7::addDashes);
                this.map(Type.STRING);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_PLAYER, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.VAR_INT);
                this.map(Type.STRING, Type.STRING, BaseProtocol1_7::addDashes);
                this.map(Type.STRING);
                this.create(Type.VAR_INT, 0);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Types1_7_6.METADATA_LIST);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.CHAT_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, Type.STRING, TranslationRewriter::toClient);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.BLOCK_ENTITY_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Types1_7_6.COMPRESSED_NBT);
                this.handler(wrapper -> {
                    Position pos = wrapper.get(Types1_7_6.POSITION_SHORT, 0);
                    short type = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    CompoundTag tag = wrapper.get(Types1_7_6.COMPRESSED_NBT, 0);
                    if (type != 4) {
                        return;
                    }
                    ByteTag skullType = (ByteTag)tag.get("SkullType");
                    if (skullType == null || skullType.asByte() != 3) {
                        return;
                    }
                    StringTag extraType = (StringTag)tag.remove("ExtraType");
                    if (ViaLegacy.getConfig().isLegacySkullLoading()) {
                        UUID uuid2;
                        GameProfileFetcher gameProfileFetcher = Via.getManager().getProviders().get(GameProfileFetcher.class);
                        String skullName = extraType == null ? "" : extraType.getValue();
                        CompoundTag newTag = tag.clone();
                        if (gameProfileFetcher.isUUIDLoaded(skullName) && gameProfileFetcher.isGameProfileLoaded(uuid2 = gameProfileFetcher.getMojangUUID(skullName))) {
                            GameProfile skullProfile = gameProfileFetcher.getGameProfile(uuid2);
                            if (skullProfile == null || skullProfile.isOffline()) {
                                return;
                            }
                            newTag.put("Owner", Protocol1_7_6_10to1_7_2_5.writeGameProfileToTag(skullProfile));
                            wrapper.set(Types1_7_6.COMPRESSED_NBT, 0, newTag);
                            return;
                        }
                        gameProfileFetcher.getMojangUUIDAsync(skullName).thenAccept(uuid -> {
                            GameProfile skullProfile = gameProfileFetcher.getGameProfile((UUID)uuid);
                            if (skullProfile == null || skullProfile.isOffline()) {
                                return;
                            }
                            newTag.put("Owner", Protocol1_7_6_10to1_7_2_5.writeGameProfileToTag(skullProfile));
                            try {
                                PacketWrapper updateSkull = PacketWrapper.create(ClientboundPackets1_7_2.BLOCK_ENTITY_DATA, wrapper.user());
                                updateSkull.write(Types1_7_6.POSITION_SHORT, pos);
                                updateSkull.write(Type.UNSIGNED_BYTE, type);
                                updateSkull.write(Types1_7_6.COMPRESSED_NBT, newTag);
                                updateSkull.send(Protocol1_7_6_10to1_7_2_5.class);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        });
                    }
                });
            }
        });
    }

    public static CompoundTag writeGameProfileToTag(GameProfile gameProfile) {
        CompoundTag ownerTag = new CompoundTag();
        if (gameProfile.userName != null && !gameProfile.userName.isEmpty()) {
            ownerTag.put("Name", new StringTag(gameProfile.userName));
        }
        if (gameProfile.uuid != null) {
            ownerTag.put("Id", new StringTag(gameProfile.uuid.toString()));
        }
        if (!gameProfile.properties.isEmpty()) {
            CompoundTag propertiesTag = new CompoundTag();
            for (Map.Entry<String, List<GameProfile.Property>> entry : gameProfile.properties.entrySet()) {
                ListTag propertiesList = new ListTag();
                for (GameProfile.Property property : entry.getValue()) {
                    CompoundTag propertyTag = new CompoundTag();
                    propertyTag.put("Value", new StringTag(property.value));
                    if (property.signature != null) {
                        propertyTag.put("Signature", new StringTag(property.signature));
                    }
                    propertiesList.add(propertyTag);
                }
                propertiesTag.put(entry.getKey(), propertiesList);
            }
            ownerTag.put("Properties", propertiesTag);
        }
        return ownerTag;
    }
}

