/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10;

import com.google.common.base.Joiner;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.item.DataItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.protocol.remapper.ValueTransformer;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.version.Types1_8;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import com.viaversion.viaversion.protocols.protocol1_8.ClientboundPackets1_8;
import com.viaversion.viaversion.protocols.protocol1_8.ServerboundPackets1_8;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import com.viaversion.viaversion.protocols.protocol1_9to1_8.types.Chunk1_8Type;
import com.viaversion.viaversion.protocols.protocol1_9to1_8.types.ChunkBulk1_8Type;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.lenni0451.mcstructs.text.serializer.TextComponentSerializer;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.data.ItemList1_6;
import net.raphimc.vialegacy.api.model.IdAndData;
import net.raphimc.vialegacy.api.remapper.LegacyItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5.ClientboundPackets1_7_2;
import net.raphimc.vialegacy.protocols.release.protocol1_7_6_10to1_7_2_5.ServerboundPackets1_7_2;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.data.Particle;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata.MetadataRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.MapData;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.MapIcon;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.TabListEntry;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.rewriter.ChatItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.rewriter.ItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.rewriter.TranslationRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage.ChunkTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage.DimensionTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage.EntityTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage.MapStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage.TablistStorage;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage.WindowTracker;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Chunk1_7_6Type;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.ChunkBulk1_7_6Type;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Types1_7_6;

public class Protocol1_8to1_7_6_10
extends AbstractProtocol<ClientboundPackets1_7_2, ClientboundPackets1_8, ServerboundPackets1_7_2, ServerboundPackets1_8> {
    private final LegacyItemRewriter<Protocol1_8to1_7_6_10> itemRewriter = new ItemRewriter(this);
    private final ChatItemRewriter chatItemRewriter = new ChatItemRewriter(this);
    private final MetadataRewriter metadataRewriter = new MetadataRewriter(this);
    public static final ValueTransformer<String, String> LEGACY_TO_JSON = new ValueTransformer<String, String>(Type.STRING, Type.STRING){

        @Override
        public String transform(PacketWrapper packetWrapper, String message) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("text", message);
            return jsonObject.toString();
        }
    };
    public static final ValueTransformer<String, String> LEGACY_TO_JSON_TRANSLATE = new ValueTransformer<String, String>(Type.STRING, Type.STRING){

        @Override
        public String transform(PacketWrapper packetWrapper, String message) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("translate", message);
            return jsonObject.toString();
        }
    };

    public Protocol1_8to1_7_6_10() {
        super(ClientboundPackets1_7_2.class, ClientboundPackets1_8.class, ServerboundPackets1_7_2.class, ServerboundPackets1_8.class);
    }

    @Override
    protected void registerPackets() {
        this.itemRewriter.register();
        this.registerClientbound(State.LOGIN, ClientboundLoginPackets.HELLO.getId(), ClientboundLoginPackets.HELLO.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.map(Type.SHORT_BYTE_ARRAY, Type.BYTE_ARRAY_PRIMITIVE);
                this.map(Type.SHORT_BYTE_ARRAY, Type.BYTE_ARRAY_PRIMITIVE);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.KEEP_ALIVE, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.JOIN_GAME, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.STRING);
                this.create(Type.BOOLEAN, false);
                this.handler(wrapper -> {
                    ProtocolInfo protocolInfo = wrapper.user().getProtocolInfo();
                    TablistStorage tablistStorage = wrapper.user().get(TablistStorage.class);
                    tablistStorage.sendTempEntry(new TabListEntry(protocolInfo.getUsername(), protocolInfo.getUuid()));
                });
                this.handler(wrapper -> {
                    int entityId = wrapper.get(Type.INT, 0);
                    byte dimensionId = wrapper.get(Type.BYTE, 0);
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    tracker.trackEntity(entityId, Entity1_10Types.EntityType.PLAYER);
                    tracker.setPlayerID(entityId);
                    wrapper.user().get(DimensionTracker.class).setDimension(dimensionId);
                    wrapper.user().get(ClientWorld.class).setEnvironment(dimensionId);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.CHAT_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING, Type.STRING, msg -> TranslationRewriter.toClient(Protocol1_8to1_7_6_10.this.chatItemRewriter.remapShowItem((String)msg)));
                this.create(Type.BYTE, (byte)0);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_EQUIPMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.SHORT);
                this.map(Types1_7_6.COMPRESSED_ITEM, Type.ITEM);
                this.handler(wrapper -> Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(wrapper.get(Type.ITEM, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_INT, Type.POSITION);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.UPDATE_HEALTH, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.FLOAT);
                this.map((Type)Type.SHORT, Type.VAR_INT);
                this.map(Type.FLOAT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.RESPAWN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    int oldDim = wrapper.user().get(DimensionTracker.class).getDimensionId();
                    int newDim = wrapper.get(Type.INT, 0);
                    wrapper.user().get(DimensionTracker.class).setDimension(newDim);
                    wrapper.user().get(ClientWorld.class).setEnvironment(newDim);
                    if (oldDim != newDim) {
                        wrapper.user().get(ChunkTracker.class).clear();
                        wrapper.user().get(EntityTracker.class).clear();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE, Type.DOUBLE, stance -> stance - (double)1.62f);
                this.map(Type.DOUBLE);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.read(Type.BOOLEAN);
                this.create(Type.BYTE, (byte)0);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.USE_BED, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Types1_7_6.POSITION_BYTE, Type.POSITION);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_PLAYER, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    wrapper.passthrough(Type.VAR_INT);
                    UUID uuid = UUID.fromString(wrapper.read(Type.STRING));
                    wrapper.write(Type.UUID, uuid);
                    String name = wrapper.read(Type.STRING);
                    TablistStorage tablistStorage = wrapper.user().get(TablistStorage.class);
                    TabListEntry tempTabEntry = new TabListEntry(name, uuid);
                    int dataCount = wrapper.read(Type.VAR_INT);
                    for (int i = 0; i < dataCount; ++i) {
                        String key = wrapper.read(Type.STRING);
                        String value = wrapper.read(Type.STRING);
                        String signature = wrapper.read(Type.STRING);
                        tempTabEntry.gameProfile.addProperty(new GameProfile.Property(key, value, signature));
                    }
                    wrapper.passthrough(Type.INT);
                    wrapper.passthrough(Type.INT);
                    wrapper.passthrough(Type.INT);
                    wrapper.passthrough(Type.BYTE);
                    wrapper.passthrough(Type.BYTE);
                    short itemId = wrapper.read(Type.SHORT);
                    DataItem currentItem = new DataItem(itemId, 1, 0, null);
                    Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(currentItem);
                    wrapper.write(Type.SHORT, (short)currentItem.identifier());
                    List<Metadata> metadata = wrapper.read(Types1_7_6.METADATA_LIST);
                    Protocol1_8to1_7_6_10.this.metadataRewriter.transform(Entity1_10Types.EntityType.PLAYER, metadata);
                    wrapper.write(Types1_8.METADATA_LIST, metadata);
                    tablistStorage.sendTempEntry(tempTabEntry);
                });
                this.handler(wrapper -> {
                    int entityID = wrapper.get(Type.VAR_INT, 0);
                    wrapper.user().get(EntityTracker.class).trackEntity(entityID, Entity1_10Types.EntityType.PLAYER);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.COLLECT_ITEM, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map((Type)Type.INT, Type.VAR_INT);
                this.handler(wrapper -> wrapper.user().get(EntityTracker.class).removeEntity(wrapper.get(Type.VAR_INT, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityID = wrapper.get(Type.VAR_INT, 0);
                    byte typeID = wrapper.get(Type.BYTE, 0);
                    int x = wrapper.get(Type.INT, 0);
                    int y = wrapper.get(Type.INT, 1);
                    int z = wrapper.get(Type.INT, 2);
                    tracker.trackEntity(entityID, Entity1_10Types.getTypeFromId(typeID, true));
                    tracker.updateEntityLocation(entityID, x, y, z, false);
                });
                this.handler(wrapper -> {
                    Entity1_10Types.EntityType type = Entity1_10Types.getTypeFromId(wrapper.get(Type.BYTE, 0).byteValue(), true);
                    int x = wrapper.get(Type.INT, 0);
                    int y = wrapper.get(Type.INT, 1);
                    int z = wrapper.get(Type.INT, 2);
                    byte yaw = wrapper.get(Type.BYTE, 2);
                    int data = wrapper.get(Type.INT, 3);
                    if (type == Entity1_10Types.ObjectType.ITEM_FRAME.getType()) {
                        switch (data) {
                            case 0: {
                                z += 32;
                                yaw = 0;
                                break;
                            }
                            case 1: {
                                x -= 32;
                                yaw = 64;
                                break;
                            }
                            case 2: {
                                z -= 32;
                                yaw = -128;
                                break;
                            }
                            case 3: {
                                x += 32;
                                yaw = -64;
                            }
                        }
                    } else if (type == Entity1_10Types.ObjectType.FALLING_BLOCK.getType()) {
                        int id = data & 0xFFFF;
                        int metadata = data >> 16;
                        IdAndData block = new IdAndData(id, metadata);
                        wrapper.user().get(ChunkTracker.class).remapBlockParticle(block);
                        data = block.id | block.data << 12;
                    }
                    y = Protocol1_8to1_7_6_10.this.realignEntityY(type, y);
                    wrapper.set(Type.INT, 0, x);
                    wrapper.set(Type.INT, 1, y);
                    wrapper.set(Type.INT, 2, z);
                    wrapper.set(Type.BYTE, 2, yaw);
                    wrapper.set(Type.INT, 3, data);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_MOB, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.VAR_INT);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Types1_7_6.METADATA_LIST, Types1_8.METADATA_LIST);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityID = wrapper.get(Type.VAR_INT, 0);
                    short typeID = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    int x = wrapper.get(Type.INT, 0);
                    int y = wrapper.get(Type.INT, 1);
                    int z = wrapper.get(Type.INT, 2);
                    List<Metadata> metadataList = wrapper.get(Types1_8.METADATA_LIST, 0);
                    Entity1_10Types.EntityType entityType = Entity1_10Types.getTypeFromId(typeID, false);
                    tracker.trackEntity(entityID, entityType);
                    tracker.updateEntityLocation(entityID, x, y, z, false);
                    tracker.updateEntityMetadata(entityID, metadataList);
                    Protocol1_8to1_7_6_10.this.metadataRewriter.transform(entityType, metadataList);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_PAINTING, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.VAR_INT);
                this.map(Type.STRING);
                this.map(Types1_7_6.POSITION_INT, Type.POSITION);
                this.map((Type)Type.INT, Type.BYTE);
                this.handler(wrapper -> {
                    short rotation = wrapper.get(Type.BYTE, 0).byteValue();
                    Position pos = wrapper.get(Type.POSITION, 0);
                    int modX = 0;
                    int modZ = 0;
                    switch (rotation) {
                        case 0: {
                            modZ = 1;
                            break;
                        }
                        case 1: {
                            modX = -1;
                            break;
                        }
                        case 2: {
                            modZ = -1;
                            break;
                        }
                        case 3: {
                            modX = 1;
                        }
                    }
                    wrapper.set(Type.POSITION, 0, new Position(pos.x() + modX, pos.y(), pos.z() + modZ));
                });
                this.handler(wrapper -> {
                    int entityID = wrapper.get(Type.VAR_INT, 0);
                    wrapper.user().get(EntityTracker.class).trackEntity(entityID, Entity1_10Types.EntityType.PAINTING);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_EXPERIENCE_ORB, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.VAR_INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.SHORT);
                this.handler(wrapper -> {
                    int entityID = wrapper.get(Type.VAR_INT, 0);
                    wrapper.user().get(EntityTracker.class).trackEntity(entityID, Entity1_10Types.EntityType.EXPERIENCE_ORB);
                    wrapper.set(Type.INT, 1, Protocol1_8to1_7_6_10.this.realignEntityY(Entity1_10Types.EntityType.EXPERIENCE_ORB, wrapper.get(Type.INT, 1)));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_VELOCITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.DESTROY_ENTITIES, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.INT_ARRAY, Type.VAR_INT_ARRAY_PRIMITIVE);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    for (int entityId : wrapper.get(Type.VAR_INT_ARRAY_PRIMITIVE, 0)) {
                        tracker.removeEntity(entityId);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_MOVEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.VAR_INT, 0);
                    byte x = wrapper.get(Type.BYTE, 0);
                    byte y = wrapper.get(Type.BYTE, 1);
                    byte z = wrapper.get(Type.BYTE, 2);
                    tracker.updateEntityLocation(entityId, x, y, z, true);
                });
                this.handler(wrapper -> {
                    if (ViaLegacy.getConfig().isDynamicOnground()) {
                        EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                        boolean onGround = wrapper.get(Type.BYTE, 1) > -8;
                        entityTracker.getGroundMap().put(wrapper.get(Type.VAR_INT, 0), onGround);
                        wrapper.write(Type.BOOLEAN, onGround);
                    } else {
                        wrapper.write(Type.BOOLEAN, true);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    if (ViaLegacy.getConfig().isDynamicOnground()) {
                        EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                        wrapper.write(Type.BOOLEAN, entityTracker.getGroundMap().getOrDefault(wrapper.get(Type.VAR_INT, 0), true));
                    } else {
                        wrapper.write(Type.BOOLEAN, true);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_POSITION_AND_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.VAR_INT, 0);
                    byte x = wrapper.get(Type.BYTE, 0);
                    byte y = wrapper.get(Type.BYTE, 1);
                    byte z = wrapper.get(Type.BYTE, 2);
                    tracker.updateEntityLocation(entityId, x, y, z, true);
                });
                this.handler(wrapper -> {
                    if (ViaLegacy.getConfig().isDynamicOnground()) {
                        EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                        boolean onGround = wrapper.get(Type.BYTE, 1) > -8;
                        entityTracker.getGroundMap().put(wrapper.get(Type.VAR_INT, 0), onGround);
                        wrapper.write(Type.BOOLEAN, onGround);
                    } else {
                        wrapper.write(Type.BOOLEAN, true);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_TELEPORT, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.create(Type.BOOLEAN, true);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    int entityId = wrapper.get(Type.VAR_INT, 0);
                    int x = wrapper.get(Type.INT, 0);
                    int y = wrapper.get(Type.INT, 1);
                    int z = wrapper.get(Type.INT, 2);
                    tracker.updateEntityLocation(entityId, x, y, z, false);
                });
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    Entity1_10Types.EntityType type = entityTracker.getTrackedEntities().get(wrapper.get(Type.VAR_INT, 0));
                    wrapper.set(Type.INT, 1, Protocol1_8to1_7_6_10.this.realignEntityY(type, wrapper.get(Type.INT, 1)));
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_HEAD_LOOK, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ATTACH_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    short leashState = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    if (leashState == 0) {
                        EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                        int ridingId = wrapper.get(Type.INT, 0);
                        int vehicleId = wrapper.get(Type.INT, 1);
                        tracker.updateEntityAttachState(ridingId, vehicleId);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_METADATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Types1_7_6.METADATA_LIST, Types1_8.METADATA_LIST);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                    List<Metadata> metadataList = wrapper.get(Types1_8.METADATA_LIST, 0);
                    int entityID = wrapper.get(Type.VAR_INT, 0);
                    if (tracker.getTrackedEntities().containsKey(entityID)) {
                        tracker.updateEntityMetadata(entityID, metadataList);
                        Protocol1_8to1_7_6_10.this.metadataRewriter.transform(tracker.getTrackedEntities().get(entityID), metadataList);
                        if (metadataList.isEmpty()) {
                            wrapper.cancel();
                        }
                    } else {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_EFFECT, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map((Type)Type.SHORT, Type.VAR_INT);
                this.create(Type.BOOLEAN, false);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.REMOVE_ENTITY_EFFECT, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.map(Type.BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SET_EXPERIENCE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.FLOAT);
                this.map((Type)Type.SHORT, Type.VAR_INT);
                this.map((Type)Type.SHORT, Type.VAR_INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.ENTITY_PROPERTIES, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.INT, Type.VAR_INT);
                this.handler(wrapper -> {
                    int amount = wrapper.passthrough(Type.INT);
                    for (int i = 0; i < amount; ++i) {
                        wrapper.passthrough(Type.STRING);
                        wrapper.passthrough(Type.DOUBLE);
                        int modifierlength = wrapper.read(Type.SHORT).shortValue();
                        wrapper.write(Type.VAR_INT, modifierlength);
                        for (int j = 0; j < modifierlength; ++j) {
                            wrapper.passthrough(Type.UUID);
                            wrapper.passthrough(Type.DOUBLE);
                            wrapper.passthrough(Type.BYTE);
                        }
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.CHUNK_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Chunk chunk = wrapper.read(new Chunk1_7_6Type(wrapper.user().get(ClientWorld.class)));
                    wrapper.user().get(ChunkTracker.class).trackAndRemap(chunk);
                    wrapper.write(new Chunk1_8Type(wrapper.user().get(ClientWorld.class)), chunk);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.MULTI_BLOCK_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.INT);
                this.map(Type.INT);
                this.map(Types1_7_6.BLOCK_CHANGE_RECORD_ARRAY, Type.BLOCK_CHANGE_RECORD_ARRAY);
                this.handler(wrapper -> {
                    BlockChangeRecord[] blockChangeRecords;
                    int chunkX = wrapper.get(Type.INT, 0);
                    int chunkZ = wrapper.get(Type.INT, 1);
                    for (BlockChangeRecord record : blockChangeRecords = wrapper.get(Type.BLOCK_CHANGE_RECORD_ARRAY, 0)) {
                        int targetX = record.getSectionX() + (chunkX << 4);
                        short targetY = record.getY(-1);
                        int targetZ = record.getSectionZ() + (chunkZ << 4);
                        IdAndData block = IdAndData.fromCompressedData(record.getBlockId());
                        Position pos = new Position(targetX, (int)targetY, targetZ);
                        wrapper.user().get(ChunkTracker.class).trackAndRemap(pos, block);
                        record.setBlockId(block.toCompressedData());
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.BLOCK_CHANGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_UBYTE, Type.POSITION);
                this.handler(wrapper -> {
                    int blockId = wrapper.read(Type.VAR_INT);
                    short data = wrapper.read(Type.UNSIGNED_BYTE);
                    Position pos = wrapper.get(Type.POSITION, 0);
                    IdAndData block = new IdAndData(blockId, data);
                    wrapper.user().get(ChunkTracker.class).trackAndRemap(pos, block);
                    wrapper.write(Type.VAR_INT, block.toCompressedData());
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.BLOCK_ACTION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT, Type.POSITION);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.VAR_INT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.BLOCK_BREAK_ANIMATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.VAR_INT);
                this.map(Types1_7_6.POSITION_INT, Type.POSITION);
                this.map(Type.BYTE);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.MAP_BULK_CHUNK, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Chunk[] chunks;
                    for (Chunk chunk : chunks = wrapper.read(new ChunkBulk1_7_6Type(wrapper.user().get(ClientWorld.class)))) {
                        wrapper.user().get(ChunkTracker.class).trackAndRemap(chunk);
                    }
                    wrapper.write(new ChunkBulk1_8Type(wrapper.user().get(ClientWorld.class)), chunks);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.EXPLOSION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.INT);
                this.handler(wrapper -> {
                    int x = wrapper.get(Type.FLOAT, 0).intValue();
                    int y = wrapper.get(Type.FLOAT, 1).intValue();
                    int z = wrapper.get(Type.FLOAT, 2).intValue();
                    int recordCount = wrapper.get(Type.INT, 0);
                    ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                    for (int i = 0; i < recordCount; ++i) {
                        Position pos = new Position(x + wrapper.passthrough(Type.BYTE), y + wrapper.passthrough(Type.BYTE), z + wrapper.passthrough(Type.BYTE));
                        chunkTracker.trackAndRemap(pos, new IdAndData(0, 0));
                    }
                });
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.EFFECT, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    int effectId = wrapper.read(Type.INT);
                    Position pos = wrapper.read(Types1_7_6.POSITION_UBYTE);
                    int data = wrapper.read(Type.INT);
                    boolean disableRelativeVolume = wrapper.read(Type.BOOLEAN);
                    if (!disableRelativeVolume && effectId == 2006) {
                        wrapper.setPacketType(ClientboundPackets1_8.SPAWN_PARTICLE);
                        Random rnd = new Random();
                        ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                        IdAndData block = chunkTracker.getBlockNotNull(pos);
                        if (block.id != 0) {
                            double var21 = Math.min(0.2f + (float)data / 15.0f, 10.0f);
                            if (var21 > 2.5) {
                                var21 = 2.5;
                            }
                            float var25 = Protocol1_8to1_7_6_10.this.randomFloatClamp(rnd, 0.0f, (float)Math.PI * 2);
                            double var26 = Protocol1_8to1_7_6_10.this.randomFloatClamp(rnd, 0.75f, 1.0f);
                            float offsetY = (float)((double)0.2f + var21 / 100.0);
                            float offsetX = (float)(Math.cos(var25) * (double)0.2f * var26 * var26 * (var21 + 0.2));
                            float offsetZ = (float)(Math.sin(var25) * (double)0.2f * var26 * var26 * (var21 + 0.2));
                            int amount = (int)(150.0 * var21);
                            wrapper.write(Type.INT, Particle.BLOCK_DUST.ordinal());
                            wrapper.write(Type.BOOLEAN, false);
                            wrapper.write(Type.FLOAT, Float.valueOf((float)pos.x() + 0.5f));
                            wrapper.write(Type.FLOAT, Float.valueOf((float)pos.y() + 1.0f));
                            wrapper.write(Type.FLOAT, Float.valueOf((float)pos.z() + 0.5f));
                            wrapper.write(Type.FLOAT, Float.valueOf(offsetX));
                            wrapper.write(Type.FLOAT, Float.valueOf(offsetY));
                            wrapper.write(Type.FLOAT, Float.valueOf(offsetZ));
                            wrapper.write(Type.FLOAT, Float.valueOf(0.15f));
                            wrapper.write(Type.INT, amount);
                            wrapper.write(Type.VAR_INT, block.id | block.data << 12);
                        } else {
                            wrapper.cancel();
                        }
                    } else {
                        if (!disableRelativeVolume && effectId == 1003) {
                            if (Math.random() > 0.5) {
                                effectId = 1006;
                            }
                        } else if (!disableRelativeVolume && effectId == 2001) {
                            ChunkTracker chunkTracker = wrapper.user().get(ChunkTracker.class);
                            int blockID = data & 0xFFF;
                            int blockData = data >> 12 & 0xFF;
                            IdAndData block = new IdAndData(blockID, blockData);
                            chunkTracker.remapBlockParticle(block);
                            data = block.id | block.data << 12;
                        }
                        wrapper.write(Type.INT, effectId);
                        wrapper.write(Type.POSITION, pos);
                        wrapper.write(Type.INT, data);
                        wrapper.write(Type.BOOLEAN, disableRelativeVolume);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SPAWN_PARTICLE, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    Object[] parts = wrapper.read(Type.STRING).split("_", 3);
                    Particle particle = Particle.find(parts[0]);
                    if (particle == null) {
                        particle = Particle.BARRIER;
                        ViaLegacy.getPlatform().getLogger().warning("Could not find 1.8 particle for " + Arrays.toString(parts));
                    }
                    wrapper.write(Type.INT, particle.ordinal());
                    wrapper.write(Type.BOOLEAN, false);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.FLOAT);
                    wrapper.passthrough(Type.INT);
                    if (particle == Particle.ICON_CRACK) {
                        int id = Integer.parseInt((String)parts[1]);
                        int damage = 0;
                        if (parts.length > 2) {
                            damage = Integer.parseInt((String)parts[2]);
                        }
                        DataItem item = new DataItem(id, 1, (short)damage, null);
                        Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(item);
                        wrapper.write(Type.VAR_INT, item.identifier());
                        if (item.data() != 0) {
                            wrapper.write(Type.VAR_INT, Integer.valueOf(item.data()));
                        }
                    } else if (particle == Particle.BLOCK_CRACK || particle == Particle.BLOCK_DUST) {
                        int id = Integer.parseInt((String)parts[1]);
                        int metadata = Integer.parseInt((String)parts[2]);
                        IdAndData block = new IdAndData(id, metadata);
                        wrapper.user().get(ChunkTracker.class).remapBlockParticle(block);
                        wrapper.write(Type.VAR_INT, block.id | block.data << 12);
                    } else if (particle.extra > 0) {
                        throw new IllegalStateException("Tried to write particle which requires extra data, but no handler was found");
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.GAME_EVENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.FLOAT);
                this.handler(wrapper -> {
                    if (wrapper.get(Type.UNSIGNED_BYTE, 0) == 3) {
                        PacketWrapper chatMessage = PacketWrapper.create(ClientboundPackets1_8.CHAT_MESSAGE, wrapper.user());
                        chatMessage.write(Type.STRING, LEGACY_TO_JSON.transform(chatMessage, "Your game mode has been updated"));
                        chatMessage.write(Type.BYTE, (byte)0);
                        chatMessage.send(Protocol1_8to1_7_6_10.class);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.OPEN_WINDOW, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String inventoryName;
                    short windowId = wrapper.passthrough(Type.UNSIGNED_BYTE);
                    short windowType = wrapper.read(Type.UNSIGNED_BYTE);
                    String title = wrapper.read(Type.STRING);
                    short slots = wrapper.read(Type.UNSIGNED_BYTE);
                    boolean useProvidedWindowTitle = wrapper.read(Type.BOOLEAN);
                    wrapper.user().get(WindowTracker.class).types.put(windowId, windowType);
                    switch (windowType) {
                        case 0: {
                            inventoryName = "minecraft:chest";
                            break;
                        }
                        case 1: {
                            inventoryName = "minecraft:crafting_table";
                            break;
                        }
                        case 2: {
                            inventoryName = "minecraft:furnace";
                            break;
                        }
                        case 3: {
                            inventoryName = "minecraft:dispenser";
                            break;
                        }
                        case 4: {
                            inventoryName = "minecraft:enchanting_table";
                            break;
                        }
                        case 5: {
                            inventoryName = "minecraft:brewing_stand";
                            break;
                        }
                        case 6: {
                            inventoryName = "minecraft:villager";
                            if (useProvidedWindowTitle && !title.isEmpty()) break;
                            title = "entity.Villager.name";
                            useProvidedWindowTitle = false;
                            break;
                        }
                        case 7: {
                            inventoryName = "minecraft:beacon";
                            break;
                        }
                        case 8: {
                            inventoryName = "minecraft:anvil";
                            break;
                        }
                        case 9: {
                            inventoryName = "minecraft:hopper";
                            break;
                        }
                        case 10: {
                            inventoryName = "minecraft:dropper";
                            break;
                        }
                        case 11: {
                            inventoryName = "EntityHorse";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown window type: " + windowType);
                        }
                    }
                    if (windowType == 1 || windowType == 4 || windowType == 8) {
                        slots = 0;
                    }
                    title = useProvidedWindowTitle ? LEGACY_TO_JSON.transform(wrapper, title) : LEGACY_TO_JSON_TRANSLATE.transform(wrapper, title);
                    wrapper.write(Type.STRING, inventoryName);
                    wrapper.write(Type.STRING, title);
                    wrapper.write(Type.UNSIGNED_BYTE, slots);
                    if (windowType == 11) {
                        wrapper.passthrough(Type.INT);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SET_SLOT, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    short windowId = wrapper.read(Type.BYTE).byteValue();
                    wrapper.write(Type.UNSIGNED_BYTE, windowId);
                    short slot = wrapper.read(Type.SHORT);
                    short windowType = wrapper.user().get(WindowTracker.class).get(windowId);
                    if (windowType == 4 && slot >= 1) {
                        slot = (short)(slot + 1);
                    }
                    wrapper.write(Type.SHORT, slot);
                });
                this.map(Types1_7_6.COMPRESSED_ITEM, Type.ITEM);
                this.handler(wrapper -> Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(wrapper.get(Type.ITEM, 0)));
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.WINDOW_ITEMS, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    short windowId = wrapper.passthrough(Type.UNSIGNED_BYTE);
                    short windowType = wrapper.user().get(WindowTracker.class).get(windowId);
                    Item[] items = wrapper.read(Types1_7_6.COMPRESSED_ITEM_ARRAY);
                    if (windowType == 4) {
                        Item[] old = items;
                        items = new Item[old.length + 1];
                        items[0] = old[0];
                        System.arraycopy(old, 1, items, 2, old.length - 1);
                        items[1] = new DataItem(351, 3, 4, null);
                    }
                    for (Item item : items) {
                        Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(item);
                    }
                    wrapper.write(Type.ITEM_ARRAY, items);
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.WINDOW_PROPERTY, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.SHORT);
                this.map(Type.SHORT);
                this.handler(wrapper -> {
                    short windowId = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    short progressBar = wrapper.get(Type.SHORT, 0);
                    short windowType = wrapper.user().get(WindowTracker.class).get(windowId);
                    if (windowType == 2) {
                        switch (progressBar) {
                            case 0: {
                                progressBar = 2;
                                PacketWrapper windowProperty = PacketWrapper.create(ClientboundPackets1_8.WINDOW_PROPERTY, wrapper.user());
                                windowProperty.write(Type.UNSIGNED_BYTE, windowId);
                                windowProperty.write(Type.SHORT, (short)3);
                                windowProperty.write(Type.SHORT, (short)200);
                                windowProperty.send(Protocol1_8to1_7_6_10.class);
                                break;
                            }
                            case 1: {
                                progressBar = 0;
                                break;
                            }
                            case 2: {
                                progressBar = 1;
                            }
                        }
                        wrapper.set(Type.SHORT, 0, progressBar);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.UPDATE_SIGN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT, Type.POSITION);
                this.map(LEGACY_TO_JSON);
                this.map(LEGACY_TO_JSON);
                this.map(LEGACY_TO_JSON);
                this.map(LEGACY_TO_JSON);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.MAP_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    int id = wrapper.passthrough(Type.VAR_INT);
                    byte[] data = wrapper.read(Type.SHORT_BYTE_ARRAY);
                    MapStorage mapStorage = wrapper.user().get(MapStorage.class);
                    MapData mapData = mapStorage.getMapData(id);
                    if (mapData == null) {
                        mapData = new MapData();
                        mapStorage.putMapData(id, mapData);
                    }
                    if (data[0] == 1) {
                        int count = (data.length - 1) / 3;
                        mapData.mapIcons = new MapIcon[count];
                        for (int i = 0; i < count; ++i) {
                            mapData.mapIcons[i] = new MapIcon((byte)(data[i * 3 + 1] >> 4), (byte)(data[i * 3 + 1] & 0xF), data[i * 3 + 2], data[i * 3 + 3]);
                        }
                    } else if (data[0] == 2) {
                        mapData.scale = data[1];
                    }
                    wrapper.write(Type.BYTE, mapData.scale);
                    wrapper.write(Type.VAR_INT, mapData.mapIcons.length);
                    for (MapIcon mapIcon : mapData.mapIcons) {
                        wrapper.write(Type.BYTE, (byte)(mapIcon.direction << 4 | mapIcon.type & 0xF));
                        wrapper.write(Type.BYTE, mapIcon.x);
                        wrapper.write(Type.BYTE, mapIcon.z);
                    }
                    if (data[0] == 0) {
                        byte x = data[1];
                        byte z = data[2];
                        int rows = data.length - 3;
                        byte[] newData = new byte[rows];
                        System.arraycopy(data, 3, newData, 0, rows);
                        wrapper.write(Type.BYTE, (byte)1);
                        wrapper.write(Type.BYTE, (byte)rows);
                        wrapper.write(Type.BYTE, x);
                        wrapper.write(Type.BYTE, z);
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, newData);
                    } else {
                        wrapper.write(Type.BYTE, (byte)0);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.BLOCK_ENTITY_DATA, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_SHORT, Type.POSITION);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Types1_7_6.COMPRESSED_NBT, Type.NBT);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.OPEN_SIGN_EDITOR, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types1_7_6.POSITION_INT, Type.POSITION);
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.PLAYER_INFO, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String name = wrapper.read(Type.STRING);
                    boolean online = wrapper.read(Type.BOOLEAN);
                    short ping = wrapper.read(Type.SHORT);
                    TablistStorage tablistStorage = wrapper.user().get(TablistStorage.class);
                    TabListEntry entry = tablistStorage.tablist.get(name);
                    if (entry == null && online) {
                        entry = new TabListEntry(name, ping);
                        tablistStorage.tablist.put(name, entry);
                        wrapper.write(Type.VAR_INT, 0);
                        wrapper.write(Type.VAR_INT, 1);
                        wrapper.write(Type.UUID, entry.gameProfile.uuid);
                        wrapper.write(Type.STRING, entry.gameProfile.userName);
                        wrapper.write(Type.VAR_INT, 0);
                        wrapper.write(Type.VAR_INT, 0);
                        wrapper.write(Type.VAR_INT, entry.ping);
                        wrapper.write(Type.OPTIONAL_STRING, null);
                    } else if (entry != null && !online) {
                        tablistStorage.tablist.remove(name);
                        wrapper.write(Type.VAR_INT, 4);
                        wrapper.write(Type.VAR_INT, 1);
                        wrapper.write(Type.UUID, entry.gameProfile.uuid);
                    } else if (entry != null) {
                        entry.ping = ping;
                        wrapper.write(Type.VAR_INT, 2);
                        wrapper.write(Type.VAR_INT, 1);
                        wrapper.write(Type.UUID, entry.gameProfile.uuid);
                        wrapper.write(Type.VAR_INT, entry.ping);
                    } else {
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.SCOREBOARD_OBJECTIVE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    String value = wrapper.read(Type.STRING);
                    byte mode = wrapper.passthrough(Type.BYTE);
                    if (mode == 0 || mode == 2) {
                        wrapper.write(Type.STRING, value);
                        wrapper.write(Type.STRING, "integer");
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.UPDATE_SCORE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    byte mode = wrapper.passthrough(Type.BYTE);
                    if (mode == 0) {
                        wrapper.passthrough(Type.STRING);
                        wrapper.write(Type.VAR_INT, wrapper.read(Type.INT));
                    } else {
                        wrapper.write(Type.STRING, "");
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.TEAMS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    byte mode = wrapper.passthrough(Type.BYTE);
                    if (mode == 0 || mode == 2) {
                        wrapper.passthrough(Type.STRING);
                        wrapper.passthrough(Type.STRING);
                        wrapper.passthrough(Type.STRING);
                        wrapper.passthrough(Type.BYTE);
                        wrapper.write(Type.STRING, "always");
                        wrapper.write(Type.BYTE, (byte)0);
                    }
                    if (mode == 0 || mode == 3 || mode == 4) {
                        int count = wrapper.read(Type.SHORT).shortValue();
                        String[] playerNames = new String[count];
                        for (int i = 0; i < count; ++i) {
                            playerNames[i] = wrapper.read(Type.STRING);
                        }
                        wrapper.write(Type.STRING_ARRAY, playerNames);
                    }
                });
            }
        });
        this.registerClientbound(ClientboundPackets1_7_2.PLUGIN_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    String channel = wrapper.get(Type.STRING, 0);
                    wrapper.read(Type.SHORT);
                    switch (channel) {
                        case "MC|Brand": {
                            byte[] data = wrapper.read(Type.REMAINING_BYTES);
                            String brand = new String(data, StandardCharsets.UTF_8);
                            wrapper.write(Type.STRING, brand);
                            break;
                        }
                        case "MC|TrList": {
                            wrapper.passthrough(Type.INT);
                            int count = wrapper.passthrough(Type.UNSIGNED_BYTE).shortValue();
                            for (int i = 0; i < count; ++i) {
                                Item item = wrapper.read(Types1_7_6.COMPRESSED_ITEM);
                                Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(item);
                                wrapper.write(Type.ITEM, item);
                                item = wrapper.read(Types1_7_6.COMPRESSED_ITEM);
                                Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(item);
                                wrapper.write(Type.ITEM, item);
                                boolean has3Items = wrapper.passthrough(Type.BOOLEAN);
                                if (has3Items) {
                                    item = wrapper.read(Types1_7_6.COMPRESSED_ITEM);
                                    Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToClient(item);
                                    wrapper.write(Type.ITEM, item);
                                }
                                wrapper.passthrough(Type.BOOLEAN);
                                wrapper.write(Type.INT, 0);
                                wrapper.write(Type.INT, Integer.MAX_VALUE);
                            }
                            break;
                        }
                        case "MC|RPack": {
                            byte[] data = wrapper.read(Type.REMAINING_BYTES);
                            String resourcePackURL = new String(data, StandardCharsets.UTF_8);
                            wrapper.setPacketType(ClientboundPackets1_8.RESOURCE_PACK);
                            wrapper.clearPacket();
                            wrapper.write(Type.STRING, resourcePackURL);
                            wrapper.write(Type.STRING, "legacy");
                            break;
                        }
                    }
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.ENCRYPTION_KEY.getId(), ServerboundLoginPackets.ENCRYPTION_KEY.getId(), new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.BYTE_ARRAY_PRIMITIVE, Type.SHORT_BYTE_ARRAY);
                this.map(Type.BYTE_ARRAY_PRIMITIVE, Type.SHORT_BYTE_ARRAY);
            }
        });
        this.registerServerbound(ServerboundPackets1_8.KEEP_ALIVE, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.VAR_INT, Type.INT);
            }
        });
        this.registerServerbound(ServerboundPackets1_8.INTERACT_ENTITY, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.VAR_INT, Type.INT);
                this.handler(wrapper -> {
                    int mode = wrapper.read(Type.VAR_INT);
                    if (mode == 2) {
                        wrapper.write(Type.BYTE, (byte)0);
                        wrapper.read(Type.FLOAT);
                        wrapper.read(Type.FLOAT);
                        wrapper.read(Type.FLOAT);
                        EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                        Entity1_10Types.EntityType entityType = entityTracker.getTrackedEntities().get(wrapper.get(Type.INT, 0));
                        if (entityType == null || !entityType.isOrHasParent(Entity1_10Types.EntityType.ARMOR_STAND)) {
                            wrapper.cancel();
                        }
                    } else {
                        wrapper.write(Type.BYTE, (byte)mode);
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_8.PLAYER_POSITION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.handler(wrapper -> wrapper.write(Type.DOUBLE, wrapper.get(Type.DOUBLE, 1) + 1.62));
                this.map(Type.DOUBLE);
                this.map(Type.BOOLEAN);
            }
        });
        this.registerServerbound(ServerboundPackets1_8.PLAYER_POSITION_AND_ROTATION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.DOUBLE);
                this.map(Type.DOUBLE);
                this.handler(wrapper -> wrapper.write(Type.DOUBLE, wrapper.get(Type.DOUBLE, 1) + 1.62));
                this.map(Type.DOUBLE);
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.map(Type.BOOLEAN);
            }
        });
        this.registerServerbound(ServerboundPackets1_8.PLAYER_DIGGING, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.VAR_INT, Type.UNSIGNED_BYTE);
                this.map(Type.POSITION, Types1_7_6.POSITION_UBYTE);
                this.map(Type.UNSIGNED_BYTE);
            }
        });
        this.registerServerbound(ServerboundPackets1_8.PLAYER_BLOCK_PLACEMENT, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.POSITION, Types1_7_6.POSITION_UBYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.ITEM, Types1_7_6.COMPRESSED_ITEM);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    short direction = wrapper.get(Type.UNSIGNED_BYTE, 0);
                    Item item = wrapper.get(Types1_7_6.COMPRESSED_ITEM, 0);
                    Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToServer(item);
                    if (item != null && item.identifier() == ItemList1_6.writtenBook.itemID && direction == 255) {
                        PacketWrapper openBook = PacketWrapper.create(ClientboundPackets1_8.PLUGIN_MESSAGE, wrapper.user());
                        openBook.write(Type.STRING, "MC|BOpen");
                        openBook.write(Type.REMAINING_BYTES, new byte[0]);
                        openBook.send(Protocol1_8to1_7_6_10.class);
                        wrapper.cancel();
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_8.ANIMATION, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                    wrapper.write(Type.INT, entityTracker.getPlayerID());
                    wrapper.write(Type.BYTE, (byte)1);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_8.ENTITY_ACTION, new PacketHandlers(){

            @Override
            public void register() {
                this.map((Type)Type.VAR_INT, Type.INT);
                this.map(Type.VAR_INT, Type.BYTE, action -> (byte)(action + 1));
                this.map((Type)Type.VAR_INT, Type.INT);
            }
        });
        this.registerServerbound(ServerboundPackets1_8.STEER_VEHICLE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.FLOAT);
                this.map(Type.FLOAT);
                this.handler(wrapper -> {
                    byte flags = wrapper.read(Type.BYTE);
                    wrapper.write(Type.BOOLEAN, (flags & 1) > 0);
                    wrapper.write(Type.BOOLEAN, (flags & 2) > 0);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_8.CLICK_WINDOW, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    short windowId = wrapper.read(Type.UNSIGNED_BYTE);
                    wrapper.write(Type.BYTE, (byte)windowId);
                    short slot = wrapper.passthrough(Type.SHORT);
                    short windowType = wrapper.user().get(WindowTracker.class).get(windowId);
                    if (windowType == 4) {
                        if (slot == 1) {
                            PacketWrapper resetHandItem = PacketWrapper.create(ClientboundPackets1_8.SET_SLOT, wrapper.user());
                            resetHandItem.write(Type.UNSIGNED_BYTE, (short)-1);
                            resetHandItem.write(Type.SHORT, (short)0);
                            resetHandItem.write(Type.ITEM, new DataItem(-1, 0, 0, null));
                            resetHandItem.send(Protocol1_8to1_7_6_10.class);
                            PacketWrapper setLapisSlot = PacketWrapper.create(ClientboundPackets1_8.SET_SLOT, wrapper.user());
                            setLapisSlot.write(Type.UNSIGNED_BYTE, windowId);
                            setLapisSlot.write(Type.SHORT, slot);
                            setLapisSlot.write(Type.ITEM, new DataItem(351, 3, 4, null));
                            setLapisSlot.send(Protocol1_8to1_7_6_10.class);
                            wrapper.cancel();
                        } else if (slot > 1) {
                            wrapper.set(Type.SHORT, 0, (short)(slot - 1));
                        }
                    }
                });
                this.map(Type.BYTE);
                this.map(Type.SHORT);
                this.map(Type.BYTE);
                this.map(Type.ITEM, Types1_7_6.COMPRESSED_ITEM);
                this.handler(wrapper -> Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToServer(wrapper.get(Types1_7_6.COMPRESSED_ITEM, 0)));
            }
        });
        this.registerServerbound(ServerboundPackets1_8.CREATIVE_INVENTORY_ACTION, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.SHORT);
                this.map(Type.ITEM, Types1_7_6.COMPRESSED_ITEM);
                this.handler(wrapper -> Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToServer(wrapper.get(Types1_7_6.COMPRESSED_ITEM, 0)));
            }
        });
        this.registerServerbound(ServerboundPackets1_8.UPDATE_SIGN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.POSITION, Types1_7_6.POSITION_SHORT);
                this.handler(wrapper -> {
                    for (int i = 0; i < 4; ++i) {
                        JsonElement component = wrapper.read(Type.COMPONENT);
                        String text = TextComponentSerializer.V1_8.deserialize(component.toString()).asLegacyFormatString();
                        if (text.length() > 15) {
                            text = text.substring(0, 15);
                        }
                        wrapper.write(Type.STRING, text);
                    }
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_8.TAB_COMPLETE, new PacketHandlers(){

            @Override
            public void register() {
                this.handler(wrapper -> {
                    String text = wrapper.read(Type.STRING);
                    wrapper.clearPacket();
                    wrapper.write(Type.STRING, text);
                });
            }
        });
        this.registerServerbound(ServerboundPackets1_8.CLIENT_SETTINGS, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.map(Type.BYTE);
                this.map(Type.BYTE);
                this.map(Type.BOOLEAN);
                this.create(Type.BYTE, (byte)2);
                this.map(Type.UNSIGNED_BYTE, Type.BOOLEAN, flags -> (flags & 1) == 1);
            }
        });
        this.registerServerbound(ServerboundPackets1_8.PLUGIN_MESSAGE, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    String channel = wrapper.get(Type.STRING, 0);
                    if (ViaLegacy.getConfig().isIgnoreLong1_8ChannelNames() && channel.length() > 16) {
                        if (!Via.getConfig().isSuppressConversionWarnings()) {
                            ViaLegacy.getPlatform().getLogger().warning("Ignoring incoming plugin channel, as it is longer than 16 characters: '" + channel + "'");
                        }
                        wrapper.cancel();
                        return;
                    }
                    PacketWrapper lengthPacketWrapper = PacketWrapper.create(null, wrapper.user());
                    ByteBuf lengthBuffer = Unpooled.buffer();
                    switch (channel) {
                        case "MC|BEdit": 
                        case "MC|BSign": {
                            Item item = wrapper.read(Type.ITEM);
                            Protocol1_8to1_7_6_10.this.itemRewriter.handleItemToServer(item);
                            lengthPacketWrapper.write(Types1_7_6.COMPRESSED_ITEM, item);
                            lengthPacketWrapper.writeToBuffer(lengthBuffer);
                            wrapper.write(Type.SHORT, (short)lengthBuffer.readableBytes());
                            wrapper.write(Types1_7_6.COMPRESSED_ITEM, item);
                            break;
                        }
                        case "MC|TrSel": {
                            int selectedTrade = wrapper.read(Type.INT);
                            lengthPacketWrapper.write(Type.INT, selectedTrade);
                            lengthPacketWrapper.writeToBuffer(lengthBuffer);
                            wrapper.write(Type.SHORT, (short)lengthBuffer.readableBytes());
                            wrapper.write(Type.INT, selectedTrade);
                            break;
                        }
                        case "MC|Brand": 
                        case "MC|ItemName": {
                            String content = wrapper.read(Type.STRING);
                            lengthPacketWrapper.write(Type.REMAINING_BYTES, content.getBytes(StandardCharsets.UTF_8));
                            lengthPacketWrapper.writeToBuffer(lengthBuffer);
                            wrapper.write(Type.SHORT, (short)lengthBuffer.readableBytes());
                            wrapper.write(Type.REMAINING_BYTES, content.getBytes(StandardCharsets.UTF_8));
                            break;
                        }
                        case "MC|AdvCdm": {
                            int posZ;
                            int posY;
                            int posXOrEntityId;
                            byte type = wrapper.read(Type.BYTE);
                            if (type == 0) {
                                posXOrEntityId = wrapper.read(Type.INT);
                                posY = wrapper.read(Type.INT);
                                posZ = wrapper.read(Type.INT);
                            } else if (type == 1) {
                                posXOrEntityId = wrapper.read(Type.INT);
                                posY = 0;
                                posZ = 0;
                            } else {
                                ViaLegacy.getPlatform().getLogger().warning("Unknown 1.8 command block type: " + type);
                                wrapper.cancel();
                                lengthBuffer.release();
                                return;
                            }
                            String command = wrapper.read(Type.STRING);
                            wrapper.read(Type.BOOLEAN);
                            lengthPacketWrapper.write(Type.BYTE, type);
                            if (type == 0) {
                                lengthPacketWrapper.write(Type.INT, posXOrEntityId);
                                lengthPacketWrapper.write(Type.INT, posY);
                                lengthPacketWrapper.write(Type.INT, posZ);
                            } else {
                                lengthPacketWrapper.write(Type.INT, posXOrEntityId);
                            }
                            lengthPacketWrapper.write(Type.STRING, command);
                            lengthPacketWrapper.writeToBuffer(lengthBuffer);
                            wrapper.write(Type.SHORT, (short)lengthBuffer.readableBytes());
                            wrapper.write(Type.BYTE, type);
                            if (type == 0) {
                                wrapper.write(Type.INT, posXOrEntityId);
                                wrapper.write(Type.INT, posY);
                                wrapper.write(Type.INT, posZ);
                            } else {
                                wrapper.write(Type.INT, posXOrEntityId);
                            }
                            wrapper.write(Type.STRING, command);
                            break;
                        }
                        case "MC|Beacon": {
                            int primaryEffect = wrapper.read(Type.INT);
                            int secondaryEffect = wrapper.read(Type.INT);
                            lengthPacketWrapper.write(Type.INT, primaryEffect);
                            lengthPacketWrapper.write(Type.INT, secondaryEffect);
                            lengthPacketWrapper.writeToBuffer(lengthBuffer);
                            wrapper.write(Type.SHORT, (short)lengthBuffer.readableBytes());
                            wrapper.write(Type.INT, primaryEffect);
                            wrapper.write(Type.INT, secondaryEffect);
                            break;
                        }
                        case "REGISTER": 
                        case "UNREGISTER": {
                            byte[] channels = wrapper.read(Type.REMAINING_BYTES);
                            if (ViaLegacy.getConfig().isIgnoreLong1_8ChannelNames()) {
                                String[] registeredChannels = new String(channels, StandardCharsets.UTF_8).split("\u0000");
                                ArrayList<String> validChannels = new ArrayList<String>(registeredChannels.length);
                                for (String registeredChannel : registeredChannels) {
                                    if (registeredChannel.length() > 16) {
                                        if (Via.getConfig().isSuppressConversionWarnings()) continue;
                                        ViaLegacy.getPlatform().getLogger().warning("Ignoring incoming plugin channel register of '" + registeredChannel + "', as it is longer than 16 characters");
                                        continue;
                                    }
                                    validChannels.add(registeredChannel);
                                }
                                if (validChannels.isEmpty()) {
                                    wrapper.cancel();
                                    return;
                                }
                                channels = Joiner.on((char)'\u0000').join(validChannels).getBytes(StandardCharsets.UTF_8);
                            }
                            wrapper.write(Type.SHORT, (short)channels.length);
                            wrapper.write(Type.REMAINING_BYTES, channels);
                            break;
                        }
                        default: {
                            byte[] data = wrapper.read(Type.REMAINING_BYTES);
                            wrapper.write(Type.SHORT, (short)data.length);
                            wrapper.write(Type.REMAINING_BYTES, data);
                        }
                    }
                    lengthBuffer.release();
                });
            }
        });
        this.cancelServerbound(ServerboundPackets1_8.SPECTATE);
        this.cancelServerbound(ServerboundPackets1_8.RESOURCE_PACK_STATUS);
    }

    private float randomFloatClamp(Random rnd, float min, float max) {
        return min >= max ? min : rnd.nextFloat() * (max - min) + min;
    }

    private int realignEntityY(Entity1_10Types.EntityType type, int y) {
        float yPos = (float)y / 32.0f;
        float yOffset = 0.0f;
        if (type == Entity1_10Types.ObjectType.FALLING_BLOCK.getType()) {
            yOffset = 0.49f;
        }
        if (type == Entity1_10Types.ObjectType.TNT_PRIMED.getType()) {
            yOffset = 0.49f;
        }
        if (type == Entity1_10Types.ObjectType.ENDER_CRYSTAL.getType()) {
            yOffset = 1.0f;
        } else if (type == Entity1_10Types.ObjectType.MINECART.getType()) {
            yOffset = 0.35f;
        } else if (type == Entity1_10Types.ObjectType.BOAT.getType()) {
            yOffset = 0.3f;
        } else if (type == Entity1_10Types.ObjectType.ITEM.getType()) {
            yOffset = 0.125f;
        } else if (type == Entity1_10Types.ObjectType.LEASH.getType()) {
            yOffset = 0.5f;
        } else if (type == Entity1_10Types.EntityType.EXPERIENCE_ORB) {
            yOffset = 0.25f;
        }
        return (int)Math.floor((yPos - yOffset) * 32.0f);
    }

    @Override
    public void init(UserConnection userConnection) {
        userConnection.put(new TablistStorage(userConnection));
        userConnection.put(new WindowTracker(userConnection));
        userConnection.put(new EntityTracker(userConnection));
        userConnection.put(new MapStorage(userConnection));
        userConnection.put(new DimensionTracker(userConnection));
        if (!userConnection.has(ClientWorld.class)) {
            userConnection.put(new ClientWorld(userConnection));
        }
        userConnection.put(new ChunkTracker(userConnection));
    }

    @Override
    public LegacyItemRewriter<Protocol1_8to1_7_6_10> getItemRewriter() {
        return this.itemRewriter;
    }

    public MetadataRewriter getMetadataRewriter() {
        return this.metadataRewriter;
    }
}

